/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.apps.graph.GraphBuilder;
import org.adempiere.apps.graph.GraphColumn;
import org.compiere.apps.AEnv;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.Lookup;
import org.compiere.model.MGoal;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MQuery;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;

public class Graph
extends CPanel
implements ChartMouseListener {
    private static final long serialVersionUID = -4150122585550132822L;
    private Point m_point0_0 = null;
    private static CLogger log = CLogger.getCLogger(Graph.class);
    private double m_Y_Target = 0.0;
    private String m_Y_TargetLabel = null;
    private static Dimension paneldimension = new Dimension(180, 150);
    private GraphBuilder builder;
    ArrayList<GraphColumn> list = new ArrayList();
    private boolean m_userSelection;
    private ChartPanel chartPanel;

    public Graph() {
        this.setLayout(new BorderLayout());
        this.builder = new GraphBuilder();
    }

    public Graph(MGoal goal) {
        this(goal, false);
    }

    public Graph(MGoal goal, boolean userSelection) {
        this();
        this.builder = new GraphBuilder();
        this.builder.setMGoal(goal);
        this.builder.setYAxisLabel(goal.getName());
        this.builder.setXAxisLabel(goal.getXAxisText());
        this.m_userSelection = userSelection;
        this.loadData();
    }

    private void loadData() {
        this.list = this.builder.loadData();
        JFreeChart chart = this.builder.createChart(this.builder.getMGoal().getChartType());
        if (this.chartPanel != null) {
            this.remove((Component)this.chartPanel);
        }
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setSize(this.getSize());
        this.chartPanel.addChartMouseListener((ChartMouseListener)this);
        this.add((Component)this.chartPanel, "Center");
        if (this.m_userSelection) {
            int AD_Reference_Value_ID = DB.getSQLValue(null, (String)"SELECT AD_Reference_ID FROM AD_Reference WHERE Name = ?", (String)"PA_Goal ChartType");
            MLookupInfo info = MLookupFactory.getLookup_List((Language)Env.getLanguage((Properties)Env.getCtx()), (int)AD_Reference_Value_ID);
            MLookup mLookup = new MLookup(info, 0);
            VLookup lookup = new VLookup("ChartType", false, false, true, (Lookup)mLookup);
            lookup.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    Object value = evt.getNewValue();
                    if (value == null) {
                        return;
                    }
                    JFreeChart chart = null;
                    chart = Graph.this.builder.createChart(value.toString());
                    if (chart != null) {
                        if (Graph.this.chartPanel != null) {
                            Graph.this.remove((Component)Graph.this.chartPanel);
                        }
                        Graph.this.chartPanel = new ChartPanel(chart);
                        Graph.this.chartPanel.setSize(Graph.this.getSize());
                        Graph.this.chartPanel.addChartMouseListener((ChartMouseListener)Graph.this);
                        Graph.this.add((Component)Graph.this.chartPanel, "Center");
                        Graph.this.getParent().validate();
                    }
                }
            });
            this.add((Component)lookup, "North");
        }
        this.setMinimumSize(paneldimension);
    }

    public Point getPoint0_0() {
        return this.m_point0_0;
    }

    public String getX_AxisLabel() {
        return this.builder.getXAxisLabel();
    }

    public void setX_AxisLabel(String axisLabel) {
        this.builder.setXAxisLabel(axisLabel);
    }

    public String getY_AxisLabel() {
        return this.builder.getYAxisLabel();
    }

    public void setY_AxisLabel(String axisLabel) {
        this.builder.setYAxisLabel(axisLabel);
    }

    public String getY_TargetLabel() {
        return this.m_Y_TargetLabel;
    }

    public void setY_TargetLabel(String targetLabel, double target) {
        this.m_Y_TargetLabel = targetLabel;
        this.m_Y_Target = target;
    }

    private GraphColumn getGraphColumn(ChartMouseEvent event) {
        Comparable sectionKey;
        ChartEntity entity = event.getEntity();
        String key = null;
        if (entity instanceof CategoryItemEntity) {
            Comparable colKey = ((CategoryItemEntity)entity).getColumnKey();
            if (colKey != null) {
                key = colKey.toString();
            }
        } else if (entity instanceof PieSectionEntity && (sectionKey = ((PieSectionEntity)entity).getSectionKey()) != null) {
            key = sectionKey.toString();
        }
        if (key == null) {
            return null;
        }
        int i = 0;
        while (i < this.list.size()) {
            String label = this.list.get(i).getLabel();
            if (key.equals(label)) {
                return this.list.get(i);
            }
            ++i;
        }
        return null;
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        if (event.getEntity() != null && event.getTrigger().getClickCount() > 1) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                GraphColumn bgc = this.getGraphColumn(event);
                if (bgc == null) {
                    return;
                }
                MQuery query = bgc.getMQuery(this.builder.getMGoal());
                if (query != null) {
                    AEnv.zoom(query);
                } else {
                    log.warning("Nothing to zoom to - " + bgc);
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void chartMouseMoved(ChartMouseEvent event) {
    }

    public GraphColumn[] getGraphColumnList() {
        return this.list.toArray(new GraphColumn[this.list.size()]);
    }
}

