/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pdf.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.jpedal.PdfDecoder;

public class PDFViewerBean
extends JPanel {
    private static final long serialVersionUID = -365936659584244L;
    private final PdfDecoder decoder = new PdfDecoder();
    private final JScrollPane center = new JScrollPane((Component)this.decoder);
    private final JTextField pageField = new JTextField(2);
    private final JLabel pageCountLabel = new JLabel("00");
    private final JComboBox rotationSelect = new JComboBox<String>(new String[]{"0", "90", "180", "270"});
    private final JComboBox zoomSelect;
    private final float[] zoomFactors = new float[]{0.25f, 0.33f, 0.5f, 0.75f, 1.0f, 1.5f, 2.0f, 4.0f, 8.0f};
    private final Action printAction = new AbstractAction(){
        private static final long serialVersionUID = -4038401603459821668L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PDFViewerBean.this.print();
        }
    };
    private final Action saveAction = new AbstractAction(){
        private static final long serialVersionUID = 2556454917786013951L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PDFViewerBean.this.save();
        }
    };
    private final Action goFirstAction = new AbstractAction(){
        private static final long serialVersionUID = 3012006964079877706L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PDFViewerBean.this.goFirst();
        }
    };
    private final Action goPreviousAction = new AbstractAction(){
        private static final long serialVersionUID = 7146121058674779580L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PDFViewerBean.this.goPrevious();
        }
    };
    private final Action goNextAction = new AbstractAction(){
        private static final long serialVersionUID = -535856649012053593L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PDFViewerBean.this.goNext();
        }
    };
    private final Action goLastAction = new AbstractAction(){
        private static final long serialVersionUID = -9129162509234933692L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PDFViewerBean.this.goLast();
        }
    };
    private final Action zoomInAction = new AbstractAction(){
        private static final long serialVersionUID = 8712227061870874820L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PDFViewerBean.this.zoomIn();
        }
    };
    private final Action zoomOutAction = new AbstractAction(){
        private static final long serialVersionUID = -796771923722993041L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PDFViewerBean.this.zoomOut();
        }
    };
    private final Action rotateCClockAction = new AbstractAction(){
        private static final long serialVersionUID = -5323310183497748731L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PDFViewerBean.this.rotateCClock();
        }
    };
    private final Action rotateClockAction = new AbstractAction(){
        private static final long serialVersionUID = 7048804716310413300L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PDFViewerBean.this.rotateClock();
        }
    };
    private String filename;
    private int currentPage = 1;
    private int scaleStep = 3;
    private int rotation = 0;
    private File tmpFile = null;

    public PDFViewerBean() {
        String[] zoomLabels = new String[this.zoomFactors.length];
        int i = 0;
        while (i < this.zoomFactors.length) {
            zoomLabels[i] = Integer.toString((int)(this.zoomFactors[i] * 100.0f));
            ++i;
        }
        this.zoomSelect = new JComboBox<String>(zoomLabels);
        this.zoomSelect.addActionListener(new ActionListener(){
            private boolean isAdjusting = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.isAdjusting) {
                    return;
                }
                this.isAdjusting = true;
                try {
                    PDFViewerBean.this.setScaleStep(PDFViewerBean.this.zoomSelect.getSelectedIndex());
                }
                finally {
                    this.isAdjusting = false;
                }
            }
        });
        this.rotationSelect.addActionListener(new ActionListener(){
            private boolean isAdjusting = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.isAdjusting) {
                    return;
                }
                this.isAdjusting = true;
                try {
                    PDFViewerBean.this.setRotation(PDFViewerBean.this.rotationSelect.getSelectedIndex() * 90);
                }
                finally {
                    this.isAdjusting = false;
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.createToolBar();
        this.add("Center", this.center);
        this.pageField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PDFViewerBean.this.pageField.selectAll();
            }
        });
        this.pageField.setHorizontalAlignment(11);
        this.pageField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PDFViewerBean.this.setCurrentPage(Integer.parseInt(PDFViewerBean.this.pageField.getText()));
            }
        });
        this.setPreferredSize(new Dimension(480, 0));
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
        this.rotationSelect.setSelectedIndex(rotation / 90);
        this.updateZoomRotate();
    }

    public void goFirst() {
        this.setCurrentPage(1);
    }

    public void goPrevious() {
        this.setCurrentPage(this.currentPage - 1);
    }

    public void goNext() {
        this.setCurrentPage(this.currentPage + 1);
    }

    public void goLast() {
        this.setCurrentPage(this.decoder.getPageCount());
    }

    public void setCurrentPage(int page) {
        if (page < 1 || page > this.decoder.getPageCount()) {
            return;
        }
        Cursor oldCursor = this.getCursor();
        try {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.decoder.setPageParameters(this.zoomFactors[this.scaleStep], page);
                this.decoder.decodePage(page);
                this.setRotation(this.decoder.getPdfPageData().getRotation(page));
                this.currentPage = page;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setCursor(oldCursor);
                return;
            }
        }
        finally {
            this.setCursor(oldCursor);
        }
        this.goFirstAction.setEnabled(this.currentPage > 1);
        this.goPreviousAction.setEnabled(this.currentPage > 1);
        this.goNextAction.setEnabled(this.currentPage < this.decoder.getPageCount());
        this.goLastAction.setEnabled(this.currentPage < this.decoder.getPageCount());
        this.pageField.setText(Integer.toString(this.currentPage));
    }

    public void zoomIn() {
        this.setScaleStep(this.scaleStep + 1);
    }

    public void zoomOut() {
        this.setScaleStep(this.scaleStep - 1);
    }

    public void rotateCClock() {
        this.rotationSelect.setSelectedIndex((this.rotationSelect.getSelectedIndex() + 3) % 4);
    }

    public void rotateClock() {
        this.rotationSelect.setSelectedIndex((this.rotationSelect.getSelectedIndex() + 1) % 4);
    }

    public void save() {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "PDF File";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".pdf");
            }
        });
        if (fc.showSaveDialog(this) != 0) {
            return;
        }
        File targetFile = fc.getSelectedFile();
        if (!targetFile.getName().toLowerCase().endsWith(".pdf")) {
            targetFile = new File(targetFile.getParentFile(), String.valueOf(targetFile.getName()) + ".pdf");
        }
        if (targetFile.exists() && JOptionPane.showConfirmDialog(this, "Do you want to overwrite the file?") != 0) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream(this.filename);
            try {
                FileOutputStream os = new FileOutputStream(targetFile);
                try {
                    int read;
                    byte[] buffer = new byte[32768];
                    while ((read = ((InputStream)is).read(buffer)) != -1) {
                        ((OutputStream)os).write(buffer, 0, read);
                    }
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPageable((Pageable)this.decoder);
        PageFormat pf = printJob.defaultPage();
        this.decoder.setPageFormat(pf);
        this.decoder.setTextPrint(1);
        printJob.setPrintable((Printable)this.decoder, pf);
        if (printJob.printDialog()) {
            Cursor oldCursor = this.getCursor();
            try {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    printJob.print();
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                    this.setCursor(oldCursor);
                }
            }
            finally {
                this.setCursor(oldCursor);
            }
        }
    }

    protected void createToolBar() {
        JToolBar bar = new JToolBar();
        bar.add(this.createActionButton(this.printAction, null, "22x22/document-print.png", "Print document"));
        bar.add(this.createActionButton(this.saveAction, null, "22x22/document-save.png", "Save document"));
        bar.add(this.createActionButton(this.goFirstAction, null, "22x22/go-first.png", "First page"));
        bar.add(this.createActionButton(this.goPreviousAction, null, "22x22/go-previous.png", "Previos page"));
        JPanel pagePanel = this.createToolbarItemPanel(this.pageField);
        bar.add(pagePanel);
        bar.add(this.createActionButton(this.goNextAction, null, "22x22/go-next.png", "Next page"));
        bar.add(this.createActionButton(this.goLastAction, null, "22x22/go-last.png", "Last page"));
        bar.add(this.createActionButton(this.zoomOutAction, null, "22x22/zoom-out.png", "Next page"));
        bar.add(this.createToolbarItemPanel(this.zoomSelect));
        bar.add(this.createActionButton(this.zoomInAction, null, "22x22/zoom-in.png", "Next page"));
        bar.add(this.createActionButton(this.rotateCClockAction, null, "22x22/rotate-cclock.png", "Next page"));
        bar.add(this.createToolbarItemPanel(this.rotationSelect));
        bar.add(this.createActionButton(this.rotateClockAction, null, "22x22/rotate-clock.png", "Next page"));
        bar.setFloatable(false);
        this.add("North", bar);
    }

    protected JPanel createToolbarItemPanel(JComponent component) {
        JPanel pagePanel = new JPanel(new GridBagLayout());
        pagePanel.add(component);
        pagePanel.setMaximumSize(pagePanel.getPreferredSize());
        return pagePanel;
    }

    public void loadPDF(String filename) {
        this.filename = filename;
        try {
            this.decoder.closePdfFile();
            this.decoder.openPdfFile(filename);
            this.pageCountLabel.setText(String.valueOf(this.decoder.getPageCount()) + " ");
            this.setCurrentPage(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected JButton createActionButton(Action action, String text, String image, String tooltip) {
        final ImageIcon icon = new ImageIcon(this.getClass().getResource(image));
        double colorFactor = 0.9;
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                int alpha = rgb >> 24 & 0xFF;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                return (int)((double)alpha * 0.9) << 24 | (int)((double)red * 0.9) << 16 | (int)((double)green * 0.9) << 8 | (int)((double)blue * 0.9);
            }
        };
        final ImageIcon darkerIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(icon.getImage().getSource(), filter)));
        final JButton result = new JButton();
        result.setAction(action);
        result.setText(text);
        result.setIcon(darkerIcon);
        result.setBorderPainted(false);
        result.setHorizontalTextPosition(0);
        result.setVerticalTextPosition(3);
        result.setMnemonic(0);
        result.setToolTipText(tooltip);
        Dimension dim = result.getPreferredSize();
        result.setMaximumSize(new Dimension(32, dim.height));
        result.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                result.setBorderPainted(true);
                result.setIcon(icon);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                result.setBorderPainted(false);
                result.setIcon(darkerIcon);
            }
        });
        result.setBorderPainted(false);
        result.setFocusPainted(false);
        return result;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void clearDocument() {
        this.decoder.closePdfFile();
        if (this.tmpFile != null) {
            this.tmpFile.delete();
            this.tmpFile = null;
        }
    }

    public void setScaleStep(int scaleStep) {
        if (scaleStep < 0 || this.zoomFactors.length <= scaleStep) {
            return;
        }
        this.scaleStep = scaleStep;
        this.zoomSelect.setSelectedIndex(scaleStep);
        this.updateZoomRotate();
    }

    protected void updateZoomRotate() {
        Cursor oldCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.decoder.setPageParameters(this.zoomFactors[this.scaleStep], this.currentPage, this.rotation);
            this.decoder.invalidate();
            this.decoder.repaint();
            this.zoomInAction.setEnabled(this.scaleStep < this.zoomFactors.length - 1);
            this.zoomOutAction.setEnabled(this.scaleStep > 0);
        }
        finally {
            this.setCursor(oldCursor);
        }
    }

    public void setScale(int percent) {
        int step = 0;
        while (step < this.zoomFactors.length - 1) {
            if (this.zoomFactors[step] * 100.0f >= (float)percent) break;
            ++step;
        }
        this.setScaleStep(step);
    }

    public void loadPDF(InputStream is) {
        block11: {
            if (this.tmpFile != null) {
                this.tmpFile.delete();
            }
            try {
                this.tmpFile = File.createTempFile("adempiere", ".pdf");
                this.tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            try {
                FileOutputStream os = new FileOutputStream(this.tmpFile);
                try {
                    try {
                        int read;
                        byte[] buffer = new byte[32768];
                        while ((read = is.read(buffer)) != -1) {
                            ((OutputStream)os).write(buffer, 0, read);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        ((OutputStream)os).close();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    ((OutputStream)os).close();
                    throw throwable;
                }
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadPDF(this.tmpFile.getAbsolutePath());
    }

    protected void finalize() throws Throwable {
        if (this.tmpFile != null) {
            this.tmpFile.delete();
        }
        this.decoder.closePdfFile();
    }
}

