/*
 * Decompiled with CFR 0.152.
 */
package org.compiere;

import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.MClient;
import org.compiere.model.MSystem;
import org.compiere.model.ModelValidationEngine;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Login;
import org.compiere.util.SecureEngine;
import org.compiere.util.Splash;

public final class AdempiereClient {
    private static CLogger log = null;

    public static synchronized boolean startup(boolean isClient) {
        if (log != null) {
            return true;
        }
        if (!Login.isJavaOK((boolean)isClient) && isClient) {
            System.exit(1);
        }
        CLogMgt.initialize((boolean)isClient);
        Ini.setClient((boolean)isClient);
        log = CLogger.getCLogger(AdempiereClient.class);
        if (log.isLoggable(Level.INFO)) {
            log.info(Adempiere.getSummaryAscii());
        }
        Ini.loadProperties((boolean)false);
        CLogMgt.setLevel((String)Ini.getProperty((String)"TraceLevel"));
        if (isClient && Ini.isPropertyBool((String)"TraceFile")) {
            CLogMgt.addHandler((Handler)new CLogFile(Ini.findAdempiereHome(), true, isClient));
        }
        if (isClient && CLogMgt.isLevelAll()) {
            log.log(Level.FINEST, System.getProperties().toString());
        }
        DB.setDBTarget((CConnection)CConnection.get((String)Adempiere.getCodeBaseHost()));
        if (isClient) {
            return false;
        }
        return AdempiereClient.startupEnvironment(isClient);
    }

    public static boolean startupEnvironment(boolean isClient) {
        String className;
        AdempiereClient.startup(isClient);
        if (!DB.isConnected()) {
            log.severe("No Database");
            return false;
        }
        MSystem system = MSystem.get((Properties)Env.getCtx());
        if (system == null) {
            return false;
        }
        ModelValidationEngine.get();
        try {
            className = system.getEncryptionKey();
            if (!(className != null && className.length() != 0 || (className = System.getProperty("ADEMPIERE_SECURE")) == null || className.length() <= 0 || className.equals("org.compiere.util.Secure"))) {
                SecureEngine.init((String)className);
                system.setEncryptionKey(className);
                system.saveEx();
            }
            SecureEngine.init((String)className);
            if (isClient) {
                MClient.get((Properties)Env.getCtx(), (int)0);
            } else {
                MClient.getAll((Properties)Env.getCtx());
            }
        }
        catch (Exception e) {
            log.warning("Environment problems: " + e.toString());
        }
        className = null;
        try {
            className = "org.compiere.wf.DocWorkflowManager";
            Class.forName(className);
            className = "org.compiere.print.ArchiveEngine";
            Class.forName(className);
        }
        catch (Exception e) {
            log.warning("Not started: " + className + " - " + e.getMessage());
        }
        if (!isClient) {
            DB.updateMail();
        }
        return true;
    }

    public static void main(String[] args) {
        Splash.getSplash();
        AdempiereClient.startup(true);
        String className = "org.compiere.apps.AMenu";
        int i = 0;
        while (i < args.length) {
            if (!args[i].equals("-debug")) {
                className = args[i];
                break;
            }
            ++i;
        }
        try {
            Class<?> startClass = Class.forName(className);
            startClass.newInstance();
        }
        catch (Exception e) {
            System.err.println("ADempiere starting: " + className + " - " + e.toString());
            e.printStackTrace();
        }
    }
}

