/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.compiere.Adempiere;
import org.compiere.acct.AcctViewerData;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.PrintScreenPainter;
import org.compiere.apps.search.Info;
import org.compiere.grid.ed.VDate;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MColumn;
import org.compiere.report.core.RModel;
import org.compiere.report.core.RModelExcelExporter;
import org.compiere.report.core.ResultTable;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CFrame;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTabbedPane;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class AcctViewer
extends CFrame
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = -6160970582569467185L;
    private AcctViewerData m_data = null;
    private ImageIcon m_iFind = new ImageIcon(Adempiere.getResource((String)"images/Find16.gif"));
    private static CLogger log = CLogger.getCLogger(AcctViewer.class);
    private CPanel mainPanel = new CPanel();
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel query = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CScrollPane result = new CScrollPane();
    private ResultTable table = new ResultTable();
    private CPanel southPanel = new CPanel();
    private CButton bQuery = new CButton();
    private CButton bPrint = new CButton();
    private CButton bExport = new CButton();
    private CLabel statusLine = new CLabel();
    private BorderLayout southLayout = new BorderLayout();
    private BorderLayout queryLayout = new BorderLayout();
    private CPanel selectionPanel = new CPanel();
    private CPanel displayPanel = new CPanel();
    private TitledBorder displayBorder;
    private TitledBorder selectionBorder;
    private GridBagLayout displayLayout = new GridBagLayout();
    private CCheckBox displayQty = new CCheckBox();
    private CCheckBox displaySourceAmt = new CCheckBox();
    private CCheckBox displayDocumentInfo = new CCheckBox();
    private CLabel lSort = new CLabel();
    private CComboBox sortBy1 = new CComboBox();
    private CComboBox sortBy2 = new CComboBox();
    private CComboBox sortBy3 = new CComboBox();
    private CCheckBox group1 = new CCheckBox();
    private CCheckBox group2 = new CCheckBox();
    private CCheckBox group3 = new CCheckBox();
    private CLabel lGroup = new CLabel();
    private GridBagLayout selectionLayout = new GridBagLayout();
    private CComboBox selAcctSchema = new CComboBox();
    private CComboBox selPostingType = new CComboBox();
    private CCheckBox selDocument = new CCheckBox();
    private CComboBox selTable = new CComboBox();
    private CButton selRecord = new CButton();
    private CLabel lOrg = new CLabel();
    private CComboBox selOrg = new CComboBox();
    private CLabel lAcct = new CLabel();
    private CButton selAcct = new CButton();
    private CLabel lDate = new CLabel();
    private CLabel lacctSchema = new CLabel();
    private CLabel lpostingType = new CLabel();
    private VDate selDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
    private VDate selDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
    private CLabel lsel1 = new CLabel();
    private CLabel lsel2 = new CLabel();
    private CLabel lsel3 = new CLabel();
    private CLabel lsel4 = new CLabel();
    private CLabel lsel5 = new CLabel();
    private CLabel lsel6 = new CLabel();
    private CLabel lsel7 = new CLabel();
    private CLabel lsel8 = new CLabel();
    private CButton sel1 = new CButton();
    private CButton sel2 = new CButton();
    private CButton sel3 = new CButton();
    private CButton sel4 = new CButton();
    private CButton sel5 = new CButton();
    private CButton sel6 = new CButton();
    private CButton sel7 = new CButton();
    private CButton sel8 = new CButton();
    private CButton bRePost = new CButton();
    private CCheckBox forcePost = new CCheckBox();
    private CComboBox sortBy4 = new CComboBox();
    private CCheckBox group4 = new CCheckBox();

    public AcctViewer() {
        this(0, 0, 0);
    }

    public AcctViewer(int AD_Client_ID, int AD_Table_ID, int Record_ID) {
        super(Msg.getMsg((Properties)Env.getCtx(), (String)"AcctViewer"));
        if (log.isLoggable(Level.INFO)) {
            log.info("AD_Table_ID=" + AD_Table_ID + ", Record_ID=" + Record_ID);
        }
        this.setDefaultCloseOperation(2);
        this.m_data = new AcctViewerData(Env.getCtx(), AEnv.createWindowNo(this), AD_Client_ID, AD_Table_ID);
        AEnv.addToWindowManager(this);
        try {
            this.jbInit();
            this.dynInit(AD_Table_ID, Record_ID);
            AEnv.showCenterScreen(this);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            this.dispose();
        }
    }

    private void jbInit() throws Exception {
        ImageIcon ii = new ImageIcon(Adempiere.getResource((String)"images/InfoAccount16.gif"));
        this.setIconImage(ii.getImage());
        this.mainLayout.setHgap(5);
        this.mainLayout.setVgap(5);
        this.mainPanel.setLayout(this.mainLayout);
        this.selectionPanel.setLayout(this.selectionLayout);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.selectionBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), Msg.getMsg((Properties)Env.getCtx(), (String)"Selection"));
        this.selectionPanel.setBorder(this.selectionBorder);
        this.lacctSchema.setLabelFor(this.selAcctSchema);
        this.lacctSchema.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_AcctSchema_ID"));
        this.lpostingType.setLabelFor(this.selPostingType);
        this.lpostingType.setText(Msg.translate((Properties)Env.getCtx(), (String)"PostingType"));
        this.selDocument.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"SelectDocument"));
        this.selDocument.addActionListener(this);
        this.lOrg.setLabelFor(this.selOrg);
        this.lOrg.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        this.lAcct.setLabelFor(this.selAcct);
        this.lAcct.setText(Msg.translate((Properties)Env.getCtx(), (String)"Account_ID"));
        this.lDate.setLabelFor(this.selDateFrom);
        this.lDate.setText(Msg.translate((Properties)Env.getCtx(), (String)"DateAcct"));
        this.lsel1.setLabelFor(this.sel1);
        this.lsel2.setLabelFor(this.sel2);
        this.lsel3.setLabelFor(this.sel3);
        this.lsel4.setLabelFor(this.sel4);
        this.lsel5.setLabelFor(this.sel5);
        this.lsel6.setLabelFor(this.sel6);
        this.lsel7.setLabelFor(this.sel7);
        this.lsel8.setLabelFor(this.sel8);
        this.displayBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), Msg.getMsg((Properties)Env.getCtx(), (String)"Display"));
        this.displayPanel.setBorder(this.displayBorder);
        this.displayPanel.setLayout(this.displayLayout);
        this.displayQty.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"DisplayQty"));
        this.displaySourceAmt.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"DisplaySourceInfo"));
        this.displayDocumentInfo.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"DisplayDocumentInfo"));
        this.lSort.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"SortBy"));
        this.lGroup.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"GroupBy"));
        this.displayPanel.add((Component)this.displaySourceAmt, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.displayDocumentInfo, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.lSort, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.sortBy1, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.sortBy2, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.group1, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.group2, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.lGroup, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.displayQty, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.displayPanel.add((Component)this.sortBy3, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.group3, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.sortBy4, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.group4, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lacctSchema, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.selectionPanel.add((Component)this.selAcctSchema, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.selectionPanel.add((Component)this.selDocument, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.selectionPanel.add((Component)this.selTable, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.selectionPanel.add((Component)this.selRecord, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.selectionPanel.add((Component)this.lpostingType, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.selPostingType, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lDate, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.selDateFrom, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.selDateTo, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lOrg, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.selOrg, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lAcct, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.selAcct, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel1, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel2, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel3, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel1, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel2, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel3, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel4, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel4, new GridBagConstraints(1, 9, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel5, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel5, new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel6, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel6, new GridBagConstraints(1, 11, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel7, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel7, new GridBagConstraints(1, 12, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel8, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel8, new GridBagConstraints(1, 13, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.queryLayout.setHgap(5);
        this.queryLayout.setVgap(5);
        this.query.setLayout(this.queryLayout);
        this.query.add((Component)this.selectionPanel, "Center");
        this.query.add((Component)this.displayPanel, "East");
        this.tabbedPane.add((Component)this.query, Msg.getMsg((Properties)Env.getCtx(), (String)"ViewerQuery"));
        this.tabbedPane.add((Component)this.result, Msg.getMsg((Properties)Env.getCtx(), (String)"ViewerResult"));
        this.tabbedPane.addChangeListener(this);
        this.result.getViewport().add((Component)this.table, null);
        this.southLayout.setHgap(5);
        this.southLayout.setVgap(5);
        this.southPanel.setLayout(this.southLayout);
        this.statusLine.setForeground(Color.blue);
        this.statusLine.setBorder(BorderFactory.createLoweredBevelBorder());
        this.southPanel.add((Component)this.statusLine, "Center");
        this.bRePost.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"RePost"));
        this.bRePost.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"RePostInfo"));
        this.bRePost.addActionListener(this);
        this.bRePost.setVisible(false);
        this.forcePost.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Force"));
        this.forcePost.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"ForceInfo"));
        this.forcePost.setVisible(false);
        CPanel leftSide = new CPanel(new FlowLayout(3, 0, 0));
        leftSide.add(this.bRePost);
        leftSide.add(this.forcePost);
        this.southPanel.add((Component)leftSide, "West");
        this.bQuery.setIcon(Env.getImageIcon((String)"Refresh16.gif"));
        this.bQuery.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh"));
        this.bQuery.addActionListener(this);
        this.bPrint.setIcon(Env.getImageIcon((String)"Print16.gif"));
        this.bPrint.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"Print"));
        this.bPrint.addActionListener(this);
        this.bExport.setIcon(Env.getImageIcon((String)"Export16.gif"));
        this.bExport.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"Export"));
        this.bExport.setVisible(this.tabbedPane.getSelectedIndex() == 1);
        this.bExport.addActionListener(this);
        CPanel rightSide = new CPanel(new FlowLayout(4, 0, 0));
        rightSide.add(this.bExport);
        rightSide.add(this.bPrint);
        rightSide.add(this.bQuery);
        this.southPanel.add((Component)rightSide, "East");
        this.getContentPane().add((Component)this.southPanel, "South");
    }

    private void dynInit(int AD_Table_ID, int Record_ID) {
        this.m_data.fillAcctSchema(this.selAcctSchema);
        this.selAcctSchema.addActionListener(this);
        this.actionAcctSchema();
        this.m_data.fillTable(this.selTable);
        this.selTable.addActionListener(this);
        this.selRecord.setIcon(this.m_iFind);
        this.selRecord.addActionListener(this);
        this.selRecord.setText("");
        this.m_data.fillPostingType(this.selPostingType);
        this.m_data.fillOrg(this.selOrg);
        this.selAcct.setActionCommand("Account_ID");
        this.selAcct.addActionListener(this);
        this.selAcct.setText("");
        this.selAcct.setIcon(this.m_iFind);
        boolean haveDoc = AD_Table_ID != 0 && Record_ID != 0;
        this.selDocument.setSelected(haveDoc);
        this.actionDocument();
        this.actionTable();
        this.statusLine.setText(" " + Msg.getMsg((Properties)Env.getCtx(), (String)"ViewerOptions"));
        if (haveDoc) {
            this.m_data.AD_Table_ID = AD_Table_ID;
            this.m_data.Record_ID = Record_ID;
            this.actionQuery();
        }
    }

    @Override
    public void dispose() {
        if (this.m_data != null) {
            this.m_data.dispose();
        }
        this.m_data = null;
        super.dispose();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        boolean visible = this.m_data.documentQuery && this.tabbedPane.getSelectedIndex() == 1;
        this.bRePost.setVisible(visible);
        this.bExport.setVisible(this.tabbedPane.getSelectedIndex() == 1);
        if (Ini.isPropertyBool((String)"ShowAdvanced")) {
            this.forcePost.setVisible(visible);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.selAcctSchema) {
            this.actionAcctSchema();
        } else if (source == this.bQuery) {
            this.actionQuery();
        } else if (source == this.selDocument) {
            this.actionDocument();
        } else if (source == this.selTable) {
            this.actionTable();
        } else if (source == this.bRePost) {
            this.actionRePost();
        } else if (source == this.bPrint) {
            PrintScreenPainter.printScreen(this);
        } else if (source == this.bExport) {
            this.exportExcel();
        } else if (source instanceof CButton) {
            this.actionButton((CButton)source);
        }
    }

    private void actionAcctSchema() {
        KeyNamePair kp = (KeyNamePair)this.selAcctSchema.getSelectedItem();
        if (kp == null) {
            return;
        }
        this.m_data.C_AcctSchema_ID = kp.getKey();
        this.m_data.ASchema = MAcctSchema.get((Properties)Env.getCtx(), (int)this.m_data.C_AcctSchema_ID);
        if (log.isLoggable(Level.INFO)) {
            log.info(this.m_data.ASchema.toString());
        }
        this.sortBy1.removeAllItems();
        this.sortBy2.removeAllItems();
        this.sortBy3.removeAllItems();
        this.sortBy4.removeAllItems();
        this.sortAddItem(new ValueNamePair("", ""));
        this.sortAddItem(new ValueNamePair("DateAcct", Msg.translate((Properties)Env.getCtx(), (String)"DateAcct")));
        this.sortAddItem(new ValueNamePair("DateTrx", Msg.translate((Properties)Env.getCtx(), (String)"DateTrx")));
        this.sortAddItem(new ValueNamePair("C_Period_ID", Msg.translate((Properties)Env.getCtx(), (String)"C_Period_ID")));
        CLabel[] labels = new CLabel[]{this.lsel1, this.lsel2, this.lsel3, this.lsel4, this.lsel5, this.lsel6, this.lsel7, this.lsel8};
        CButton[] buttons = new CButton[]{this.sel1, this.sel2, this.sel3, this.sel4, this.sel5, this.sel6, this.sel7, this.sel8};
        int selectionIndex = 0;
        MAcctSchemaElement[] elements = this.m_data.ASchema.getAcctSchemaElements();
        int i = 0;
        while (i < elements.length && selectionIndex < labels.length) {
            MAcctSchemaElement ase = elements[i];
            String columnName = ase.getColumnName();
            String displayColumnName = ase.getDisplayColumnName();
            this.sortAddItem(new ValueNamePair(columnName, Msg.translate((Properties)Env.getCtx(), (String)displayColumnName)));
            if (!ase.isElementType("OO") && !ase.isElementType("AC")) {
                labels[selectionIndex].setText(Msg.translate((Properties)Env.getCtx(), (String)displayColumnName));
                labels[selectionIndex].setVisible(true);
                buttons[selectionIndex].setActionCommand(columnName);
                buttons[selectionIndex].addActionListener(this);
                buttons[selectionIndex].setIcon(this.m_iFind);
                buttons[selectionIndex].setText("");
                buttons[selectionIndex].setVisible(true);
                ++selectionIndex;
            }
            ++i;
        }
        while (selectionIndex < labels.length) {
            labels[selectionIndex].setVisible(false);
            buttons[selectionIndex++].setVisible(false);
        }
    }

    private void sortAddItem(ValueNamePair vn) {
        this.sortBy1.addItem(vn);
        this.sortBy2.addItem(vn);
        this.sortBy3.addItem(vn);
        this.sortBy4.addItem(vn);
    }

    private void actionQuery() {
        StringBuilder para = new StringBuilder();
        this.m_data.C_AcctSchema_ID = 0;
        this.m_data.AD_Org_ID = 0;
        KeyNamePair kp = (KeyNamePair)this.selAcctSchema.getSelectedItem();
        if (kp != null) {
            this.m_data.C_AcctSchema_ID = kp.getKey();
        }
        para.append("C_AcctSchema_ID=").append(this.m_data.C_AcctSchema_ID);
        ValueNamePair vp = (ValueNamePair)this.selPostingType.getSelectedItem();
        this.m_data.PostingType = vp.getValue();
        para.append(", PostingType=").append(this.m_data.PostingType);
        this.m_data.documentQuery = this.selDocument.isSelected();
        para.append(", DocumentQuery=").append(this.m_data.documentQuery);
        if (this.selDocument.isSelected()) {
            if (this.m_data.AD_Table_ID == 0 || this.m_data.Record_ID == 0) {
                return;
            }
            para.append(", AD_Table_ID=").append(this.m_data.AD_Table_ID).append(", Record_ID=").append(this.m_data.Record_ID);
        } else {
            this.m_data.DateFrom = (Timestamp)this.selDateFrom.getValue();
            para.append(", DateFrom=").append(this.m_data.DateFrom);
            this.m_data.DateTo = (Timestamp)this.selDateTo.getValue();
            para.append(", DateTo=").append(this.m_data.DateTo);
            kp = (KeyNamePair)this.selOrg.getSelectedItem();
            if (kp != null) {
                this.m_data.AD_Org_ID = kp.getKey();
            }
            para.append(", AD_Org_ID=").append(this.m_data.AD_Org_ID);
            Iterator<String> it = this.m_data.whereInfo.values().iterator();
            while (it.hasNext()) {
                para.append(", ").append(it.next());
            }
        }
        this.m_data.displayQty = this.displayQty.isSelected();
        para.append(" - Display Qty=").append(this.m_data.displayQty);
        this.m_data.displaySourceAmt = this.displaySourceAmt.isSelected();
        para.append(", Source=").append(this.m_data.displaySourceAmt);
        this.m_data.displayDocumentInfo = this.displayDocumentInfo.isSelected();
        para.append(", Doc=").append(this.m_data.displayDocumentInfo);
        this.m_data.sortBy1 = ((ValueNamePair)this.sortBy1.getSelectedItem()).getValue();
        this.m_data.group1 = this.group1.isSelected();
        para.append(" - Sorting: ").append(this.m_data.sortBy1).append("/").append(this.m_data.group1);
        this.m_data.sortBy2 = ((ValueNamePair)this.sortBy2.getSelectedItem()).getValue();
        this.m_data.group2 = this.group2.isSelected();
        para.append(", ").append(this.m_data.sortBy2).append("/").append(this.m_data.group2);
        this.m_data.sortBy3 = ((ValueNamePair)this.sortBy3.getSelectedItem()).getValue();
        this.m_data.group3 = this.group3.isSelected();
        para.append(", ").append(this.m_data.sortBy3).append("/").append(this.m_data.group3);
        this.m_data.sortBy4 = ((ValueNamePair)this.sortBy4.getSelectedItem()).getValue();
        this.m_data.group4 = this.group4.isSelected();
        para.append(", ").append(this.m_data.sortBy4).append("/").append(this.m_data.group4);
        this.bQuery.setEnabled(false);
        this.statusLine.setText(" " + Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
        if (log.isLoggable(Level.CONFIG)) {
            log.config(para.toString());
        }
        Thread.yield();
        this.tabbedPane.setSelectedIndex(1);
        this.table.setModel(this.m_data.query());
        this.bQuery.setEnabled(true);
        this.statusLine.setText(" " + Msg.getMsg((Properties)Env.getCtx(), (String)"ViewerOptions"));
    }

    private void actionDocument() {
        boolean doc = this.selDocument.isSelected();
        this.selTable.setEnabled(doc);
        this.selRecord.setEnabled(doc);
        this.selDateFrom.setReadWrite(!doc);
        this.selDateTo.setReadWrite(!doc);
        this.selOrg.setEnabled(!doc);
        this.selAcct.setEnabled(!doc);
        this.sel1.setEnabled(!doc);
        this.sel2.setEnabled(!doc);
        this.sel3.setEnabled(!doc);
        this.sel4.setEnabled(!doc);
        this.sel5.setEnabled(!doc);
        this.sel6.setEnabled(!doc);
        this.sel7.setEnabled(!doc);
        this.sel8.setEnabled(!doc);
    }

    private void actionTable() {
        ValueNamePair vp = (ValueNamePair)this.selTable.getSelectedItem();
        this.m_data.AD_Table_ID = this.m_data.tableInfo.get(vp.getValue());
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(vp.getValue()) + " = " + this.m_data.AD_Table_ID);
        }
        this.m_data.Record_ID = 0;
        this.selRecord.setText("");
        this.selRecord.setActionCommand(String.valueOf(vp.getValue()) + "_ID");
    }

    private int actionButton(CButton button) {
        String tableName;
        Info info;
        MAcctSchemaElement ase;
        String keyColumn = button.getActionCommand();
        log.info(keyColumn);
        String whereClause = "(IsSummary='N' OR IsSummary IS NULL)";
        String lookupColumn = keyColumn;
        if (keyColumn.equals("Account_ID")) {
            lookupColumn = "C_ElementValue_ID";
            ase = this.m_data.ASchema.getAcctSchemaElement("AC");
            if (ase != null) {
                whereClause = String.valueOf(whereClause) + " AND C_Element_ID=" + ase.getC_Element_ID();
            }
        } else if (keyColumn.equals("User1_ID")) {
            lookupColumn = "C_ElementValue_ID";
            ase = this.m_data.ASchema.getAcctSchemaElement("U1");
            if (ase != null) {
                whereClause = String.valueOf(whereClause) + " AND C_Element_ID=" + ase.getC_Element_ID();
            }
        } else if (keyColumn.equals("User2_ID")) {
            lookupColumn = "C_ElementValue_ID";
            ase = this.m_data.ASchema.getAcctSchemaElement("U2");
            if (ase != null) {
                whereClause = String.valueOf(whereClause) + " AND C_Element_ID=" + ase.getC_Element_ID();
            }
        } else if (keyColumn.equals("AD_OrgTrx_ID")) {
            lookupColumn = "AD_Org_ID";
        } else if (keyColumn.equals("UserElement1_ID")) {
            ase = this.m_data.ASchema.getAcctSchemaElement("X1");
            lookupColumn = MColumn.getColumnName((Properties)Env.getCtx(), (int)ase.getAD_Column_ID());
            whereClause = "";
        } else if (keyColumn.equals("UserElement2_ID")) {
            ase = this.m_data.ASchema.getAcctSchemaElement("X2");
            lookupColumn = MColumn.getColumnName((Properties)Env.getCtx(), (int)ase.getAD_Column_ID());
            whereClause = "";
        } else if (keyColumn.equals("M_Product_ID")) {
            whereClause = "";
        } else if (this.selDocument.isSelected()) {
            whereClause = "";
        }
        if (!(info = Info.create(this, true, this.m_data.WindowNo, tableName = lookupColumn.substring(0, lookupColumn.length() - 3), lookupColumn, "", false, whereClause)).loadedOK()) {
            info.dispose();
            info = null;
            button.setText("");
            this.m_data.whereInfo.put(keyColumn, "");
            return 0;
        }
        info.setVisible(true);
        String selectSQL = info.getSelectedSQL();
        Integer key = (Integer)info.getSelectedKey();
        info = null;
        if (selectSQL == null || selectSQL.length() == 0 || key == null) {
            button.setText("");
            this.m_data.whereInfo.put(keyColumn, "");
            return 0;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(keyColumn) + " - " + key);
        }
        if (button == this.selRecord) {
            this.m_data.Record_ID = key;
        } else {
            this.m_data.whereInfo.put(keyColumn, String.valueOf(keyColumn) + "=" + key);
        }
        button.setText(this.m_data.getButtonText(tableName, lookupColumn, selectSQL));
        this.pack();
        return key;
    }

    private void actionRePost() {
        if (this.m_data.documentQuery && this.m_data.AD_Table_ID != 0 && this.m_data.Record_ID != 0 && ADialog.ask(this.m_data.WindowNo, this, "PostImmediate?")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            boolean force = this.forcePost.isSelected();
            String error = AEnv.postImmediate(this.m_data.WindowNo, this.m_data.AD_Client_ID, this.m_data.AD_Table_ID, this.m_data.Record_ID, force);
            this.setCursor(Cursor.getDefaultCursor());
            if (error != null) {
                ADialog.error(0, this, "PostingError-N", error);
            }
            this.actionQuery();
        }
    }

    private void exportExcel() {
        block3: {
            RModel model = this.table.getRModel();
            if (model == null) {
                return;
            }
            try {
                RModelExcelExporter exporter = new RModelExcelExporter(model);
                exporter.export(null, null);
            }
            catch (Exception e) {
                ADialog.error(0, this, "Error", e.getLocalizedMessage());
                if (!CLogMgt.isLevelFinest()) break block3;
                e.printStackTrace();
            }
        }
    }
}

