/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.rmi.AccessException;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.OnlineHelp;
import org.compiere.apps.StatusBar;
import org.compiere.db.CConnection;
import org.compiere.db.CConnectionEditor;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.MUser;
import org.compiere.print.CPrinter;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public final class ALogin
extends CDialog
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = -3057525535969948097L;
    protected static final String RESOURCE = "org.compiere.apps.ALoginRes";
    private static ResourceBundle res = ResourceBundle.getBundle("org.compiere.apps.ALoginRes");
    private static CLogger log = CLogger.getCLogger(ALogin.class);
    private static final int TAB_CONNECTION = 0;
    private static final int TAB_DEFAULTS = 1;
    private static final int TAB_CHANGE_PASSWORD = 2;
    private static final int NOT_CONNECTED = -1;
    private static final int CONNECTED_OK = 0;
    private static final int CONNECTED_OK_WITH_PASSWORD_EXPIRED = 1;
    private static final int NO_OF_SECURITY_QUESTION = 5;
    private static final String SECURITY_QUESTION_PREFIX = "SecurityQuestion_";
    private CPanel mainPanel = new CPanel(new BorderLayout());
    private CTabbedPane loginTabPane = new CTabbedPane();
    private CPanel connectionPanel = new CPanel();
    private CLabel hostLabel = new CLabel();
    private CConnectionEditor hostField = new CConnectionEditor();
    private CLabel userLabel = new CLabel();
    private CTextField userTextField = new CTextField();
    private CLabel passwordLabel = new CLabel();
    private JPasswordField passwordField = new JPasswordField();
    private CPanel defaultPanel = new CPanel();
    private CLabel clientLabel = new CLabel();
    private CLabel orgLabel = new CLabel();
    private CLabel dateLabel = new CLabel();
    private VDate dateField = new VDate(15);
    private VComboBox orgCombo = new VComboBox();
    private VComboBox clientCombo = new VComboBox();
    private CLabel warehouseLabel = new CLabel();
    private VComboBox warehouseCombo = new VComboBox();
    private CLabel printerLabel = new CLabel();
    private CPrinter printerField = new CPrinter();
    private CLabel roleLabel = new CLabel();
    private VComboBox roleCombo = new VComboBox();
    private CLabel copy0Label = new CLabel();
    private CLabel titleLabel = new CLabel();
    private CLabel versionLabel = new CLabel();
    private CLabel copy1Label = new CLabel();
    private GridBagLayout connectionLayout = new GridBagLayout();
    private GridBagLayout defaultPanelLayout = new GridBagLayout();
    private CLabel languageLabel = new CLabel();
    private VComboBox languageCombo = new VComboBox(Language.getNames());
    private CLabel compileDate = new CLabel();
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private StatusBar statusBar = new StatusBar();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, false, false, false, false, false, false);
    private CPanel changePasswordPanel = new CPanel();
    private GridBagLayout changePasswordPanelLayout = new GridBagLayout();
    private CLabel lblOldPassword = new CLabel();
    private CLabel lblNewPassword = new CLabel();
    private CLabel lblRetypeNewPassword = new CLabel();
    private JPasswordField txtOldPassword = new JPasswordField();
    private JPasswordField txtNewPassword = new JPasswordField();
    private JPasswordField txtRetypeNewPassword = new JPasswordField();
    private CLabel lblSecurityQuestion = new CLabel();
    private CLabel lblAnswer = new CLabel();
    private VComboBox lstSecurityQuestion = new VComboBox();
    private CTextField txtAnswer = new CTextField();
    private CConnection m_cc;
    private String m_user;
    private char[] m_pwd = new char[0];
    private boolean m_comboActive = false;
    private boolean m_okPressed = false;
    private int m_connectionOK = -1;
    private int m_WindowNo;
    private Properties m_ctx = Env.getCtx();
    private Login m_login = null;
    private String txt_NotConnected;
    private String txt_NoDatabase;
    private String txt_UserPwdError;
    private String txt_RoleError;
    private String txt_LoggedIn;
    private String txt_PasswordExpired;

    public ALogin(Frame parent) {
        super(parent, "Login", true);
        log.finer("");
        this.setDefaultCloseOperation(2);
        this.m_WindowNo = AEnv.createWindowNo(null);
        res = ResourceBundle.getBundle(RESOURCE);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
        this.getRootPane().setDefaultButton(this.confirmPanel.getOKButton());
        parent.setIconImage(Adempiere.getImage16());
    }

    private void jbInit() throws Exception {
        this.setName("Login");
        this.orgCombo.setName("orgCombo");
        this.clientCombo.setName("clientCombo");
        this.userTextField.setName("userTextField");
        this.passwordField.setName("passwordField");
        this.titleLabel.setFont(new Font("Serif", 2, 10));
        this.titleLabel.setForeground(Color.blue);
        this.titleLabel.setRequestFocusEnabled(false);
        this.titleLabel.setToolTipText(Adempiere.getURL());
        this.titleLabel.setHorizontalTextPosition(0);
        this.titleLabel.setIcon(Adempiere.getImageIconLogo());
        this.titleLabel.setText(Adempiere.getSubtitle());
        this.titleLabel.setVerticalTextPosition(3);
        this.versionLabel.setRequestFocusEnabled(false);
        this.versionLabel.setHorizontalAlignment(4);
        this.versionLabel.setHorizontalTextPosition(4);
        this.hostLabel.setRequestFocusEnabled(false);
        this.hostLabel.setLabelFor(this.hostField);
        this.hostField.addActionListener(this);
        this.userLabel.setRequestFocusEnabled(false);
        this.userLabel.setLabelFor(this.userTextField);
        this.passwordLabel.setRequestFocusEnabled(false);
        this.passwordLabel.setLabelFor(this.passwordField);
        this.languageLabel.setLabelFor(this.languageCombo);
        this.copy0Label.setFont(new Font("Serif", 2, 10));
        this.copy0Label.setForeground(Color.blue);
        this.copy0Label.setRequestFocusEnabled(false);
        this.copy1Label.setRequestFocusEnabled(false);
        this.roleLabel.setRequestFocusEnabled(false);
        this.roleLabel.setLabelFor(this.roleCombo);
        this.clientLabel.setRequestFocusEnabled(false);
        this.orgLabel.setRequestFocusEnabled(false);
        this.dateLabel.setRequestFocusEnabled(false);
        this.warehouseLabel.setRequestFocusEnabled(false);
        this.printerLabel.setRequestFocusEnabled(false);
        this.compileDate.setHorizontalAlignment(4);
        this.compileDate.setHorizontalTextPosition(4);
        this.compileDate.setText(Adempiere.DATE_VERSION);
        this.compileDate.setToolTipText(Adempiere.getImplementationVendor());
        this.southPanel.setLayout(this.southLayout);
        this.loginTabPane.addChangeListener(this);
        this.connectionPanel.setLayout(this.connectionLayout);
        this.titleLabel.setHorizontalAlignment(0);
        this.versionLabel.setText(Adempiere.MAIN_VERSION);
        this.versionLabel.setToolTipText(Adempiere.getImplementationVersion());
        this.hostLabel.setHorizontalAlignment(4);
        this.hostLabel.setText("Host");
        this.hostLabel.setLabelFor(this.hostField);
        this.connectionPanel.add((Component)this.hostLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.connectionPanel.add((Component)this.hostField, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.userLabel.setHorizontalAlignment(4);
        this.userLabel.setText("User");
        this.userLabel.setLabelFor(this.userTextField);
        this.connectionPanel.add((Component)this.userLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.userTextField.setText("System");
        this.connectionPanel.add((Component)this.userTextField, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.passwordLabel.setHorizontalAlignment(4);
        this.passwordLabel.setText("Password");
        this.passwordLabel.setLabelFor(this.passwordField);
        this.connectionPanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.passwordField.setText("System");
        this.connectionPanel.add((Component)this.passwordField, new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.languageLabel.setHorizontalAlignment(4);
        this.languageLabel.setText("Language");
        this.languageLabel.setLabelFor(this.languageCombo);
        this.languageCombo.addActionListener(this);
        this.connectionPanel.add((Component)this.languageLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.connectionPanel.add((Component)this.languageCombo, new GridBagConstraints(1, 5, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.copy0Label.setHorizontalAlignment(4);
        this.connectionPanel.add((Component)this.copy0Label, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.copy1Label.setText("\u00a9 1999-2013 iDempiere\u00ae");
        this.connectionPanel.add((Component)this.copy1Label, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 12, 12), 0, 0));
        this.connectionPanel.add((Component)this.compileDate, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 12, 0, new Insets(2, 0, 0, 12), 0, 0));
        this.connectionPanel.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 2, 2, 0.0, 0.0, 17, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.connectionPanel.add((Component)this.versionLabel, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 13, 0, new Insets(12, 5, 0, 12), 0, 0));
        this.loginTabPane.add((Component)this.connectionPanel, res.getString("Connection"));
        this.defaultPanel.setLayout(this.defaultPanelLayout);
        this.clientLabel.setText("Client");
        this.clientLabel.setHorizontalAlignment(4);
        this.clientLabel.setLabelFor(this.clientCombo);
        this.clientCombo.addActionListener(this);
        this.defaultPanel.add((Component)this.clientLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.defaultPanel.add((Component)this.clientCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.roleLabel.setText("Role");
        this.roleLabel.setHorizontalAlignment(4);
        this.roleLabel.setLabelFor(this.roleCombo);
        this.roleCombo.addActionListener(this);
        this.defaultPanel.add((Component)this.roleLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.defaultPanel.add((Component)this.roleCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.orgLabel.setText("Organization");
        this.orgLabel.setHorizontalAlignment(4);
        this.orgLabel.setLabelFor(this.orgCombo);
        this.defaultPanel.add((Component)this.orgLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.orgCombo.addActionListener(this);
        this.defaultPanel.add((Component)this.orgCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.dateLabel.setText("Date");
        this.dateLabel.setHorizontalAlignment(4);
        this.dateLabel.setLabelFor(this.dateField);
        this.defaultPanel.add((Component)this.dateLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.defaultPanel.add((Component)this.dateField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.warehouseLabel.setText("Warehouse");
        this.warehouseLabel.setHorizontalAlignment(4);
        this.warehouseLabel.setLabelFor(this.warehouseCombo);
        this.printerLabel.setText("Printer");
        this.printerLabel.setHorizontalAlignment(4);
        this.printerLabel.setLabelFor(this.printerField);
        this.defaultPanel.add((Component)this.printerLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 12, 5), 0, 0));
        this.defaultPanel.add((Component)this.printerField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 12, 12), 0, 0));
        this.defaultPanel.add((Component)this.warehouseLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.defaultPanel.add((Component)this.warehouseCombo, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.loginTabPane.add((Component)this.defaultPanel, res.getString("Defaults"));
        this.txtOldPassword.setName("txtOldPassword");
        this.lblOldPassword.setRequestFocusEnabled(false);
        this.lblOldPassword.setLabelFor(this.txtOldPassword);
        this.lblOldPassword.setHorizontalAlignment(4);
        this.lblOldPassword.setText(Msg.getMsg((Properties)this.m_ctx, (String)"Old Password"));
        this.txtNewPassword.setName("txtNewPassword");
        this.lblNewPassword.setRequestFocusEnabled(false);
        this.lblNewPassword.setLabelFor(this.txtNewPassword);
        this.lblNewPassword.setHorizontalAlignment(4);
        this.lblNewPassword.setText(Msg.getMsg((Properties)this.m_ctx, (String)"New Password"));
        this.txtRetypeNewPassword.setName("txtRetypeNewPassword");
        this.lblRetypeNewPassword.setRequestFocusEnabled(false);
        this.lblRetypeNewPassword.setLabelFor(this.txtRetypeNewPassword);
        this.lblRetypeNewPassword.setHorizontalAlignment(4);
        this.lblRetypeNewPassword.setText(Msg.getMsg((Properties)this.m_ctx, (String)"New Password Confirm"));
        this.lstSecurityQuestion.setName("lstSecurityQuestion");
        this.lblSecurityQuestion.setRequestFocusEnabled(false);
        this.lblSecurityQuestion.setLabelFor(this.lstSecurityQuestion);
        this.lblSecurityQuestion.setHorizontalAlignment(4);
        this.lblSecurityQuestion.setText(Msg.getMsg((Properties)this.m_ctx, (String)"SecurityQuestion"));
        this.lstSecurityQuestion.removeAllItems();
        int i = 1;
        while (i <= 5) {
            this.lstSecurityQuestion.addItem(new ValueNamePair(SECURITY_QUESTION_PREFIX + i, Msg.getMsg((Properties)this.m_ctx, (String)(SECURITY_QUESTION_PREFIX + i))));
            ++i;
        }
        this.txtAnswer.setName("txtAnswer");
        this.lblAnswer.setRequestFocusEnabled(false);
        this.lblAnswer.setLabelFor(this.txtAnswer);
        this.lblAnswer.setHorizontalAlignment(4);
        this.lblAnswer.setText(Msg.getMsg((Properties)this.m_ctx, (String)"Answer"));
        this.changePasswordPanel.setLayout(this.changePasswordPanelLayout);
        this.changePasswordPanel.add((Component)this.lblOldPassword, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.changePasswordPanel.add((Component)this.txtOldPassword, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.changePasswordPanel.add((Component)this.lblNewPassword, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.changePasswordPanel.add((Component)this.txtNewPassword, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.changePasswordPanel.add((Component)this.lblRetypeNewPassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.changePasswordPanel.add((Component)this.txtRetypeNewPassword, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.changePasswordPanel.add((Component)this.lblSecurityQuestion, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.changePasswordPanel.add((Component)this.lstSecurityQuestion, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.changePasswordPanel.add((Component)this.lblAnswer, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.changePasswordPanel.add((Component)this.txtAnswer, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.loginTabPane.add((Component)this.changePasswordPanel, res.getString("ChangePassword"));
        this.loginTabPane.setEnabledAt(2, false);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.loginTabPane, "Center");
        this.mainPanel.setName("loginMainPanel");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.confirmPanel, "North");
        this.southPanel.add((Component)this.statusBar, "South");
        this.confirmPanel.addActionListener(this);
        CButton helpBtn = new CButton(Env.getImageIcon2((String)"Help24"));
        helpBtn.setActionCommand("onlineLoginHelp");
        helpBtn.addActionListener(this);
        helpBtn.setToolTipText(res.getString("Help"));
        this.confirmPanel.addComponent(helpBtn);
        this.statusBar.setStatusDB(null);
    }

    public boolean initLogin() {
        this.m_cc = CConnection.get((String)Adempiere.getCodeBaseHost());
        this.hostField.setValue(this.m_cc);
        if (Ini.isPropertyBool((String)"ValidateConnectionOnStartup")) {
            this.validateConnection();
        }
        this.userTextField.setText(Ini.getProperty((String)"ApplicationUserID"));
        if (Ini.isPropertyBool((String)"StorePassword")) {
            this.passwordField.setText(Ini.getProperty((String)"ApplicationPassword"));
        } else {
            this.passwordField.setText("");
        }
        this.languageCombo.setSelectedItem(Ini.getProperty((String)"Language"));
        if (Ini.isPropertyBool((String)"AutoLogin")) {
            this.connectionOK();
            this.defaultsOK();
            if (this.m_connectionOK >= 0) {
                this.m_okPressed = true;
            }
            return this.m_connectionOK >= 0;
        }
        return false;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.toFront();
            this.confirmPanel.getOKButton().requestFocusInWindow();
        }
    }

    private void validateAppServer() {
        this.m_user = this.userTextField.getText();
        this.m_pwd = this.passwordField.getPassword();
        this.m_cc.setAppServerCredential(this.m_user, this.m_pwd);
        this.m_cc.testAppsServer();
    }

    private void connectToDatabase() {
        DB.setDBTarget((CConnection)this.m_cc);
        DB.connect();
    }

    private void validateConnection() {
        this.m_connectionOK = -1;
        this.validateAppServer();
        DB.closeTarget();
        this.connectToDatabase();
        this.hostField.setDisplay();
    }

    private void appExit() {
        this.m_connectionOK = -1;
        this.dispose();
    }

    public boolean isConnected() {
        return this.m_connectionOK >= -1;
    }

    public boolean isOKpressed() {
        return this.m_okPressed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.confirmPanel.getOKButton().setEnabled(false);
            if (this.loginTabPane.getSelectedIndex() == 0) {
                this.connectionOK();
                this.printerField.refresh();
            } else if (this.loginTabPane.getSelectedIndex() == 2) {
                this.validateChangePassword();
            } else {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.m_okPressed = true;
                if (!this.defaultsOK()) {
                    this.m_okPressed = false;
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.confirmPanel.getOKButton().setEnabled(true);
        } else if (e.getActionCommand().equals("Cancel")) {
            this.appExit();
        } else if (e.getSource() == this.hostField) {
            this.validateConnection();
            this.languageComboChanged();
        } else if (e.getSource() == this.languageCombo) {
            this.languageComboChanged();
        } else if (e.getSource() == this.clientCombo) {
            this.clientComboChanged();
        } else if (e.getSource() == this.roleCombo) {
            this.roleComboChanged();
        } else if (e.getSource() == this.orgCombo) {
            this.orgComboChanged();
        } else if ("onlineLoginHelp".equals(e.getActionCommand())) {
            OnlineHelp.openInDefaultBrowser();
        }
    }

    private void connectionOK() {
        log.info("");
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.confirmPanel.getOKButton().setEnabled(false);
        this.m_connectionOK = this.tryConnection();
        if (this.m_connectionOK >= 0) {
            Language l = Language.getLoginLanguage();
            Env.verifyLanguage((Properties)this.m_ctx, (Language)l);
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Language", (String)l.getAD_Language());
            Msg.getMsg((Properties)this.m_ctx, (String)"0");
            MSystem system = MSystem.get((Properties)this.m_ctx);
            if (system.isJustMigrated()) {
                this.statusBar.setStatusLine("Running: After Migration ....", true);
                ADialog.info(this.m_WindowNo, this, "AfterMigration");
                Thread.yield();
                DB.afterMigration((Properties)this.m_ctx);
            }
            this.printerField.setValue(Ini.getProperty((String)"Printer"));
            if (this.m_connectionOK == 1) {
                this.loginTabPane.setSelectedIndex(2);
            } else {
                this.loginTabPane.setSelectedIndex(1);
            }
        }
        this.confirmPanel.getOKButton().setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * Exception decompiling
     */
    private void validateChangePassword() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!String.valueOf(this.passwordField.getPassword()).equals(String.valueOf(this.m_pwd)) || !this.userTextField.getText().equals(this.m_user)) {
            this.m_connectionOK = -1;
        }
        if (this.m_connectionOK == 1) {
            this.statusBar.setStatusLine(this.txt_PasswordExpired);
            this.loginTabPane.setSelectedIndex(2);
        } else if (this.m_connectionOK == 0) {
            this.statusBar.setStatusLine(this.txt_LoggedIn);
        } else {
            this.statusBar.setStatusLine(this.txt_NotConnected, true);
            this.loginTabPane.setSelectedIndex(0);
        }
        this.confirmPanel.getOKButton().requestFocus();
    }

    private boolean defaultsOK() {
        log.info("");
        KeyNamePair org = (KeyNamePair)this.orgCombo.getSelectedItem();
        if (org == null) {
            return false;
        }
        Ini.setProperty((String)"Connection", (String)CConnection.get().toStringLong());
        Ini.setProperty((String)"Language", (String)((String)this.languageCombo.getSelectedItem()));
        String error = this.m_login.validateLogin(org);
        if (error != null && error.length() > 0) {
            ADialog.info(this.m_WindowNo, this, error);
            this.appExit();
            return false;
        }
        this.statusBar.setStatusLine("Loading Preferences");
        String msg = this.m_login.loadPreferences(org, (KeyNamePair)this.warehouseCombo.getSelectedItem(), this.dateField.getTimestamp(), this.printerField.getDisplay());
        if (msg.length() > 0) {
            ADialog.info(this.m_WindowNo, this, msg);
        }
        this.checkVersion();
        if (this.m_connectionOK >= 0) {
            this.dispose();
        }
        return this.m_connectionOK >= 0;
    }

    private int tryConnection() {
        this.m_user = this.userTextField.getText();
        this.m_pwd = this.passwordField.getPassword();
        if (!DB.isConnected((boolean)false)) {
            this.validateConnection();
        }
        if (!DB.isConnected((boolean)false)) {
            this.statusBar.setStatusLine(this.txt_NoDatabase, true);
            this.hostField.setBackground(AdempierePLAF.getFieldBackground_Error());
            return -1;
        }
        Ini.setProperty((String)"AdempiereSys", (boolean)"Reference".equalsIgnoreCase(CConnection.get().getDbUid()));
        Ini.setProperty((String)"LogMigrationScript", (boolean)"Reference".equalsIgnoreCase(CConnection.get().getDbUid()));
        this.m_login = new Login(this.m_ctx);
        KeyNamePair[] clients = null;
        try {
            clients = this.m_login.getClients(this.m_user, new String(this.m_pwd));
            if (clients == null || clients.length == 0) {
                String loginErrMsg = this.m_login.getLoginErrMsg();
                if (loginErrMsg != null && loginErrMsg.length() > 0) {
                    this.statusBar.setStatusLine(loginErrMsg, true);
                } else {
                    this.statusBar.setStatusLine(this.txt_UserPwdError, true);
                }
                this.userTextField.setBackground(AdempierePLAF.getFieldBackground_Error());
                this.passwordField.setBackground(AdempierePLAF.getFieldBackground_Error());
                return -1;
            }
        }
        catch (Throwable e) {
            if (e.getCause() instanceof AccessException) {
                this.statusBar.setStatusLine(this.txt_UserPwdError, true);
                this.userTextField.setBackground(AdempierePLAF.getFieldBackground_Error());
                this.passwordField.setBackground(AdempierePLAF.getFieldBackground_Error());
                return -1;
            }
            log.log(Level.SEVERE, CLogger.getRootCause((Throwable)e).getLocalizedMessage(), CLogger.getRootCause((Throwable)e));
            this.statusBar.setStatusLine(CLogger.getRootCause((Throwable)e).getLocalizedMessage(), true);
            return -1;
        }
        this.m_comboActive = true;
        if (this.clientCombo.getItemCount() > 0) {
            this.clientCombo.removeAllItems();
        }
        KeyNamePair iniValue = null;
        String iniDefault = Ini.getProperty((String)"Client");
        int i = 0;
        while (i < clients.length) {
            this.clientCombo.addItem(clients[i]);
            if (clients[i].getName().equals(iniDefault)) {
                iniValue = clients[i];
            }
            ++i;
        }
        if (iniValue != null) {
            this.clientCombo.setSelectedItem(iniValue);
        } else {
            this.clientCombo.setSelectedItem(clients[0]);
        }
        if (this.clientCombo.getItemCount() == 1) {
            this.clientCombo.setSelectedIndex(0);
            this.clientCombo.setVisible(false);
            this.clientLabel.setVisible(false);
        } else {
            this.clientLabel.setVisible(true);
            this.clientCombo.setVisible(true);
        }
        this.userTextField.setBackground(AdempierePLAF.getFieldBackground_Normal());
        this.passwordField.setBackground(AdempierePLAF.getFieldBackground_Normal());
        this.setTitle(this.hostField.getDisplay());
        this.m_comboActive = false;
        this.clientComboChanged();
        if (this.m_login.isPasswordExpired()) {
            this.statusBar.setStatusLine(this.txt_PasswordExpired);
            return 1;
        }
        this.statusBar.setStatusLine(this.txt_LoggedIn);
        return 0;
    }

    private void clientComboChanged() {
        KeyNamePair client = (KeyNamePair)this.clientCombo.getSelectedItem();
        if (client == null || this.m_comboActive) {
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(": " + client);
        }
        this.m_comboActive = true;
        Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", (int)client.getKey());
        MUser user = MUser.get((Properties)this.m_ctx, (String)this.userTextField.getText());
        if (user != null) {
            Env.setContext((Properties)this.m_ctx, (String)"#AD_User_Name", (String)this.userTextField.getText());
            Env.setContext((Properties)this.m_ctx, (String)"#AD_User_ID", (int)user.getAD_User_ID());
            Env.setContext((Properties)this.m_ctx, (String)"#SalesRep_ID", (int)user.getAD_User_ID());
        }
        KeyNamePair[] roles = this.m_login.getRoles(this.userTextField.getText(), client);
        this.roleCombo.setVisible(true);
        this.roleLabel.setVisible(true);
        if (this.roleCombo.getItemCount() > 0) {
            this.roleCombo.removeAllItems();
        }
        if (this.orgCombo.getItemCount() > 0) {
            this.orgCombo.removeAllItems();
        }
        if (roles == null || roles.length == 0) {
            this.statusBar.setStatusLine(this.txt_RoleError, true);
            this.m_comboActive = false;
            return;
        }
        KeyNamePair iniValue = null;
        String iniDefault = Ini.getProperty((String)"Role");
        int i = 0;
        while (i < roles.length) {
            this.roleCombo.addItem(roles[i]);
            if (roles[i].getName().equals(iniDefault)) {
                iniValue = roles[i];
            }
            ++i;
        }
        if (iniValue != null) {
            this.roleCombo.setSelectedItem(iniValue);
        }
        if (this.roleCombo.getItemCount() == 1 && !MSysConfig.getBooleanValue((String)"ALogin_ShowOneRole", (boolean)true)) {
            this.roleCombo.setSelectedIndex(0);
            this.roleCombo.setVisible(false);
            this.roleLabel.setVisible(false);
        }
        this.m_comboActive = false;
        this.roleComboChanged();
    }

    private void roleComboChanged() {
        MUser user;
        KeyNamePair rol = (KeyNamePair)this.roleCombo.getSelectedItem();
        if (rol == null || this.m_comboActive) {
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(": " + rol);
        }
        this.m_comboActive = true;
        if (Env.getContextAsInt((Properties)this.m_ctx, (String)"#AD_Client_ID") > 0 && (user = MUser.get((Properties)this.m_ctx, (String)this.userTextField.getText())) != null) {
            Env.setContext((Properties)this.m_ctx, (String)"#AD_User_ID", (int)user.getAD_User_ID());
            Env.setContext((Properties)this.m_ctx, (String)"#SalesRep_ID", (int)user.getAD_User_ID());
        }
        KeyNamePair[] orgs = this.m_login.getOrgs(rol);
        if (this.orgCombo.getItemCount() > 0) {
            this.orgCombo.removeAllItems();
        }
        if (orgs == null || orgs.length == 0) {
            this.statusBar.setStatusLine(this.txt_RoleError, true);
            this.m_comboActive = false;
            return;
        }
        KeyNamePair orgValue = null;
        KeyNamePair orgValue2 = null;
        String iniDefault = Ini.getProperty((String)"Organization");
        int i = 0;
        while (i < orgs.length) {
            this.orgCombo.addItem(orgs[i]);
            if (orgs[i].getName().equals(iniDefault)) {
                orgValue = orgs[i];
            }
            if (orgValue2 == null && orgs[i].getKey() != 0) {
                orgValue2 = orgs[i];
            }
            ++i;
        }
        if (orgValue2 != null && orgValue != null && orgValue.getKey() == 0) {
            orgValue = orgValue2;
        }
        if (orgValue != null) {
            this.orgCombo.setSelectedItem(orgValue);
        } else {
            orgValue = (KeyNamePair)this.orgCombo.getSelectedItem();
        }
        this.m_comboActive = false;
        this.orgComboChanged();
    }

    private void orgComboChanged() {
        KeyNamePair org = (KeyNamePair)this.orgCombo.getSelectedItem();
        if (org == null || this.m_comboActive) {
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(": " + org);
        }
        this.m_comboActive = true;
        KeyNamePair[] whs = this.m_login.getWarehouses(org);
        if (this.warehouseCombo.getItemCount() > 0) {
            this.warehouseCombo.removeAllItems();
        }
        if (whs != null) {
            KeyNamePair iniValue = null;
            String iniDefault = Ini.getProperty((String)"Warehouse");
            int i = 0;
            while (i < whs.length) {
                this.warehouseCombo.addItem(whs[i]);
                if (whs[i].getName().equals(iniDefault)) {
                    iniValue = whs[i];
                }
                ++i;
            }
            if (iniValue != null) {
                this.warehouseCombo.setSelectedItem(iniValue);
            }
        }
        this.m_comboActive = false;
    }

    private boolean checkVersion() {
        boolean retValue = false;
        try {
            String version = AEnv.getServerVersion();
            if (Adempiere.DATE_VERSION.equals(version)) {
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Server = Client - " + version);
                }
                retValue = true;
            } else if (version != null) {
                StringBuilder msg = new StringBuilder(">>\n");
                msg.append(res.getString("VersionConflict")).append("\n").append(res.getString("VersionInfo")).append("\n");
                msg.append(version == null ? "null" : version).append(" <> ").append(Adempiere.DATE_VERSION).append("\n");
                msg.append(res.getString("PleaseUpgrade")).append("\n<<");
                JOptionPane.showMessageDialog(null, msg.toString(), String.valueOf(Adempiere.getName()) + " - " + res.getString("VersionConflict"), 0);
                AEnv.exit(1);
            }
        }
        catch (Exception e) {
            log.severe("Contact Server failed - " + e.getClass().toString() + ": " + e.getMessage());
        }
        return retValue;
    }

    private void languageComboChanged() {
        boolean email_login;
        String langName = (String)this.languageCombo.getSelectedItem();
        Language language = Language.getLanguage((String)langName);
        Language.setLoginLanguage((Language)language);
        Env.setContext((Properties)this.m_ctx, (String)"#AD_Language", (String)language.getAD_Language());
        Locale loc = language.getLocale();
        Locale.setDefault(loc);
        this.setLocale(loc);
        res = ResourceBundle.getBundle(RESOURCE, loc);
        this.setTitle(res.getString("Login"));
        this.hostLabel.setText(res.getString("Host"));
        boolean bl = email_login = DB.isConnected() && MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false);
        if (email_login) {
            this.userLabel.setText(res.getString("EMail"));
        } else {
            this.userLabel.setText(res.getString("User"));
        }
        this.userLabel.setToolTipText(res.getString("EnterUser"));
        this.passwordLabel.setText(res.getString("Password"));
        this.passwordLabel.setToolTipText(res.getString("EnterPassword"));
        this.languageLabel.setText(res.getString("Language"));
        this.languageLabel.setToolTipText(res.getString("SelectLanguage"));
        this.roleLabel.setText(res.getString("Role"));
        this.clientLabel.setText(res.getString("Client"));
        this.orgLabel.setText(res.getString("Organization"));
        this.dateLabel.setText(res.getString("Date"));
        this.warehouseLabel.setText(res.getString("Warehouse"));
        this.printerLabel.setText(res.getString("Printer"));
        this.defaultPanel.setToolTipText(res.getString("Defaults"));
        this.connectionPanel.setToolTipText(res.getString("Connection"));
        this.txt_NotConnected = res.getString("NotConnected");
        this.txt_NoDatabase = res.getString("DatabaseNotFound");
        this.txt_UserPwdError = res.getString("UserPwdError");
        this.txt_RoleError = res.getString("RoleNotFound");
        this.txt_LoggedIn = res.getString("Authorized");
        this.txt_PasswordExpired = res.getString("PasswordExpired");
        this.loginTabPane.setTitleAt(0, res.getString("Connection"));
        if (this.loginTabPane.getTabCount() > 1) {
            this.loginTabPane.setTitleAt(1, res.getString("Defaults"));
        }
        this.confirmPanel.getOKButton().setToolTipText(res.getString("Ok"));
        this.confirmPanel.getCancelButton().setToolTipText(res.getString("Cancel"));
        this.dateField.setFormat();
        this.dateField.setValue(new Timestamp(System.currentTimeMillis()));
        if (this.m_connectionOK == 0) {
            this.setTitle(this.hostField.getDisplay());
            this.statusBar.setStatusLine(this.txt_LoggedIn);
        } else if (this.m_connectionOK == 1) {
            this.setTitle(this.hostField.getDisplay());
            this.statusBar.setStatusLine(this.txt_PasswordExpired);
        } else {
            this.setTitle(res.getString("Login"));
            this.statusBar.setStatusLine(this.txt_NotConnected, true);
        }
    }
}

