/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.adempiere.util.Callback;
import org.adempiere.util.IProcessUI;
import org.compiere.acct.AcctViewer;
import org.compiere.apps.AArchive;
import org.compiere.apps.AChat;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AExport;
import org.compiere.apps.AMenu;
import org.compiere.apps.ARequest;
import org.compiere.apps.AWindow;
import org.compiere.apps.AZoomAcross;
import org.compiere.apps.AppsAction;
import org.compiere.apps.Attachment;
import org.compiere.apps.ClientProcessCtrl;
import org.compiere.apps.Help;
import org.compiere.apps.ProcessModalDialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.WindowMenu;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.search.Find;
import org.compiere.grid.APanelTab;
import org.compiere.grid.GridController;
import org.compiere.grid.GridSynchronizer;
import org.compiere.grid.ICreateFrom;
import org.compiere.grid.RecordAccessDialog;
import org.compiere.grid.VCreateFromFactory;
import org.compiere.grid.VOnlyCurrentDays;
import org.compiere.grid.VSortTab;
import org.compiere.grid.VTabbedPane;
import org.compiere.grid.VTable;
import org.compiere.grid.ed.VButton;
import org.compiere.grid.ed.VDocAction;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.GridWorkbench;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MToolBarButtonRestrict;
import org.compiere.model.MUser;
import org.compiere.model.MWindow;
import org.compiere.model.X_AD_ToolBarButton;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.AReport;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;

public final class APanel
extends CPanel
implements DataStatusListener,
ChangeListener,
ActionListener,
IProcessUI {
    private static final long serialVersionUID = -253840959387736456L;
    private boolean isNested = false;
    private boolean ToolBarMenuRestictionLoaded = false;
    private static CLogger log = CLogger.getCLogger(APanel.class);
    private AWindow m_window;
    private boolean isCancel = false;
    private BorderLayout mainLayout = new BorderLayout();
    private VTabbedPane tabPanel = new VTabbedPane(true);
    private StatusBar statusBar = new StatusBar();
    private CPanel northPanel = new CPanel();
    private JToolBar toolBar = new JToolBar();
    private JMenuBar menuBar = new JMenuBar();
    private FlowLayout northLayout = new FlowLayout();
    private AppsAction aPrevious;
    private AppsAction aNext;
    private AppsAction aParent;
    private AppsAction aDetail;
    private AppsAction aFirst;
    private AppsAction aLast;
    private AppsAction aNew;
    private AppsAction aCopy;
    private AppsAction aDelete;
    private AppsAction aPrint;
    private AppsAction aPrintPreview;
    private AppsAction aExport = null;
    private AppsAction aRefresh;
    private AppsAction aHistory;
    private AppsAction aAttachment;
    private AppsAction aChat;
    private AppsAction aMulti;
    private AppsAction aFind;
    private AppsAction aWorkflow;
    private AppsAction aZoomAcross;
    private AppsAction aRequest;
    private AppsAction aWinSize;
    private AppsAction aArchive;
    private AppsAction aProcess;
    public AppsAction aIgnore;
    public AppsAction aSave;
    public AppsAction aSaveAndCreate;
    public AppsAction aLock;
    private AppsAction aReport;
    private AppsAction aEnd;
    private AppsAction aHome;
    private AppsAction aHelp;
    private AppsAction aProduct;
    private AppsAction aLogout;
    private AppsAction aAccount;
    private AppsAction aCalculator;
    private AppsAction aCalendar;
    private AppsAction aEditor;
    private AppsAction aPreference;
    private AppsAction aScript;
    private AppsAction aOnline;
    private AppsAction aMailSupport;
    private AppsAction aAbout;
    private AppsAction aPrintScr;
    private AppsAction aScrShot;
    private AppsAction aExit;
    private AppsAction aBPartner;
    private AppsAction aDeleteSelection;
    private AppsAction aShowAllWindow;
    private SwitchAction aSwitchLinesDownAction;
    private SwitchAction aSwitchLinesUpAction;
    private WindowMenu m_WindowMenu;
    private Properties m_ctx;
    private GridWorkbench m_mWorkbench;
    private GridTab m_curTab;
    private GridController m_curGC;
    private JTabbedPane m_curWinTab = null;
    private int m_curWindowNo;
    private int m_curTabIndex = -1;
    private APanelTab m_curAPanelTab = null;
    private boolean m_disposing = false;
    private boolean m_errorDisplayed = false;
    private boolean m_onlyCurrentRows = true;
    private int m_onlyCurrentDays = 0;
    private boolean m_isLocked = false;
    private boolean m_isPersonalLock = MRole.getDefault().isPersonalLock();
    private int m_lastModifiers;
    private HashMap<Integer, GridController> includedMap;
    private long m_popup_closingtime = 0L;

    public APanel(GridController gc, int windowNo) {
        this.isNested = true;
        this.m_ctx = Env.getCtx();
        try {
            this.m_curGC = gc;
            gc.addDataStatusListener(this);
            this.m_curTab = gc.getMTab();
            GridController tabElement = null;
            tabElement = gc;
            VTabbedPane tabPane = new VTabbedPane(false);
            tabPane.addTab(this.m_curTab.getName().toString(), this.m_curTab, (Component)tabElement);
            this.m_curWinTab = tabPane;
            this.m_curWindowNo = windowNo;
            this.jbInit();
            this.initSwitchLineAction();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        this.createMenu();
        MRole role = MRole.getDefault();
        this.m_curGC.query(this.m_onlyCurrentRows, this.m_onlyCurrentDays, role.getMaxQueryRecords());
        this.m_curTab.navigateCurrent();
        this.m_curGC.dynamicDisplay(0);
    }

    public APanel(AWindow window) {
        this.m_window = window;
        this.m_ctx = Env.getCtx();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        this.createMenu();
    }

    public void dispose() {
        this.m_disposing = true;
        if (this.m_curAPanelTab != null) {
            this.m_curAPanelTab.unregisterPanel();
            this.m_curAPanelTab = null;
        }
        this.tabPanel.dispose(this);
        this.tabPanel = null;
        int i = 0;
        while (i < this.m_mWorkbench.getWindowCount()) {
            this.m_curWindowNo = this.m_mWorkbench.getWindowNo(i);
            if (log.isLoggable(Level.INFO)) {
                log.info("#" + this.m_curWindowNo);
            }
            Env.setAutoCommit((Properties)this.m_ctx, (int)this.m_curWindowNo, (boolean)false);
            this.m_mWorkbench.dispose(i);
            Env.clearWinContext((Properties)this.m_ctx, (int)this.m_curWindowNo);
            ++i;
        }
        if (this.m_mWorkbench != null) {
            this.m_mWorkbench.dispose();
        }
        this.m_mWorkbench = null;
        if (this.menuBar != null) {
            this.menuBar.removeAll();
        }
        this.menuBar = null;
        if (this.toolBar != null) {
            this.toolBar.removeAll();
        }
        this.toolBar = null;
        this.removeAll();
    }

    private void jbInit() throws Exception {
        this.setLocale(Language.getLoginLanguage().getLocale());
        this.setLayout(this.mainLayout);
        this.mainLayout.setHgap(2);
        this.mainLayout.setVgap(2);
        if (this.isNested) {
            this.add((Component)this.m_curGC, "Center");
        } else {
            CPanel dummy = new CPanel();
            dummy.setLayout(new BorderLayout());
            dummy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            dummy.add((Component)this.tabPanel, "Center");
            this.add((Component)dummy, "Center");
        }
        this.add((Component)this.statusBar, "South");
        this.add((Component)this.northPanel, "North");
        this.northPanel.setLayout(this.northLayout);
        this.northLayout.setAlignment(0);
        this.toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setFloatable(false);
        this.northPanel.add((Component)this.toolBar, null);
    }

    private void createMenu() {
        JMenu mFile = AEnv.getMenu("File");
        this.menuBar.add(mFile);
        this.aPrintScr = this.addAction("PrintScreen", mFile, KeyStroke.getKeyStroke(154, 0), false);
        this.aScrShot = this.addAction("ScreenShot", mFile, KeyStroke.getKeyStroke(154, 1), false);
        this.aReport = this.addAction("Report", mFile, KeyStroke.getKeyStroke(122, 0), false);
        this.aPrint = this.addAction("Print", mFile, KeyStroke.getKeyStroke(123, 0), false);
        this.aPrintPreview = this.addAction("PrintPreview", mFile, KeyStroke.getKeyStroke(80, 9), false);
        if (MRole.getDefault().isCanExport()) {
            this.aExport = this.addAction("Export", mFile, null, false);
        }
        mFile.addSeparator();
        this.aEnd = this.addAction("End", mFile, KeyStroke.getKeyStroke(88, 8), false);
        this.aLogout = this.addAction("Logout", mFile, KeyStroke.getKeyStroke(76, 9), false);
        this.aExit = this.addAction("Exit", mFile, KeyStroke.getKeyStroke(88, 9), false);
        JMenu mEdit = AEnv.getMenu("Edit");
        this.menuBar.add(mEdit);
        this.aNew = this.addAction("New", mEdit, KeyStroke.getKeyStroke(113, 0), false);
        this.aSave = this.addAction("Save", mEdit, KeyStroke.getKeyStroke(115, 0), false);
        this.aSaveAndCreate = this.addAction("SaveCreate", mEdit, KeyStroke.getKeyStroke(81, 2), false);
        mEdit.addSeparator();
        this.aCopy = this.addAction("Copy", mEdit, KeyStroke.getKeyStroke(113, 1), false);
        this.aDelete = this.addAction("Delete", mEdit, KeyStroke.getKeyStroke(114, 0), false);
        this.aDeleteSelection = this.addAction("DeleteSelection", mEdit, KeyStroke.getKeyStroke(68, 2), false);
        this.aIgnore = this.addAction("Ignore", mEdit, KeyStroke.getKeyStroke(27, 0), false);
        this.aRefresh = this.addAction("Refresh", mEdit, KeyStroke.getKeyStroke(116, 0), false);
        mEdit.addSeparator();
        this.aFind = this.addAction("Find", mEdit, KeyStroke.getKeyStroke(117, 0), true);
        if (this.m_isPersonalLock) {
            this.aLock = this.addAction("Lock", mEdit, null, true);
        }
        JMenu mView = AEnv.getMenu("View");
        this.menuBar.add(mView);
        if (MRole.getDefault().isAllow_Info_Product()) {
            this.aProduct = this.addAction("InfoProduct", mView, KeyStroke.getKeyStroke(73, 8), false);
        }
        if (MRole.getDefault().isAllow_Info_BPartner()) {
            this.aBPartner = this.addAction("InfoBPartner", mView, KeyStroke.getKeyStroke(73, 9), false);
        }
        if (MRole.getDefault().isShowAcct() && MRole.getDefault().isAllow_Info_Account()) {
            this.aAccount = this.addAction("InfoAccount", mView, KeyStroke.getKeyStroke(73, 10), false);
        }
        if (MRole.getDefault().isAllow_Info_Schedule()) {
            AEnv.addMenuItem("InfoSchedule", null, null, mView, this);
        }
        mView.addSeparator();
        if (MRole.getDefault().isAllow_Info_Order()) {
            AEnv.addMenuItem("InfoOrder", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Invoice()) {
            AEnv.addMenuItem("InfoInvoice", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_InOut()) {
            AEnv.addMenuItem("InfoInOut", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Payment()) {
            AEnv.addMenuItem("InfoPayment", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Resource()) {
            AEnv.addMenuItem("InfoAssignment", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Asset()) {
            AEnv.addMenuItem("InfoAsset", "Info", null, mView, this);
        }
        mView.addSeparator();
        this.aAttachment = this.addAction("Attachment", mView, KeyStroke.getKeyStroke(118, 0), true);
        this.aChat = this.addAction("Chat", mView, null, true);
        this.aHistory = this.addAction("History", mView, KeyStroke.getKeyStroke(120, 0), true);
        mView.addSeparator();
        this.aMulti = this.addAction("Multi", mView, KeyStroke.getKeyStroke(119, 0), true);
        JMenu mGo = AEnv.getMenu("Go");
        this.menuBar.add(mGo);
        this.aFirst = this.addAction("First", mGo, KeyStroke.getKeyStroke(33, 8), false);
        this.aPrevious = this.addAction("Previous", mGo, KeyStroke.getKeyStroke(38, 8), false);
        this.aNext = this.addAction("Next", mGo, KeyStroke.getKeyStroke(40, 8), false);
        this.aLast = this.addAction("Last", mGo, KeyStroke.getKeyStroke(34, 8), false);
        mGo.addSeparator();
        this.aParent = this.addAction("Parent", mGo, KeyStroke.getKeyStroke(37, 8), false);
        this.aDetail = this.addAction("Detail", mGo, KeyStroke.getKeyStroke(39, 8), false);
        mGo.addSeparator();
        this.aZoomAcross = this.addAction("ZoomAcross", mGo, null, false);
        this.aRequest = this.addAction("Request", mGo, null, false);
        this.aArchive = this.addAction("Archive", mGo, null, false);
        this.aHome = this.addAction("Home", mGo, null, false);
        JMenu mTools = AEnv.getMenu("Tools");
        this.menuBar.add(mTools);
        this.aCalculator = this.addAction("Calculator", mTools, null, false);
        this.aCalendar = this.addAction("Calendar", mTools, null, false);
        this.aEditor = this.addAction("Editor", mTools, null, false);
        MUser user = MUser.get((Properties)Env.getCtx());
        if (user.isAdministrator()) {
            this.aScript = this.addAction("Script", mTools, null, false);
        }
        if ("Y".equals(Env.getContext((Properties)this.m_ctx, (String)"#SysAdmin"))) {
            this.aWinSize = this.addAction("WinSize", mTools, null, false);
        }
        if (AEnv.isWorkflowProcess()) {
            this.aWorkflow = this.addAction("WorkFlow", mTools, null, false);
        }
        if (MRole.getDefault().isShowPreference()) {
            mTools.addSeparator();
            this.aPreference = this.addAction("Preference", mTools, null, false);
        }
        AMenu aMenu = (AMenu)AEnv.getWindow(0);
        this.m_WindowMenu = new WindowMenu(aMenu.getWindowManager(), this.m_window);
        this.menuBar.add(this.m_WindowMenu);
        this.aShowAllWindow = this.addAction("ShowAllWindow", null, KeyStroke.getKeyStroke(87, 2), false);
        JMenu mHelp = AEnv.getMenu("Help");
        this.menuBar.add(mHelp);
        this.aHelp = this.addAction("Help", mHelp, KeyStroke.getKeyStroke(112, 0), false);
        this.aOnline = this.addAction("Online", mHelp, null, false);
        this.aMailSupport = this.addAction("EMailSupport", mHelp, null, false);
        this.aAbout = this.addAction("About", mHelp, null, false);
        this.aProcess = this.addAction("Process", null, null, false);
        this.toolBar.add(this.aIgnore.getButton());
        this.toolBar.addSeparator();
        this.toolBar.add(this.aHelp.getButton());
        this.toolBar.add(this.aNew.getButton());
        this.toolBar.add(this.aCopy.getButton());
        this.toolBar.add(this.aDelete.getButton());
        this.toolBar.add(this.aDeleteSelection.getButton());
        this.toolBar.add(this.aSave.getButton());
        this.toolBar.add(this.aSaveAndCreate.getButton());
        this.toolBar.add(this.aProcess.getButton());
        this.toolBar.addSeparator();
        this.toolBar.add(this.aRefresh.getButton());
        this.toolBar.add(this.aFind.getButton());
        this.toolBar.add(this.aAttachment.getButton());
        this.toolBar.add(this.aChat.getButton());
        this.toolBar.add(this.aMulti.getButton());
        this.toolBar.addSeparator();
        if (this.m_curGC == null || this.m_curGC != null && !this.m_curGC.isDetailGrid()) {
            this.toolBar.add(this.aHistory.getButton());
            this.toolBar.add(this.aHome.getButton());
            this.toolBar.add(this.aParent.getButton());
            this.toolBar.add(this.aDetail.getButton());
            this.toolBar.addSeparator();
        }
        this.toolBar.add(this.aFirst.getButton());
        this.toolBar.add(this.aPrevious.getButton());
        this.toolBar.add(this.aNext.getButton());
        this.toolBar.add(this.aLast.getButton());
        this.toolBar.addSeparator();
        this.toolBar.add(this.aReport.getButton());
        this.toolBar.add(this.aArchive.getButton());
        this.toolBar.add(this.aPrintPreview.getButton());
        this.toolBar.add(this.aPrint.getButton());
        if (this.m_curGC == null || this.m_curGC != null && !this.m_curGC.isDetailGrid()) {
            this.toolBar.addSeparator();
            if (this.m_isPersonalLock) {
                this.toolBar.add(this.aLock.getButton());
            }
            this.toolBar.add(this.aZoomAcross.getButton());
            if (this.aWorkflow != null) {
                this.toolBar.add(this.aWorkflow.getButton());
            }
            this.toolBar.add(this.aRequest.getButton());
            if (MRole.getDefault().isAllow_Info_Product()) {
                this.toolBar.add(this.aProduct.getButton());
            }
            this.toolBar.addSeparator();
            this.toolBar.add(this.aEnd.getButton());
        }
        if (CLogMgt.isLevelAll()) {
            Util.printActionInputMap((JComponent)this);
        }
    }

    private AppsAction addAction(String actionName, JMenu menu, KeyStroke accelerator, boolean toggle) {
        AppsAction action = new AppsAction(actionName, accelerator, toggle);
        if (menu != null) {
            menu.add(action.getMenuItem());
        }
        action.setDelegate(this);
        if (accelerator != null) {
            this.getInputMap(2).put(accelerator, actionName);
            this.getActionMap().put(actionName, action);
        }
        return action;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public String getTitle() {
        if (this.m_mWorkbench != null && this.m_mWorkbench.getWindowCount() > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.m_mWorkbench.getName()).append("  ").append(Env.getContext((Properties)this.m_ctx, (String)"#AD_User_Name")).append("@").append(Env.getContext((Properties)this.m_ctx, (String)"#AD_Client_Name")).append(".").append(Env.getContext((Properties)this.m_ctx, (String)"#AD_Org_Name")).append(" [").append(Env.getContext((Properties)this.m_ctx, (String)"#DB_UID")).append("]");
            return sb.toString();
        }
        return Env.getHeader((Properties)this.m_ctx, (int)this.m_curWindowNo);
    }

    public boolean initPanel(int AD_Workbench_ID, int AD_Window_ID, MQuery query) {
        if (log.isLoggable(Level.INFO)) {
            log.info("WB=" + AD_Workbench_ID + ", Win=" + AD_Window_ID + ", Query=" + query);
        }
        this.setName("APanel" + AD_Window_ID);
        if (AD_Workbench_ID != 0) {
            ADialog.warn(0, this, "", "Not implemented yet");
            return false;
        }
        this.m_mWorkbench = new GridWorkbench(this.m_ctx, AD_Window_ID);
        Dimension windowSize = this.m_mWorkbench.getWindowSize();
        MQuery detailQuery = null;
        int wb = 0;
        while (wb < this.m_mWorkbench.getWindowCount()) {
            this.m_curWindowNo = AEnv.createWindowNo(this);
            this.m_mWorkbench.setWindowNo(wb, this.m_curWindowNo);
            Env.setAutoCommit((Properties)this.m_ctx, (int)this.m_curWindowNo, (boolean)Env.isAutoCommit((Properties)this.m_ctx));
            boolean autoNew = Env.isAutoNew((Properties)this.m_ctx);
            Env.setAutoNew((Properties)this.m_ctx, (int)this.m_curWindowNo, (boolean)autoNew);
            VTabbedPane window = null;
            if (this.m_mWorkbench.getWindowCount() == 1) {
                window = this.tabPanel;
                window.setWorkbench(false);
            } else {
                VTabbedPane tp;
                window = tp = new VTabbedPane(false);
            }
            window.addChangeListener(this);
            int wbType = this.m_mWorkbench.getWindowType(wb);
            if (wbType == 1) {
                this.includedMap = new HashMap(4);
                GridWindowVO wVO = Env.getMWindowVO((int)this.m_curWindowNo, (int)this.m_mWorkbench.getWindowID(wb), (int)0);
                if (wVO == null) {
                    ADialog.error(0, null, "AccessTableNoView", "(No Window Model Info)");
                    return false;
                }
                GridWindow mWindow = new GridWindow(wVO, true);
                Env.setContext((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)"IsSOTrx", (boolean)mWindow.isSOTrx());
                if (!autoNew && mWindow.isTransaction()) {
                    Env.setAutoNew((Properties)this.m_ctx, (int)this.m_curWindowNo, (boolean)true);
                }
                this.m_mWorkbench.setMWindow(wb, mWindow);
                if (wb == 0) {
                    this.m_onlyCurrentRows = mWindow.isTransaction();
                }
                if (windowSize == null) {
                    windowSize = mWindow.getWindowSize();
                }
                int tabSize = mWindow.getTabCount();
                boolean goSingleRow = query != null;
                int tab = 0;
                while (tab < tabSize) {
                    boolean included = false;
                    if (tab == 0) {
                        mWindow.initTab(0);
                    }
                    GridTab gTab = mWindow.getTab(tab);
                    Env.setContext((Properties)this.m_ctx, (int)this.m_curWindowNo, (int)tab, (String)"_TabInfo_TabLevel", (String)Integer.toString(gTab.getTabLevel()));
                    if (tab == 0) {
                        if (this.m_mWorkbench.getWindowCount() == 1) {
                            if (query != null && query.getZoomTableName() != null && query.getZoomColumnName() != null && query.getZoomValue() instanceof Integer && (Integer)query.getZoomValue() > 0 && !query.getZoomTableName().equalsIgnoreCase(gTab.getTableName())) {
                                detailQuery = query;
                                query = new MQuery();
                                query.addRestriction("1=2");
                            }
                            this.isCancel = false;
                            query = this.initialQuery(query, gTab);
                            if (this.isCancel) {
                                return false;
                            }
                            if (query != null && query.getRecordCount() <= 1) {
                                goSingleRow = true;
                            }
                        } else if (wb != 0) {
                            query = this.m_mWorkbench.getQuery();
                        }
                        if (query != null) {
                            this.m_onlyCurrentRows = false;
                            gTab.setQuery(query);
                        }
                        if (wb == 0) {
                            this.m_curTab = gTab;
                        }
                    }
                    CPanel tabElement = null;
                    if (gTab.isSortTab()) {
                        VSortTab st = new VSortTab(this.m_curWindowNo, gTab.getAD_Table_ID(), gTab.getAD_ColumnSortOrder_ID(), gTab.getAD_ColumnSortYesNo_ID());
                        st.setTabLevel(gTab.getTabLevel());
                        tabElement = st;
                    } else {
                        GridController parent;
                        GridController gc = new GridController();
                        CompiereColor cc = CompiereColor.getCompiereColor(mWindow.getColor());
                        if (cc != null) {
                            gc.setBackgroundColor(cc);
                        }
                        gc.initGrid(gTab, false, this.m_curWindowNo, this, mWindow, tab != 0);
                        gc.addDataStatusListener(this);
                        gc.registerESCAction(this.aIgnore);
                        if (wb == 0 && tab == 0) {
                            this.m_curGC = gc;
                            Dimension size = gc.getPreferredSize();
                            size.width += 4;
                            size.height += 4;
                            gc.setPreferredSize(size);
                        }
                        tabElement = gc;
                        if (tab == 0 && goSingleRow) {
                            gc.switchSingleRow();
                        }
                        GridField[] fields = gc.getMTab().getFields();
                        int m_tab_id = 0;
                        int f = 0;
                        while (f < fields.length) {
                            m_tab_id = fields[f].getIncluded_Tab_ID();
                            if (m_tab_id != 0) {
                                this.includedMap.put(m_tab_id, gc);
                            }
                            ++f;
                        }
                        if (this.includedMap.size() > 0 && (parent = this.includedMap.get(new Integer(gTab.getAD_Tab_ID()))) != null) {
                            gc.removeDataStatusListener(this);
                            GridSynchronizer synchronizer = new GridSynchronizer(mWindow, parent, gc);
                            if (parent == this.m_curGC) {
                                synchronizer.activateChild();
                            }
                            included = parent.includeTab(gc, this, synchronizer);
                        }
                        this.initSwitchLineAction();
                    }
                    if (!included) {
                        int pos;
                        StringBuilder tabName = new StringBuilder();
                        tabName.append("<html>");
                        if (gTab.isReadOnly()) {
                            tabName.append("<i>");
                        }
                        if ((pos = gTab.getName().indexOf(" ")) == -1) {
                            tabName.append(gTab.getName()).append("<br>&nbsp;");
                        } else {
                            tabName.append(gTab.getName().substring(0, pos)).append("<br>").append(gTab.getName().substring(pos + 1));
                        }
                        if (gTab.isReadOnly()) {
                            tabName.append("</i>");
                        }
                        tabName.append("<!--").append(gTab.getAD_Tab_ID()).append("-->");
                        tabName.append("</html>");
                        window.addTab(tabName.toString(), gTab, (Component)tabElement);
                    }
                    ++tab;
                }
            }
            if (this.m_mWorkbench.getWindowCount() == 1) {
                window.setToolTipText(this.m_mWorkbench.getDescription(wb));
            } else {
                this.tabPanel.addTab(this.m_mWorkbench.getName(wb), this.m_mWorkbench.getIcon(wb), window, this.m_mWorkbench.getDescription(wb));
            }
            Env.setContext((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)"_WinInfo_WindowName", (String)this.m_mWorkbench.getName(wb));
            ++wb;
        }
        this.toolBar.setName(this.getTitle());
        this.m_curTab.getTableModel().setChanged(false);
        this.aDetail.setEnabled(this.m_curWinTab.getTabCount() - 1 != 0);
        if (this.m_curWinTab instanceof VTabbedPane) {
            ((VTabbedPane)this.m_curWinTab).evaluate(null);
        }
        if (windowSize != null) {
            this.setPreferredSize(windowSize);
        } else {
            this.revalidate();
        }
        if (detailQuery != null && this.zoomToDetailTab(detailQuery)) {
            return true;
        }
        Dimension size = this.getPreferredSize();
        if (log.isLoggable(Level.INFO)) {
            log.info("fini - " + size);
        }
        this.m_curWinTab.requestFocusInWindow();
        return true;
    }

    private boolean zoomToDetailTab(MQuery query) {
        if (query != null && query.getZoomTableName() != null && query.getZoomColumnName() != null) {
            GridTab gTab = this.m_mWorkbench.getMWindow(0).getTab(0);
            if (!query.getZoomTableName().equalsIgnoreCase(gTab.getTableName())) {
                int tabSize = this.m_mWorkbench.getMWindow(0).getTabCount();
                int tab = 0;
                while (tab < tabSize) {
                    gTab = this.m_mWorkbench.getMWindow(0).getTab(tab);
                    if (!gTab.isSortTab() && gTab.getTableName().equalsIgnoreCase(query.getZoomTableName()) && this.doZoomToDetail(gTab, query, tab)) {
                        return true;
                    }
                    ++tab;
                }
            }
        }
        return false;
    }

    private boolean doZoomToDetail(GridTab gTab, MQuery query, int tabIndex) {
        GridField[] fields;
        GridField[] gridFieldArray = fields = gTab.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            GridField field = gridFieldArray[n2];
            if (field.getColumnName().equalsIgnoreCase(query.getZoomColumnName())) {
                this.m_mWorkbench.getMWindow(0).initTab(tabIndex);
                int parentId = DB.getSQLValue(null, (String)("SELECT " + gTab.getLinkColumnName() + " FROM " + gTab.getTableName() + " WHERE " + query.getWhereClause()));
                if (parentId > 0) {
                    TreeMap<Integer, Object[]> parentMap = new TreeMap<Integer, Object[]>();
                    int index = tabIndex;
                    int oldpid = parentId;
                    GridTab currentTab = gTab;
                    while (index > 0) {
                        GridTab pTab = this.m_mWorkbench.getMWindow(0).getTab(--index);
                        if (pTab.getTabLevel() >= currentTab.getTabLevel()) continue;
                        this.m_mWorkbench.getMWindow(0).initTab(index);
                        if (index > 0) {
                            if (pTab.getLinkColumnName() == null || pTab.getLinkColumnName().trim().length() <= 0) continue;
                            int pid = DB.getSQLValue(null, (String)("SELECT " + pTab.getLinkColumnName() + " FROM " + pTab.getTableName() + " WHERE " + currentTab.getLinkColumnName() + " = ?"), (int)oldpid);
                            if (pid > 0) {
                                parentMap.put(index, new Object[]{currentTab.getLinkColumnName(), oldpid});
                                oldpid = pid;
                                currentTab = pTab;
                                continue;
                            }
                            parentMap.clear();
                            break;
                        }
                        parentMap.put(index, new Object[]{currentTab.getLinkColumnName(), oldpid});
                    }
                    for (Map.Entry entry : parentMap.entrySet()) {
                        GridTab pTab = this.m_mWorkbench.getMWindow(0).getTab(((Integer)entry.getKey()).intValue());
                        Object[] value = (Object[])entry.getValue();
                        MQuery pquery = new MQuery(pTab.getAD_Table_ID());
                        pquery.addRestriction((String)value[0], "=", value[1]);
                        pTab.setQuery(pquery);
                        GridController gc = (GridController)this.tabPanel.getComponentAt((Integer)entry.getKey());
                        gc.activate();
                        gc.query(false, 0, 0);
                    }
                    MQuery targetQuery = new MQuery(gTab.getAD_Table_ID());
                    targetQuery.addRestriction(gTab.getLinkColumnName(), "=", parentId);
                    gTab.setQuery(targetQuery);
                    GridController gc = null;
                    if (!this.includedMap.containsKey(gTab.getAD_Tab_ID())) {
                        int target = this.tabPanel.findTabindex(gTab);
                        gc = (GridController)this.tabPanel.getComponentAt(target);
                    } else {
                        GridController parent = this.includedMap.get(gTab.getAD_Tab_ID());
                        gc = parent.findChild(gTab);
                    }
                    gc.activate();
                    gc.query(false, 0, 0);
                    GridTable table = gTab.getTableModel();
                    int count = table.getRowCount();
                    int i = 0;
                    while (i < count) {
                        int id = table.getKeyID(i);
                        if (id == (Integer)query.getZoomValue()) {
                            if (!this.includedMap.containsKey(gTab.getAD_Tab_ID())) {
                                this.tabPanel.setSelectedIndex(this.tabPanel.findTabindex(gTab));
                            } else {
                                GridController parent = this.includedMap.get(gTab.getAD_Tab_ID());
                                int pindex = this.tabPanel.findTabindex(parent.getMTab());
                                if (pindex >= 0) {
                                    this.tabPanel.setSelectedIndex(pindex);
                                }
                            }
                            gTab.navigate(i);
                            return true;
                        }
                        ++i;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    public int getWindowNo() {
        return this.m_curWindowNo;
    }

    private MQuery initialQuery(MQuery query, GridTab mTab) {
        MRole role = MRole.getDefault((Properties)this.m_ctx, (boolean)false);
        if (query != null && query.isActive() && !role.isQueryMax(query.getRecordCount())) {
            return query;
        }
        StringBuffer where = new StringBuffer(Env.parseContext((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)mTab.getWhereExtended(), (boolean)false));
        boolean require = mTab.isHighVolume();
        if (!require && !this.m_onlyCurrentRows) {
            String wh2;
            if (query != null && (wh2 = query.getWhereClause()).length() > 0) {
                if (where.length() > 0) {
                    where.append(" AND ");
                }
                where.append(wh2);
            }
            StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ").append(mTab.getTableName());
            if (where.length() > 0) {
                sql.append(" WHERE ").append(where);
            }
            int no = DB.getSQLValue(null, (String)sql.toString());
            require = MRole.getDefault().isQueryRequire(no);
        }
        if (require) {
            GridField[] findFields = mTab.getFields();
            Find find = new Find(AEnv.getFrame(this), this.m_curWindowNo, mTab.getName(), mTab.getAD_Tab_ID(), mTab.getAD_Table_ID(), mTab.getTableName(), where.toString(), findFields, 10);
            query = find.getQuery();
            this.isCancel = query == null;
            find.dispose();
            find = null;
        }
        return query;
    }

    private int getWindowIndex() {
        if (this.m_mWorkbench.getWindowCount() == 1) {
            return 0;
        }
        return this.tabPanel.getSelectedIndex();
    }

    private boolean isFirstTab() {
        return this.m_curWinTab.getSelectedIndex() == 0;
    }

    public Image getImage() {
        return this.m_mWorkbench.getImage(this.getWindowIndex());
    }

    public void dataStatusChanged(DataStatusEvent e) {
        boolean canHaveAttachment;
        String trxInfo;
        boolean readOnly;
        boolean insertRecord;
        boolean changed;
        if (this.m_disposing) {
            return;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(e.getMessage());
        }
        String dbInfo = e.getMessage();
        if (this.m_curTab != null && this.m_curTab.isQueryActive()) {
            dbInfo = "[ " + dbInfo + " ]";
        }
        this.statusBar.setStatusDB(dbInfo, e);
        if (!this.isNested) {
            this.m_window.setTitle(this.getTitle());
        }
        if (e.getAD_Message() != null || e.getInfo() != null) {
            String info;
            StringBuilder sb = new StringBuilder();
            String msg = e.getMessage();
            if (msg != null && msg.length() > 0) {
                sb.append(Msg.getMsg((Properties)this.m_ctx, (String)e.getAD_Message()));
            }
            if ((info = e.getInfo()) != null && info.length() > 0) {
                if (sb.length() > 0 && !sb.toString().trim().endsWith(":")) {
                    sb.append(": ");
                }
                sb.append(info);
            }
            if (sb.length() > 0) {
                int pos = sb.indexOf("\n");
                if (pos != -1) {
                    sb.replace(pos, pos + 1, " - ");
                }
                this.setStatusLine(sb.toString(), e.isError());
            }
        }
        if (e.isError() && !e.isConfirmed()) {
            ADialog.error(this.m_curWindowNo, this, e.getAD_Message(), e.getInfo());
            e.setConfirmed(true);
            this.m_errorDisplayed = true;
        } else if (e.isWarning() && !e.isConfirmed()) {
            ADialog.warn(this.m_curWindowNo, this, e.getAD_Message(), e.getInfo());
            e.setConfirmed(true);
        }
        boolean firstRow = e.isFirstRow();
        this.aFirst.setEnabled(!firstRow);
        this.aPrevious.setEnabled(!firstRow);
        boolean lastRow = e.isLastRow();
        this.aNext.setEnabled(!lastRow);
        this.aLast.setEnabled(!lastRow);
        boolean bl = changed = e.isChanged() || e.isInserting();
        if (e.getAD_Message() != null && e.getAD_Message().equals("Saved")) {
            changed = false;
        }
        boolean bl2 = insertRecord = !(readOnly = this.m_curTab.isReadOnly());
        if (insertRecord) {
            insertRecord = this.m_curTab.isInsertRecord();
        }
        this.aNew.setEnabled(!changed && insertRecord);
        this.aCopy.setEnabled(!changed && insertRecord);
        this.aRefresh.setEnabled(!changed);
        this.aDelete.setEnabled(!changed && !readOnly);
        this.aDeleteSelection.setEnabled(!changed && !readOnly);
        if (readOnly && this.m_curTab.isAlwaysUpdateField()) {
            readOnly = false;
        }
        this.aIgnore.setEnabled(changed && !readOnly);
        this.aSave.setEnabled(changed && !readOnly);
        this.aSaveAndCreate.setEnabled(changed && !readOnly);
        if (e.getTotalRows() == 0 && insertRecord) {
            this.aNew.setEnabled(true);
            this.aDelete.setEnabled(false);
            this.aDeleteSelection.setEnabled(false);
        }
        this.aMulti.setPressed(!this.m_curGC.isSingleRow());
        if (this.isFirstTab()) {
            this.aHistory.setPressed(!this.m_curTab.isOnlyCurrentRows());
        }
        if ((trxInfo = this.m_curTab.getTrxInfo()) != null) {
            this.statusBar.setInfo(trxInfo);
        }
        if ((canHaveAttachment = this.m_curTab.canHaveAttachment()) && e.isLoading() && this.m_curTab.getCurrentRow() > e.getLoadedRows()) {
            canHaveAttachment = false;
        }
        if (canHaveAttachment && this.m_curTab.getRecord_ID() == -1) {
            canHaveAttachment = false;
        }
        if (canHaveAttachment) {
            this.aAttachment.setEnabled(true);
            this.aAttachment.setPressed(this.m_curTab.hasAttachment());
            this.aChat.setEnabled(true);
            this.aChat.setPressed(this.m_curTab.hasChat());
        } else {
            this.aAttachment.setEnabled(false);
            this.aChat.setEnabled(false);
        }
        if (this.m_isPersonalLock) {
            this.aLock.setPressed(this.m_curTab.isLocked());
        }
        if (this.m_curWinTab instanceof VTabbedPane) {
            ((VTabbedPane)this.m_curWinTab).evaluate(e);
        }
    }

    public void setStatusLine(String text, boolean error) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(text);
        }
        this.statusBar.setStatusLine(text, error);
    }

    private void setBusy(boolean busy, boolean focus) {
        this.m_isLocked = busy;
        JFrame frame = AEnv.getFrame(this);
        if (frame == null) {
            return;
        }
        if (frame instanceof AWindow) {
            ((AWindow)frame).setBusy(busy);
        }
        if (busy) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            frame.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
            frame.setCursor(Cursor.getDefaultCursor());
            if (focus) {
                this.m_curGC.requestFocus();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        boolean isAPanelTab;
        boolean back;
        block37: {
            GridController gc;
            int tpIndex;
            block35: {
                block38: {
                    VTabbedPane tp;
                    block36: {
                        if (this.m_disposing) {
                            return;
                        }
                        if (log.isLoggable(Level.INFO)) {
                            log.info(e.toString());
                        }
                        this.setBusy(true, true);
                        tp = (VTabbedPane)e.getSource();
                        back = false;
                        isAPanelTab = false;
                        if (!tp.isWorkbench()) break block36;
                        int WBIndex = this.tabPanel.getSelectedIndex();
                        this.m_curWindowNo = this.m_mWorkbench.getWindowNo(WBIndex);
                        if (log.isLoggable(Level.INFO)) {
                            log.info("curWin=" + this.m_curWindowNo + " - Win=" + tp);
                        }
                        if (!(tp.getSelectedComponent() instanceof JTabbedPane)) {
                            throw new IllegalArgumentException("Window does not contain Tabs");
                        }
                        this.m_curWinTab = (JTabbedPane)tp.getSelectedComponent();
                        if (!(this.m_curWinTab.getSelectedComponent() instanceof GridController)) {
                            throw new IllegalArgumentException("Window-Tab does not contain GridControler");
                        }
                        this.m_curGC = (GridController)this.m_curWinTab.getSelectedComponent();
                        this.initSwitchLineAction();
                        this.m_curTabIndex = this.m_curWinTab.getSelectedIndex();
                        break block37;
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Tab=" + tp);
                    }
                    this.m_curWinTab = tp;
                    tpIndex = this.m_curWinTab.getSelectedIndex();
                    if (tpIndex == this.m_curTabIndex) {
                        return;
                    }
                    back = tpIndex < this.m_curTabIndex;
                    gc = null;
                    if (this.m_curWinTab.getSelectedComponent() instanceof GridController) {
                        gc = (GridController)this.m_curWinTab.getSelectedComponent();
                    } else {
                        if (!(this.m_curWinTab.getSelectedComponent() instanceof APanelTab)) {
                            throw new IllegalArgumentException("Tab does not contain GridControler");
                        }
                        isAPanelTab = true;
                    }
                    if (this.m_curGC == null) break block35;
                    this.m_curGC.stopEditor(true);
                    if (!this.m_curTab.needSave(true, false)) break block35;
                    if (!this.m_curTab.needSave(true, true)) break block38;
                    if (Env.isAutoCommit((Properties)this.m_ctx, (int)this.m_curWindowNo)) {
                        if (!this.m_curTab.dataSave(true)) {
                            this.showLastError();
                            this.m_curWinTab.setSelectedIndex(this.m_curTabIndex);
                            this.setBusy(false, true);
                            return;
                        }
                        break block35;
                    } else if (ADialog.ask(this.m_curWindowNo, this, "SaveChanges?", this.m_curTab.getCommitWarning())) {
                        if (!this.m_curTab.dataSave(true)) {
                            this.showLastError();
                            this.m_curWinTab.setSelectedIndex(this.m_curTabIndex);
                            this.setBusy(false, true);
                            return;
                        }
                        break block35;
                    } else {
                        int newRecord = this.m_curTab.getTableModel().getNewRow();
                        if (newRecord != -1) {
                            this.m_curWinTab.setSelectedIndex(this.m_curTabIndex);
                            this.setBusy(false, true);
                            return;
                        }
                        this.m_curTab.dataIgnore();
                    }
                    break block35;
                }
                this.m_curTab.dataIgnore();
            }
            if (this.m_curAPanelTab != null) {
                this.m_curAPanelTab.saveData();
                this.m_curAPanelTab.unregisterPanel();
                this.m_curAPanelTab = null;
            }
            this.m_curTabIndex = tpIndex;
            if (!isAPanelTab) {
                this.m_curGC = gc;
                this.initSwitchLineAction();
            }
        }
        if (isAPanelTab) {
            this.m_curAPanelTab = (APanelTab)((Object)this.m_curWinTab.getSelectedComponent());
            this.m_curAPanelTab.registerAPanel(this);
            this.m_curAPanelTab.loadData();
            this.aFirst.setEnabled(false);
            this.aPrevious.setEnabled(false);
            this.aNext.setEnabled(false);
            this.aLast.setEnabled(false);
        } else {
            int gwTabIndex = this.m_mWorkbench.getMWindow(0).getTabIndex(this.m_curGC.getMTab());
            if (!this.m_mWorkbench.getMWindow(0).isTabInitialized(gwTabIndex)) {
                this.m_mWorkbench.getMWindow(0).initTab(gwTabIndex);
            }
            this.m_curGC.activate();
            this.m_curTab = this.m_curGC.getMTab();
            if (back && this.m_curTab.isCurrent()) {
                this.m_curTab.dataRefresh();
            } else {
                MRole role = MRole.getDefault();
                this.m_curGC.query(this.m_onlyCurrentRows, this.m_onlyCurrentDays, role.getMaxQueryRecords());
            }
            if (this.m_curTab.getRowCount() == 0) {
                if (!this.m_curTab.isReadOnly() && (Env.isAutoNew((Properties)this.m_ctx, (int)this.m_curWindowNo) || this.m_curTab.isQueryNewRecord())) {
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config("No record - New - AutoNew=" + Env.isAutoNew((Properties)this.m_ctx, (int)this.m_curWindowNo) + " - QueryNew=" + this.m_curTab.isQueryNewRecord());
                    }
                    this.m_curTab.dataNew(false);
                } else {
                    this.aSave.setEnabled(false);
                    this.aSaveAndCreate.setEnabled(false);
                    this.aDelete.setEnabled(false);
                    this.aDeleteSelection.setEnabled(false);
                }
                this.m_curTab.navigateCurrent();
                this.m_curGC.dynamicDisplay(0);
            }
        }
        this.aDetail.setEnabled(this.m_curTabIndex != this.m_curWinTab.getTabCount() - 1);
        this.aParent.setEnabled(this.m_curTabIndex != 0 && this.m_curWinTab.getTabCount() > 1);
        if (this.m_mWorkbench.getMWindow(this.getWindowIndex()).isTransaction()) {
            this.aHistory.setEnabled(this.isFirstTab());
        } else {
            this.aHistory.setPressed(false);
            this.aHistory.setEnabled(false);
        }
        this.aPrint.setEnabled(this.m_curTab.isPrinted());
        this.aPrintPreview.setEnabled(this.m_curTab.isPrinted());
        this.aFind.setPressed(this.m_curTab.isQueryActive());
        if (isAPanelTab) {
            this.aMulti.setPressed(false);
            this.aMulti.setEnabled(false);
            this.aNew.setEnabled(false);
            this.aDelete.setEnabled(false);
            this.aDeleteSelection.setEnabled(false);
            this.aFind.setEnabled(false);
            this.aRefresh.setEnabled(false);
            this.aAttachment.setEnabled(false);
            this.aChat.setEnabled(false);
        } else {
            this.aMulti.setEnabled(true);
            this.aMulti.setPressed(!this.m_curGC.isSingleRow());
            this.aFind.setEnabled(true);
            this.aRefresh.setEnabled(true);
            this.aAttachment.setEnabled(true);
            this.aChat.setEnabled(true);
            GridField[] fields = this.m_curGC.getMTab().getFields();
            boolean processEnabled = false;
            GridField[] gridFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                GridField field = gridFieldArray[n2];
                if (field.isToolbarButton() && field.isDisplayed()) {
                    processEnabled = true;
                    break;
                }
                ++n2;
            }
            this.aProcess.setEnabled(processEnabled);
        }
        this.m_curWinTab.requestFocusInWindow();
        this.setBusy(false, true);
        if (!this.ToolBarMenuRestictionLoaded) {
            this.updateToolBarAndMenuWithRestriction();
            this.ToolBarMenuRestictionLoaded = true;
        }
        log.config("fini");
    }

    private void cmd_detail() {
        int index = this.m_curWinTab.getSelectedIndex();
        if (index == this.m_curWinTab.getTabCount() - 1) {
            return;
        }
        if (this.m_curWinTab instanceof VTabbedPane) {
            VTabbedPane tabPane = (VTabbedPane)this.m_curWinTab;
            ++index;
            while (index < tabPane.getTabCount()) {
                if (tabPane.isEnabledAt(index)) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curGC.acceptEditorChanges();
                    tabPane.setSelectedIndex(index);
                    break;
                }
                ++index;
            }
        } else {
            this.m_curGC.getTable().removeEditor();
            this.m_curGC.acceptEditorChanges();
            this.m_curWinTab.setSelectedIndex(index + 1);
        }
    }

    private void cmd_parent() {
        int index = this.m_curWinTab.getSelectedIndex();
        if (index == 0) {
            return;
        }
        if (this.m_curWinTab instanceof VTabbedPane) {
            VTabbedPane tabPane = (VTabbedPane)this.m_curWinTab;
            --index;
            while (index >= 0) {
                if (tabPane.isEnabledAt(index)) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curGC.acceptEditorChanges();
                    tabPane.setSelectedIndex(index);
                    break;
                }
                --index;
            }
        } else {
            this.m_curGC.getTable().removeEditor();
            this.m_curGC.acceptEditorChanges();
            this.m_curWinTab.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(e.getActionCommand()) + " - " + e.getModifiers());
        }
        if (this.m_disposing || this.isUILocked()) {
            return;
        }
        this.m_lastModifiers = e.getModifiers();
        String cmd = e.getActionCommand();
        if (cmd.equals("ScreenShot")) {
            AEnv.actionPerformed(e.getActionCommand(), this.m_curWindowNo, this);
            return;
        }
        if (!cmd.equals(this.aShowAllWindow.getName())) {
            this.setBusy(true, true);
        }
        if (e.getSource() instanceof VButton) {
            this.setStatusLine(this.processButtonCallout((VButton)e.getSource()), true);
            this.actionButton((VButton)e.getSource());
            this.setBusy(false, true);
            return;
        }
        try {
            if (cmd.equals(this.aReport.getName())) {
                this.cmd_report();
            } else if (cmd.equals(this.aPrint.getName())) {
                this.cmd_print();
            } else if (cmd.equals(this.aPrintPreview.getName())) {
                this.cmd_print(true);
            } else if (this.aExport != null && cmd.equals(this.aExport.getName())) {
                this.cmd_export();
            } else if (cmd.equals(this.aEnd.getName())) {
                this.cmd_end(false);
            } else if (cmd.equals(this.aExit.getName())) {
                this.cmd_end(true);
            } else if (cmd.equals(this.aNew.getName())) {
                this.cmd_new(false);
            } else if (cmd.equals(this.aSave.getName())) {
                this.cmd_save(true);
            } else if (cmd.equals(this.aSaveAndCreate.getName())) {
                this.cmd_saveAndCreate(true);
            } else if (cmd.equals(this.aCopy.getName())) {
                this.cmd_new(true);
            } else if (cmd.equals(this.aDelete.getName())) {
                this.cmd_delete();
            } else if (cmd.equals(this.aDeleteSelection.getName())) {
                this.cmd_deleteSelection();
            } else if (cmd.equals(this.aIgnore.getName())) {
                this.cmd_ignore();
            } else if (cmd.equals(this.aRefresh.getName())) {
                this.cmd_refresh();
            } else if (cmd.equals(this.aFind.getName())) {
                this.cmd_find();
            } else if (this.m_isPersonalLock && cmd.equals(this.aLock.getName())) {
                this.cmd_lock();
            } else if (cmd.equals(this.aProcess.getName())) {
                this.cmd_process();
            } else if (cmd.equals(this.aAttachment.getName())) {
                this.cmd_attachment();
            } else if (cmd.equals(this.aChat.getName())) {
                this.cmd_chat();
            } else if (cmd.equals(this.aHistory.getName())) {
                this.cmd_history();
            } else if (cmd.equals(this.aMulti.getName())) {
                this.m_curGC.switchRowPresentation();
            } else {
                if (cmd.equals(this.aHome.getName())) {
                    this.setBusy(false, false);
                    AEnv.showWindow(AEnv.getWindow(0));
                    return;
                }
                if (cmd.equals(this.aFirst.getName())) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curGC.acceptEditorChanges();
                    this.m_curTab.navigate(0);
                } else if (cmd.equals(this.aSwitchLinesUpAction.getName())) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curTab.switchRows(this.m_curTab.getCurrentRow(), this.m_curTab.getCurrentRow() - 1, this.m_curGC.getTable().getSortColumn(), this.m_curGC.getTable().isSortAscending());
                    this.m_curGC.getTable().requestFocus();
                } else if (cmd.equals(this.aPrevious.getName())) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curGC.acceptEditorChanges();
                    if ((e.getModifiers() & 1) != 0) {
                        this.m_curTab.switchRows(this.m_curTab.getCurrentRow(), this.m_curTab.getCurrentRow() - 1, this.m_curGC.getTable().getSortColumn(), this.m_curGC.getTable().isSortAscending());
                    } else {
                        this.m_curTab.navigateRelative(-1);
                    }
                } else if (cmd.equals(this.aSwitchLinesDownAction.getName())) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curTab.switchRows(this.m_curTab.getCurrentRow(), this.m_curTab.getCurrentRow() + 1, this.m_curGC.getTable().getSortColumn(), this.m_curGC.getTable().isSortAscending());
                    this.m_curGC.getTable().requestFocus();
                } else if (cmd.equals(this.aNext.getName())) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curGC.acceptEditorChanges();
                    if ((e.getModifiers() & 1) != 0) {
                        this.m_curTab.switchRows(this.m_curTab.getCurrentRow(), this.m_curTab.getCurrentRow() + 1, this.m_curGC.getTable().getSortColumn(), this.m_curGC.getTable().isSortAscending());
                    } else {
                        this.m_curTab.navigateRelative(1);
                    }
                } else if (cmd.equals(this.aLast.getName())) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curGC.acceptEditorChanges();
                    this.m_curTab.navigate(this.m_curTab.getRowCount() - 1);
                } else if (cmd.equals(this.aParent.getName())) {
                    this.cmd_parent();
                } else if (cmd.equals(this.aDetail.getName())) {
                    this.cmd_detail();
                } else if (cmd.equals(this.aZoomAcross.getName())) {
                    this.cmd_zoomAcross();
                } else if (cmd.equals(this.aRequest.getName())) {
                    this.cmd_request();
                } else if (cmd.equals(this.aArchive.getName())) {
                    this.cmd_archive();
                } else if (this.aWorkflow != null && cmd.equals(this.aWorkflow.getName())) {
                    if (this.m_curTab.getRecord_ID() > 0) {
                        if (this.m_curTab.getTabNo() == 0 && this.m_mWorkbench.getMWindow(this.getWindowIndex()).isTransaction()) {
                            AEnv.startWorkflowProcess(this.m_curTab.getAD_Table_ID(), this.m_curTab.getRecord_ID());
                        } else {
                            AEnv.startWorkflowProcess(this.m_curTab.getAD_Table_ID(), this.m_curTab.getRecord_ID());
                        }
                    }
                } else if (this.aWinSize != null && cmd.equals(this.aWinSize.getName())) {
                    this.cmd_winSize();
                } else if (cmd.equals(this.aHelp.getName())) {
                    this.cmd_help();
                } else if (cmd.equals(this.aLogout.getName())) {
                    this.cmd_logout();
                } else if (cmd.equals(this.aShowAllWindow.getName())) {
                    this.m_WindowMenu.expose();
                } else if (!AEnv.actionPerformed(e.getActionCommand(), this.m_curWindowNo, this)) {
                    log.log(Level.SEVERE, "No action for: " + cmd);
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, cmd, (Throwable)ex);
            String msg = ex.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = ex.toString();
            }
            msg = Msg.parseTranslation((Properties)this.m_ctx, (String)msg);
            ADialog.error(this.m_curWindowNo, this, "Error", msg);
        }
        this.m_curWinTab.requestFocusInWindow();
        this.setBusy(false, true);
    }

    private void cmd_logout() {
        JFrame top = AEnv.getWindow(0);
        if (top instanceof AMenu) {
            ((AMenu)top).logout();
        }
    }

    private String processButtonCallout(VButton button) {
        GridField field = this.m_curTab.getField(button.getColumnName());
        return this.m_curTab.processCallout(field);
    }

    private void cmd_new(boolean copy) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("copy=" + copy);
        }
        if (!this.m_curTab.isInsertRecord()) {
            log.warning("Insert Record disabled for Tab");
            return;
        }
        this.m_curGC.stopEditor(true);
        this.m_curGC.acceptEditorChanges();
        if (this.aSave.isEnabled()) {
            if (Env.isAutoCommit((Properties)this.m_ctx, (int)this.m_curWindowNo)) {
                if (!this.cmd_save(true)) {
                    return;
                }
            } else if (ADialog.ask(this.m_curWindowNo, this, "SaveChanges?", this.m_curTab.getCommitWarning())) {
                if (!this.cmd_save(true)) {
                    return;
                }
            } else {
                this.m_curTab.dataIgnore();
            }
        }
        if (copy && this.m_curTab.getCurrentRow() < 0) {
            copy = false;
        }
        this.m_curTab.dataNew(copy);
        this.m_curGC.dynamicDisplay(0);
    }

    private void cmd_delete() {
        if (this.m_curTab.isReadOnly()) {
            return;
        }
        int keyID = this.m_curTab.getRecord_ID();
        if (ADialog.ask(this.m_curWindowNo, this, "DeleteRecord?") && this.m_curTab.dataDelete()) {
            this.m_curGC.rowChanged(false, keyID);
        }
        this.m_curGC.dynamicDisplay(0);
    }

    private void cmd_deleteSelection() {
        if (this.m_curTab.isReadOnly()) {
            return;
        }
        JPanel messagePanel = new JPanel();
        JList list = new JList();
        JScrollPane scrollPane = new JScrollPane(list);
        Vector<String> data = new Vector<String>();
        String keyColumnName = this.m_curTab.getKeyColumnName();
        String sql = null;
        if (!"".equals(keyColumnName)) {
            sql = MLookupFactory.getLookup_TableDirEmbed((Language)Env.getLanguage((Properties)this.m_ctx), (String)keyColumnName, (String)"[?", (String)"?]").replace("[?.?]", "?");
        }
        int noOfRows = this.m_curTab.getRowCount();
        int i = 0;
        while (i < noOfRows) {
            StringBuffer displayValue = new StringBuffer();
            if ("".equals(keyColumnName)) {
                ArrayList parentColumnNames = this.m_curTab.getParentColumnNames();
                for (String columnName : parentColumnNames) {
                    GridField field = this.m_curTab.getField(columnName);
                    if (field.isLookup()) {
                        Lookup lookup = field.getLookup();
                        if (lookup != null) {
                            displayValue = displayValue.append(lookup.getDisplay(this.m_curTab.getValue(i, columnName))).append(" | ");
                            continue;
                        }
                        displayValue = displayValue.append(this.m_curTab.getValue(i, columnName)).append(" | ");
                        continue;
                    }
                    displayValue = displayValue.append(this.m_curTab.getValue(i, columnName)).append(" | ");
                }
            } else {
                int id = this.m_curTab.getKeyID(i);
                String value = DB.getSQLValueStringEx(null, (String)sql, (Object[])new Object[]{id});
                if (value != null) {
                    value = value.replace(" - ", " | ");
                }
                displayValue.append(value);
                if (displayValue.length() == 0 || CLogMgt.isLevelFine()) {
                    if (displayValue.length() > 0) {
                        displayValue.append(" | ");
                    }
                    displayValue.append("<").append(id).append(">");
                }
            }
            data.add(displayValue.toString());
            ++i;
        }
        list.setListData(data);
        list.setSelectionMode(2);
        messagePanel.add(scrollPane);
        JOptionPane pane = new JOptionPane(messagePanel, 3, 2);
        JDialog deleteDialog = pane.createDialog(this.getParent(), Msg.getMsg((Properties)this.m_ctx, (String)"DeleteSelection"));
        deleteDialog.setVisible(true);
        Integer okCancel = (Integer)pane.getValue();
        if (okCancel != null && okCancel == 0) {
            log.fine("ok");
            Object[] selectedValues = list.getSelectedValues();
            int i2 = 0;
            while (i2 < selectedValues.length) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(selectedValues[i2].toString());
                }
                ++i2;
            }
            int[] indices = list.getSelectedIndices();
            Arrays.sort(indices);
            int offset = 0;
            int i3 = 0;
            while (i3 < indices.length) {
                this.m_curTab.navigate(indices[i3] - offset);
                int keyID = this.m_curTab.getRecord_ID();
                if (this.m_curTab.dataDelete()) {
                    this.m_curGC.rowChanged(false, keyID);
                    ++offset;
                }
                ++i3;
            }
            this.m_curGC.dynamicDisplay(0);
        } else {
            log.fine("cancel");
        }
    }

    public boolean cmd_save(boolean manualCmd) {
        if (this.m_curAPanelTab != null) {
            manualCmd = false;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Manual=" + manualCmd);
        }
        this.m_errorDisplayed = false;
        this.m_curGC.stopEditor(true);
        this.m_curGC.acceptEditorChanges();
        if (this.m_curAPanelTab != null) {
            this.m_curAPanelTab.saveData();
            this.aSave.setEnabled(false);
            this.aSaveAndCreate.setEnabled(false);
        }
        if (this.m_curTab.getCommitWarning().length() > 0 && this.m_curTab.needSave(true, false) && !ADialog.ask(this.m_curWindowNo, this, "SaveChanges?", this.m_curTab.getCommitWarning())) {
            return false;
        }
        boolean retValue = this.m_curTab.dataSave(manualCmd);
        if (manualCmd && !retValue && !this.m_errorDisplayed) {
            this.showLastError();
        }
        if (retValue) {
            this.m_curGC.rowChanged(true, this.m_curTab.getRecord_ID());
        }
        if (manualCmd) {
            this.m_curGC.dynamicDisplay(0);
            if (!this.isNested) {
                this.m_window.setTitle(this.getTitle());
            }
        }
        if (this.m_curGC.isDetailGrid() && retValue) {
            this.m_curGC.getGCParent().refreshMTab(this.m_curGC);
        }
        return retValue;
    }

    private void showLastError() {
        String msg = CLogger.retrieveErrorString(null);
        if (msg != null) {
            ADialog.error(this.m_curWindowNo, this, null, msg);
        } else {
            ADialog.error(this.m_curWindowNo, this, "SaveIgnored");
        }
        this.setStatusLine(Msg.getMsg((Properties)this.m_ctx, (String)"SaveIgnored"), true);
    }

    public boolean cmd_saveAndCreate(boolean manualCmd) {
        boolean retValue = this.cmd_save(manualCmd);
        if (retValue) {
            this.cmd_new(false);
        }
        return retValue;
    }

    public void cmd_process() {
        if (System.currentTimeMillis() - this.m_popup_closingtime < 200L) {
            return;
        }
        GridField[] fields = this.m_curGC.getMTab().getFields();
        ArrayList<GridField> processFields = new ArrayList<GridField>();
        GridField[] gridFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            GridField field = gridFieldArray[n2];
            if (field.isToolbarButton() && field.isDisplayed()) {
                processFields.add(field);
            }
            ++n2;
        }
        JPopupMenu popup = new JPopupMenu();
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                APanel.this.m_popup_closingtime = System.currentTimeMillis();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        for (GridField field : processFields) {
            if (!field.isDisplayed(true)) continue;
            ImageIcon icon = Env.getImageIcon2((String)"Process16");
            String text = field.getHeader();
            Color color = null;
            MLookup m_lookup = null;
            if (field.getColumnName().endsWith("_ID") && !field.getColumnName().equals("Record_ID")) {
                m_lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)field.getWindowNo(), (int)0, (int)field.getAD_Column_ID(), (int)30);
            } else if (field.getAD_Reference_Value_ID() != 0) {
                m_lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)field.getWindowNo(), (int)0, (int)field.getAD_Column_ID(), (int)17);
            }
            int AD_Reference_ID = -1;
            String columnName = field.getColumnName();
            if (columnName.equals("PaymentRule")) {
                AD_Reference_ID = 195;
                color = Color.blue;
                icon = Env.getImageIcon((String)"Payment16.gif");
            } else if (columnName.equals("DocAction")) {
                AD_Reference_ID = 135;
                color = Color.blue;
                icon = Env.getImageIcon((String)"Process16.gif");
            } else if (columnName.equals("CreateFrom")) {
                icon = Env.getImageIcon((String)"Copy16.gif");
            } else if (columnName.equals("Record_ID")) {
                icon = Env.getImageIcon((String)"Zoom16.gif");
                text = Msg.getMsg((Properties)Env.getCtx(), (String)"ZoomDocument");
            } else if (columnName.equals("Posted")) {
                AD_Reference_ID = 234;
                color = Color.magenta;
                icon = Env.getImageIcon((String)"InfoAccount16.gif");
            }
            HashMap<String, String> values = null;
            if (AD_Reference_ID > 0) {
                block27: {
                    values = new HashMap<String, String>();
                    String SQL = Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Ref_List") ? "SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=?" : "SELECT l.Value, t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language((Properties)Env.getCtx()) + "'" + " AND l.AD_Reference_ID=?";
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)SQL, null);
                            pstmt.setInt(1, AD_Reference_ID);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                String value = rs.getString(1);
                                String name = rs.getString(2);
                                values.put(value, name);
                            }
                        }
                        catch (SQLException e) {
                            log.log(Level.SEVERE, SQL, (Throwable)e);
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block27;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
                if (field.getValue() != null && !field.getColumnName().equals("Record_ID")) {
                    NamePair pp;
                    if (values != null) {
                        text = (String)values.get(field.getValue());
                    } else if (m_lookup != null && (pp = m_lookup.get(field.getValue())) != null) {
                        text = pp.getName();
                    }
                }
            }
            JMenuItem item = new JMenuItem(text, icon);
            item.setForeground(color);
            item.setName(field.getColumnName());
            popup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem menuItem = (JMenuItem)e.getSource();
                    String columnName = menuItem.getName();
                    GridField callingField = APanel.this.m_curTab.getField(columnName);
                    APanel.this.setStatusLine(APanel.this.m_curTab.processCallout(callingField), true);
                    APanel.this.actionButtonCleanUp(menuItem.getName(), callingField.getAD_Process_ID(), callingField.getHeader());
                }
            });
        }
        popup.show(this.aProcess.getButton(), -1, this.aProcess.getButton().getHeight());
    }

    private void cmd_ignore() {
        this.m_curGC.stopEditor(false);
        if (this.m_curAPanelTab != null) {
            this.m_curAPanelTab.loadData();
        }
        this.m_curTab.dataIgnore();
        this.m_curTab.dataRefresh(true);
        this.m_curGC.dynamicDisplay(0);
    }

    private void cmd_refresh() {
        this.cmd_save(false);
        this.m_curTab.dataRefreshAll();
        this.m_curGC.dynamicDisplay(0);
    }

    private void cmd_report() {
        log.info("");
        if (!MRole.getDefault().isCanReport(this.m_curTab.getAD_Table_ID())) {
            ADialog.error(this.m_curWindowNo, this, "AccessCannotReport");
            return;
        }
        this.cmd_save(false);
        MQuery query = new MQuery(this.m_curTab.getTableName());
        String queryColumn = this.m_curTab.getLinkColumnName();
        if (queryColumn.length() == 0) {
            queryColumn = this.m_curTab.getKeyColumnName();
        }
        String infoName = null;
        String infoDisplay = null;
        int i = 0;
        while (i < this.m_curTab.getFieldCount()) {
            GridField field = this.m_curTab.getField(i);
            if (field.isKey()) {
                infoName = field.getHeader();
            }
            if ((field.getColumnName().equals("Name") || field.getColumnName().equals("DocumentNo")) && field.getValue() != null) {
                infoDisplay = field.getValue().toString();
            }
            if (infoName != null && infoDisplay != null) break;
            ++i;
        }
        if (queryColumn.length() != 0) {
            if (queryColumn.endsWith("_ID")) {
                query.addRestriction(queryColumn, "=", (Object)new Integer(Env.getContextAsInt((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)queryColumn)), infoName, infoDisplay);
            } else {
                query.addRestriction(queryColumn, "=", (Object)Env.getContext((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)queryColumn), infoName, infoDisplay);
            }
        }
        new AReport(this.m_curTab.getAD_Table_ID(), this.aReport.getButton(), query, this, this.m_curWindowNo, this.m_curTab.getWhereExtended());
    }

    private void cmd_zoomAcross() {
        int record_ID = this.m_curTab.getRecord_ID();
        if (log.isLoggable(Level.INFO)) {
            log.info("ID=" + record_ID);
        }
        if (record_ID <= 0) {
            return;
        }
        MQuery query = new MQuery();
        String link = this.m_curTab.getKeyColumnName();
        if (link.length() == 0) {
            link = this.m_curTab.getLinkColumnName();
        }
        if (link.length() != 0) {
            if (link.endsWith("_ID")) {
                query.addRestriction(link, "=", (Object)new Integer(Env.getContextAsInt((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)link)));
            } else {
                query.addRestriction(link, "=", (Object)Env.getContext((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)link));
            }
        }
        new AZoomAcross(this.aZoomAcross.getButton(), this.m_curTab.getTableName(), this.m_curTab.getAD_Window_ID(), query);
    }

    private void cmd_request() {
        int record_ID = this.m_curTab.getRecord_ID();
        if (log.isLoggable(Level.INFO)) {
            log.info("ID=" + record_ID);
        }
        if (record_ID <= 0) {
            return;
        }
        int AD_Table_ID = this.m_curTab.getAD_Table_ID();
        int C_BPartner_ID = 0;
        Object BPartner_ID = this.m_curTab.getValue("C_BPartner_ID");
        if (BPartner_ID != null) {
            C_BPartner_ID = (Integer)BPartner_ID;
        }
        new ARequest(this.aRequest.getButton(), AD_Table_ID, record_ID, C_BPartner_ID);
    }

    private void cmd_archive() {
        int record_ID = this.m_curTab.getRecord_ID();
        if (log.isLoggable(Level.INFO)) {
            log.info("ID=" + record_ID);
        }
        if (record_ID <= 0) {
            return;
        }
        int AD_Table_ID = this.m_curTab.getAD_Table_ID();
        new AArchive(this.aArchive.getButton(), AD_Table_ID, record_ID);
    }

    private void cmd_print() {
        this.cmd_print(false);
    }

    private void cmd_print(boolean printPreview) {
        int AD_Process_ID = this.m_curTab.getAD_Process_ID();
        if (log.isLoggable(Level.INFO)) {
            log.info("ID=" + AD_Process_ID);
        }
        if (AD_Process_ID == 0) {
            this.cmd_report();
            return;
        }
        this.cmd_save(false);
        int table_ID = this.m_curTab.getAD_Table_ID();
        int record_ID = this.m_curTab.getRecord_ID();
        ProcessInfo pi = new ProcessInfo(this.getTitle(), AD_Process_ID, table_ID, record_ID);
        pi.setAD_User_ID(Env.getAD_User_ID((Properties)this.m_ctx));
        pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)this.m_ctx));
        pi.setPrintPreview(printPreview);
        ClientProcessCtrl.process(this, this.m_curWindowNo, pi, null);
        this.statusBar.setStatusLine(pi.getSummary(), pi.isError());
    }

    private void cmd_find() {
        if (this.m_curTab == null) {
            return;
        }
        this.cmd_save(false);
        GridField[] findFields = GridField.createFields((Properties)this.m_ctx, (int)this.m_curWindowNo, (int)0, (int)this.m_curTab.getAD_Tab_ID());
        Find find = new Find(AEnv.getFrame(this), this.m_curWindowNo, this.m_curTab.getName(), this.m_curTab.getAD_Tab_ID(), this.m_curTab.getAD_Table_ID(), this.m_curTab.getTableName(), this.m_curTab.getWhereExtended(), findFields, 1);
        MQuery query = find.getQuery();
        find.dispose();
        find = null;
        if (query != null) {
            this.m_onlyCurrentRows = false;
            this.m_curTab.setQuery(query);
            this.m_curGC.query(this.m_onlyCurrentRows, this.m_onlyCurrentDays, 0);
        }
        this.aFind.setPressed(this.m_curTab.isQueryActive());
    }

    private void cmd_attachment() {
        int record_ID = this.m_curTab.getRecord_ID();
        if (log.isLoggable(Level.INFO)) {
            log.info("Record_ID=" + record_ID);
        }
        if (record_ID == -1) {
            this.aAttachment.setEnabled(false);
            return;
        }
        Attachment va = new Attachment(AEnv.getFrame(this), this.m_curWindowNo, this.m_curTab.getAD_AttachmentID(), this.m_curTab.getAD_Table_ID(), record_ID, null);
        this.aAttachment.setPressed(this.m_curTab.hasAttachment());
    }

    private void cmd_chat() {
        int record_ID = this.m_curTab.getRecord_ID();
        if (log.isLoggable(Level.INFO)) {
            log.info("Record_ID=" + record_ID);
        }
        if (record_ID == -1) {
            this.aChat.setEnabled(false);
            return;
        }
        String infoName = null;
        String infoDisplay = null;
        int i = 0;
        while (i < this.m_curTab.getFieldCount()) {
            GridField field = this.m_curTab.getField(i);
            if (field.isKey()) {
                infoName = field.getHeader();
            }
            if ((field.getColumnName().equals("Name") || field.getColumnName().equals("DocumentNo")) && field.getValue() != null) {
                infoDisplay = field.getValue().toString();
            }
            if (infoName != null && infoDisplay != null) break;
            ++i;
        }
        String description = String.valueOf(infoName) + ": " + infoDisplay;
        new AChat(AEnv.getFrame(this), this.m_curWindowNo, this.m_curTab.getCM_ChatID(), this.m_curTab.getAD_Table_ID(), record_ID, description, null);
        this.aChat.setPressed(this.m_curTab.hasChat());
    }

    private void cmd_lock() {
        if (log.isLoggable(Level.INFO)) {
            log.info("Modifiers=" + this.m_lastModifiers);
        }
        if (!this.m_isPersonalLock) {
            return;
        }
        int record_ID = this.m_curTab.getRecord_ID();
        if (record_ID == -1) {
            return;
        }
        if ((this.m_lastModifiers & 2) != 0) {
            new RecordAccessDialog(AEnv.getFrame(this), this.m_curTab.getAD_Table_ID(), record_ID);
        } else {
            this.m_curTab.lock(Env.getCtx(), record_ID, this.aLock.getButton().isSelected());
        }
        this.aLock.setPressed(this.m_curTab.isLocked());
    }

    private void cmd_history() {
        if (log.isLoggable(Level.INFO)) {
            log.info("");
        }
        if (this.m_mWorkbench.getMWindow(this.getWindowIndex()).isTransaction()) {
            if (this.m_curTab.needSave(true, true) && !this.cmd_save(false)) {
                return;
            }
            Point pt = new Point(0, this.aHistory.getButton().getBounds().height);
            SwingUtilities.convertPointToScreen(pt, this.aHistory.getButton());
            VOnlyCurrentDays ocd = new VOnlyCurrentDays((Frame)AEnv.getFrame(this), pt);
            if (!ocd.isCancel()) {
                this.m_onlyCurrentDays = ocd.getCurrentDays();
                if (this.m_onlyCurrentDays == 1) {
                    this.m_onlyCurrentRows = true;
                    this.m_onlyCurrentDays = 0;
                } else {
                    this.m_onlyCurrentRows = false;
                }
                this.m_curTab.setQuery(null);
                MRole role = MRole.getDefault();
                int maxRows = role.getMaxQueryRecords();
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("OnlyCurrent=" + this.m_onlyCurrentRows + ", Days=" + this.m_onlyCurrentDays + ", MaxRows=" + maxRows);
                }
                this.m_curGC.query(this.m_onlyCurrentRows, this.m_onlyCurrentDays, maxRows);
            } else if (this.isFirstTab()) {
                this.aHistory.setPressed(!this.m_curTab.isOnlyCurrentRows());
            }
        }
    }

    private void cmd_help() {
        log.info("");
        Help hlp = new Help((Frame)AEnv.getFrame(this), this.getTitle(), this.m_mWorkbench.getMWindow(this.getWindowIndex()));
        hlp.setVisible(true);
    }

    private void cmd_end(boolean exit) {
        boolean exitSystem = false;
        if (!this.cmd_save(false)) {
            return;
        }
        if (exit && ADialog.ask(this.m_curWindowNo, this, "ExitApplication?")) {
            exitSystem = true;
        }
        AEnv.getFrame(this).dispose();
        if (exitSystem) {
            AEnv.exit(0);
        }
    }

    private void cmd_winSize() {
        Dimension size = this.getSize();
        if (!ADialog.ask(this.m_curWindowNo, this, "WinSizeSet", "x=" + size.width + " - y=" + size.height)) {
            this.setPreferredSize(null);
            SwingUtilities.getWindowAncestor(this).pack();
            size = new Dimension(0, 0);
        }
        MWindow win = new MWindow(this.m_ctx, this.m_curTab.getAD_Window_ID(), null);
        win.setWindowSize(size);
        win.saveEx();
    }

    private void cmd_export() {
        new AExport(this);
    }

    private void actionButton(VButton vButton) {
        String title;
        if (log.isLoggable(Level.INFO)) {
            log.info(vButton.toString());
        }
        if ((title = vButton.getDescription()) == null || title.length() == 0) {
            title = vButton.getName();
        }
        this.actionButtonCleanUp(vButton.getColumnName(), vButton.getProcess_ID(), title);
    }

    private void actionButtonCleanUp(String columnName, int processID, String title) {
        if (this.m_curTab.hasChangedCurrentTabAndParents()) {
            String msg = CLogger.retrieveErrorString((String)"Please ReQuery Window");
            ADialog.error(this.m_curWindowNo, this, null, msg);
            return;
        }
        boolean startWOasking = false;
        String col = columnName;
        if (col.equals("Record_ID")) {
            int AD_Table_ID = Env.getContextAsInt((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)"AD_Table_ID");
            int Record_ID = Env.getContextAsInt((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)"Record_ID");
            AEnv.zoom(AD_Table_ID, Record_ID);
            return;
        }
        if (this.m_curTab.needSave(true, false) && !this.cmd_save(true)) {
            return;
        }
        for (GridTab includedTab : this.m_curTab.getIncludedTabs()) {
            if (!includedTab.needSave(true, false) || includedTab.dataSave(true)) continue;
            return;
        }
        int table_ID = this.m_curTab.getAD_Table_ID();
        int record_ID = this.m_curTab.getRecord_ID();
        if (record_ID == -1 && this.m_curTab.getKeyColumnName().equals("AD_Language")) {
            record_ID = Env.getContextAsInt((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)"AD_Language_ID");
        }
        if (record_ID == -1 && (processID == 306 || processID == 307)) {
            Integer id = (Integer)this.m_curTab.getValue("AD_ChangeLog_ID");
            record_ID = id;
        }
        if (record_ID == -1 && this.m_curTab.getKeyColumnName().endsWith("_ID")) {
            ADialog.error(this.m_curWindowNo, this, "SaveErrorRowNotFound");
            return;
        }
        boolean isProcessMandatory = false;
        if (col.equals("DocAction")) {
            isProcessMandatory = true;
            VDocAction vda = new VDocAction(this.m_curWindowNo, this.m_curTab, null, record_ID);
            if (vda.getNumberOfOptions() == 0) {
                vda.dispose();
                log.info("DocAction - No Options");
                return;
            }
            vda.setVisible(true);
            if (!vda.isStartProcess()) {
                return;
            }
            startWOasking = true;
            vda.dispose();
        } else if (col.equals("CreateFrom")) {
            ICreateFrom cf;
            if (processID <= 0 && (cf = VCreateFromFactory.create(this.m_curTab)) != null) {
                if (cf.isInitOK()) {
                    cf.showWindow();
                    cf.closeWindow();
                    this.m_curTab.dataRefresh();
                } else {
                    cf.closeWindow();
                }
                return;
            }
        } else if (col.equals("Posted") && MRole.getDefault().isShowAcct()) {
            Object ps;
            String docStatus;
            String processed = Env.getContext((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)"Processed");
            if (!(processed.equals("Y") || "CO".equals(docStatus = Env.getContext((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)"DocStatus")) || "CL".equals(docStatus) || "RE".equals(docStatus) || "VO".equals(docStatus))) {
                ADialog.error(this.m_curWindowNo, this, "PostDocNotComplete");
                return;
            }
            int tableId = Env.getContextAsInt((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)"AD_Table_ID", (boolean)true);
            int recordId = Env.getContextAsInt((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)"Record_ID", (boolean)true);
            if (tableId == 0 || recordId == 0) {
                tableId = this.m_curTab.getAD_Table_ID();
                recordId = this.m_curTab.getRecord_ID();
            }
            if ((ps = this.m_curTab.getValue("Posted")) != null && ps.equals("Y")) {
                new AcctViewer(Env.getContextAsInt((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)"AD_Client_ID"), tableId, recordId);
            } else if (ADialog.ask(this.m_curWindowNo, this, "PostImmediate?")) {
                boolean force = ps != null && !ps.equals("N");
                String error = AEnv.postImmediate(this.m_curWindowNo, Env.getAD_Client_ID((Properties)this.m_ctx), tableId, recordId, force);
                if (error != null) {
                    ADialog.error(this.m_curWindowNo, this, "PostingError-N", error);
                }
                this.cmd_refresh();
            }
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Process_ID=" + processID + ", Record_ID=" + record_ID);
        }
        if (processID == 0) {
            if (isProcessMandatory) {
                ADialog.error(this.m_curWindowNo, this, null, Msg.parseTranslation((Properties)this.m_ctx, (String)"@NotFound@ @AD_Process_ID@"));
            }
            return;
        }
        if (this.m_curTab.needSave(true, false) && !this.cmd_save(true)) {
            return;
        }
        MProcess pr = new MProcess(this.m_ctx, processID, null);
        int form_ID = pr.getAD_Form_ID();
        if (form_ID != 0) {
            if (this.m_curTab.needSave(true, false) && !this.cmd_save(true)) {
                return;
            }
            FormFrame ff = new FormFrame(this.getGraphicsConfiguration());
            ProcessInfo pi = new ProcessInfo(title, processID, table_ID, record_ID);
            pi.setAD_User_ID(Env.getAD_User_ID((Properties)this.m_ctx));
            pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)this.m_ctx));
            ff.setProcessInfo(pi);
            ff.openForm(form_ID, this.m_curTab);
            ff.pack();
            AEnv.showCenterScreen(ff);
            return;
        }
        ProcessModalDialog dialog = new ProcessModalDialog(this.m_ctx, AEnv.getWindow(this.m_curWindowNo), Env.getHeader((Properties)this.m_ctx, (int)this.m_curWindowNo), this, this.m_curWindowNo, processID, table_ID, record_ID, startWOasking);
        if (dialog.isValidDialog()) {
            dialog.validate();
            dialog.pack();
            AEnv.showCenterWindow(AEnv.getWindow(this.m_curWindowNo), dialog);
        }
    }

    public void lockUI(ProcessInfo pi) {
        this.setBusy(true, false);
    }

    public void unlockUI(ProcessInfo pi) {
        boolean notPrint = pi != null && pi.getAD_Process_ID() != this.m_curTab.getAD_Process_ID() && !pi.isReportingProcess();
        this.setBusy(false, notPrint);
        if (notPrint) {
            this.m_curTab.dataRefresh();
            if (pi.isTimeout()) {
                Env.setContext((Properties)this.m_ctx, (int)this.m_curWindowNo, (String)"Processed", (String)"Y");
            }
            this.m_curGC.dynamicDisplay(0);
            this.setStatusLine(pi.getSummary(), pi.isError());
            if (pi.isError()) {
                ADialog.error(this.m_curWindowNo, this, null, pi.getSummary());
            }
            ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
            String logInfo = pi.getLogInfo();
            if (logInfo.length() > 0) {
                ADialog.info(this.m_curWindowNo, this, Env.getHeader((Properties)this.m_ctx, (int)this.m_curWindowNo), pi.getTitle(), logInfo);
            }
        } else {
            this.setStatusLine(pi.getSummary(), pi.isError());
            if (pi.isError()) {
                ADialog.error(this.m_curWindowNo, this, null, pi.getSummary());
            }
        }
    }

    public boolean isUILocked() {
        return this.m_isLocked;
    }

    public void executeASync(ProcessInfo pi) {
        log.config("-");
    }

    public GridTab getCurrentTab() {
        return this.m_curTab;
    }

    public int noOfTabs() {
        return this.m_curWinTab.getTabCount();
    }

    public int getSelectedTabIndex() {
        return this.m_curWinTab.getSelectedIndex();
    }

    public void setSelectedTabIndex(int index) {
        this.m_curWinTab.setSelectedIndex(index);
    }

    public String getSelectedTabName() {
        String title = this.m_curWinTab.getTitleAt(this.m_curWinTab.getSelectedIndex());
        title = title.substring(title.indexOf("<html>") + 6);
        title = title.substring(0, title.indexOf(60));
        return title;
    }

    @Override
    public String toString() {
        String s = "APanel[curWindowNo=" + this.m_curWindowNo;
        if (this.m_mWorkbench != null) {
            s = String.valueOf(s) + ",WB=" + this.m_mWorkbench.toString();
        }
        s = String.valueOf(s) + "]";
        return s;
    }

    private void initSwitchLineAction() {
        this.aSwitchLinesDownAction = new SwitchAction("switchLinesDown", KeyStroke.getKeyStroke(40, 1), this);
        this.aSwitchLinesUpAction = new SwitchAction("switchLinesUp", KeyStroke.getKeyStroke(38, 1), this);
        VTable table = this.m_curGC.getTable();
        table.getInputMap(1).put(KeyStroke.getKeyStroke(40, 1), "none");
        table.getInputMap(1).put(KeyStroke.getKeyStroke(38, 1), "none");
        table.getInputMap(0).put(KeyStroke.getKeyStroke(40, 1), "none");
        table.getInputMap(0).put(KeyStroke.getKeyStroke(38, 1), "none");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(40, 1), this.aSwitchLinesDownAction.getName());
        this.getActionMap().put(this.aSwitchLinesDownAction.getName(), this.aSwitchLinesDownAction);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(38, 1), this.aSwitchLinesUpAction.getName());
        this.getActionMap().put(this.aSwitchLinesUpAction.getName(), this.aSwitchLinesUpAction);
    }

    public boolean isNested() {
        return this.isNested;
    }

    public JTabbedPane getCurrentTabbedPane() {
        return this.m_curWinTab;
    }

    public void statusUpdate(String message) {
        JFrame frame = AEnv.getFrame(this);
        if (frame == null) {
            return;
        }
        if (frame instanceof AWindow) {
            ((AWindow)frame).setBusyMessage(message);
        }
    }

    private void updateToolBarAndMenuWithRestriction() {
        int ToolBarButton_ID = 0;
        int[] restrictionList = MToolBarButtonRestrict.getOfWindow((Properties)this.m_ctx, (int)MRole.getDefault().getAD_Role_ID(), (int)this.m_window.getAD_Window_ID(), (boolean)false, null);
        if (log.isLoggable(Level.INFO)) {
            log.info("restrictionList=" + restrictionList.toString());
        }
        int i = 0;
        while (i < restrictionList.length) {
            ToolBarButton_ID = restrictionList[i];
            X_AD_ToolBarButton tbt = new X_AD_ToolBarButton(this.m_ctx, ToolBarButton_ID, null);
            String restrictName = tbt.getComponentName();
            if (log.isLoggable(Level.CONFIG)) {
                log.config("tbt=" + tbt.getAD_ToolBarButton_ID() + " / " + restrictName);
            }
            boolean found = false;
            int t = 0;
            while (t < this.toolBar.getComponentCount() && !found) {
                if (this.toolBar.getComponent(t).getName() != null && this.toolBar.getComponent(t).getName().equals(restrictName)) {
                    this.toolBar.remove(t);
                    found = true;
                }
                ++t;
            }
            found = false;
            int m1 = 0;
            while (m1 < this.menuBar.getComponentCount() && !found) {
                JMenu menu = this.menuBar.getMenu(m1);
                int m2 = 0;
                while (m2 < menu.getItemCount() && !found) {
                    if (menu.getItem(m2) != null && menu.getItem(m2).getActionCommand().equals(restrictName)) {
                        menu.remove(m2);
                        found = true;
                    }
                    ++m2;
                }
                ++m1;
            }
            ++i;
        }
    }

    public void ask(String message, Callback<Boolean> callback) {
        boolean b = ADialog.ask(this.m_curWindowNo, this, message);
        if (callback != null) {
            callback.onCallback((Object)b);
        }
    }

    public void download(File file) {
    }

    class SwitchAction
    extends AbstractAction {
        private static final long serialVersionUID = 3837712049468116744L;
        private ActionListener al;
        private String name;

        SwitchAction(String name, KeyStroke accelerator, ActionListener al) {
            super(name);
            this.putValue("Name", name);
            this.putValue("ShortDescription", name);
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("ActionCommandKey", name);
            this.al = al;
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.al.actionPerformed(e);
        }

        public String getName() {
            return this.name;
        }
    }
}

