/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.IProcessUI;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.ProcessDialog;
import org.compiere.apps.ProcessParameterPanel;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ProcessModalDialog
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = -1573751323319156081L;
    private IProcessUI m_processUI;
    private int m_WindowNo;
    private Properties m_ctx;
    private int m_tableId;
    private int m_recordId;
    private boolean m_autoStart;
    private int m_AD_Process_ID;
    private String m_Name = null;
    private StringBuffer m_messageText = new StringBuffer();
    private String m_ShowHelp = null;
    private boolean m_valid = true;
    private static CLogger log = CLogger.getCLogger(ProcessDialog.class);
    private CPanel dialog = new CPanel(){
        private static final long serialVersionUID = -8093428846912456722L;

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Dimension m = this.getMinimumSize();
            if (d.height < m.height || d.width < m.width) {
                Dimension d1 = new Dimension();
                d1.height = Math.max(d.height, m.height);
                d1.width = Math.max(d.width, m.width);
                return d1;
            }
            return d;
        }
    };
    private BorderLayout mainLayout = new BorderLayout();
    private ConfirmPanel southPanel = new ConfirmPanel(true);
    private CButton bOK = null;
    private JEditorPane message = new JEditorPane(){
        private static final long serialVersionUID = 1218214722657165651L;

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Dimension m = this.getMaximumSize();
            if (d.height > m.height || d.width > m.width) {
                Dimension d1 = new Dimension();
                d1.height = Math.min(d.height, m.height);
                d1.width = Math.min(d.width, m.width);
                return d1;
            }
            return d;
        }
    };
    private JScrollPane messagePane = new JScrollPane(this.message){
        private static final long serialVersionUID = 8653555758412012675L;

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Dimension m = this.getMaximumSize();
            if (d.height > m.height || d.width > m.width) {
                Dimension d1 = new Dimension();
                d1.height = Math.min(d.height, m.height);
                d1.width = Math.min(d.width, m.width);
                return d1;
            }
            return d;
        }
    };
    private CPanel centerPanel = null;
    private ProcessParameterPanel parameterPanel = null;
    private JSeparator separator = new JSeparator();
    private ProcessInfo m_pi = null;

    public ProcessModalDialog(Properties ctx, Frame parent, String title, IProcessUI aProcess, int WindowNo, int AD_Process_ID, int tableId, int recordId, boolean autoStart) {
        super(parent, title, true);
        if (log.isLoggable(Level.INFO)) {
            log.info("Process=" + AD_Process_ID);
        }
        this.m_ctx = ctx;
        this.m_processUI = aProcess;
        this.m_WindowNo = WindowNo;
        this.m_AD_Process_ID = AD_Process_ID;
        this.m_tableId = tableId;
        this.m_recordId = recordId;
        this.m_autoStart = autoStart;
        try {
            this.jbInit();
            this.init();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.dialog.setLayout(this.mainLayout);
        this.dialog.setMinimumSize(new Dimension(500, 200));
        this.southPanel.addActionListener(this);
        this.bOK = this.southPanel.getOKButton();
        this.message.setContentType("text/html");
        this.message.setEditable(false);
        this.message.setBackground(Color.white);
        this.message.setFocusable(false);
        this.getContentPane().add(this.dialog);
        this.dialog.add((Component)this.southPanel, "South");
        this.dialog.add((Component)this.messagePane, "North");
        this.messagePane.setBorder(null);
        this.messagePane.setMaximumSize(new Dimension(600, 300));
        this.centerPanel = new CPanel();
        this.centerPanel.setBorder(null);
        this.centerPanel.setLayout(new BorderLayout());
        this.dialog.add((Component)this.centerPanel, "Center");
        this.getRootPane().setDefaultButton(this.bOK);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.bOK.requestFocus();
        }
    }

    @Override
    public void dispose() {
        this.m_valid = false;
        this.parameterPanel.restoreContext();
        super.dispose();
    }

    public boolean isValidDialog() {
        return this.m_valid;
    }

    public boolean init() {
        log.config("");
        boolean trl = !Env.isBaseLanguage((Properties)this.m_ctx, (String)"AD_Process");
        String sql = "SELECT Name, Description, Help, IsReport, ShowHelp FROM AD_Process WHERE AD_Process_ID=?";
        if (trl) {
            sql = "SELECT t.Name, t.Description, t.Help, p.IsReport, p.ShowHelp FROM AD_Process p, AD_Process_Trl t WHERE p.AD_Process_ID=t.AD_Process_ID AND p.AD_Process_ID=? AND t.AD_Language=?";
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, this.m_AD_Process_ID);
                if (trl) {
                    pstmt.setString(2, Env.getAD_Language((Properties)this.m_ctx));
                }
                if ((rs = pstmt.executeQuery()).next()) {
                    this.m_Name = rs.getString(1);
                    this.m_ShowHelp = rs.getString(5);
                    this.m_messageText.append("<b>");
                    String s = rs.getString(2);
                    if (rs.wasNull()) {
                        this.m_messageText.append(Msg.getMsg((Properties)this.m_ctx, (String)"StartProcess?"));
                    } else {
                        this.m_messageText.append(s);
                    }
                    this.m_messageText.append("</b>");
                    s = rs.getString(3);
                    if (!rs.wasNull()) {
                        this.m_messageText.append("<p>").append(s).append("</p>");
                    }
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (this.m_Name == null) {
            return false;
        }
        this.setTitle(this.m_Name);
        this.message.setMargin(new Insets(10, 10, 10, 10));
        this.message.setText(this.m_messageText.toString());
        this.m_pi = new ProcessInfo(this.m_Name, this.m_AD_Process_ID, this.m_tableId, this.m_recordId);
        this.m_pi.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        this.m_pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)Env.getCtx()));
        this.parameterPanel = new ProcessParameterPanel(this.m_WindowNo, this.m_pi);
        this.parameterPanel.setWindow(this);
        this.centerPanel.removeAll();
        if (this.parameterPanel.init()) {
            this.centerPanel.add((Component)this.separator, "North");
            this.centerPanel.add((Component)this.parameterPanel, "Center");
        } else {
            if (this.m_ShowHelp != null && this.m_ShowHelp.equals("N")) {
                this.m_autoStart = true;
            }
            if (this.m_autoStart) {
                this.bOK.doClick();
            }
        }
        if (this.m_ShowHelp != null && this.m_ShowHelp.equals("S")) {
            this.bOK.doClick();
        }
        this.dialog.revalidate();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOK) {
            ProcessCtl.process(this.m_processUI, this.m_WindowNo, this.parameterPanel, this.m_pi, null);
            this.dispose();
        } else if (e.getSource() == this.southPanel.getCancelButton()) {
            this.dispose();
        }
    }
}

