/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.RecordInfo;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.MRole;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class StatusBar
extends CPanel
implements IStatusBar {
    private static final long serialVersionUID = 1465783013058042860L;
    private BorderLayout mainLayout = new BorderLayout();
    private JLabel statusLine = new JLabel();
    private JLabel statusDB = new JLabel();
    private JLabel infoLine = new JLabel();
    private boolean mt_error;
    private String mt_text;
    private String m_text;
    private DataStatusEvent m_dse = null;

    public StatusBar() {
        this(false);
    }

    public StatusBar(boolean withInfo) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setName("statusBar");
        if (!withInfo) {
            this.infoLine.setVisible(false);
        }
    }

    private void jbInit() throws Exception {
        this.statusLine.setBorder(BorderFactory.createEtchedBorder());
        this.statusLine.setText("statusLine");
        this.statusLine.setOpaque(false);
        this.statusDB.setForeground(Color.blue);
        this.statusDB.setBorder(BorderFactory.createEtchedBorder());
        this.statusDB.setText("#");
        this.statusDB.setOpaque(false);
        this.statusDB.addMouseListener(new StatusBar_mouseAdapter(this));
        this.setLayout(this.mainLayout);
        this.infoLine.setFont(AdempierePLAF.getFont_Label());
        this.infoLine.setBorder(BorderFactory.createLineBorder(AdempierePLAF.getSecondary2()));
        this.infoLine.setHorizontalAlignment(0);
        this.infoLine.setHorizontalTextPosition(0);
        this.infoLine.setText("info");
        this.mainLayout.setHgap(2);
        this.mainLayout.setVgap(2);
        this.add((Component)this.statusLine, "Center");
        this.add((Component)this.statusDB, "East");
        this.add((Component)this.infoLine, "North");
    }

    public void setStatusLine(String text) {
        if (text == null) {
            this.setStatusLine("", false);
        } else {
            this.setStatusLine(text, false);
        }
    }

    public void setStatusLine(String text, boolean error) {
        this.mt_error = error;
        this.mt_text = text;
        if (this.mt_error) {
            this.statusLine.setForeground(AdempierePLAF.getTextColor_Issue());
        } else {
            this.statusLine.setForeground(AdempierePLAF.getTextColor_OK());
        }
        this.statusLine.setText(" " + this.mt_text);
        Thread.yield();
    }

    public String getStatusLine() {
        return this.statusLine.getText().trim();
    }

    public void setStatusToolTip(String tip) {
        this.statusLine.setToolTipText(tip);
    }

    public void setStatusDB(String text, DataStatusEvent dse) {
        if (text == null || text.length() == 0) {
            this.statusDB.setText("");
            this.statusDB.setVisible(false);
        } else {
            StringBuilder sb = new StringBuilder(" ");
            sb.append(text).append(" ");
            this.statusDB.setText(sb.toString());
            if (!this.statusDB.isVisible()) {
                this.statusDB.setVisible(true);
            }
        }
        this.m_text = text;
        this.m_dse = dse;
    }

    public void setStatusDB(String text) {
        this.setStatusDB(text, null);
    }

    public void setStatusDB(int no) {
        this.setStatusDB(String.valueOf(no), null);
    }

    public void setInfo(String text) {
        if (!this.infoLine.isVisible()) {
            this.infoLine.setVisible(true);
        }
        this.infoLine.setText(text);
    }

    public void addStatusComponent(JComponent component) {
        this.add((Component)component, "East");
    }

    void mouseClicked(MouseEvent e) {
        if (this.m_dse == null || this.m_dse.CreatedBy == null || !MRole.getDefault().isShowPreference()) {
            return;
        }
        String title = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Who")) + this.m_text;
        RecordInfo info = new RecordInfo((Frame)AEnv.getFrame(this), title, this.m_dse);
        AEnv.showCenterScreen(info);
    }

    static class StatusBar_mouseAdapter
    extends MouseAdapter {
        private StatusBar adaptee;

        StatusBar_mouseAdapter(StatusBar adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.adaptee.mouseClicked(e);
        }
    }
}

