/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.LayoutCallback;
import net.miginfocom.swing.MigLayout;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.APanel;
import org.compiere.grid.GridController;
import org.compiere.grid.ed.VButton;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.model.GridField;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CollapsiblePanel;
import org.compiere.util.CLogger;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.border.DropShadowBorder;

public final class VPanel
extends CTabbedPane {
    private static final long serialVersionUID = 8227080366665213627L;
    private int m_WindowNo;
    private boolean debug = false;
    private String defaultLayoutConstraints;
    private int labelMinWidth = 0;
    private int fieldMinWidth = 0;
    private final boolean m_leftToRight = Language.getLoginLanguage().isLeftToRight();
    private String m_oldFieldGroup = null;
    private String m_oldFieldGroupType = null;
    private Hashtable<String, JPanel> m_tablist = new Hashtable();
    private Hashtable<Integer, CollapsiblePanel> m_tabincludelist = new Hashtable();
    private CPanel m_main = new CPanel(CompiereColor.getDefaultBackground());
    private DropShadowBorder marginBorder = new DropShadowBorder();
    private LayoutCallback callback = new LayoutCallback(){

        public BoundSize[] getSize(ComponentWrapper comp) {
            if (comp.getComponent() instanceof CLabel) {
                Component c = (Component)comp.getComponent();
                int w = VPanel.this.labelMinWidth;
                int h = c.getPreferredSize().height;
                BoundSize width = ConstraintParser.parseBoundSize((String)(String.valueOf(w) + ":" + w), (boolean)false, (boolean)true);
                BoundSize height = ConstraintParser.parseBoundSize((String)(String.valueOf(h) + ":" + h), (boolean)false, (boolean)false);
                return new BoundSize[]{width, height};
            }
            Component c = (Component)comp.getComponent();
            int w = VPanel.this.fieldMinWidth;
            int h = c.getPreferredSize().height;
            BoundSize width = ConstraintParser.parseBoundSize((String)(String.valueOf(w) + ":" + w), (boolean)false, (boolean)true);
            BoundSize height = ConstraintParser.parseBoundSize((String)(String.valueOf(h) + ":" + h), (boolean)false, (boolean)false);
            return new BoundSize[]{width, height};
        }

        public void correctBounds(ComponentWrapper comp) {
        }
    };
    private VEditor prevEditor = null;
    private GridField prevField = null;
    private boolean wrap = false;
    private static CLogger log = CLogger.getCLogger(VPanel.class);
    private ArrayList<Character> m_mnemonics = new ArrayList(30);
    private ArrayList<Component> m_fields = new ArrayList(30);
    private HashMap<Integer, GridController> includedTabList = new HashMap();

    public VPanel(String Name) {
        this(Name, 0);
    }

    public VPanel(String Name, int WindowNo) {
        this.m_WindowNo = WindowNo;
        this.defaultLayoutConstraints = "hidemode 3";
        this.defaultLayoutConstraints = String.valueOf(this.defaultLayoutConstraints) + (this.debug ? ", debug" : "");
        this.m_main.setName(Name);
        String constraints = this.defaultLayoutConstraints;
        MigLayout mainLayout = new MigLayout(constraints);
        mainLayout.addLayoutCallback(this.callback);
        this.m_main.setLayout((LayoutManager)mainLayout);
        this.m_tablist.put("main", this.m_main);
        this.setBorder((Border)this.marginBorder);
        CPanel dummy = new CPanel();
        dummy.setLayout(new BorderLayout());
        dummy.add((Component)this.m_main, "North");
        dummy.setName(this.m_main.getName());
        this.add(dummy);
    }

    public void setMnemonic(GridField mField) {
        char mnemonic;
        if (mField.isCreateMnemonic()) {
            return;
        }
        String text = mField.getHeader();
        int pos = text.indexOf(38);
        if (pos != -1 && text.length() > pos && (mnemonic = text.toUpperCase().charAt(pos + 1)) != ' ') {
            if (!this.m_mnemonics.contains(Character.valueOf(mnemonic))) {
                mField.setMnemonic(mnemonic);
                this.m_mnemonics.add(Character.valueOf(mnemonic));
            } else {
                log.warning(String.valueOf(mField.getColumnName()) + " - Conflict - Already exists: " + mnemonic + " (" + text + ")");
            }
        }
    }

    public void addFieldBuffered(VEditor editor, GridField mField) {
        boolean bl = mField != null ? !mField.isSameLine() : (this.wrap = false);
        if (this.prevEditor != null && this.prevField != null) {
            this.addField(this.prevEditor, this.prevField);
        }
        this.prevEditor = editor;
        this.prevField = mField;
    }

    public void addField(VEditor editor, GridField mField) {
        JPanel m_tab;
        int AD_Tab_ID = mField.getIncluded_Tab_ID();
        if (AD_Tab_ID != 0) {
            CollapsiblePanel m_tab2 = new CollapsiblePanel("");
            this.m_tabincludelist.put(AD_Tab_ID, m_tab2);
            this.m_main.add((Component)m_tab2, "newline, spanx, growx");
            m_tab2.setName("IncludedTab#" + AD_Tab_ID);
            if (this.includedTabList.containsKey(AD_Tab_ID)) {
                this.includeTab(this.includedTabList.get(AD_Tab_ID));
            }
            return;
        }
        CLabel label = VEditorFactory.getLabel(mField);
        if (label == null && editor == null) {
            return;
        }
        boolean sameLine = mField.isSameLine();
        String fieldGroup = mField.getFieldGroup();
        String fieldGroupType = mField.getFieldGroupType();
        if (Util.isEmpty((String)fieldGroup)) {
            fieldGroup = this.m_oldFieldGroup;
            fieldGroupType = this.m_oldFieldGroupType;
        }
        if (this.addGroup(fieldGroup, fieldGroupType)) {
            if ("C".equals(fieldGroupType)) {
                CollapsiblePanel panel = (CollapsiblePanel)this.m_tablist.get(fieldGroup);
                panel.getCollapsiblePane().setCollapsed(mField.getIsCollapsedByDefault());
            }
            sameLine = false;
        } else {
            fieldGroup = this.m_oldFieldGroup;
            fieldGroupType = this.m_oldFieldGroupType;
        }
        String constraints = "align trailing";
        if (!sameLine) {
            constraints = String.valueOf(constraints) + ", newline";
        }
        if (label == null) {
            label = new CLabel("");
            label.setName(mField.getColumnName());
        }
        if (mField.isCreateMnemonic()) {
            this.setMnemonic(label, mField.getMnemonic());
        }
        if (fieldGroupType.equals("T")) {
            m_tab = (CPanel)this.m_tablist.get(fieldGroup);
            m_tab.add((Component)label, constraints);
        } else if (fieldGroupType.equals("C")) {
            m_tab = (CollapsiblePanel)this.m_tablist.get(fieldGroup);
            ((CollapsiblePanel)m_tab).getCollapsiblePane().getContentPane().add((Component)label, constraints);
        } else {
            this.m_main.add((Component)label, constraints);
        }
        int currentWidth = label.getPreferredSize().width;
        int n = this.labelMinWidth = currentWidth > this.labelMinWidth ? currentWidth : this.labelMinWidth;
        if (editor != null) {
            Component field = (Component)((Object)editor);
            constraints = "growx, pushx";
            if (mField.isLongField()) {
                constraints = String.valueOf(constraints) + (mField.isLongField() ? ",spanx" : "");
            }
            if (this.wrap) {
                constraints = String.valueOf(constraints) + ", wrap 0";
            }
            if (fieldGroupType.equals("T")) {
                CPanel m_tab3 = (CPanel)this.m_tablist.get(fieldGroup);
                m_tab3.add(field, constraints);
            } else if (fieldGroupType.equals("C")) {
                CollapsiblePanel m_tab4 = (CollapsiblePanel)this.m_tablist.get(fieldGroup);
                Component comp = (Component)((Object)editor);
                comp.setMinimumSize(comp.getPreferredSize());
                if (mField.getDisplayType() == 14 || mField.getDisplayType() == 34 || mField.getDisplayType() == 36) {
                    Component component = (Component)((Object)editor);
                    component.setMinimumSize(component.getPreferredSize());
                }
                if (!mField.isLongField()) {
                    this.fieldMinWidth = field.getPreferredSize().width > this.fieldMinWidth ? field.getPreferredSize().width : this.fieldMinWidth;
                }
                m_tab4.getCollapsiblePane().getContentPane().add(field, constraints);
            } else {
                this.m_main.add(field, constraints);
                if (!mField.isLongField()) {
                    this.fieldMinWidth = field.getPreferredSize().width > this.fieldMinWidth ? field.getPreferredSize().width : this.fieldMinWidth;
                }
            }
            label.setLabelFor(field);
        }
    }

    private boolean addGroup(String fieldGroup, String fieldGroupType) {
        if (this.m_oldFieldGroup == null) {
            this.m_oldFieldGroup = "";
            this.m_oldFieldGroupType = "";
        }
        if (fieldGroup == null || fieldGroup.length() == 0 || fieldGroup.equals(this.m_oldFieldGroup)) {
            return false;
        }
        if (this.m_tablist.get(fieldGroup) != null) {
            return false;
        }
        if (fieldGroupType.equals("T")) {
            CPanel m_tab = new CPanel();
            m_tab.setBackground(AdempierePLAF.getFormBackground());
            String tpConstraints = this.defaultLayoutConstraints;
            MigLayout layout = new MigLayout(tpConstraints);
            layout.addLayoutCallback(this.callback);
            m_tab.setLayout((LayoutManager)layout);
            m_tab.setName(fieldGroup);
            CPanel dummy = new CPanel();
            dummy.setLayout(new BorderLayout());
            dummy.add((Component)m_tab, "North");
            dummy.setName(m_tab.getName());
            dummy.setBorder(BorderFactory.createEmptyBorder(10, 12, 0, 12));
            this.add(dummy);
            this.m_tablist.put(fieldGroup, m_tab);
        } else if (fieldGroupType.equals("C")) {
            CollapsiblePanel collapsibleSection = new CollapsiblePanel(fieldGroup);
            JXCollapsiblePane m_tab = collapsibleSection.getCollapsiblePane();
            m_tab.setAnimated(false);
            m_tab.getContentPane().setBackground(AdempierePLAF.getFormBackground());
            String cpConstraints = this.defaultLayoutConstraints;
            cpConstraints = String.valueOf(cpConstraints) + ", ins 0 0 n 0";
            MigLayout layout = new MigLayout(cpConstraints);
            layout.addLayoutCallback(this.callback);
            collapsibleSection.setName(fieldGroup);
            this.m_main.add((Component)collapsibleSection, "newline, spanx, growx");
            m_tab.setLayout((LayoutManager)layout);
            Component strut1 = Box.createVerticalStrut(1);
            strut1.setName("vstrut1" + fieldGroup);
            Component strut2 = Box.createVerticalStrut(1);
            strut2.setName("vstrut2" + fieldGroup);
            m_tab.add((Component)new CLabel(""), (Object)"gap 0 0 0 0");
            m_tab.add(strut1, (Object)"pushx, growx, gap 0 0 0 0");
            m_tab.add((Component)new CLabel(""), (Object)"");
            m_tab.add(strut2, (Object)"pushx, growx, gap 0 0 0 0, wrap");
            this.m_tablist.put(fieldGroup, collapsibleSection);
        } else {
            CLabel label = new CLabel(fieldGroup, 10);
            label.setFont(AdempierePLAF.getFont_Label().deriveFont(3, AdempierePLAF.getFont_Label().getSize2D()));
            this.m_main.add((Component)label, "newline, spanx, growx");
            this.m_main.add((Component)new JSeparator(), "newline, spanx, growx");
        }
        this.m_oldFieldGroup = fieldGroup;
        this.m_oldFieldGroupType = fieldGroupType;
        return true;
    }

    private void setMnemonic(CLabel label, char predefinedMnemonic) {
        String text = label.getText();
        int pos = text.indexOf(38);
        if (pos != -1 && predefinedMnemonic != '\u0000') {
            text = String.valueOf(text.substring(0, pos)) + text.substring(pos + 1);
            label.setText(text);
            label.setSavedMnemonic(predefinedMnemonic);
            this.m_fields.add(label);
            if (log.isLoggable(Level.FINEST)) {
                log.finest(String.valueOf(predefinedMnemonic) + " - " + label.getName());
            }
        } else {
            char mnemonic = this.getMnemonic(text, label);
            if (mnemonic != '\u0000') {
                label.setSavedMnemonic(mnemonic);
            }
        }
    }

    private char getMnemonic(String text, Component source) {
        if (text == null || text.length() == 0) {
            return '\u0000';
        }
        String oText = text;
        char mnemonic = (text = text.trim().toUpperCase()).charAt(0);
        if (this.m_mnemonics.contains(Character.valueOf(mnemonic))) {
            mnemonic = '\u0000';
            int index = text.indexOf(32);
            while (index != -1 && text.length() > index) {
                char c = text.charAt(index + 1);
                if (Character.isLetterOrDigit(c) && !this.m_mnemonics.contains(Character.valueOf(c))) {
                    mnemonic = c;
                    break;
                }
                index = text.indexOf(32, index + 1);
            }
            if (mnemonic == '\u0000') {
                int i = 1;
                while (i < text.length()) {
                    char c = text.charAt(i);
                    if (Character.isLetterOrDigit(c) && !this.m_mnemonics.contains(Character.valueOf(c))) {
                        mnemonic = c;
                        break;
                    }
                    ++i;
                }
            }
            if (mnemonic == '\u0000') {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("None for: " + oText);
                }
                return '\u0000';
            }
        }
        this.m_mnemonics.add(Character.valueOf(mnemonic));
        this.m_fields.add(source);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.valueOf(mnemonic) + " - " + source.getName());
        }
        return mnemonic;
    }

    public void setMnemonics(boolean set) {
        int size = this.m_fields.size();
        int i = 0;
        while (i < size) {
            Component c = this.m_fields.get(i);
            if (c instanceof CLabel) {
                CLabel l = (CLabel)c;
                if (set) {
                    l.setDisplayedMnemonic(l.getSavedMnemonic());
                } else {
                    l.setDisplayedMnemonic(0);
                }
            } else if (c instanceof VCheckBox) {
                VCheckBox cb = (VCheckBox)c;
                if (set) {
                    cb.setMnemonic(cb.getSavedMnemonic());
                } else {
                    cb.setMnemonic(0);
                }
            } else if (c instanceof VButton) {
                VButton b = (VButton)c;
                if (set) {
                    b.setMnemonic(b.getSavedMnemonic());
                } else {
                    b.setMnemonic(0);
                }
            }
            ++i;
        }
    }

    public void setBackground(int AD_Color_ID) {
    }

    private void findChildComponents(CPanel container, List<Component> list) {
        Component[] comp = container.getComponents();
        int c = 0;
        while (c < comp.length) {
            list.add(comp[c]);
            if (comp[c] instanceof CollapsiblePanel) {
                CollapsiblePanel collapsiblePanel = (CollapsiblePanel)comp[c];
                Component[] nestedComps = collapsiblePanel.getCollapsiblePane().getContentPane().getComponents();
                int y = 0;
                while (y < nestedComps.length) {
                    if (nestedComps[y] instanceof CPanel) {
                        CPanel nestedPanel = (CPanel)nestedComps[y];
                        Component[] nestedPanelComps = nestedPanel.getComponents();
                        int x = 0;
                        while (x < nestedPanelComps.length) {
                            list.add(nestedPanelComps[x]);
                            ++x;
                        }
                    } else {
                        list.add(nestedComps[y]);
                    }
                    ++y;
                }
            } else if (comp[c] instanceof CPanel) {
                this.findChildComponents((CPanel)comp[c], list);
            }
            ++c;
        }
    }

    public Component[] getComponentsRecursive() {
        ArrayList<Component> list = new ArrayList<Component>();
        int i = 0;
        while (i < this.getTabCount()) {
            list.add(this.getComponentAt(i));
            if (this.getComponentAt(i) instanceof CPanel) {
                CPanel panel = (CPanel)this.getComponentAt(i);
                this.findChildComponents(panel, list);
            }
            ++i;
        }
        Component[] result = new Component[list.size()];
        list.toArray(result);
        return result;
    }

    public void includeTab(GridController detail) {
        CollapsiblePanel section = this.m_tabincludelist.get(detail.getMTab().getAD_Tab_ID());
        if (section != null) {
            APanel panel = new APanel(detail, this.m_WindowNo);
            String name = String.valueOf(detail.getMTab().getName());
            section.setTitle(name);
            section.getCollapsiblePane().getContentPane().setLayout(new BorderLayout());
            section.getCollapsiblePane().getContentPane().add((Component)panel, "Center");
        }
        if (!this.includedTabList.containsKey(detail.getMTab().getAD_Tab_ID())) {
            this.includedTabList.put(detail.getMTab().getAD_Tab_ID(), detail);
        }
    }
}

