/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.logging.Level;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.compiere.apps.ADialog;
import org.compiere.grid.ed.VNumber;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public final class MDocNumber
extends PlainDocument {
    private static final long serialVersionUID = 2586631851842406102L;
    private int m_displayType = 0;
    private DecimalFormat m_format = null;
    private JTextComponent m_tc = null;
    private String m_title = null;
    private char m_decimalSeparator = (char)46;
    private char m_groupingSeparator = (char)44;
    private char m_minusSign = (char)45;
    private char m_percentSign = (char)37;
    private static CLogger log = CLogger.getCLogger(MDocNumber.class);

    public MDocNumber(int displayType, DecimalFormat format, JTextComponent tc, String title) {
        if (format == null || tc == null || title == null) {
            throw new IllegalArgumentException("Invalid argument");
        }
        this.m_displayType = displayType;
        this.m_format = format;
        this.m_tc = tc;
        this.m_title = title;
        DecimalFormatSymbols sym = this.m_format.getDecimalFormatSymbols();
        this.m_decimalSeparator = sym.getDecimalSeparator();
        this.m_groupingSeparator = sym.getGroupingSeparator();
        this.m_minusSign = sym.getMinusSign();
    }

    @Override
    public void insertString(int origOffset, String string, AttributeSet attr) throws BadLocationException {
        block31: {
            char c;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Offset=" + origOffset + " String=" + string + " Length=" + string.length());
            }
            if (origOffset < 0 || string == null) {
                throw new IllegalArgumentException("Invalid argument");
            }
            int offset = origOffset;
            int length = string.length();
            if (length != 1) {
                super.insertString(offset, string, attr);
                return;
            }
            String content = this.getText();
            if (content.indexOf(this.m_groupingSeparator) != -1) {
                StringBuilder result = new StringBuilder();
                int i = 0;
                while (i < content.length()) {
                    if (content.charAt(i) == this.m_groupingSeparator) {
                        if (i < offset) {
                            --offset;
                        }
                    } else {
                        result.append(content.charAt(i));
                    }
                    ++i;
                }
                super.remove(0, content.length());
                super.insertString(0, result.toString(), attr);
                this.m_tc.setCaretPosition(offset);
                content = result.toString();
            }
            if (Character.isDigit(c = string.charAt(0))) {
                super.insertString(offset, string, attr);
                return;
            }
            if (c == this.m_decimalSeparator || c == this.m_groupingSeparator || c == '.' || c == ',') {
                if (this.m_displayType == 11) {
                    return;
                }
                int pos = content.indexOf(this.m_decimalSeparator);
                String decimal = String.valueOf(this.m_decimalSeparator);
                super.insertString(offset, decimal, attr);
                if (pos != 0) {
                    content = this.getText();
                    StringBuilder result = new StringBuilder();
                    int correction = 0;
                    int i = 0;
                    while (i < content.length()) {
                        if (content.charAt(i) == this.m_decimalSeparator) {
                            if (i == offset) {
                                result.append(content.charAt(i));
                            } else if (i < offset) {
                                ++correction;
                            }
                        } else {
                            result.append(content.charAt(i));
                        }
                        ++i;
                    }
                    super.remove(0, content.length());
                    super.insertString(0, result.toString(), attr);
                    this.m_tc.setCaretPosition(offset - correction + 1);
                }
            } else if ("=+-/*%".indexOf(c) > -1) {
                if (c == this.m_minusSign && offset == 0) {
                    if (this.m_displayType == 11) {
                        return;
                    }
                    super.insertString(0, "-", attr);
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Input=" + c + " (" + c + ")");
                    }
                    if (c == this.m_percentSign && offset > 0) {
                        if (this.m_displayType == 11) {
                            return;
                        }
                        String value = this.getText();
                        BigDecimal percentValue = Env.ZERO;
                        try {
                            if (value != null && value.length() > 0) {
                                Number number = this.m_format.parse(value);
                                percentValue = new BigDecimal(number.toString());
                                percentValue = percentValue.divide(Env.ONEHUNDRED, this.m_format.getMaximumFractionDigits(), 4);
                                this.m_tc.setText(this.m_format.format(percentValue));
                            }
                            break block31;
                        }
                        catch (ParseException pe) {
                            if (log.isLoggable(Level.INFO)) {
                                log.info("InvalidEntry - " + pe.getMessage());
                            }
                            break block31;
                        }
                    }
                    String result = VNumber.startCalculator(this.m_tc, this.getText(), this.m_format, this.m_displayType, this.m_title, c);
                    super.remove(0, content.length());
                    this.m_tc.setText(result);
                }
            } else {
                ADialog.beep();
            }
        }
    }

    @Override
    public void remove(int origOffset, int length) throws BadLocationException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Offset=" + origOffset + " Length=" + length);
        }
        if (origOffset < 0 || length < 0) {
            throw new IllegalArgumentException("MDocNumber.remove - invalid argument");
        }
        int offset = origOffset;
        if (length != 1) {
            super.remove(offset, length);
            return;
        }
        String content = this.getText();
        if (content.indexOf(this.m_groupingSeparator) != -1) {
            StringBuilder result = new StringBuilder();
            int i = 0;
            while (i < content.length()) {
                if (content.charAt(i) == this.m_groupingSeparator && i != origOffset) {
                    if (i < offset) {
                        --offset;
                    }
                } else {
                    result.append(content.charAt(i));
                }
                ++i;
            }
            super.remove(0, content.length());
            super.insertString(0, result.toString(), null);
            this.m_tc.setCaretPosition(offset);
        }
        super.remove(offset, length);
    }

    private String getText() {
        AbstractDocument.Content c = this.getContent();
        String str = "";
        try {
            str = c.getString(0, c.length() - 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }
}

