/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.FieldRecordInfo;
import org.compiere.grid.ed.Editor;
import org.compiere.grid.ed.MDocString;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VOvrCaret;
import org.compiere.grid.ed.ValuePreference;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.model.Obscure;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public final class VString
extends CTextField
implements VEditor,
ActionListener,
FocusListener {
    private static final long serialVersionUID = 8487860095322876086L;
    public static final int MAXDISPLAY_LENGTH = 60;
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mEditor;
    private GridField m_mField = null;
    private String m_columnName;
    private String m_oldText;
    private String m_initialText;
    private String m_VFormat;
    private int m_fieldLength;
    private Obscure m_obscure = null;
    private Font m_stdFont = null;
    private Font m_obscureFont = null;
    private volatile boolean m_setting = false;
    private volatile boolean m_infocus = false;
    private static CLogger log = CLogger.getCLogger(VString.class);

    public VString() {
        this("String", false, false, true, 30, 30, "", null);
    }

    public VString(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int displayLength, int fieldLength, String VFormat, String ObscureType) {
        super(displayLength > 60 ? 60 : displayLength);
        super.setName(columnName);
        this.m_columnName = columnName;
        if (VFormat == null) {
            VFormat = "";
        }
        this.m_VFormat = VFormat;
        this.m_fieldLength = fieldLength;
        if (this.m_VFormat.length() != 0 || this.m_fieldLength != 0) {
            this.setDocument(new MDocString(this.m_VFormat, this.m_fieldLength, this));
        }
        if (this.m_VFormat.length() != 0) {
            this.setCaret(new VOvrCaret());
        }
        this.setMandatory(mandatory);
        if (ObscureType != null && ObscureType.length() > 0) {
            this.m_obscure = new Obscure("", ObscureType);
            this.m_stdFont = this.getFont();
            this.m_obscureFont = new Font("SansSerif", 2, this.m_stdFont.getSize());
        }
        if (isReadOnly || !isUpdateable) {
            this.setEditable(false);
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        }
        this.addKeyListener(this);
        this.addActionListener(this);
        this.addFocusListener(this);
        this.addMouseListener(new VString_mouseAdapter(this));
        if (fieldLength > displayLength) {
            this.mEditor = new CMenuItem(Msg.getMsg((Properties)Env.getCtx(), (String)"Editor"), Env.getImageIcon((String)"Editor16.gif"));
            this.mEditor.addActionListener(this);
            this.popupMenu.add(this.mEditor);
        }
        this.setForeground(AdempierePLAF.getTextColor_Normal());
        this.setBackground(AdempierePLAF.getFieldBackground_Normal());
    }

    @Override
    public void dispose() {
        this.m_mField = null;
    }

    @Override
    public void setValue(Object value) {
        this.m_oldText = value == null ? "" : value.toString();
        if (this.m_setting) {
            return;
        }
        this.setText(this.m_oldText);
        this.m_initialText = this.m_oldText;
        if (!this.isEditable() || !this.isEnabled()) {
            this.setCaretPosition(0);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    @Override
    public String getDisplay() {
        return super.getText();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Key=" + e.getKeyCode() + " - " + e.getKeyChar() + " -> " + this.getText());
        }
        if (e.getKeyCode() == 27) {
            this.setText(this.m_initialText);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ValuePreference")) {
            if (MRole.getDefault().isShowPreference() && !this.m_mField.isEncrypted() && !this.m_mField.isEncryptedColumn()) {
                ValuePreference.start(this.m_mField, this.getValue());
            }
            return;
        }
        if (e.getActionCommand().equals("ChangeLog")) {
            FieldRecordInfo.start(this.m_mField);
            return;
        }
        if (e.getSource() == this.mEditor) {
            String s = Editor.startEditor(this, Msg.translate((Properties)Env.getCtx(), (String)this.m_columnName), this.getText(), this.isEditable(), this.m_fieldLength);
            this.setText(s);
        }
        try {
            this.fireVetoableChange(this.m_columnName, this.m_oldText, this.getText());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
        if (this.m_mField != null && MRole.getDefault().isShowPreference() && !mField.isEncrypted() && !mField.isEncryptedColumn()) {
            ValuePreference.addMenu(this, this.popupMenu);
        }
        if (this.m_mField != null) {
            FieldRecordInfo.addMenu(this, this.popupMenu);
        }
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }

    public void setVFormat(String strMask) {
        this.m_VFormat = strMask;
        try {
            CaretListener[] cl = this.getCaretListeners();
            this.removeCaretListener(cl[0]);
        }
        catch (ClassCastException ex) {
            log.fine("VString.setVFormat - No caret Listeners");
        }
        String s = this.getText();
        this.setDocument(new MDocString(this.m_VFormat, this.m_fieldLength, this));
        this.setText(s);
    }

    @Override
    public void setText(String text) {
        if (this.m_obscure != null && !this.m_infocus) {
            super.setFont(this.m_obscureFont);
            super.setText(this.m_obscure.getObscuredValue(text));
            super.setForeground(Color.gray);
        } else {
            if (this.m_stdFont != null) {
                super.setFont(this.m_stdFont);
                super.setForeground(AdempierePLAF.getTextColor_Normal());
            }
            super.setText(text);
        }
    }

    @Override
    public String getText() {
        String text = super.getText();
        if (this.m_obscure != null && text != null && text.length() > 0 && this.isReadWrite() && text.equals(this.m_obscure.getObscuredValue())) {
            text = this.m_obscure.getClearValue();
        }
        return text;
    }

    public String getVFormat() {
        return this.m_VFormat;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.m_infocus = true;
        this.setText(this.getText());
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.m_setting = true;
        try {
            String clear = this.getText();
            if (clear.length() > this.m_fieldLength) {
                clear = clear.substring(0, this.m_fieldLength);
            }
            this.fireVetoableChange(this.m_columnName, this.m_oldText, clear);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.m_setting = false;
        this.m_infocus = false;
        this.setText(this.getText());
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.m_stdFont = f;
        this.m_obscureFont = new Font("SansSerif", 2, this.m_stdFont.getSize());
    }

    final class VString_mouseAdapter
    extends MouseAdapter {
        private VString m_adaptee;

        VString_mouseAdapter(VString adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.m_adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

