/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.ReferenceUtils;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.compiere.model.MAttachment;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AttachmentElementHandler
extends AbstractElementHandler {
    private List<Integer> attachments = new ArrayList<Integer>();

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String action = null;
        MAttachment mAttachment = (MAttachment)this.findPO(ctx, element);
        if (mAttachment == null) {
            int AD_Table_ID = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)((Element)element.properties.get("AD_Table_ID")), (String)this.getTrxName(ctx));
            if (AD_Table_ID <= 0) {
                element.defer = true;
                element.unresolved = "AD_Table_ID";
                return;
            }
            Element recordElement = (Element)element.properties.get("Record_ID");
            int Record_ID = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)recordElement, (String)this.getTrxName(ctx));
            if (Record_ID <= 0) {
                element.defer = true;
                element.unresolved = "Record_ID";
                return;
            }
            int id = DB.getSQLValue((String)this.getTrxName(ctx), (String)("SELECT AD_Attachment_ID FROM AD_Attachment WHERE Record_ID=" + Record_ID + " AND AD_Table_ID=" + AD_Table_ID));
            mAttachment = new MAttachment(ctx.ctx, id > 0 ? id : 0, this.getTrxName(ctx));
            if (mAttachment.is_new()) {
                mAttachment.setAD_Table_ID(AD_Table_ID);
                mAttachment.setRecord_ID(Record_ID);
            }
        }
        List excludes = this.defaultExcludeList("AD_Attachment");
        excludes.add("AD_Table_ID");
        excludes.add("Record_ID");
        if (mAttachment.getAD_Attachment_ID() == 0 && this.isOfficialId(element, "AD_Attachment_ID")) {
            mAttachment.setAD_Attachment_ID(this.getIntValue(element, "AD_Attachment_ID"));
        }
        if (this.attachments.contains(mAttachment.getAD_Attachment_ID())) {
            element.skip = true;
            return;
        }
        PoFiller pf = new PoFiller(ctx, (PO)mAttachment, element, (AbstractElementHandler)this);
        List notfounds = pf.autoFill(excludes);
        if (notfounds.size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        mAttachment.getEntries();
        if (mAttachment.is_new() || mAttachment.is_Changed()) {
            X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Attachment", 254);
            if (!mAttachment.is_new()) {
                this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Attachment", (PO)mAttachment);
                action = "Update";
            } else {
                action = "New";
            }
            if (mAttachment.save(this.getTrxName(ctx))) {
                this.logImportDetail(ctx, impDetail, 1, mAttachment.toString(), mAttachment.get_ID(), action);
                element.recordId = mAttachment.getAD_Attachment_ID();
                this.attachments.add(mAttachment.getAD_Attachment_ID());
            } else {
                this.logImportDetail(ctx, impDetail, 0, mAttachment.toString(), mAttachment.get_ID(), action);
                throw new POSaveFailedException("Failed to save Attachment " + mAttachment.toString());
            }
        }
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    protected void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_Attachment_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Attachment_ID");
        if (this.attachments.contains(AD_Attachment_ID)) {
            return;
        }
        this.attachments.add(AD_Attachment_ID);
        MAttachment mAttachment = new MAttachment(ctx.ctx, AD_Attachment_ID, this.getTrxName(ctx));
        if (ctx.packOut.getFromDate() != null && mAttachment.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "table");
        document.startElement("", "", "AD_Attachment", atts);
        this.createAttachmentBinding(ctx, document, mAttachment);
        int[] ids = PO.getAllIDs((String)"AD_AttachmentNote", (String)("AD_Attachment_ID=" + AD_Attachment_ID), (String)this.getTrxName(ctx));
        if (ids != null && ids.length > 0) {
            ElementHandler handler = ctx.packOut.getHandler("AD_AttachmentNote");
            int[] nArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int AD_AttachmentNote_ID = nArray[n2];
                try {
                    handler.packOut(ctx.packOut, document, null, AD_AttachmentNote_ID);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
                ++n2;
            }
        }
        document.endElement("", "", "AD_Attachment");
    }

    private void createAttachmentBinding(PIPOContext ctx, TransformerHandler document, MAttachment mAttachment) {
        PoExporter filler = new PoExporter(ctx, document, (PO)mAttachment);
        if (mAttachment.getAD_Attachment_ID() <= 999999) {
            filler.add("AD_Attachment_ID", new AttributesImpl());
        }
        List excludes = this.defaultExcludeList("AD_Attachment");
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        packout.getCtx().ctx.put("AD_Attachment_ID", Integer.toString(recordId));
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Attachment_ID");
    }
}

