/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_Val_Rule;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DynValRuleElementHandler
extends AbstractElementHandler {
    private List<Integer> rules = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        List excludes;
        PoFiller filler;
        List notfounds;
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        String name = this.getStringValue(element, "Name");
        X_AD_Val_Rule mValRule = (X_AD_Val_Rule)this.findPO(ctx, element);
        if (mValRule == null) {
            int id = this.findIdByColumn(ctx, "AD_Val_Rule", "Name", name);
            mValRule = new X_AD_Val_Rule(ctx.ctx, id > 0 ? id : 0, this.getTrxName(ctx));
        }
        if (mValRule.getAD_Val_Rule_ID() == 0 && this.isOfficialId(element, "AD_Val_Rule_ID")) {
            mValRule.setAD_Val_Rule_ID(this.getIntValue(element, "AD_Val_Rule_ID"));
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)mValRule, element, (AbstractElementHandler)this)).autoFill(excludes = this.defaultExcludeList("AD_Val_Rule"))).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!mValRule.is_new()) {
            if (!mValRule.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Val_Rule", 108);
        String action = null;
        if (!mValRule.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Val_Rule", (PO)mValRule);
            action = "Update";
        } else {
            action = "New";
        }
        if (mValRule.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mValRule.getName(), mValRule.get_ID(), action);
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mValRule.getName(), mValRule.get_ID(), action);
        throw new POSaveFailedException("Failed to save dynamic validation rule " + mValRule.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    protected void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_Val_Rule_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Val_Rule_ID");
        if (this.rules.contains(AD_Val_Rule_ID)) {
            return;
        }
        this.rules.add(AD_Val_Rule_ID);
        X_AD_Val_Rule m_ValRule = new X_AD_Val_Rule(ctx.ctx, AD_Val_Rule_ID, null);
        if (ctx.packOut.getFromDate() != null && m_ValRule.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "table");
        document.startElement("", "", "AD_Val_Rule", atts);
        this.createDynamicValidationRuleBinding(ctx, document, m_ValRule);
        document.endElement("", "", "AD_Val_Rule");
    }

    private void createDynamicValidationRuleBinding(PIPOContext ctx, TransformerHandler document, X_AD_Val_Rule m_ValRule) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_ValRule);
        List excludes = this.defaultExcludeList("AD_Val_Rule");
        if (m_ValRule.getAD_Val_Rule_ID() <= 999999) {
            filler.add("AD_Val_Rule_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Val_Rule_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Val_Rule_ID");
    }
}

