/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.CommonTranslationHandler;
import org.compiere.model.PO;
import org.compiere.model.X_AD_FieldGroup;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FieldGroupElementHandler
extends AbstractElementHandler {
    private List<Integer> processedFieldGroups = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        String action = null;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(elementValue) + " " + this.getStringValue(element, "Name"));
        }
        String entitytype = this.getStringValue(element, "EntityType");
        String name = this.getStringValue(element, "Name");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        X_AD_FieldGroup fieldGroup = (X_AD_FieldGroup)this.findPO(ctx, element);
        if (fieldGroup == null) {
            int id = this.findIdByColumn(ctx, "AD_FieldGroup", "Name", name);
            fieldGroup = new X_AD_FieldGroup(ctx.ctx, id > 0 ? id : 0, this.getTrxName(ctx));
        }
        PoFiller pf = new PoFiller(ctx, (PO)fieldGroup, element, (AbstractElementHandler)this);
        List excludes = this.defaultExcludeList("AD_FieldGroup");
        if (fieldGroup.getAD_FieldGroup_ID() == 0 && this.isOfficialId(element, "AD_FieldGroup_ID")) {
            pf.setInteger("AD_FieldGroup_ID");
        }
        if (this.processedFieldGroups.contains(fieldGroup.getAD_FieldGroup_ID())) {
            element.skip = true;
            return;
        }
        List notfounds = pf.autoFill(excludes);
        if (notfounds.size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!fieldGroup.is_new()) {
            if (!fieldGroup.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_FieldGroup", 414);
        if (!fieldGroup.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_FieldGroup", (PO)fieldGroup);
            action = "Update";
        } else {
            action = "New";
        }
        if (fieldGroup.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, fieldGroup.getName(), fieldGroup.get_ID(), action);
            element.recordId = fieldGroup.getAD_FieldGroup_ID();
            this.processedFieldGroups.add(fieldGroup.getAD_FieldGroup_ID());
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, fieldGroup.getName(), fieldGroup.get_ID(), action);
        throw new POSaveFailedException("Failed to save Field Group " + fieldGroup.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    protected void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        block4: {
            int fieldGroup_id = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_FieldGroup_ID");
            if (this.processedFieldGroups.contains(fieldGroup_id)) {
                return;
            }
            this.processedFieldGroups.add(fieldGroup_id);
            X_AD_FieldGroup fieldGroup = new X_AD_FieldGroup(ctx.ctx, fieldGroup_id, null);
            if (ctx.packOut.getFromDate() != null && fieldGroup.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            this.addTypeName(atts, "table");
            document.startElement("", "", "AD_FieldGroup", atts);
            this.createAdElementBinding(ctx, document, fieldGroup);
            PackOut packOut = ctx.packOut;
            try {
                new CommonTranslationHandler().packOut(packOut, document, null, fieldGroup.get_ID());
            }
            catch (Exception e) {
                if (!this.log.isLoggable(Level.INFO)) break block4;
                this.log.info(e.toString());
            }
        }
        document.endElement("", "", "AD_FieldGroup");
    }

    private void createAdElementBinding(PIPOContext ctx, TransformerHandler document, X_AD_FieldGroup fieldGroup) {
        PoExporter filler = new PoExporter(ctx, document, (PO)fieldGroup);
        List excludes = this.defaultExcludeList("AD_FieldGroup");
        if (fieldGroup.getAD_FieldGroup_ID() <= 999999) {
            filler.add("AD_FieldGroup_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_FieldGroup_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_FieldGroup_ID");
    }
}

