/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Modification;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModificationElementHandler
extends AbstractElementHandler {
    private List<Integer> modifications = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String action = null;
        String entitytype = this.getStringValue(element, "EntityType");
        String name = this.getStringValue(element, "Name");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        X_AD_Modification modification = (X_AD_Modification)this.findPO(ctx, element);
        if (modification == null) {
            int id = this.findIdByColumn(ctx, "AD_Modification", "Name", name, true);
            modification = new X_AD_Modification(ctx.ctx, id, this.getTrxName(ctx));
        }
        List excludes = this.defaultExcludeList("AD_Modification");
        if (modification.getAD_Modification_ID() == 0 && this.isOfficialId(element, "AD_Modification_ID")) {
            modification.setAD_Modification_ID(this.getIntValue(element, "AD_Modification_ID"));
        }
        if (this.modifications.contains(modification.getAD_Modification_ID())) {
            element.skip = true;
            return;
        }
        PoFiller pf = new PoFiller(ctx, (PO)modification, element, (AbstractElementHandler)this);
        List notfounds = pf.autoFill(excludes);
        if (notfounds.size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!modification.is_new()) {
            if (!modification.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Modification", 883);
        if (!modification.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Modification", (PO)modification);
            action = "Update";
        } else {
            action = "New";
        }
        if (modification.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, modification.getName(), modification.get_ID(), action);
            element.recordId = modification.getAD_Modification_ID();
            this.modifications.add(modification.getAD_Modification_ID());
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, modification.getName(), modification.get_ID(), action);
        throw new POSaveFailedException("Failed to save Model Validator " + modification.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int ad_modification_id = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Modification_ID");
        if (this.modifications.contains(ad_modification_id)) {
            return;
        }
        this.modifications.add(ad_modification_id);
        X_AD_Modification modification = new X_AD_Modification(ctx.ctx, ad_modification_id, null);
        if (ctx.packOut.getFromDate() != null && modification.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "table");
        document.startElement("", "", "AD_Modification", atts);
        this.createADModificationBinding(ctx, document, modification);
        document.endElement("", "", "AD_Modification");
    }

    private void createADModificationBinding(PIPOContext ctx, TransformerHandler document, X_AD_Modification modification) {
        PoExporter filler = new PoExporter(ctx, document, (PO)modification);
        if (modification.getAD_Modification_ID() <= 999999) {
            filler.add("AD_Modification_ID", new AttributesImpl());
        }
        List excludes = this.defaultExcludeList("AD_Modification");
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Modification_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Modification_ID");
    }
}

