/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.ReferenceUtils;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_PrintFormatItem;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PrintFormatItemElementHandler
extends AbstractElementHandler {
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        List excludes = this.defaultExcludeList("AD_PrintFormatItem");
        if (this.isParentDefer(element, "AD_PrintFormatItem")) {
            element.defer = true;
            return;
        }
        X_AD_PrintFormatItem mPrintFormatItem = (X_AD_PrintFormatItem)this.findPO(ctx, element);
        if (mPrintFormatItem == null) {
            int parentId = 0;
            if (this.getParentId(element, "AD_PrintFormatItem") > 0) {
                parentId = this.getParentId(element, "AD_PrintFormatItem");
            } else {
                Element pfElement = (Element)element.properties.get("AD_PrintFormat_ID");
                parentId = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)pfElement, (String)this.getTrxName(ctx));
            }
            if (parentId <= 0) {
                element.defer = true;
                element.unresolved = "AD_PrintFormat_ID";
                return;
            }
            String name = this.getStringValue(element, "Name");
            int id = this.findIdByNameAndParentId(ctx, "AD_PrintFormatItem", name, "AD_PrintFormat", parentId);
            mPrintFormatItem = new X_AD_PrintFormatItem(ctx.ctx, id > 0 ? id : 0, this.getTrxName(ctx));
            mPrintFormatItem.setAD_PrintFormat_ID(parentId);
            excludes.add("AD_PrintFormat_ID");
        }
        PoFiller filler = new PoFiller(ctx, (PO)mPrintFormatItem, element, (AbstractElementHandler)this);
        if (mPrintFormatItem.getAD_PrintFormatItem_ID() == 0 && this.isOfficialId(element, "AD_PrintFormatItem_ID")) {
            filler.setInteger("AD_PrintFormatItem_ID");
        }
        excludes.add("AD_Table_ID");
        excludes.add("AD_Column_ID");
        int columnId = 0;
        Element columnElement = (Element)element.properties.get("AD_Column_ID");
        if (ReferenceUtils.isIDLookup((Element)columnElement) || ReferenceUtils.isUUIDLookup((Element)columnElement)) {
            columnId = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)columnElement, (String)this.getTrxName(ctx));
        } else {
            Element tableElement = (Element)element.properties.get("AD_Table_ID");
            int tableId = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)tableElement, (String)this.getTrxName(ctx));
            String columnName = this.getStringValue(element, "AD_Column_ID");
            columnId = this.findIdByColumnAndParentId(ctx, "AD_Column", "ColumnName", columnName, "AD_Table", tableId);
        }
        if (columnId > 0) {
            mPrintFormatItem.setAD_Column_ID(columnId);
        }
        excludes.add("AD_PrintFormatChild_ID");
        Element pfchildElement = (Element)element.properties.get("AD_PrintFormatChild_ID");
        int AD_PrintFormatChild_ID = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)pfchildElement, (String)this.getTrxName(ctx));
        if (AD_PrintFormatChild_ID > 0) {
            mPrintFormatItem.setAD_PrintFormatChild_ID(AD_PrintFormatChild_ID);
        } else if (pfchildElement.contents != null && pfchildElement.contents.length() > 0) {
            element.defer = true;
            element.unresolved = "AD_PrintFormat: " + pfchildElement.contents;
            return;
        }
        List notfounds = filler.autoFill(excludes);
        if (notfounds.size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (mPrintFormatItem.is_new() || mPrintFormatItem.is_Changed()) {
            X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_PrintFormatItem", 489);
            String action = null;
            if (!mPrintFormatItem.is_new()) {
                this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_PrintFormatItem", (PO)mPrintFormatItem);
                action = "Update";
            } else {
                action = "New";
            }
            if (mPrintFormatItem.save(this.getTrxName(ctx))) {
                this.logImportDetail(ctx, impDetail, 1, mPrintFormatItem.getName(), mPrintFormatItem.get_ID(), action);
            } else {
                this.logImportDetail(ctx, impDetail, 0, mPrintFormatItem.getName(), mPrintFormatItem.get_ID(), action);
                throw new POSaveFailedException("Failed to save PrintFormatItem " + mPrintFormatItem.getName());
            }
        }
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_PrintFormatItem_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_PrintFormatItem_ID");
        X_AD_PrintFormatItem m_PrintFormatItem = new X_AD_PrintFormatItem(ctx.ctx, AD_PrintFormatItem_ID, null);
        if (ctx.packOut.getFromDate() != null && m_PrintFormatItem.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "table");
        document.startElement("", "", "AD_PrintFormatItem", atts);
        this.createPrintFormatItemBinding(ctx, document, m_PrintFormatItem);
        document.endElement("", "", "AD_PrintFormatItem");
    }

    private void createPrintFormatItemBinding(PIPOContext ctx, TransformerHandler document, X_AD_PrintFormatItem mPrintformatItem) {
        PoExporter filler = new PoExporter(ctx, document, (PO)mPrintformatItem);
        List excludes = this.defaultExcludeList("AD_PrintFormatItem");
        if (mPrintformatItem.getAD_PrintFormatItem_ID() <= 999999) {
            filler.add("AD_PrintFormatItem_ID", new AttributesImpl());
        }
        if (mPrintformatItem.getAD_Client_ID() == 0 && mPrintformatItem.getAD_Column_ID() > 0) {
            String sql = "SELECT AD_Table_ID FROM AD_Column WHERE AD_Column_ID=?";
            int tableID = DB.getSQLValue(null, (String)sql, (int)mPrintformatItem.getAD_Column_ID());
            AttributesImpl referenceAtts = new AttributesImpl();
            filler.addTableReference("AD_Table_ID", "AD_Table", "TableName", tableID, referenceAtts);
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_PrintFormatItem_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_PrintFormatItem_ID");
    }
}

