/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MStore;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Ini;

public class EMailTest
extends SvrProcess {
    protected int p_AD_Client_ID = 0;

    protected void prepare() {
        this.p_AD_Client_ID = this.getRecord_ID();
        if (this.p_AD_Client_ID == 0) {
            this.p_AD_Client_ID = Env.getAD_Client_ID((Properties)this.getCtx());
        }
    }

    protected String doIt() throws Exception {
        MClient client = MClient.get((Properties)this.getCtx(), (int)this.p_AD_Client_ID);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(client.toString());
        }
        String clientTest = client.testEMail();
        StringBuilder msglog = new StringBuilder().append(client.getName()).append(": ").append(clientTest);
        this.addLog(0, null, null, msglog.toString());
        if (!Ini.isClient()) {
            File file;
            String documentDir = client.getDocumentDir();
            if (documentDir == null || documentDir.length() == 0) {
                documentDir = ".";
            }
            if ((file = new File(documentDir)).exists() && file.isDirectory()) {
                this.addLog(0, null, null, "Found Directory: " + client.getDocumentDir());
            } else {
                this.addLog(0, null, null, "Not Found Directory: " + client.getDocumentDir());
            }
        }
        MStore[] wstores = MStore.getOfClient((MClient)client);
        int i = 0;
        while (i < wstores.length) {
            MStore store = wstores[i];
            String test = store.testEMail();
            msglog = new StringBuilder().append(store.getName()).append(": ").append(test);
            this.addLog(0, null, null, msglog.toString());
            ++i;
        }
        return clientTest;
    }
}

