/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutConfirm;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class InOutCreateConfirm
extends SvrProcess {
    private int p_M_InOut_ID = 0;
    private String p_ConfirmType = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("ConfirmType")) {
                    this.p_ConfirmType = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_M_InOut_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MInOut shipment;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("M_InOut_ID=" + this.p_M_InOut_ID + ", Type=" + this.p_ConfirmType);
        }
        if ((shipment = new MInOut(this.getCtx(), this.p_M_InOut_ID, this.get_TrxName())).get_ID() == 0) {
            throw new IllegalArgumentException("Not found M_InOut_ID=" + this.p_M_InOut_ID);
        }
        MInOutConfirm confirm = MInOutConfirm.create((MInOut)shipment, (String)this.p_ConfirmType, (boolean)true);
        if (confirm == null) {
            throw new Exception("Cannot create Confirmation for " + shipment.getDocumentNo());
        }
        this.addLog(confirm.getM_InOutConfirm_ID(), null, null, confirm.getDocumentNo(), confirm.get_Table_ID(), confirm.getM_InOutConfirm_ID());
        return confirm.getDocumentNo();
    }
}

