/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Statement;
import org.compiere.model.MInfoColumn;
import org.compiere.model.MInfoWindow;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class InfoWindowValidate
extends SvrProcess {
    private int p_AD_InfoWindow_ID = 0;

    protected void prepare() {
        this.p_AD_InfoWindow_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MInfoColumn[] infoColumns;
        MInfoWindow infoWindow = new MInfoWindow(this.getCtx(), this.p_AD_InfoWindow_ID, null);
        infoWindow.setIsValid(false);
        infoWindow.saveEx();
        StringBuilder builder = new StringBuilder("SELECT ");
        if (infoWindow.isDistinct()) {
            builder.append("DISTINCT ");
        }
        if ((infoColumns = infoWindow.getInfoColumns()).length == 0) {
            throw new Exception("NoColumns");
        }
        int columnIndex = 0;
        while (columnIndex < infoColumns.length) {
            if (columnIndex > 0) {
                builder.append(", ");
            }
            builder.append(infoColumns[columnIndex].getSelectClause());
            ++columnIndex;
        }
        builder.append(" FROM ").append(infoWindow.getFromClause());
        if (infoWindow.getWhereClause() != null && infoWindow.getWhereClause().trim().length() > 0) {
            builder.append(" WHERE ").append(infoWindow.getWhereClause());
        }
        if (infoWindow.getOtherClause() != null && infoWindow.getOtherClause().trim().length() > 0) {
            builder.append(" ").append(infoWindow.getOtherClause());
        }
        if (infoWindow.getOrderByClause() != null && infoWindow.getOrderByClause().trim().length() > 0) {
            builder.append(" ORDER BY ").append(infoWindow.getOrderByClause());
        }
        while (builder.indexOf("@") >= 0) {
            int start = builder.indexOf("@");
            int end = builder.indexOf("@", start + 1);
            if (start < 0 || end <= start) break;
            builder.replace(start, end + 1, "0");
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)builder.toString(), (String)this.get_TrxName());
            pstmt.executeQuery();
        }
        catch (Throwable throwable) {
            DB.close(pstmt);
            throw throwable;
        }
        DB.close((Statement)pstmt);
        infoWindow.setIsValid(true);
        infoWindow.saveEx();
        return "Ok";
    }
}

