/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.MRequestUpdate;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class RequestInvoice
extends SvrProcess {
    private int p_R_RequestType_ID = 0;
    private int p_R_Group_ID = 0;
    private int p_R_Category_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_M_Product_ID = 0;
    private MInvoice m_invoice = null;
    private int m_linecount = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("R_RequestType_ID")) {
                    this.p_R_RequestType_ID = para[i].getParameterAsInt();
                } else if (name.equals("R_Group_ID")) {
                    this.p_R_Group_ID = para[i].getParameterAsInt();
                } else if (name.equals("R_Category_ID")) {
                    this.p_R_Category_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_ID")) {
                    this.p_M_Product_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        block17: {
            MRequestType type;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("R_RequestType_ID=" + this.p_R_RequestType_ID + ", R_Group_ID=" + this.p_R_Group_ID + ", R_Category_ID=" + this.p_R_Category_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", p_M_Product_ID=" + this.p_M_Product_ID);
            }
            if ((type = MRequestType.get((Properties)this.getCtx(), (int)this.p_R_RequestType_ID)).get_ID() == 0) {
                throw new AdempiereSystemError("@R_RequestType_ID@ @NotFound@ " + this.p_R_RequestType_ID);
            }
            if (!type.isInvoiced()) {
                throw new AdempiereSystemError("@R_RequestType_ID@ <> @IsInvoiced@");
            }
            StringBuilder sql = new StringBuilder("SELECT * FROM R_Request r").append(" INNER JOIN R_Status s ON (r.R_Status_ID=s.R_Status_ID) ").append("WHERE s.IsClosed='Y'").append(" AND r.R_RequestType_ID=?");
            if (this.p_R_Group_ID != 0) {
                sql.append(" AND r.R_Group_ID=?");
            }
            if (this.p_R_Category_ID != 0) {
                sql.append(" AND r.R_Category_ID=?");
            }
            if (this.p_C_BPartner_ID != 0) {
                sql.append(" AND r.C_BPartner_ID=?");
            }
            sql.append(" AND r.IsInvoiced='Y' ").append("ORDER BY C_BPartner_ID");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    int index = 1;
                    pstmt.setInt(index++, this.p_R_RequestType_ID);
                    if (this.p_R_Group_ID != 0) {
                        pstmt.setInt(index++, this.p_R_Group_ID);
                    }
                    if (this.p_R_Category_ID != 0) {
                        pstmt.setInt(index++, this.p_R_Category_ID);
                    }
                    if (this.p_C_BPartner_ID != 0) {
                        pstmt.setInt(index++, this.p_C_BPartner_ID);
                    }
                    rs = pstmt.executeQuery();
                    int oldC_BPartner_ID = 0;
                    while (rs.next()) {
                        MRequest request = new MRequest(this.getCtx(), rs, this.get_TrxName());
                        if (!request.isInvoiced()) continue;
                        if (oldC_BPartner_ID != request.getC_BPartner_ID()) {
                            this.invoiceDone();
                        }
                        if (this.m_invoice == null) {
                            this.invoiceNew(request);
                            oldC_BPartner_ID = request.getC_BPartner_ID();
                        }
                        this.invoiceLine(request);
                    }
                    this.invoiceDone();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return null;
    }

    private void invoiceDone() {
        if (this.m_invoice != null) {
            if (this.m_linecount == 0) {
                this.m_invoice.delete(false);
            } else {
                if (!this.m_invoice.processIt("PR")) {
                    this.log.warning("Invoice Process Failed: " + this.m_invoice + " - " + this.m_invoice.getProcessMsg());
                    throw new IllegalStateException("Invoice Process Failed: " + this.m_invoice + " - " + this.m_invoice.getProcessMsg());
                }
                this.m_invoice.saveEx();
                String message = Msg.parseTranslation((Properties)this.getCtx(), (String)("@InvoiceProcessed@ " + this.m_invoice.getDocumentNo()));
                this.addLog(0, null, this.m_invoice.getGrandTotal(), message, this.m_invoice.get_Table_ID(), this.m_invoice.getC_Invoice_ID());
            }
        }
        this.m_invoice = null;
    }

    private void invoiceNew(MRequest request) {
        this.m_invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        this.m_invoice.setIsSOTrx(true);
        MBPartner partner = new MBPartner(this.getCtx(), request.getC_BPartner_ID(), null);
        this.m_invoice.setBPartner(partner);
        this.m_invoice.saveEx();
        this.m_linecount = 0;
    }

    private void invoiceLine(MRequest request) {
        MRequestUpdate[] updates = request.getUpdates(null);
        int i = 0;
        while (i < updates.length) {
            BigDecimal qty = updates[i].getQtyInvoiced();
            if (qty != null && qty.signum() != 0) {
                MInvoiceLine il = new MInvoiceLine(this.m_invoice);
                ++this.m_linecount;
                il.setLine(this.m_linecount * 10);
                il.setQty(qty);
                int M_Product_ID = updates[i].getM_ProductSpent_ID();
                if (M_Product_ID == 0) {
                    M_Product_ID = this.p_M_Product_ID;
                }
                il.setM_Product_ID(M_Product_ID);
                il.setPrice();
                il.saveEx();
            }
            ++i;
        }
    }
}

