/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.utils.LogWriter;

public class LabColorSpace
extends GenericColorSpace {
    private int r;
    private int g;
    private int b;
    private float lastL = -1.0f;
    private float lastA = 65536.0f;
    private float lastBstar;
    private Hashtable cache = new Hashtable();
    private final float C1 = 0.12841855f;
    private final float C2 = 0.13793103f;
    private final float C3 = 0.20689656f;
    private final float C4 = 0.39215687f;
    private final float C5 = 128.0f;

    public LabColorSpace(String string, String string2, String string3) {
        this.value = 6;
        this.setCIEValues(string, string2, string3, null, null);
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < n; i += 3) {
            float f = (float)(byArray[i] & 0xFF) * 0.39215687f;
            float f2 = (float)(byArray[i + 1] & 0xFF) - 128.0f;
            float f3 = (float)(byArray[i + 2] & 0xFF) - 128.0f;
            this.convertToRGB(f, f2, f3);
            byArray[i] = (byte)this.r;
            byArray[i + 1] = (byte)this.g;
            byArray[i + 2] = (byte)this.b;
        }
        return byArray;
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, String string) {
        BufferedImage bufferedImage = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
            Raster raster = jPEGImageDecoder.decodeAsRaster();
            int n3 = raster.getWidth();
            int n4 = raster.getHeight();
            int n5 = n3 * n4;
            DataBuffer dataBuffer = raster.getDataBuffer();
            for (int i = 0; i < n5 * 3; i += 3) {
                float f = dataBuffer.getElemFloat(i) * 0.39215687f;
                float f2 = dataBuffer.getElemFloat(i + 1) - 128.0f;
                float f3 = dataBuffer.getElemFloat(i + 2) - 128.0f;
                this.convertToRGB(f, f2, f3);
                dataBuffer.setElem(i, this.r);
                dataBuffer.setElem(i + 1, this.g);
                dataBuffer.setElem(i + 2, this.b);
            }
            int[] nArray = new int[]{0, 1, 2};
            bufferedImage = new BufferedImage(n3, n4, 1);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBuffer, n3, n4, n3 * 3, 3, nArray, null);
            bufferedImage.setData(writableRaster);
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
        }
        return bufferedImage;
    }

    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        int n3 = n * n2;
        try {
            for (int i = 0; i < n3 * 3; i += 3) {
                float f = dataBufferByte.getElemFloat(i) * 0.39215687f;
                float f2 = dataBufferByte.getElemFloat(i + 1) - 128.0f;
                float f3 = dataBufferByte.getElemFloat(i + 2) - 128.0f;
                this.convertToRGB(f, f2, f3);
                ((DataBuffer)dataBufferByte).setElem(i, this.r);
                ((DataBuffer)dataBufferByte).setElem(i + 1, this.g);
                ((DataBuffer)dataBufferByte).setElem(i + 2, this.b);
            }
            int[] nArray = new int[]{0, 1, 2};
            bufferedImage = new BufferedImage(n, n2, 1);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
            bufferedImage.setData(writableRaster);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
        }
        return bufferedImage;
    }

    private void convertToRGB(float f, float f2, float f3) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 100.0f) {
            f = 100.0f;
        }
        if (f2 < this.R[0]) {
            f2 = this.R[0];
        } else if (f2 > this.R[1]) {
            f2 = this.R[1];
        }
        if (f3 < this.R[2]) {
            f3 = this.R[2];
        } else if (f3 > this.R[3]) {
            f3 = this.R[3];
        }
        if (this.lastL != f || this.lastA != f2 || this.lastBstar != f3) {
            int n = (int)f;
            int n2 = (int)(f2 - this.R[0]);
            int n3 = (int)(f3 - this.R[2]);
            Integer n4 = new Integer((n << 16) + (n2 << 8) + n3);
            Object v = this.cache.get(n4);
            if (v != null) {
                int n5 = (Integer)v;
                this.r = n5 >> 16 & 0xFF;
                this.g = n5 >> 8 & 0xFF;
                this.b = n5 & 0xFF;
            } else {
                int n6;
                double d = ((double)f + 16.0) / 116.0;
                double[] dArray = new double[]{d + (double)f2 / 500.0, d, d - (double)f3 / 200.0};
                float[] fArray = new float[3];
                for (n6 = 0; n6 < 3; ++n6) {
                    fArray[n6] = dArray[n6] >= 0.2068965584039688 ? (float)((double)this.W[n6] * dArray[n6] * dArray[n6] * dArray[n6]) : (float)((double)(this.W[n6] * 0.12841855f) * (dArray[n6] - 0.13793103396892548));
                }
                fArray = this.cs.toRGB(fArray);
                this.r = (int)(fArray[0] * 255.0f);
                this.g = (int)(fArray[1] * 255.0f);
                this.b = (int)(fArray[2] * 255.0f);
                if (this.r < 0) {
                    this.r = 0;
                }
                if (this.g < 0) {
                    this.g = 0;
                }
                if (this.b < 0) {
                    this.b = 0;
                }
                if (this.r > 255) {
                    this.r = 255;
                }
                if (this.g > 255) {
                    this.g = 255;
                }
                if (this.b > 255) {
                    this.b = 255;
                }
                n6 = (this.r << 16) + (this.g << 8) + this.b;
                this.cache.put(n4, new Integer(n6));
            }
            this.lastL = f;
            this.lastA = f2;
            this.lastBstar = f3;
        }
    }

    public final void setColor(String[] stringArray, int n) {
        float f = Float.parseFloat(stringArray[2]);
        float f2 = Float.parseFloat(stringArray[1]);
        float f3 = Float.parseFloat(stringArray[0]);
        this.convertToRGB(f, f2, f3);
        this.currentColor = new PdfColor(this.r, this.g, this.b);
    }
}

