/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.oasis.BorderStyle;
import net.sf.jasperreports.engine.export.oasis.ParagraphStyle;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class CellStyle
extends BorderStyle {
    private String backcolor;
    private final String horizontalAlignment;
    private final String verticalAlignment;

    public CellStyle(WriterHelper styleWriter, JRExporterGridCell gridCell) {
        super(styleWriter);
        JRAlignment alignment;
        JRPrintElement element = gridCell.getElement();
        if (element != null && element.getModeValue() == ModeEnum.OPAQUE) {
            this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
        } else if (gridCell.getBackcolor() != null) {
            this.backcolor = JRColorUtil.getColorHexa(gridCell.getBackcolor());
        }
        RotationEnum rotation = element instanceof JRPrintText ? ((JRPrintText)element).getRotationValue() : RotationEnum.NONE;
        VerticalAlignEnum vAlign = VerticalAlignEnum.TOP;
        HorizontalAlignEnum hAlign = HorizontalAlignEnum.LEFT;
        JRAlignment jRAlignment = alignment = element instanceof JRAlignment ? (JRAlignment)((Object)element) : null;
        if (alignment != null) {
            vAlign = alignment.getVerticalAlignmentValue();
            hAlign = alignment.getHorizontalAlignmentValue();
        }
        this.horizontalAlignment = ParagraphStyle.getHorizontalAlignment(hAlign, vAlign, rotation);
        this.verticalAlignment = ParagraphStyle.getVerticalAlignment(hAlign, vAlign, rotation);
        this.setBox(gridCell.getBox());
    }

    @Override
    public String getId() {
        return this.backcolor + super.getId() + "|" + this.horizontalAlignment + "|" + this.verticalAlignment;
    }

    @Override
    public void write(String cellStyleName) {
        this.styleWriter.write("<style:style style:name=\"");
        this.styleWriter.write(cellStyleName);
        this.styleWriter.write("\"");
        this.styleWriter.write(" style:family=\"table-cell\">\n");
        this.styleWriter.write(" <style:table-cell-properties");
        this.styleWriter.write(" fo:wrap-option=\"wrap\"");
        this.styleWriter.write(" style:shrink-to-fit=\"false\"");
        if (this.backcolor != null) {
            this.styleWriter.write(" fo:background-color=\"#");
            this.styleWriter.write(this.backcolor);
            this.styleWriter.write("\"");
        }
        this.writeBorder(0);
        this.writeBorder(1);
        this.writeBorder(2);
        this.writeBorder(3);
        if (this.verticalAlignment != null) {
            this.styleWriter.write(" style:vertical-align=\"");
            this.styleWriter.write(this.verticalAlignment);
            this.styleWriter.write("\"");
        }
        this.styleWriter.write("/>\n");
        if (this.horizontalAlignment != null) {
            this.styleWriter.write(" <style:paragraph-properties");
            this.styleWriter.write(" fo:text-align=\"");
            this.styleWriter.write(this.horizontalAlignment);
            this.styleWriter.write("\"");
            this.styleWriter.write("/>\n");
        }
        this.styleWriter.write("</style:style>\n");
    }
}

