/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.util.BitArrayBin;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.LRUCache;

public class ActiveMQMessageAudit {
    public static final int DEFAULT_WINDOW_SIZE = 2048;
    public static final int MAXIMUM_PRODUCER_COUNT = 64;
    private int auditDepth;
    private int maximumNumberOfProducersToTrack;
    private LRUCache<Object, BitArrayBin> map;

    public ActiveMQMessageAudit() {
        this(2048, 64);
    }

    public ActiveMQMessageAudit(int auditDepth, int maximumNumberOfProducersToTrack) {
        this.auditDepth = auditDepth;
        this.maximumNumberOfProducersToTrack = maximumNumberOfProducersToTrack;
        this.map = new LRUCache(0, maximumNumberOfProducersToTrack, 0.75f, true);
    }

    public int getAuditDepth() {
        return this.auditDepth;
    }

    public void setAuditDepth(int auditDepth) {
        this.auditDepth = auditDepth;
    }

    public int getMaximumNumberOfProducersToTrack() {
        return this.maximumNumberOfProducersToTrack;
    }

    public void setMaximumNumberOfProducersToTrack(int maximumNumberOfProducersToTrack) {
        this.maximumNumberOfProducersToTrack = maximumNumberOfProducersToTrack;
        this.map.setMaxCacheSize(maximumNumberOfProducersToTrack);
    }

    public boolean isDuplicate(Message message) throws JMSException {
        return this.isDuplicate(message.getJMSMessageID());
    }

    public synchronized boolean isDuplicate(String id) {
        boolean answer = false;
        String seed = IdGenerator.getSeedFromId(id);
        if (seed != null) {
            long index;
            BitArrayBin bab = (BitArrayBin)this.map.get(seed);
            if (bab == null) {
                bab = new BitArrayBin(this.auditDepth);
                this.map.put(seed, bab);
            }
            if ((index = IdGenerator.getSequenceFromId(id)) >= 0L) {
                answer = bab.setBit(index, true);
            }
        }
        return answer;
    }

    public boolean isDuplicate(MessageReference message) {
        MessageId id = message.getMessageId();
        return this.isDuplicate(id);
    }

    public synchronized boolean isDuplicate(MessageId id) {
        ProducerId pid;
        boolean answer = false;
        if (id != null && (pid = id.getProducerId()) != null) {
            BitArrayBin bab = (BitArrayBin)this.map.get(pid);
            if (bab == null) {
                bab = new BitArrayBin(this.auditDepth);
                this.map.put(pid, bab);
            }
            answer = bab.setBit(id.getProducerSequenceId(), true);
        }
        return answer;
    }

    public void rollback(MessageReference message) {
        MessageId id = message.getMessageId();
        this.rollback(id);
    }

    public synchronized void rollback(MessageId id) {
        BitArrayBin bab;
        ProducerId pid;
        if (id != null && (pid = id.getProducerId()) != null && (bab = (BitArrayBin)this.map.get(pid)) != null) {
            bab.setBit(id.getProducerSequenceId(), false);
        }
    }

    public boolean isInOrder(Message msg) throws JMSException {
        return this.isInOrder(msg.getJMSMessageID());
    }

    public synchronized boolean isInOrder(String id) {
        BitArrayBin bab;
        String seed;
        boolean answer = true;
        if (id != null && (seed = IdGenerator.getSeedFromId(id)) != null && (bab = (BitArrayBin)this.map.get(seed)) != null) {
            long index = IdGenerator.getSequenceFromId(id);
            answer = bab.isInOrder(index);
        }
        return answer;
    }

    public synchronized boolean isInOrder(MessageReference message) {
        return this.isInOrder(message.getMessageId());
    }

    public synchronized boolean isInOrder(MessageId id) {
        ProducerId pid;
        boolean answer = false;
        if (id != null && (pid = id.getProducerId()) != null) {
            BitArrayBin bab = (BitArrayBin)this.map.get(pid);
            if (bab == null) {
                bab = new BitArrayBin(this.auditDepth);
                this.map.put(pid, bab);
            }
            answer = bab.isInOrder(id.getProducerSequenceId());
        }
        return answer;
    }
}

