/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import org.adempiere.apps.graph.Graph;
import org.adempiere.apps.graph.GraphColumn;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.model.MAchievement;
import org.compiere.model.MDashboardContent;
import org.compiere.model.MDashboardPreference;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MProjectType;
import org.compiere.model.MQuery;
import org.compiere.model.MRequestType;
import org.compiere.model.MRole;
import org.compiere.swing.CMenuItem;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class HtmlDashboard
extends JPanel
implements MouseListener,
ActionListener,
HyperlinkListener {
    private static final long serialVersionUID = 8125801717324723271L;
    private static Dimension paneldimensionMin = new Dimension(80, 80);
    private JEditorPane html;
    private static CLogger log = CLogger.getCLogger(HtmlDashboard.class);
    MGoal[] m_goals = null;
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mRefresh = new CMenuItem(Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh"), Env.getImageIcon((String)"Refresh16.gif"));
    URL lastUrl = null;
    ArrayList<MQuery> queryZoom = null;

    public HtmlDashboard(String url, MGoal[] m_goals, boolean scrolling) {
        this.setName("test title");
        this.setLayout(new BorderLayout());
        this.m_goals = m_goals;
        JEditorPane.registerEditorKitForContentType("text/html", "org.adempiere.apps.graph.FCHtmlEditorKit");
        this.html = new JEditorPane();
        this.html.setContentType("text/html");
        this.html.setEditable(false);
        this.htmlUpdate(url);
        JScrollPane scrollPane = null;
        scrollPane = scrolling ? new JScrollPane() : new JScrollPane(21, 31);
        scrollPane.getViewport().add((Component)this.html, "Center");
        this.add((Component)scrollPane, "Center");
        this.setMinimumSize(paneldimensionMin);
        this.addMouseListener(this);
        this.html.addHyperlinkListener(this);
        this.mRefresh.addActionListener(this);
        this.popupMenu.add(this.mRefresh);
        this.html.addMouseListener(this);
        this.html.setBackground(this.getBackground());
    }

    public HtmlDashboard(String url) {
        new HtmlDashboard(url, null, true);
    }

    private String createHTML(PAGE_TYPE requestPage) {
        StringBuilder result;
        block27: {
            result = new StringBuilder("<html><head>");
            URL url = this.getClass().getClassLoader().getResource("org/compiere/css/PAPanel.css");
            BufferedReader bufferedReader = null;
            try {
                try {
                    String cssLine;
                    InputStreamReader ins = new InputStreamReader(url.openStream());
                    bufferedReader = new BufferedReader(ins);
                    result.append("<style type=\"text/css\">");
                    while ((cssLine = bufferedReader.readLine()) != null) {
                        result.append(cssLine).append("\n");
                    }
                    result.append("</style>");
                }
                catch (IOException e1) {
                    log.log(Level.SEVERE, e1.getLocalizedMessage(), (Throwable)e1);
                    if (bufferedReader == null) break block27;
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bufferedReader = null;
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bufferedReader = null;
                }
                throw throwable;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bufferedReader = null;
            }
        }
        switch (requestPage) {
            case PAGE_LOGO: {
                result.append("</head><body class=\"header\">").append("<table width=\"100%\"><tr><td>").append("<img src=\"res:org/compiere/images/logo_ad.png\">").append("</td><td></td><td width=\"290\">").append("</td></tr></table>").append("</body></html>");
                break;
            }
            case PAGE_HOME: {
                result.append("</head><body><div class=\"content\">\n");
                this.queryZoom = null;
                this.queryZoom = new ArrayList();
                String appendToHome = null;
                try {
                    int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
                    int AD_Role_ID = Env.getAD_Role_ID((Properties)Env.getCtx());
                    MDashboardPreference[] dps = MDashboardPreference.getForSession((int)AD_User_ID, (int)AD_Role_ID);
                    if (dps.length == 0) {
                        this.createDashboardPreference();
                    }
                    MDashboardPreference[] mDashboardPreferenceArray = dps = MDashboardPreference.getForSession((boolean)true, (int)AD_User_ID, (int)AD_Role_ID);
                    int n = dps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MDashboardPreference dp = mDashboardPreferenceArray[n2];
                        MDashboardContent dc = new MDashboardContent(dp.getCtx(), dp.getPA_DashboardContent_ID(), dp.get_TrxName());
                        if (Util.isEmpty((String)dc.getZulFilePath(), (boolean)true)) {
                            appendToHome = dc.getHTML();
                            String descriptionTrl = dp.get_Translation("Description");
                            if (appendToHome != null) {
                                if (descriptionTrl != null) {
                                    result.append("<H2>").append(descriptionTrl).append("</H2>\n");
                                }
                                result.append(this.stripHtml(appendToHome, false)).append("<br>\n");
                            }
                            if (dc.getAD_Menu_ID() > 0) {
                                result.append("<a class=\"hrefNode\" href=\"http:///window/node#");
                                result.append(String.valueOf(dc.getAD_Window_ID()));
                                result.append("\">");
                                result.append(descriptionTrl.toString());
                                result.append("</a><br>\n");
                            }
                            result.append("<br>\n");
                            if (dc.getPA_Goal_ID() > 0) {
                                result.append(this.goalsDetail(dc.getPA_Goal_ID()));
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                }
                result.append("<br><br><br>\n").append("</div>\n</body>\n</html>\n");
                break;
            }
            default: {
                log.warning("Unknown option - " + (Object)((Object)requestPage));
            }
        }
        return result.toString();
    }

    private void createDashboardPreference() {
        MDashboardContent[] dcs;
        if (Env.getAD_User_ID((Properties)Env.getCtx()) == 0 && Env.getAD_Role_ID((Properties)Env.getCtx()) == 0) {
            return;
        }
        MDashboardContent[] mDashboardContentArray = dcs = MDashboardContent.getForSession((int)0, (int)0);
        int n = dcs.length;
        int n2 = 0;
        while (n2 < n) {
            MDashboardContent dc = mDashboardContentArray[n2];
            MDashboardPreference preference = new MDashboardPreference(Env.getCtx(), 0, null);
            preference.setAD_Org_ID(Env.getAD_Org_ID((Properties)Env.getCtx()));
            preference.setAD_Role_ID(Env.getAD_Role_ID((Properties)Env.getCtx()));
            preference.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
            preference.setColumnNo(dc.getColumnNo());
            preference.setIsCollapsedByDefault(dc.isCollapsedByDefault());
            preference.setIsShowInDashboard(dc.isShowInDashboard());
            preference.setLine(dc.getLine());
            preference.setPA_DashboardContent_ID(dc.getPA_DashboardContent_ID());
            if (!preference.save()) {
                StringBuilder msglog = new StringBuilder("Failed to create dashboard preference ").append(preference.toString());
                log.log(Level.SEVERE, msglog.toString());
            }
            ++n2;
        }
    }

    private String goalsDetail(int AD_Table_ID) {
        StringBuilder output = new StringBuilder();
        if (this.m_goals == null) {
            return output.toString();
        }
        int i = 0;
        while (i < this.m_goals.length) {
            MMeasureCalc mc = MMeasureCalc.get((Properties)Env.getCtx(), (int)this.m_goals[i].getMeasure().getPA_MeasureCalc_ID());
            if (AD_Table_ID == this.m_goals[i].getPA_Goal_ID()) {
                output.append("<table class=\"dataGrid\"><tr>\n<th colspan=\"3\" class=\"label\"><b>").append(this.m_goals[i].getName()).append("</b></th></tr>\n");
                output.append("<tr><td class=\"label\">Target</td><td colspan=\"2\" class=\"tdcontent\">").append(this.m_goals[i].getMeasureTarget()).append("</td></tr>\n");
                output.append("<tr><td class=\"label\">Actual</td><td colspan=\"2\" class=\"tdcontent\">").append(this.m_goals[i].getMeasureActual()).append("</td></tr>\n");
                Graph barPanel = new Graph(this.m_goals[i]);
                GraphColumn[] bList = barPanel.getGraphColumnList();
                MQuery query = null;
                output.append("<tr><td rowspan=\"").append(bList.length).append("\" class=\"label\" valign=\"top\">").append(this.m_goals[i].getXAxisText()).append("</td>\n");
                int k = 0;
                while (k < bList.length) {
                    GraphColumn bgc = bList[k];
                    if (k > 0) {
                        output.append("<tr>");
                    }
                    if (bgc.getAchievement() != null) {
                        MAchievement a = bgc.getAchievement();
                        query = MQuery.getEqualQuery((String)"PA_Measure_ID", (int)a.getPA_Measure_ID());
                    } else if (bgc.getGoal() != null) {
                        MGoal goal = bgc.getGoal();
                        query = MQuery.getEqualQuery((String)"PA_Measure_ID", (int)goal.getPA_Measure_ID());
                    } else if (bgc.getMeasureCalc() != null) {
                        mc = bgc.getMeasureCalc();
                        query = mc.getQuery(this.m_goals[i].getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), MRole.getDefault());
                    } else if (bgc.getProjectType() != null) {
                        MProjectType pt = bgc.getProjectType();
                        query = pt.getQuery(this.m_goals[i].getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), bgc.getID(), MRole.getDefault());
                    } else if (bgc.getRequestType() != null) {
                        MRequestType rt = bgc.getRequestType();
                        query = rt.getQuery(this.m_goals[i].getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), bgc.getID(), MRole.getDefault());
                    }
                    output.append("<td class=\"tdcontent\">").append(bgc.getLabel()).append("</td><td  class=\"tdcontent\">");
                    if (query != null) {
                        output.append("<a class=\"hrefZoom\" href=\"http:///window/zoom#").append(this.queryZoom.size()).append("\">").append(bgc.getValue()).append("</a><br>\n");
                        this.queryZoom.add(query);
                    } else {
                        if (log.isLoggable(Level.INFO)) {
                            log.info("Nothing to zoom to - " + bgc);
                        }
                        output.append(bgc.getValue());
                    }
                    output.append("</td></tr>");
                    ++k;
                }
                output.append("</tr>").append("<tr><td colspan=\"3\">").append(this.m_goals[i].getDescription()).append("<br>").append(this.stripHtml(this.m_goals[i].getColorSchema().getDescription(), true)).append("</td></tr>").append("</table>\n");
                bList = null;
                barPanel = null;
            }
            ++i;
        }
        return output.toString();
    }

    private String stripHtml(String htmlString, boolean all) {
        htmlString = htmlString.replace("<html>", "").replace("</html>", "").replace("<body>", "").replace("</body>", "").replace("<head>", "").replace("</head>", "");
        if (all) {
            htmlString = htmlString.replace(">", "&gt;").replace("<", "&lt;");
        }
        return htmlString;
    }

    private void htmlUpdate(String url) {
        try {
            this.htmlUpdate(new URL(url));
        }
        catch (MalformedURLException e) {
            log.warning("Malformed URL: " + e);
        }
    }

    private void htmlUpdate(URL url) {
        if (url == null || url.getPath().equals("/local/home")) {
            this.html.setText(this.createHTML(PAGE_TYPE.PAGE_HOME));
            this.html.setCaretPosition(0);
            this.lastUrl = url;
        } else if (url.getPath().equals("/local/logo")) {
            this.html.setText(this.createHTML(PAGE_TYPE.PAGE_LOGO));
            this.html.setCaretPosition(0);
            this.lastUrl = url;
        } else if (url.getPath().equals("/local/performance")) {
            this.html.setText(this.createHTML(PAGE_TYPE.PAGE_PERFORMANCE));
        } else if (url.getPath().equals("/window/node")) {
            int AD_Window_ID = Integer.parseInt(url.getRef());
            AWindow frame = new AWindow(this.getGraphicsConfiguration());
            if (!frame.initWindow(AD_Window_ID, null)) {
                return;
            }
            AEnv.addToWindowManager(frame);
            if (Ini.isPropertyBool((String)"OpenWindowMaximized")) {
                AEnv.showMaximized(frame);
            } else {
                AEnv.showCenterScreen(frame);
            }
            frame = null;
            this.html.setCursor(Cursor.getPredefinedCursor(0));
        } else if (url.getPath().equals("/window/zoom")) {
            int index = Integer.parseInt(String.valueOf(url.getRef()));
            if (index >= 0 && index < this.queryZoom.size()) {
                this.html.setCursor(Cursor.getPredefinedCursor(3));
                AEnv.zoom(this.queryZoom.get(index));
                this.html.setCursor(Cursor.getPredefinedCursor(0));
            }
        } else if (url != null) {
            Cursor cursor = this.html.getCursor();
            this.html.setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(new PageLoader(this.html, url, cursor));
            this.lastUrl = url;
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.htmlUpdate(event.getURL());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mRefresh) {
            if (this.m_goals != null) {
                int i = 0;
                while (i < this.m_goals.length) {
                    this.m_goals[i].updateGoal(true);
                    ++i;
                }
            }
            this.htmlUpdate(this.lastUrl);
            Container parent = this.getParent();
            if (parent != null) {
                parent.invalidate();
            }
            this.invalidate();
            if (parent != null) {
                parent.repaint();
            } else {
                this.repaint();
            }
        }
    }

    private static enum PAGE_TYPE {
        PAGE_HOME,
        PAGE_PERFORMANCE,
        PAGE_LOGO;

    }

    static class PageLoader
    implements Runnable {
        private JEditorPane html;
        private URL url;
        private Cursor cursor;

        PageLoader(JEditorPane html, URL url, Cursor cursor) {
            this.html = html;
            this.url = url;
            this.cursor = cursor;
        }

        @Override
        public void run() {
            if (this.url == null) {
                this.html.setCursor(this.cursor);
                Container parent = this.html.getParent();
                parent.repaint();
            } else {
                Document doc = this.html.getDocument();
                try {
                    try {
                        this.html.setPage(this.url);
                    }
                    catch (IOException ioe) {
                        this.html.setDocument(doc);
                        this.url = null;
                        SwingUtilities.invokeLater(this);
                    }
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

