/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JScrollPane;
import org.adempiere.apps.graph.Graph;
import org.adempiere.apps.graph.HtmlDashboard;
import org.adempiere.apps.graph.PerformanceDetail;
import org.adempiere.apps.graph.PerformanceIndicator;
import org.compiere.model.MGoal;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class PAPanel
extends CPanel
implements ActionListener {
    private static final long serialVersionUID = 4937417260772233929L;
    private MGoal[] m_goals = null;
    private static CLogger log = CLogger.getCLogger(PAPanel.class);

    public static PAPanel get() {
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        MGoal[] goals = MGoal.getUserGoals((Properties)Env.getCtx(), (int)AD_User_ID);
        if (goals.length == 0) {
            return null;
        }
        return new PAPanel(goals);
    }

    private PAPanel(MGoal[] goals) {
        this.m_goals = goals;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        Box boxV = Box.createVerticalBox();
        Box boxH = Box.createHorizontalBox();
        Box boxV1 = Box.createVerticalBox();
        Box boxV2 = Box.createVerticalBox();
        Box boxH1 = Box.createHorizontalBox();
        boxV2.setPreferredSize(new Dimension(120, 120));
        int i = 0;
        while (i < this.m_goals.length) {
            PerformanceIndicator pi = new PerformanceIndicator(this.m_goals[i]);
            pi.addActionListener(this);
            boxV1.add((Component)pi, "North");
            ++i;
        }
        boxV1.add(Box.createVerticalGlue(), "Center");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getViewport().add((Component)boxV1, "Center");
        scrollPane.setMinimumSize(new Dimension(190, 180));
        HtmlDashboard contentHtml = new HtmlDashboard("http:///local/home", this.m_goals, true);
        boxV2.add((Component)contentHtml, "Center");
        int i2 = 0;
        while (i2 < Math.min(2, this.m_goals.length)) {
            if (this.m_goals[i2].getMeasure() != null) {
                boxH1.add((Component)new Graph(this.m_goals[i2]), "South");
            }
            ++i2;
        }
        boxV2.add((Component)boxH1, "South");
        boxH.add((Component)scrollPane, "West");
        boxH.add(Box.createHorizontalStrut(5));
        boxH.add((Component)boxV2, "Center");
        HtmlDashboard t = new HtmlDashboard("http:///local/logo", null, false);
        t.setMaximumSize(new Dimension(2000, 80));
        boxV.add((Component)t, "North");
        boxV.add(Box.createVerticalStrut(5));
        boxV.add((Component)boxH, "Center");
        boxV.add(Box.createVerticalGlue());
        this.add((Component)boxV, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof PerformanceIndicator) {
            MGoal goal;
            PerformanceIndicator pi = (PerformanceIndicator)e.getSource();
            if (log.isLoggable(Level.INFO)) {
                log.info(pi.getName());
            }
            if ((goal = pi.getGoal()).getMeasure() != null) {
                new PerformanceDetail(goal);
            }
        }
    }
}

