/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.compiere.Adempiere;
import org.compiere.acct.AcctViewer;
import org.compiere.apps.ADialog;
import org.compiere.apps.AMenu;
import org.compiere.apps.AMenuStartItem;
import org.compiere.apps.AWindow;
import org.compiere.apps.AboutBox;
import org.compiere.apps.BeanShellEditor;
import org.compiere.apps.Preference;
import org.compiere.apps.PrintScreenPainter;
import org.compiere.apps.ScreenShot;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.InfoSchedule;
import org.compiere.db.CConnection;
import org.compiere.grid.ed.Calculator;
import org.compiere.grid.ed.Calendar;
import org.compiere.grid.ed.Editor;
import org.compiere.interfaces.Server;
import org.compiere.model.MMenu;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.process.DocumentEngine;
import org.compiere.swing.CButton;
import org.compiere.swing.CFrame;
import org.compiere.swing.CMenuItem;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Splash;

public final class AEnv {
    private static ArrayList<Container> s_windows = new ArrayList(20);
    private static ArrayList<CFrame> s_hiddenWindows = new ArrayList();
    private static boolean s_closingWindows = false;
    private static Boolean s_workflow = null;
    private static int s_workflow_Window_ID = 0;
    private static int s_serverTries = 0;
    private static Server s_server = null;
    private static CLogger log = CLogger.getCLogger(AEnv.class);

    public static boolean hideWindow(CFrame window) {
        if (!Ini.isCacheWindow() || s_closingWindows) {
            return false;
        }
        int i = 0;
        while (i < s_hiddenWindows.size()) {
            CFrame hidden = s_hiddenWindows.get(i);
            if (log.isLoggable(Level.INFO)) {
                log.info(String.valueOf(i) + ": " + hidden);
            }
            if (hidden.getAD_Window_ID() == window.getAD_Window_ID()) {
                return false;
            }
            ++i;
        }
        if (window.getAD_Window_ID() != 0 && s_hiddenWindows.add(window)) {
            window.setVisible(false);
            if (log.isLoggable(Level.INFO)) {
                log.info(window.toString());
            }
            if (s_hiddenWindows.size() > 10) {
                CFrame toClose = s_hiddenWindows.remove(0);
                try {
                    s_closingWindows = true;
                    toClose.dispose();
                }
                finally {
                    s_closingWindows = false;
                }
            }
            return true;
        }
        return false;
    }

    public static CFrame showWindow(int AD_Window_ID) {
        int i = 0;
        while (i < s_hiddenWindows.size()) {
            CFrame hidden = s_hiddenWindows.get(i);
            if (hidden.getAD_Window_ID() == AD_Window_ID) {
                s_hiddenWindows.remove(i);
                if (log.isLoggable(Level.INFO)) {
                    log.info(hidden.toString());
                }
                hidden.setVisible(true);
                int state = hidden.getExtendedState();
                if ((state & 1) > 0) {
                    hidden.setExtendedState(state & 0xFFFFFFFE);
                }
                hidden.toFront();
                return hidden;
            }
            ++i;
        }
        return null;
    }

    static void closeWindows() {
        s_closingWindows = true;
        int i = 0;
        while (i < s_hiddenWindows.size()) {
            CFrame hidden = s_hiddenWindows.get(i);
            hidden.dispose();
            ++i;
        }
        s_hiddenWindows.clear();
        s_closingWindows = false;
    }

    public static void showWindow(Window window) {
        Frame f;
        int state;
        window.setVisible(true);
        if (window instanceof Frame && ((state = (f = (Frame)window).getExtendedState()) & 1) > 0) {
            f.setExtendedState(state & 0xFFFFFFFE);
        }
        window.toFront();
    }

    public static void showCenterScreen(Window window) {
        AEnv.positionCenterScreen(window);
        AEnv.showWindow(window);
    }

    public static void showMaximized(Frame frame) {
        frame.pack();
        frame.setExtendedState(6);
        frame.setVisible(true);
        frame.toFront();
    }

    public static void positionCenterScreen(Window window) {
        AEnv.positionScreen(window, 0);
    }

    public static void showScreen(Window window, int position) {
        AEnv.positionScreen(window, position);
        AEnv.showWindow(window);
    }

    public static void positionScreen(Window window, int position) {
        window.pack();
        GraphicsConfiguration config = window.getGraphicsConfiguration();
        Rectangle bounds = config.getBounds();
        Dimension sSize = bounds.getSize();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config);
        sSize.width -= insets.left + insets.right;
        sSize.height -= insets.top + insets.bottom;
        Dimension wSize = window.getSize();
        if (wSize.height > sSize.height) {
            wSize.height = sSize.height;
        }
        if (wSize.width > sSize.width) {
            wSize.width = sSize.width;
        }
        window.setSize(wSize);
        int x = (sSize.width - wSize.width) / 2;
        int y = (sSize.height - wSize.height) / 2;
        if (position != 0) {
            if (position == 8) {
                x = 0;
                y = 0;
            } else if (position == 1) {
                y = 0;
            } else if (position == 2) {
                x = sSize.width - wSize.width;
                y = 0;
            } else if (position == 7) {
                x = 0;
            } else if (position == 3) {
                x = sSize.width - wSize.width;
            } else if (position == 5) {
                y = sSize.height - wSize.height;
            } else if (position == 6) {
                x = 0;
                y = sSize.height - wSize.height;
            } else if (position == 4) {
                x = sSize.width - wSize.width;
                y = sSize.height - wSize.height;
            }
        }
        window.setLocation(bounds.x + x + insets.left, bounds.y + y + insets.top);
    }

    public static void showCenterWindow(Window parent, Window window) {
        AEnv.positionCenterWindow(parent, window);
        AEnv.showWindow(window);
    }

    public static void positionCenterWindow(Window parent, Window window) {
        int y;
        if (parent == null) {
            AEnv.positionCenterScreen(window);
            return;
        }
        window.pack();
        Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
        GraphicsConfiguration config = window.getGraphicsConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config);
        sSize.width -= insets.left + insets.right;
        sSize.height -= insets.top + insets.bottom;
        Dimension wSize = window.getSize();
        if (wSize.height > sSize.height) {
            wSize.height = sSize.height;
        }
        if (wSize.width > sSize.width) {
            wSize.width = sSize.width;
        }
        window.setSize(wSize);
        Rectangle pBounds = parent.getBounds();
        if (pBounds.x == pBounds.y && pBounds.x == 0) {
            AEnv.positionCenterScreen(window);
            return;
        }
        int x = pBounds.x + (pBounds.width - wSize.width) / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = pBounds.y + (pBounds.height - wSize.height) / 2) < 0) {
            y = 0;
        }
        if (x + wSize.width > sSize.width) {
            x = sSize.width - wSize.width;
        }
        if (y + wSize.height > sSize.height) {
            y = sSize.height - wSize.height;
        }
        window.setLocation(x + insets.left, y + insets.top);
    }

    public static CButton getButton(String iconName) {
        CButton button = new CButton(Env.getImageIcon((String)(String.valueOf(iconName) + "16.gif")));
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)iconName));
        button.setDefaultCapable(false);
        return button;
    }

    public static JMenu getMenu(String AD_Message) {
        char ch;
        JMenu menu = new JMenu();
        String text = Msg.getMsg((Properties)Env.getCtx(), (String)AD_Message);
        int pos = text.indexOf(38);
        if (pos != -1 && text.length() > pos && (ch = text.toUpperCase().charAt(pos + 1)) != ' ') {
            text = String.valueOf(text.substring(0, pos)) + text.substring(pos + 1);
            menu.setMnemonic(ch);
        }
        menu.setText(text);
        return menu;
    }

    public static JMenuItem addMenuItem(String actionName, String iconName, KeyStroke ks, JMenu menu, ActionListener al) {
        if (iconName == null) {
            iconName = actionName;
        }
        String text = Msg.getMsg((Properties)Env.getCtx(), (String)actionName);
        ImageIcon icon = Env.getImageIcon2((String)(String.valueOf(iconName) + "16"));
        CMenuItem mi = new CMenuItem(text, icon);
        mi.setActionCommand(actionName);
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        if (menu != null) {
            menu.add(mi);
        }
        if (al != null) {
            mi.addActionListener(al);
        }
        return mi;
    }

    public static boolean actionPerformed(String actionCommand, int WindowNo, Container c) {
        MRole role = MRole.getDefault();
        if (actionCommand.equals("PrintScreen")) {
            PrintScreenPainter.printScreen(AEnv.getFrame(c));
        } else if (actionCommand.equals("ScreenShot")) {
            ScreenShot.createJPEG(AEnv.getFrame(c), null);
        } else if (actionCommand.equals("Exit")) {
            if (ADialog.ask(WindowNo, c, "ExitApplication?")) {
                AMenu aMenu = (AMenu)AEnv.getWindow(0);
                aMenu.dispose();
            }
        } else if (actionCommand.equals("Logout")) {
            AMenu aMenu = (AMenu)AEnv.getWindow(0);
            aMenu.logout();
        } else if (actionCommand.equals("InfoProduct") && AEnv.canAccessInfo("PRODUCT")) {
            Info.showProduct(AEnv.getFrame(c), WindowNo);
        } else if (actionCommand.equals("InfoBPartner") && AEnv.canAccessInfo("BPARTNER")) {
            Info.showBPartner(AEnv.getFrame(c), WindowNo);
        } else if (actionCommand.equals("InfoAsset") && AEnv.canAccessInfo("ASSET")) {
            Info.showAsset(AEnv.getFrame(c), WindowNo);
        } else if (actionCommand.equals("InfoAccount") && MRole.getDefault().isShowAcct() && AEnv.canAccessInfo("ACCOUNT")) {
            new AcctViewer();
        } else if (actionCommand.equals("InfoSchedule") && AEnv.canAccessInfo("SCHEDULE")) {
            new InfoSchedule((Frame)AEnv.getFrame(c), null, false);
        } else if (actionCommand.equals("InfoMRP") && AEnv.canAccessInfo("MRP")) {
            CFrame frame = (CFrame)AEnv.getFrame(c);
            int m_menu_id = MMenu.getMenu_ID((String)"MRP Info");
            AMenu menu = AEnv.getAMenu(frame);
            AMenuStartItem form = new AMenuStartItem(m_menu_id, true, Msg.translate((Properties)Env.getCtx(), (String)"MRP Info"), menu);
            form.start();
        } else if (actionCommand.equals("InfoCRP") && AEnv.canAccessInfo("CRP")) {
            CFrame frame = (CFrame)AEnv.getFrame(c);
            int m_menu_id = MMenu.getMenu_ID((String)"CRP Info");
            AMenu menu = AEnv.getAMenu(frame);
            AMenuStartItem form = new AMenuStartItem(m_menu_id, true, Msg.translate((Properties)Env.getCtx(), (String)"CRP Info"), menu);
            form.start();
        } else if (actionCommand.equals("InfoOrder") && AEnv.canAccessInfo("ORDER")) {
            Info.showOrder(AEnv.getFrame(c), WindowNo, "");
        } else if (actionCommand.equals("InfoInvoice") && AEnv.canAccessInfo("INVOICE")) {
            Info.showInvoice(AEnv.getFrame(c), WindowNo, "");
        } else if (actionCommand.equals("InfoInOut") && AEnv.canAccessInfo("INOUT")) {
            Info.showInOut(AEnv.getFrame(c), WindowNo, "");
        } else if (actionCommand.equals("InfoPayment") && AEnv.canAccessInfo("PAYMENT")) {
            Info.showPayment(AEnv.getFrame(c), WindowNo, "");
        } else if (actionCommand.equals("InfoCashLine") && AEnv.canAccessInfo("CASHJOURNAL")) {
            Info.showCashLine(AEnv.getFrame(c), WindowNo, "");
        } else if (actionCommand.equals("InfoAssignment") && AEnv.canAccessInfo("RESOURCE")) {
            Info.showAssignment(AEnv.getFrame(c), WindowNo, "");
        } else if (actionCommand.equals("WorkFlow")) {
            AEnv.startWorkflowProcess(0, 0);
        } else if (actionCommand.equals("Home")) {
            AEnv.showWindow(AEnv.getWindow(0));
        } else if (actionCommand.equals("Calculator")) {
            Calculator calc = new Calculator(AEnv.getFrame(c));
            calc.setDisposeOnEqual(false);
            AEnv.showCenterScreen(calc);
        } else if (actionCommand.equals("Calendar")) {
            AEnv.showCenterScreen(new Calendar(AEnv.getFrame(c)));
        } else if (actionCommand.equals("Editor")) {
            AEnv.showCenterScreen(new Editor(AEnv.getFrame(c)));
        } else if (actionCommand.equals("Script")) {
            new BeanShellEditor(AEnv.getFrame(c));
        } else if (actionCommand.equals("Preference")) {
            if (role.isShowPreference()) {
                AEnv.showCenterScreen(new Preference((Frame)AEnv.getFrame(c), WindowNo));
            }
        } else if (actionCommand.equals("Online")) {
            Env.startBrowser((String)Adempiere.getOnlineHelpURL());
        } else if (actionCommand.equals("EMailSupport")) {
            ADialog.createSupportEMail(AEnv.getFrame(c), AEnv.getFrame(c).getTitle(), "\n\n");
        } else if (actionCommand.equals("About")) {
            AEnv.showCenterScreen(new AboutBox(AEnv.getFrame(c)));
        } else {
            return false;
        }
        return true;
    }

    public static void setTextMnemonic(JButton b, String text) {
        if (text == null || b == null) {
            return;
        }
        int pos = text.indexOf(38);
        if (pos != -1) {
            char ch = text.charAt(pos + 1);
            b.setMnemonic(ch);
            b.setText(String.valueOf(text.substring(0, pos)) + text.substring(pos + 1));
        }
        b.setText(text);
    }

    public static char getMnemonic(String text) {
        int pos = text.indexOf(38);
        if (pos != -1) {
            return text.charAt(pos + 1);
        }
        return '\u0000';
    }

    public static void zoom(int AD_Table_ID, int Record_ID) {
        AWindow frame;
        String whereClause;
        int PO_Window_ID;
        int AD_Window_ID;
        String TableName;
        block12: {
            TableName = null;
            AD_Window_ID = 0;
            PO_Window_ID = 0;
            String sql = "SELECT TableName, AD_Window_ID, PO_Window_ID FROM AD_Table WHERE AD_Table_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, AD_Table_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        TableName = rs.getString(1);
                        AD_Window_ID = rs.getInt(2);
                        PO_Window_ID = rs.getInt(3);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (TableName == null || AD_Window_ID == 0) {
            return;
        }
        boolean isSOTrx = true;
        if (PO_Window_ID != 0 && !(isSOTrx = DB.isSOTrx((String)TableName, (String)(whereClause = String.valueOf(TableName) + "_ID=" + Record_ID)))) {
            AD_Window_ID = PO_Window_ID;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(TableName) + " - Record_ID=" + Record_ID + " (IsSOTrx=" + isSOTrx + ")");
        }
        if (!(frame = new AWindow(null)).initWindow(AD_Window_ID, MQuery.getEqualQuery((String)(String.valueOf(TableName) + "_ID"), (int)Record_ID))) {
            return;
        }
        AEnv.addToWindowManager(frame);
        if (Ini.isPropertyBool((String)"OpenWindowMaximized")) {
            AEnv.showMaximized(frame);
        } else {
            AEnv.showCenterScreen(frame);
        }
        frame = null;
    }

    public static void zoom(MQuery query) {
        AWindow frame;
        int PO_Window_ID;
        int AD_Window_ID;
        String TableName;
        block13: {
            if (query == null || query.getTableName() == null || query.getTableName().length() == 0) {
                return;
            }
            TableName = query.getTableName();
            AD_Window_ID = 0;
            PO_Window_ID = 0;
            String sql = "SELECT AD_Window_ID, PO_Window_ID FROM AD_Table WHERE TableName=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setString(1, TableName);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        AD_Window_ID = rs.getInt(1);
                        PO_Window_ID = rs.getInt(2);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (AD_Window_ID == 0) {
            return;
        }
        boolean isSOTrx = true;
        if (PO_Window_ID != 0 && !(isSOTrx = DB.isSOTrx((String)TableName, (String)query.getWhereClause(false)))) {
            AD_Window_ID = PO_Window_ID;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(query + " (IsSOTrx=" + isSOTrx + ")");
        }
        if (!(frame = new AWindow(null)).initWindow(AD_Window_ID, query)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        if (Ini.isPropertyBool((String)"OpenWindowMaximized")) {
            AEnv.showMaximized(frame);
        } else {
            AEnv.showCenterScreen(frame);
        }
        frame = null;
    }

    public static void addToWindowManager(CFrame frame) {
        JFrame top = AEnv.getWindow(0);
        if (top instanceof AMenu) {
            ((AMenu)top).getWindowManager().add(frame);
        }
    }

    public static AMenu getAMenu(CFrame frame) {
        JFrame top = AEnv.getWindow(0);
        if (top instanceof AMenu) {
            return (AMenu)top;
        }
        return null;
    }

    public static void exit(int status) {
        Env.exitEnv((int)status);
    }

    public static void logout() {
        Env.logout();
        Splash.getSplash().setVisible(true);
        new AMenu();
    }

    public static boolean isWorkflowProcess() {
        if (s_workflow == null) {
            s_workflow = Boolean.FALSE;
            int AD_Table_ID = 645;
            if (MRole.getDefault().isTableAccess(AD_Table_ID, true)) {
                s_workflow = Boolean.TRUE;
            } else {
                AD_Table_ID = 644;
                if (MRole.getDefault().isTableAccess(AD_Table_ID, true)) {
                    s_workflow = Boolean.TRUE;
                } else if (log.isLoggable(Level.CONFIG)) {
                    log.config(s_workflow.toString());
                }
            }
            if (s_workflow.booleanValue()) {
                s_workflow_Window_ID = DB.getSQLValue(null, (String)"SELECT AD_Window_ID FROM AD_Table WHERE AD_Table_ID=?", (int)AD_Table_ID);
                if (s_workflow_Window_ID == 0) {
                    s_workflow_Window_ID = 297;
                }
                if (log.isLoggable(Level.CONFIG)) {
                    log.config(s_workflow + ", Window=" + s_workflow_Window_ID);
                }
            }
        }
        return s_workflow;
    }

    public static void startWorkflowProcess(int AD_Table_ID, int Record_ID) {
        AWindow frame;
        if (s_workflow_Window_ID == 0) {
            return;
        }
        MQuery query = null;
        if (AD_Table_ID != 0 && Record_ID != 0) {
            query = new MQuery("AD_WF_Process");
            query.addRestriction("AD_Table_ID", "=", AD_Table_ID);
            query.addRestriction("Record_ID", "=", Record_ID);
        }
        if (!(frame = new AWindow(null)).initWindow(s_workflow_Window_ID, query)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        if (Ini.isPropertyBool((String)"OpenWindowMaximized")) {
            frame.pack();
            frame.setExtendedState(6);
            frame.setVisible(true);
            frame.toFront();
        } else {
            AEnv.showCenterScreen(frame);
        }
        frame = null;
    }

    public static boolean isServerActive() {
        boolean contactAgain = s_server == null && s_serverTries == 0;
        boolean ok = CConnection.get().isAppsServerOK(contactAgain);
        if (ok) {
            s_serverTries = 0;
            return true;
        }
        if (s_serverTries > 1) {
            return false;
        }
        CLogMgt.enable((boolean)false);
        try {
            ++s_serverTries;
            if (log.isLoggable(Level.CONFIG)) {
                log.config("try #" + s_serverTries);
            }
            if (ok = CConnection.get().isAppsServerOK(true)) {
                s_serverTries = 0;
            }
        }
        catch (Exception ex) {
            ok = false;
            s_server = null;
        }
        CLogMgt.enable((boolean)true);
        return ok;
    }

    public static String getServerVersion() {
        return CConnection.get().getServerVersion();
    }

    public static String postImmediate(int WindowNo, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Window=" + WindowNo + ", AD_Table_ID=" + AD_Table_ID + "/" + Record_ID + ", Force=" + force);
        }
        String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)AD_Client_ID, (int)AD_Table_ID, (int)Record_ID, (boolean)force, null);
        return error;
    }

    public static void cacheReset(String tableName, int Record_ID) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("TableName=" + tableName + ", Record_ID=" + Record_ID);
        }
        if (AEnv.isServerActive()) {
            log.config("trying server");
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    server.cacheReset(Env.getRemoteCallCtx((Properties)Env.getCtx()), tableName, Record_ID);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "ex", (Throwable)e);
                s_server = null;
            }
        }
    }

    public static void updateUI() {
        Set<Window> updated = AEnv.updateUI0();
        JFrame top = AEnv.getWindow(0);
        if (top instanceof AMenu) {
            CFrame[] frames;
            CFrame[] cFrameArray = frames = ((AMenu)top).getWindowManager().getWindows();
            int n = frames.length;
            int n2 = 0;
            while (n2 < n) {
                CFrame f = cFrameArray[n2];
                if (!updated.contains(f)) {
                    Component[] childs;
                    SwingUtilities.updateComponentTreeUI(f);
                    f.validate();
                    RepaintManager mgr = RepaintManager.currentManager(f);
                    Component[] componentArray = childs = f.getComponents();
                    int n3 = childs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Component c = componentArray[n4];
                        if (c instanceof JComponent) {
                            mgr.markCompletelyDirty((JComponent)c);
                        }
                        ++n4;
                    }
                    f.repaint();
                    updated.add(f);
                }
                ++n2;
            }
        }
    }

    public static boolean canAccessInfo(String infoWindowName) {
        boolean result;
        block5: {
            ResultSet rs;
            CPreparedStatement prolestmt;
            block4: {
                result = false;
                int roleid = Env.getAD_Role_ID((Properties)Env.getCtx());
                String sqlRolePermission = "Select COUNT(AD_ROLE_ID) AS ROWCOUNT FROM AD_ROLE WHERE AD_ROLE_ID=" + roleid + " AND ALLOW_INFO_" + infoWindowName + "='Y'";
                log.config(sqlRolePermission);
                prolestmt = null;
                rs = null;
                try {
                    prolestmt = DB.prepareStatement((String)sqlRolePermission, null);
                    rs = prolestmt.executeQuery();
                    rs.next();
                    if (rs.getInt("ROWCOUNT") <= 0) break block4;
                    result = true;
                }
                catch (Exception e) {
                    try {
                        System.out.println(e);
                        log.log(Level.SEVERE, "(1)", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)prolestmt);
                        rs = null;
                        prolestmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)prolestmt);
                    rs = null;
                    prolestmt = null;
                    break block5;
                }
            }
            DB.close((ResultSet)rs, (Statement)prolestmt);
            rs = null;
            prolestmt = null;
            return false;
            DB.close((ResultSet)rs, (Statement)prolestmt);
            rs = null;
            prolestmt = null;
        }
        return result;
    }

    public static Set<Window> updateUI0() {
        int n;
        HashSet<Window> updated = new HashSet<Window>();
        for (Container container : s_windows) {
            Component[] childs;
            JFrame w = AEnv.getFrame(container);
            if (w == null || updated.contains(w)) continue;
            SwingUtilities.updateComponentTreeUI(w);
            w.validate();
            RepaintManager mgr = RepaintManager.currentManager(w);
            Component[] componentArray = childs = w.getComponents();
            int n2 = childs.length;
            n = 0;
            while (n < n2) {
                Component child = componentArray[n];
                if (child instanceof JComponent) {
                    mgr.markCompletelyDirty((JComponent)child);
                }
                ++n;
            }
            w.repaint();
            updated.add(w);
        }
        for (Window window : s_hiddenWindows) {
            Component[] childs;
            if (updated.contains(window)) continue;
            SwingUtilities.updateComponentTreeUI(window);
            window.validate();
            RepaintManager mgr = RepaintManager.currentManager(window);
            Component[] componentArray = childs = window.getComponents();
            n = childs.length;
            int n3 = 0;
            while (n3 < n) {
                Component child = componentArray[n3];
                if (child instanceof JComponent) {
                    mgr.markCompletelyDirty((JComponent)child);
                }
                ++n3;
            }
            window.repaint();
            updated.add(window);
        }
        return updated;
    }

    public static int createWindowNo(Container win) {
        int retValue = s_windows.size();
        s_windows.add(win);
        return retValue;
    }

    public static int getWindowNo(Container container) {
        if (container == null) {
            return 0;
        }
        JFrame winFrame = AEnv.getFrame(container);
        if (winFrame == null) {
            return 0;
        }
        int i = 0;
        while (i < s_windows.size()) {
            JFrame cmpFrame;
            Container cmp = s_windows.get(i);
            if (cmp != null && winFrame.equals(cmpFrame = AEnv.getFrame(cmp))) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static JFrame getWindow(int WindowNo) {
        JFrame retValue = null;
        try {
            retValue = AEnv.getFrame(s_windows.get(WindowNo));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.toString());
        }
        return retValue;
    }

    public static void removeWindow(int WindowNo) {
        if (WindowNo < s_windows.size()) {
            s_windows.set(WindowNo, null);
        }
    }

    public static JFrame getFrame(Container container) {
        Container element = container;
        while (element != null) {
            if (element instanceof JFrame) {
                return (JFrame)element;
            }
            element = element.getParent();
        }
        return null;
    }

    public static void reset(boolean finalCall) {
        AEnv.closeWindows();
        if (s_windows.size() > 0) {
            if (!finalCall) {
                Container c = s_windows.get(0);
                s_windows.clear();
                AEnv.createWindowNo(c);
            } else {
                s_windows.clear();
            }
        }
    }
}

