/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Arrays;
import org.compiere.apps.ALayoutCollection;
import org.compiere.apps.ALayoutConstraint;

public class ALayout
implements LayoutManager2 {
    private ALayoutCollection m_data = new ALayoutCollection();
    private int m_spaceH;
    private int m_spaceV;
    private boolean m_colFill;

    public ALayout() {
        this(2, 4, true);
    }

    public ALayout(int spaceH, int spaceV, boolean colFill) {
        this.setSpaceH(spaceH);
        this.setSpaceV(spaceV);
        this.m_colFill = colFill;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    @Override
    public void addLayoutComponent(Component component, Object constraint) {
        ALayoutConstraint con = null;
        if (constraint instanceof ALayoutConstraint) {
            con = (ALayoutConstraint)constraint;
        }
        this.m_data.put(con, component);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (!this.m_data.containsValue(comp)) {
            return;
        }
        for (Object key : this.m_data.keySet()) {
            if (!this.m_data.get(key).equals(comp)) continue;
            this.m_data.remove(key);
            return;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.calculateLayoutSize(parent, 'P');
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.calculateLayoutSize(parent, 'm');
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.calculateLayoutSize(parent, 'M');
    }

    private Dimension calculateLayoutSize(Container parent, char how) {
        this.checkComponents(parent);
        int rows = this.getRowCount();
        int cols = this.getColCount();
        Dimension[][] dim = new Dimension[rows][cols];
        Object[] keys = this.m_data.keySet().toArray();
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            ALayoutConstraint constraint = (ALayoutConstraint)keys[i];
            Component component = (Component)this.m_data.get(keys[i]);
            Dimension d = null;
            d = how == 'P' ? component.getPreferredSize() : (how == 'M' ? component.getMaximumSize() : component.getMinimumSize());
            dim[constraint.getRow()][constraint.getCol()] = component.isVisible() ? d : null;
            ++i;
        }
        Insets insets = parent.getInsets();
        Dimension retValue = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        retValue.height += this.m_spaceH;
        retValue.width += this.m_spaceV;
        int maxWidth = 0;
        int r = 0;
        while (r < rows) {
            int height = 0;
            int width = 0;
            int c = 0;
            while (c < cols) {
                Dimension d = dim[r][c];
                if (d != null) {
                    width += d.width;
                    height = Math.max(height, d.height);
                }
                width += this.m_spaceV;
                ++c;
            }
            retValue.height += height + this.m_spaceH;
            maxWidth += Math.max(maxWidth, width);
            ++r;
        }
        retValue.width += maxWidth;
        return retValue;
    }

    @Override
    public void layoutContainer(Container parent) {
        this.checkComponents(parent);
        int rows = this.getRowCount();
        int cols = this.getColCount();
        Component[][] com = new Component[rows][cols];
        Object[] keys = this.m_data.keySet().toArray();
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            ALayoutConstraint constraint = (ALayoutConstraint)keys[i];
            Component component = (Component)this.m_data.get(keys[i]);
            com[constraint.getRow()][constraint.getCol()] = component.isVisible() ? component : null;
            ++i;
        }
        int[] colWidth = new int[cols];
        int[] rowHeight = new int[rows];
        int columnWidth = this.m_spaceV;
        int c = 0;
        while (c < cols) {
            int width = 0;
            int r = 0;
            while (r < rows) {
                Component component = com[r][c];
                if (component != null) {
                    width = Math.max(width, component.getPreferredSize().width);
                    rowHeight[r] = Math.max(rowHeight[r], component.getPreferredSize().height);
                }
                ++r;
            }
            colWidth[c] = width;
            columnWidth += width + this.m_spaceV;
            ++c;
        }
        int parentWidth = parent.getSize().width;
        double multiplier = (double)parentWidth / (double)columnWidth;
        if (multiplier < 0.5) {
            multiplier = 0.5;
        }
        int c2 = 0;
        while (c2 < cols) {
            colWidth[c2] = (int)((double)colWidth[c2] * multiplier);
            ++c2;
        }
        int spaceV = (int)((double)this.m_spaceV * multiplier);
        Insets insets = parent.getInsets();
        int posH = insets.top + this.m_spaceH;
        int r = 0;
        while (r < rows) {
            int posV = insets.left + spaceV;
            int height = 0;
            int c3 = 0;
            while (c3 < cols) {
                Component component = com[r][c3];
                if (component != null) {
                    Dimension ps = component.getPreferredSize();
                    int w = ps.width;
                    if (this.m_colFill || w > colWidth[c3]) {
                        w = colWidth[c3];
                    }
                    int h = ps.height;
                    int topSpace = 0;
                    if (h < rowHeight[r]) {
                        topSpace = (rowHeight[r] - h) / 3;
                    }
                    height = Math.max(height, h);
                    component.setBounds(posV, posH + topSpace, w, h);
                }
                posV += colWidth[c3] + spaceV;
                ++c3;
            }
            posH += height + this.m_spaceH;
            ++r;
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    private void checkComponents(Container target) {
        int size = target.getComponentCount();
        int i = 0;
        while (i < size) {
            Component comp = target.getComponent(i);
            if (!this.m_data.containsValue(comp)) {
                this.m_data.put((Object)null, comp);
            }
            ++i;
        }
    }

    public int getRowCount() {
        return this.m_data.getMaxRow() + 1;
    }

    public int getColCount() {
        return this.m_data.getMaxCol() + 1;
    }

    public void setSpaceH(int spaceH) {
        this.m_spaceH = spaceH;
    }

    public int getSpaceH() {
        return this.m_spaceH;
    }

    public void setSpaceV(int spaceV) {
        this.m_spaceV = spaceV;
    }

    public int getSpaceV() {
        return this.m_spaceV;
    }
}

