/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.Lookup;
import org.compiere.model.MClient;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.PO;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextArea;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class EMailDialog
extends CDialog
implements ActionListener,
VetoableChangeListener {
    private static final long serialVersionUID = -6850428309037475213L;
    private MClient m_client = null;
    private MUser m_from = null;
    private MUser m_user = null;
    private MUser m_ccuser = null;
    private String m_to;
    private String m_cc;
    private String m_subject;
    private String m_message;
    private File m_attachFile;
    private static CLogger log = CLogger.getCLogger(EMailDialog.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel headerPanel = new CPanel();
    private GridBagLayout headerLayout = new GridBagLayout();
    private CTextField fFrom = new CTextField(20);
    private CTextField fTo = new CTextField(20);
    private CTextField fCc = new CTextField(20);
    private VLookup fUser = null;
    private VLookup fCcUser = null;
    private CTextField fSubject = new CTextField(40);
    private CLabel lFrom = new CLabel();
    private CLabel lTo = new CLabel();
    private CLabel lCc = new CLabel();
    private CLabel lSubject = new CLabel();
    private CLabel lAttachment = new CLabel();
    private CTextField fAttachment = new CTextField(40);
    private CTextArea fMessage = new CTextArea();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private StatusBar statusBar = new StatusBar();

    public EMailDialog(Dialog owner, String title, MUser from, String to, String subject, String message, File attachment) {
        super(owner, title, true);
        this.commonInit(from, to, subject, message, attachment);
    }

    public EMailDialog(Frame owner, String title, MUser from, String to, String subject, String message, File attachment) {
        super(owner, title, true);
        this.commonInit(from, to, subject, message, attachment);
    }

    private void commonInit(MUser from, String to, String subject, String message, File attachment) {
        this.m_client = MClient.get((Properties)Env.getCtx());
        try {
            int WindowNo = 0;
            int AD_Column_ID = 0;
            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)WindowNo, (int)AD_Column_ID, (int)30, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"AD_User_ID", (int)0, (boolean)false, (String)"EMail IS NOT NULL");
            this.fUser = new VLookup("AD_User_ID", false, false, true, (Lookup)lookup);
            this.fUser.addVetoableChangeListener(this);
            this.fCcUser = new VLookup("AD_User_ID", false, false, true, (Lookup)lookup);
            this.fCcUser.addVetoableChangeListener(this);
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "EMailDialog", (Throwable)ex);
        }
        this.set(from, to, subject, message);
        this.setAttachment(attachment);
        AEnv.showCenterScreen(this);
    }

    void jbInit() throws Exception {
        this.lFrom.setText(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"From")) + ":");
        this.lTo.setText(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"To")) + ":");
        this.lCc.setText(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Cc")) + ":");
        this.lSubject.setText(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Subject")) + ":");
        this.lAttachment.setText(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Attachment")) + ":");
        this.fFrom.setReadWrite(false);
        this.mainPanel.setLayout(this.mainLayout);
        this.headerPanel.setLayout(this.headerLayout);
        this.mainLayout.setHgap(5);
        this.mainLayout.setVgap(5);
        this.fMessage.setPreferredSize(new Dimension(150, 150));
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.headerPanel, "North");
        this.headerPanel.add((Component)this.lFrom, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 5), 0, 0));
        this.headerPanel.add((Component)this.fFrom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.headerPanel.add((Component)this.lTo, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 5), 0, 0));
        this.headerPanel.add((Component)this.fUser, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 10), 0, 0));
        this.headerPanel.add((Component)this.fTo, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 0, 0));
        this.headerPanel.add((Component)this.lCc, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 5), 0, 0));
        this.headerPanel.add((Component)this.fCcUser, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 10), 0, 0));
        this.headerPanel.add((Component)this.fCc, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 0, 0));
        this.headerPanel.add((Component)this.lSubject, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.headerPanel.add((Component)this.fSubject, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 1, 0));
        this.headerPanel.add((Component)this.lAttachment, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.headerPanel.add((Component)this.fAttachment, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 1, 0));
        this.mainPanel.add((Component)this.fMessage, "Center");
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.confirmPanel.addActionListener(this);
        this.statusBar.setStatusDB(null);
    }

    public void set(MUser from, String to, String subject, String message) {
        this.setFrom(from);
        this.setTo(to);
        this.setSubject(subject);
        this.setMessage(message);
        this.statusBar.setStatusLine(this.m_client.getSMTPHost());
    }

    public void setTo(String newTo) {
        this.m_to = newTo;
        this.fTo.setText(this.m_to);
    }

    public void setCc(String newCc) {
        this.m_cc = newCc;
        this.fCc.setText(this.m_cc);
    }

    public String getTo() {
        this.m_to = this.fTo.getText();
        return this.m_to;
    }

    public String getCc() {
        this.m_cc = this.fCc.getText();
        return this.m_cc;
    }

    public void setFrom(MUser newFrom) {
        this.m_from = newFrom;
        if (newFrom == null || !newFrom.isEMailValid() || !newFrom.isCanSendEMail()) {
            this.confirmPanel.getOKButton().setEnabled(false);
            this.fFrom.setText("**Invalid**");
        } else {
            this.fFrom.setText(this.m_from.getEMail());
        }
    }

    public MUser getFrom() {
        return this.m_from;
    }

    public void setSubject(String newSubject) {
        this.m_subject = newSubject;
        this.fSubject.setText(this.m_subject);
    }

    public String getSubject() {
        this.m_subject = this.fSubject.getText();
        return this.m_subject;
    }

    public void setMessage(String newMessage) {
        this.m_message = newMessage;
        this.fMessage.setText(this.m_message);
        this.fMessage.setCaretPosition(0);
    }

    public String getMessage() {
        this.m_message = this.fMessage.getText();
        return this.m_message;
    }

    public void setAttachment(File attachment) {
        this.m_attachFile = attachment;
        if (attachment == null) {
            this.lAttachment.setVisible(false);
            this.fAttachment.setVisible(false);
        } else {
            this.lAttachment.setVisible(true);
            this.fAttachment.setVisible(true);
            this.fAttachment.setText(attachment.getName());
            this.fAttachment.setReadWrite(false);
        }
    }

    public File getAttachment() {
        return this.m_attachFile;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
        if (this.getTo() == null || this.getTo().length() == 0) {
            return;
        }
        if (e.getActionCommand().equals("Ok")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.confirmPanel.getOKButton().setEnabled(false);
            StringTokenizer st = new StringTokenizer(this.getTo(), " ,;", false);
            String to = st.nextToken();
            EMail email = this.m_client.createEMail(this.getFrom(), to, this.getSubject(), this.getMessage());
            String status = "Check Setup";
            if (email != null) {
                while (st.hasMoreTokens()) {
                    email.addTo(st.nextToken());
                }
                StringTokenizer stcc = new StringTokenizer(this.getCc(), " ,;", false);
                while (stcc.hasMoreTokens()) {
                    String cc = stcc.nextToken();
                    if (cc == null || cc.length() <= 0) continue;
                    email.addCc(cc);
                }
                if (this.m_attachFile != null && this.m_attachFile.exists()) {
                    email.addAttachment(this.m_attachFile);
                }
                status = email.send();
                if (this.m_user != null) {
                    new MUserMail((PO)this.m_user, this.m_user.getAD_User_ID(), email).saveEx();
                }
                if (email.isSentOK()) {
                    ADialog.info(0, this, "MessageSent");
                    this.dispose();
                } else {
                    ADialog.error(0, this, "MessageNotSent", status);
                }
            } else {
                ADialog.error(0, this, "MessageNotSent", status);
            }
            this.confirmPanel.getOKButton().setEnabled(false);
            this.setCursor(Cursor.getDefaultCursor());
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        VLookup source = (VLookup)evt.getSource();
        Object value = evt.getNewValue();
        if (log.isLoggable(Level.INFO)) {
            log.info("Value=" + value);
        }
        if (source.equals(this.fUser)) {
            if (value == null) {
                this.fTo.setText("");
            }
            if (value instanceof Integer) {
                int AD_User_ID = (Integer)value;
                this.m_user = MUser.get((Properties)Env.getCtx(), (int)AD_User_ID);
                this.fTo.setValue(this.m_user.getEMail());
            }
        } else {
            if (value == null) {
                this.fCc.setText("");
            }
            if (value instanceof Integer) {
                int AD_User_ID = (Integer)value;
                this.m_ccuser = MUser.get((Properties)Env.getCtx(), (int)AD_User_ID);
                this.fCc.setValue(this.m_ccuser.getEMail());
            }
        }
    }
}

