/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.Lookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InfoAsset
extends Info {
    private static final long serialVersionUID = 6014685562933753813L;
    private static String s_assetFROM = "A_ASSET a LEFT OUTER JOIN M_Product p ON (a.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_BPartner bp ON (a.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN AD_User u ON (a.AD_User_ID=u.AD_User_ID)";
    private static final Info_Column[] s_assetLayout = new Info_Column[]{new Info_Column(" ", "a.A_Asset_ID", IDColumn.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"Value"), "a.Value", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"Name"), "a.Name", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"), "p.Name", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"), "bp.Name", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"AD_User_ID"), "u.Name", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"AssetServiceDate"), "a.AssetServiceDate", Timestamp.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"GuaranteeDate"), "a.GuaranteeDate", Timestamp.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"VersionNo"), "a.VersionNo", String.class)};
    private CLabel labelValue = new CLabel();
    private CTextField fieldValue = new CTextField(10);
    private CLabel labelName = new CLabel();
    private CTextField fieldName = new CTextField(10);
    private CLabel lBPartner_ID = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"BPartner"));
    private VLookup fBPartner_ID;
    private CLabel lProduct_ID = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"Product"));
    private VLookup fProduct_ID;

    public InfoAsset(Frame frame, boolean modal, int WindowNo, int A_Asset_ID, String value, boolean multiSelection, String whereClause) {
        this(frame, modal, WindowNo, A_Asset_ID, value, multiSelection, whereClause, true);
    }

    public InfoAsset(Frame frame, boolean modal, int WindowNo, int A_Asset_ID, String value, boolean multiSelection, String whereClause, boolean lookup) {
        super(frame, modal, WindowNo, "a", "A_Asset_ID", multiSelection, whereClause);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(value) + ", ID=" + A_Asset_ID + ", WHERE=" + whereClause);
        }
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"InfoAsset"));
        this.statInit();
        this.initInfo(value, A_Asset_ID, whereClause);
        int no = this.p_table.getRowCount();
        this.setStatusLine(String.valueOf(Integer.toString(no)) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0) {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        this.labelValue.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Value"));
        this.fieldValue.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldValue.addActionListener(this);
        this.labelName.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Name"));
        this.fieldName.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldName.addActionListener(this);
        this.fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)8065, (int)30));
        this.lBPartner_ID.setLabelFor(this.fBPartner_ID);
        this.fBPartner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fProduct_ID = new VLookup("M_Product_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)8047, (int)30));
        this.lProduct_ID.setLabelFor(this.fProduct_ID);
        this.fProduct_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.parameterPanel.setLayout(new ALayout());
        this.parameterPanel.add((Component)this.labelValue, new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fieldValue, null);
        this.parameterPanel.add((Component)this.lBPartner_ID, null);
        this.parameterPanel.add((Component)this.fBPartner_ID, null);
        this.parameterPanel.add((Component)this.labelName, new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fieldName, null);
        this.parameterPanel.add((Component)this.lProduct_ID, null);
        this.parameterPanel.add((Component)this.fProduct_ID, null);
    }

    private void initInfo(String value, int A_Asset_ID, String whereClause) {
        StringBuilder where = new StringBuilder();
        where.append("a.IsActive='Y'");
        if (whereClause != null && whereClause.length() > 0) {
            where.append(" AND ").append(whereClause);
        }
        this.prepareTable(s_assetLayout, s_assetFROM, where.toString(), "a.Value");
        if (value == null) {
            value = "%";
        }
        if (!value.endsWith("%")) {
            value = String.valueOf(value) + "%";
        }
        this.fieldValue.setText(value);
    }

    @Override
    protected String getSQLWhere() {
        Integer M_Product_ID;
        Integer C_BPartner_ID;
        String name;
        StringBuilder sql = new StringBuilder();
        String value = this.fieldValue.getText().toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            sql.append(" AND UPPER(a.Value) LIKE ?");
        }
        if (!(name = this.fieldName.getText().toUpperCase()).equals("") && !name.equals("%")) {
            sql.append(" AND UPPER(a.Name) LIKE ?");
        }
        if ((C_BPartner_ID = (Integer)this.fBPartner_ID.getValue()) != null) {
            sql.append(" AND a.C_BPartner_ID=").append(C_BPartner_ID);
        }
        if ((M_Product_ID = (Integer)this.fProduct_ID.getValue()) != null) {
            sql.append(" AND a.M_Product_ID=").append(M_Product_ID);
        }
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        String name;
        int index = 1;
        String value = this.fieldValue.getText().toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            if (!value.endsWith("%")) {
                value = String.valueOf(value) + "%";
            }
            pstmt.setString(index++, value);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Value: " + value);
            }
        }
        if (!(name = this.fieldName.getText().toUpperCase()).equals("") && !name.equals("%")) {
            if (!name.endsWith("%")) {
                name = String.valueOf(name) + "%";
            }
            pstmt.setString(index++, name);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Name: " + name);
            }
        }
    }

    @Override
    public void saveSelectionDetail() {
        int row = this.p_table.getSelectedRow();
        if (row == -1) {
            return;
        }
        Integer ID = this.getSelectedRowKey();
        Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"A_Asset_ID", (String)(ID == null ? "0" : ID.toString()));
    }

    @Override
    protected void showHistory() {
        this.log.info("InfoAsset.showHistory");
    }

    @Override
    protected boolean hasHistory() {
        return false;
    }

    @Override
    protected void zoom() {
        this.log.info("InfoAsset.zoom");
        Integer A_Asset_ID = this.getSelectedRowKey();
        if (A_Asset_ID == null) {
            return;
        }
        MQuery query = new MQuery("A_Asset");
        query.addRestriction("A_Asset_ID", "=", (Object)A_Asset_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("A_Asset", true);
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    @Override
    protected void customize() {
        this.log.info("InfoAsset.customize");
    }

    @Override
    protected boolean hasCustomize() {
        return false;
    }
}

