/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.swing.CButton;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VFile
extends JComponent
implements VEditor,
ActionListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = -4665930745414194731L;
    private CTextField m_text = new CTextField(15);
    private CButton m_button = new CButton();
    private String m_columnName;
    private String m_oldText;
    private String m_initialText;
    private int m_fieldLength;
    private volatile boolean m_setting = false;
    private int m_selectionMode = 1;
    private int m_dialogType = 2;
    private static CLogger log = CLogger.getCLogger(VFile.class);
    private GridField m_field = null;

    public VFile(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int fieldLength, boolean files) {
        String col;
        super.setName(columnName);
        this.m_columnName = columnName;
        this.m_fieldLength = fieldLength;
        if (files) {
            this.m_selectionMode = 0;
        }
        if ((col = columnName.toLowerCase()).indexOf("open") != -1 || col.indexOf("load") != -1) {
            this.m_dialogType = 0;
        } else if (col.indexOf("save") != -1) {
            this.m_dialogType = 1;
        }
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(this.m_text.getPreferredSize());
        int height = this.m_text.getPreferredSize().height;
        this.m_button.setIcon(Env.getImageIcon((String)"Open16.gif"));
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setPreferredSize(new Dimension(height, height));
        this.m_button.addActionListener(this);
        this.add((Component)this.m_button, "East");
        this.m_text.setBorder(null);
        this.m_text.setEditable(true);
        this.m_text.setFocusable(true);
        this.m_text.setFont(AdempierePLAF.getFont_Field());
        this.m_text.setForeground(AdempierePLAF.getTextColor_Normal());
        this.m_text.addMouseListener(new VFile_mouseAdapter(this));
        this.m_text.addKeyListener(this);
        this.m_text.addFocusListener(this);
        this.add((Component)this.m_text, "Center");
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        this.setMandatory(mandatory);
    }

    @Override
    public void dispose() {
        this.m_text = null;
        this.m_button = null;
        this.m_field = null;
    }

    @Override
    public void setReadWrite(boolean value) {
        this.m_button.setReadWrite(value);
        if (this.m_button.isVisible() != value) {
            this.m_button.setVisible(value);
        }
        this.m_text.setReadWrite(value);
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return this.m_button.isReadWrite();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_button.setMandatory(mandatory);
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_button.isMandatory();
    }

    @Override
    public void setBackground(Color color) {
        if (!color.equals(this.m_text.getBackground())) {
            this.m_text.setBackground(color);
        }
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.isMandatory()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        }
    }

    @Override
    public void setForeground(Color fg) {
        this.m_text.setForeground(fg);
    }

    @Override
    public void setValue(Object value) {
        this.m_oldText = value == null ? "" : value.toString();
        if (this.m_setting) {
            return;
        }
        this.m_text.setText(this.m_oldText);
        this.m_initialText = this.m_oldText;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public Object getValue() {
        return this.m_text.getText();
    }

    @Override
    public String getDisplay() {
        return this.m_text.getText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String m_value = this.m_text.getText();
        log.config(m_value);
        String fieldName = null;
        fieldName = this.m_field != null ? this.m_field.getHeader() : Msg.getElement((Properties)Env.getCtx(), (String)this.m_columnName);
        JFileChooser chooser = new JFileChooser(m_value);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(this.m_selectionMode);
        chooser.setDialogTitle(fieldName);
        chooser.setDialogType(this.m_dialogType);
        int returnVal = -1;
        returnVal = this.m_dialogType == 1 ? chooser.showSaveDialog(this) : (this.m_dialogType == 0 ? chooser.showOpenDialog(this) : chooser.showDialog(this, fieldName));
        if (returnVal != 0) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        this.m_text.setText(selectedFile.getAbsolutePath());
        try {
            this.fireVetoableChange(this.m_columnName, this.m_oldText, this.m_text.getText());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.m_text.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.m_text.removeActionListener(listener);
    }

    @Override
    public void setField(GridField mField) {
        this.m_field = mField;
    }

    @Override
    public GridField getField() {
        return this.m_field;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Key=" + e.getKeyCode() + " - " + e.getKeyChar() + " -> " + this.m_text.getText());
        }
        if (e.getKeyCode() == 27) {
            this.m_text.setText(this.m_initialText);
        } else if (e.getKeyChar() == '\uffff') {
            return;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.m_setting = true;
        try {
            String clear = this.m_text.getText();
            if (clear.length() > this.m_fieldLength) {
                clear = clear.substring(0, this.m_fieldLength);
            }
            this.fireVetoableChange(this.m_columnName, this.m_oldText, clear);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.m_setting = false;
    }

    final class VFile_mouseAdapter
    extends MouseAdapter {
        private VFile m_adaptee;

        VFile_mouseAdapter(VFile adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }
}

