/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JFormattedTextField;
import net.miginfocom.swing.MigLayout;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.model.MPOSKey;
import org.compiere.model.MPOSKeyLayout;
import org.compiere.pos.PosBasePanel;
import org.compiere.pos.PosKeyListener;
import org.compiere.pos.PosKeyPanel;
import org.compiere.pos.PosTextField;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;

public class POSKeyboard
extends CDialog
implements ActionListener,
PosKeyListener {
    private static final long serialVersionUID = 3296839634889851637L;
    private PosTextField field;
    private MPOSKeyLayout keylayout;
    private JFormattedTextField text = new JFormattedTextField();
    private HashMap<Integer, MPOSKey> keys;
    private static CLogger log = CLogger.getCLogger(POSKeyboard.class);

    public POSKeyboard(PosBasePanel posPanel, int C_POSKeyLayout_ID, PosTextField field, String title) {
        this(posPanel, C_POSKeyLayout_ID);
        this.setTitle(title);
        this.setPosTextField(field);
    }

    public POSKeyboard(PosBasePanel posPanel, int keyLayoutId) {
        super((Frame)AEnv.getFrame(posPanel), true);
        this.keylayout = MPOSKeyLayout.get((Properties)posPanel.getCtx(), (int)keyLayoutId);
        this.init(keyLayoutId);
    }

    public void init(int POSKeyLayout_ID) {
        CPanel panel = new CPanel();
        this.getContentPane().add(panel);
        panel.setLayout((LayoutManager)new MigLayout("fill"));
        if (this.keylayout.getPOSKeyLayoutType().equals("N")) {
            this.text.setHorizontalAlignment(11);
        }
        panel.add((Component)this.text, "north, growx, h 30!, wrap, gap 10 10 10 10");
        PosKeyPanel keys = new PosKeyPanel(POSKeyLayout_ID, this);
        panel.add((Component)keys, "center, growx, growy");
        ConfirmPanel confirm = new ConfirmPanel(true, false, true, false, false, false, false);
        confirm.addActionListener(this);
        Dimension buttonDim = new Dimension(50, 50);
        confirm.getResetButton().setPreferredSize(buttonDim);
        confirm.getOKButton().setPreferredSize(buttonDim);
        confirm.getCancelButton().setPreferredSize(buttonDim);
        panel.add((Component)confirm, "south");
        this.pack();
        this.setLocationByPlatform(true);
        this.text.requestFocusInWindow();
    }

    @Override
    public void dispose() {
        if (this.keys != null) {
            this.keys.clear();
            this.keys = null;
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action;
        block13: {
            action = e.getActionCommand();
            if (action == null || action.length() == 0) {
                return;
            }
            if (action.equals("Reset")) {
                if (this.keylayout.getPOSKeyLayoutType().equals("N")) {
                    this.text.setText("0");
                } else {
                    this.text.setText("");
                }
                try {
                    this.text.commitEdit();
                }
                catch (ParseException e1) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "JFormattedTextField commit failed");
                    }
                    break block13;
                }
            }
            if (action.equals("Cancel")) {
                this.dispose();
            } else if (action.equals("Ok")) {
                block14: {
                    this.field.setText(this.text.getText());
                    try {
                        this.field.commitEdit();
                    }
                    catch (ParseException e1) {
                        if (!log.isLoggable(Level.FINE)) break block14;
                        log.log(Level.FINE, "JFormattedTextField commit failed");
                    }
                }
                this.dispose();
            }
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("PosSubBasicKeys - actionPerformed: " + action);
        }
    }

    @Override
    public void keyReturned(MPOSKey key) {
        block27: {
            String entry = key.getText();
            String old = this.text.getText();
            int caretPos = this.text.getCaretPosition();
            if (this.text.getSelectedText() != null) {
                caretPos = this.text.getSelectionStart();
            }
            String head = old.substring(0, caretPos);
            if (this.text.getSelectedText() != null) {
                caretPos = this.text.getSelectionEnd();
            }
            String tail = old.substring(caretPos, old.length());
            if (entry != null && !entry.isEmpty()) {
                if (this.keylayout.getPOSKeyLayoutType().equals("K")) {
                    if (key.getText() != null) {
                        this.text.setText(String.valueOf(head) + entry + tail);
                    }
                } else if (this.keylayout.getPOSKeyLayoutType().equals("N")) {
                    if (entry.equals(".")) {
                        this.text.setText(String.valueOf(head) + entry + tail);
                    }
                    if (entry.equals(",")) {
                        this.text.setText(String.valueOf(head) + entry + tail);
                    } else if (entry.equals("C")) {
                        this.text.setText("0");
                    } else {
                        try {
                            int number = Integer.parseInt(entry);
                            if (number >= 0 && number <= 9) {
                                this.text.setText(String.valueOf(head) + number + tail);
                            } else {
                                Object current = this.text.getValue();
                                if (current == null) {
                                    this.text.setText(Integer.toString(number));
                                } else if (current instanceof BigDecimal) {
                                    this.text.setText(((BigDecimal)current).add(new BigDecimal(Integer.toString(number))).toPlainString());
                                } else if (current instanceof Integer) {
                                    this.text.setText(Integer.toString((Integer)current + number));
                                } else if (current instanceof Long) {
                                    this.text.setText(Long.toString((Long)current + (long)number));
                                } else if (current instanceof Double) {
                                    this.text.setText(Double.toString((Double)current + (double)number));
                                }
                            }
                        }
                        catch (NumberFormatException number) {
                            // empty catch block
                        }
                    }
                    try {
                        this.text.commitEdit();
                    }
                    catch (ParseException e) {
                        if (!log.isLoggable(Level.FINE)) break block27;
                        log.log(Level.FINE, "JFormattedTextField commit failed");
                    }
                }
            }
        }
    }

    public void setPosTextField(PosTextField posTextField) {
        this.field = posTextField;
        this.text.setFormatterFactory(this.field.getFormatterFactory());
        this.text.setText(this.field.getText());
        this.text.setValue(this.field.getValue());
        this.getContentPane().invalidate();
    }
}

