/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.im.InputMethodRequests;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.model.MSysConfig;
import org.compiere.swing.CEditor;
import org.compiere.util.Env;

public class CTextArea
extends JScrollPane
implements CEditor {
    private static final long serialVersionUID = 6208738910767859872L;
    private static final String FIRE_CHANGE = "fire-change";
    private JTextArea m_textArea = null;
    private boolean m_mandatory = false;

    public CTextArea() {
        this(new JTextArea());
    }

    public CTextArea(String text) {
        this(new JTextArea(text));
    }

    public CTextArea(int rows, int columns) {
        this(new JTextArea(rows, columns));
    }

    public CTextArea(String text, int rows, int columns) {
        this(new JTextArea(text, rows, columns));
    }

    public CTextArea(Document doc) {
        this(new JTextArea(doc));
    }

    public CTextArea(Document doc, String text, int rows, int columns) {
        this(new JTextArea(doc, text, rows, columns));
    }

    public CTextArea(JTextArea textArea) {
        super(textArea);
        this.m_textArea = textArea;
        super.setOpaque(false);
        super.getViewport().setOpaque(false);
        this.m_textArea.setLineWrap(true);
        this.m_textArea.setWrapStyleWord(true);
        this.m_textArea.firePropertyChange("editable", !this.isEditable(), this.isEditable());
        this.m_textArea.setFocusTraversalKeys(0, null);
        this.m_textArea.setFocusTraversalKeys(1, null);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 128);
        this.m_textArea.getInputMap().put(keyStroke, "insert-tab");
        keyStroke = KeyStroke.getKeyStroke(10, 64);
        this.m_textArea.getInputMap().put(keyStroke, "insert-break");
        keyStroke = KeyStroke.getKeyStroke(10, 128);
        this.m_textArea.getInputMap().put(keyStroke, "insert-break");
        boolean taBehaviour = MSysConfig.getBooleanValue((String)"SWING_OVERRIDE_TEXT_AREA_BEHAVIOUR", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (taBehaviour) {
            InputMap im = this.m_textArea.getInputMap();
            im.put(KeyStroke.getKeyStroke(10, 0), FIRE_CHANGE);
            ActionMap am = this.m_textArea.getActionMap();
            am.put(FIRE_CHANGE, new AbstractAction(){
                private static final long serialVersionUID = -4599908611347627047L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CTextArea.this.m_textArea.dispatchEvent(new FocusEvent(CTextArea.this.m_textArea, 1005));
                    CTextArea.this.m_textArea.requestFocus();
                }
            });
        }
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        if (this.m_textArea.isEditable() != rw) {
            this.m_textArea.setEditable(rw);
        }
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return this.m_textArea.isEditable();
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        }
    }

    @Override
    public void setBackground(Color color) {
        if (color.equals(this.getBackground())) {
            return;
        }
        if (this.m_textArea == null) {
            super.setBackground(color);
        } else {
            this.m_textArea.setBackground(color);
        }
    }

    @Override
    public Color getBackground() {
        if (this.m_textArea == null) {
            return super.getBackground();
        }
        return this.m_textArea.getBackground();
    }

    @Override
    public void setForeground(Color color) {
        if (this.m_textArea == null) {
            super.setForeground(color);
        } else {
            this.m_textArea.setForeground(color);
        }
    }

    @Override
    public Color getForeground() {
        if (this.m_textArea == null) {
            return super.getForeground();
        }
        return this.m_textArea.getForeground();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.m_textArea.setText("");
        } else {
            this.m_textArea.setText(value.toString());
        }
    }

    @Override
    public Object getValue() {
        return this.m_textArea.getText();
    }

    @Override
    public String getDisplay() {
        return this.m_textArea.getText();
    }

    public void setText(String text) {
        this.m_textArea.setText(text);
        this.m_textArea.setCaretPosition(0);
    }

    public String getText() {
        return this.m_textArea.getText();
    }

    public void append(String text) {
        this.m_textArea.append(text);
    }

    public void setColumns(int cols) {
        this.m_textArea.setColumns(cols);
    }

    public int getColumns() {
        return this.m_textArea.getColumns();
    }

    public void setRows(int rows) {
        this.m_textArea.setRows(rows);
    }

    public int getRows() {
        return this.m_textArea.getRows();
    }

    public void setCaretPosition(int pos) {
        this.m_textArea.setCaretPosition(pos);
    }

    public int getCaretPosition() {
        return this.m_textArea.getCaretPosition();
    }

    public void setEditable(boolean edit) {
        this.m_textArea.setEditable(edit);
    }

    public boolean isEditable() {
        return this.m_textArea.isEditable();
    }

    public void setLineWrap(boolean wrap) {
        this.m_textArea.setLineWrap(wrap);
    }

    public void setWrapStyleWord(boolean word) {
        this.m_textArea.setWrapStyleWord(word);
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        if (this.m_textArea == null) {
            super.setOpaque(isOpaque);
        } else {
            this.m_textArea.setOpaque(isOpaque);
        }
    }

    public void setMargin(Insets m) {
        if (this.m_textArea != null) {
            this.m_textArea.setMargin(m);
        }
    }

    @Override
    public void addFocusListener(FocusListener l) {
        if (this.m_textArea == null) {
            super.addFocusListener(l);
        } else {
            this.m_textArea.addFocusListener(l);
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.m_textArea.addMouseListener(l);
    }

    @Override
    public void addKeyListener(KeyListener l) {
        this.m_textArea.addKeyListener(l);
    }

    @Override
    public void addInputMethodListener(InputMethodListener l) {
        this.m_textArea.addInputMethodListener(l);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.m_textArea.getInputMethodRequests();
    }

    @Override
    public void setInputVerifier(InputVerifier l) {
        this.m_textArea.setInputVerifier(l);
    }
}

