/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.ReferenceUtils;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.compiere.model.MField;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Field;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FieldElementHandler
extends AbstractElementHandler {
    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        List notfounds;
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        if (this.isParentDefer(element, "AD_Tab")) {
            element.defer = true;
            return;
        }
        List excludes = this.defaultExcludeList("AD_Field");
        excludes.add("AD_Window_ID");
        excludes.add("AD_Tab_ID");
        int tabid = this.getParentId(element, "AD_Tab");
        if (tabid <= 0) {
            Element tabElement = (Element)element.properties.get("AD_Tab_ID");
            if (ReferenceUtils.isIDLookup((Element)tabElement) || ReferenceUtils.isUUIDLookup((Element)tabElement)) {
                tabid = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)tabElement, (String)this.getTrxName(ctx));
            } else {
                String tabName = this.getStringValue(element, "AD_Tab_ID");
                int AD_Window_ID = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)((Element)element.properties.get("AD_Window_ID")), (String)this.getTrxName(ctx));
                if (AD_Window_ID > 0) {
                    tabid = this.findIdByNameAndParentId(ctx, "AD_Tab", tabName, "AD_Window", AD_Window_ID);
                }
            }
        }
        if (tabid <= 0) {
            element.defer = true;
            element.unresolved = "AD_Tab_ID";
            return;
        }
        excludes.add("AD_Table_ID");
        excludes.add("AD_Column_ID");
        int AD_Table_ID = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)((Element)element.properties.get("AD_Table_ID")), (String)this.getTrxName(ctx));
        Element columnElement = (Element)element.properties.get("AD_Column_ID");
        int AD_Column_ID = 0;
        if (ReferenceUtils.isIDLookup((Element)columnElement) || ReferenceUtils.isUUIDLookup((Element)columnElement)) {
            AD_Column_ID = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)columnElement, (String)this.getTrxName(ctx));
        } else {
            String colname = this.getStringValue(element, "AD_Column_ID", excludes);
            AD_Column_ID = this.findIdByColumnAndParentId(ctx, "AD_Column", "ColumnName", colname, "AD_Table", AD_Table_ID);
        }
        if (AD_Column_ID == 0) {
            element.defer = true;
            element.unresolved = "AD_Column_ID";
            return;
        }
        MField mField = (MField)this.findPO(ctx, element);
        if (mField == null) {
            StringBuffer sqlB = new StringBuffer("select AD_Field_ID from AD_Field where AD_Column_ID = ").append(AD_Column_ID).append(" and AD_Tab_ID = ?");
            int id = DB.getSQLValue((String)this.getTrxName(ctx), (String)sqlB.toString(), (int)tabid);
            mField = new MField(ctx.ctx, id > 0 ? id : 0, this.getTrxName(ctx));
            if (mField.is_new()) {
                mField.setAD_Column_ID(AD_Column_ID);
                mField.setAD_Tab_ID(tabid);
            }
        } else {
            if (mField.getAD_Tab_ID() != tabid) {
                mField.setAD_Tab_ID(tabid);
            }
            if (mField.getAD_Column_ID() != AD_Column_ID) {
                mField.setAD_Column_ID(AD_Column_ID);
            }
        }
        PoFiller filler = new PoFiller(ctx, (PO)mField, element, (AbstractElementHandler)this);
        if (mField.getAD_Field_ID() == 0 && this.isOfficialId(element, "AD_Field_ID")) {
            filler.setInteger("AD_Field_ID");
        }
        if ((notfounds = filler.autoFill(excludes)).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!mField.is_new()) {
            if (!mField.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Field", 107);
        String action = null;
        if (!mField.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Field", (PO)mField);
            action = "Update";
        } else {
            action = "New";
        }
        if (mField.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mField.getName(), mField.get_ID(), action);
            element.recordId = mField.getAD_Field_ID();
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mField.getName(), mField.get_ID(), action);
        throw new POSaveFailedException("Failed to save field definition " + mField.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_Field_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Field_ID");
        X_AD_Field m_Field = new X_AD_Field(ctx.ctx, AD_Field_ID, null);
        PackOut packOut = ctx.packOut;
        try {
            ElementHandler handler;
            if (m_Field.getAD_FieldGroup_ID() > 0) {
                handler = packOut.getHandler("AD_FieldGroup");
                handler.packOut(packOut, document, null, m_Field.getAD_FieldGroup_ID());
            }
            if (m_Field.getAD_Reference_ID() > 0) {
                handler = packOut.getHandler("AD_Reference");
                handler.packOut(packOut, document, null, m_Field.getAD_Reference_ID());
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        if (ctx.packOut.getFromDate() != null && m_Field.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "table");
        document.startElement("", "", "AD_Field", atts);
        this.createFieldBinding(ctx, document, m_Field);
        document.endElement("", "", "AD_Field");
    }

    private void createFieldBinding(PIPOContext ctx, TransformerHandler document, X_AD_Field m_Field) {
        AttributesImpl atts;
        int AD_Table_ID;
        List excludes = this.defaultExcludeList("AD_Field");
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Field);
        if (m_Field.getAD_Field_ID() <= 999999) {
            filler.add("AD_Field_ID", new AttributesImpl());
        }
        if ((AD_Table_ID = DB.getSQLValue((String)this.getTrxName(ctx), (String)"SELECT AD_Table_ID FROM AD_Column WHERE AD_Column_ID=?", (int)m_Field.getAD_Column_ID())) > 0) {
            atts = new AttributesImpl();
            filler.addTableReference("AD_Table_ID", "AD_Table", "TableName", AD_Table_ID, atts);
        }
        excludes.add("AD_Tab_ID");
        atts = new AttributesImpl();
        filler.addTableReference("AD_Tab_ID", "AD_Tab", "Name", m_Field.getAD_Tab_ID(), atts);
        if (atts.getValue("reference").equals("table")) {
            int AD_Window_ID = DB.getSQLValue((String)this.getTrxName(ctx), (String)"SELECT AD_Window_ID FROM AD_Tab WHERE AD_Tab_ID=?", (int)m_Field.getAD_Tab_ID());
            filler.addTableReference("AD_Window_ID", "AD_Window", "Name", AD_Window_ID, new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Field_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Field_ID");
    }
}

