/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.util.Properties;
import org.adempiere.util.ShippingUtil;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MInOut;
import org.compiere.model.MShipper;
import org.compiere.model.MShipperLabels;
import org.compiere.model.MShipperPackaging;
import org.compiere.model.MShipperPickupTypes;
import org.compiere.util.Env;

public class CalloutPackage
extends CalloutEngine {
    public String afterShipper(Properties ctx, int windowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if (this.isCalloutActive()) {
            return "";
        }
        int inout_id = Env.getContextAsInt((Properties)ctx, (int)windowNo, (String)"M_InOut_ID");
        if (inout_id > 0) {
            String shipperAccount = null;
            String dutiesShipperAccount = null;
            MInOut inout = new MInOut(ctx, inout_id, null);
            if (inout.getFreightCharges().equals("D_PP") || inout.getFreightCharges().equals("E_PPB")) {
                int shipper_id = Env.getContextAsInt((Properties)ctx, (int)windowNo, (String)"M_Shipper_ID");
                if (shipper_id > 0) {
                    int org_id = Env.getContextAsInt((Properties)ctx, (int)windowNo, (String)"AD_Org_ID");
                    shipperAccount = ShippingUtil.getSenderShipperAccount((int)shipper_id, (int)org_id);
                    dutiesShipperAccount = ShippingUtil.getSenderDutiesShipperAccount((int)shipper_id, (int)org_id);
                }
            } else {
                shipperAccount = inout.getShipperAccount();
            }
            if (shipperAccount != null) {
                mTab.setValue("ShipperAccount", (Object)shipperAccount);
            }
            if (dutiesShipperAccount != null) {
                mTab.setValue("DutiesShipperAccount", dutiesShipperAccount);
            }
        }
        return "";
    }

    public String afterShipperSetDefaults(Properties ctx, int windowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if (this.isCalloutActive()) {
            return "";
        }
        if (value != null && (Integer)value > 0) {
            int inout_id;
            int ad_org_id;
            int c_bpartner_id;
            int accountLocationId;
            int shipper_id = (Integer)value;
            String whereClause = "M_Shipper_ID = " + shipper_id + " AND IsDefault='Y' AND IsActive='Y'";
            int[] ids = MShipperLabels.getAllIDs((String)"M_ShipperLabels", (String)whereClause, null);
            if (ids.length > 0) {
                mTab.setValue("M_ShipperLabels_ID", (Object)ids[0]);
            }
            if ((ids = MShipperPackaging.getAllIDs((String)"M_ShipperPackaging", (String)whereClause, null)).length > 0) {
                mTab.setValue("M_ShipperPackaging_ID", (Object)ids[0]);
            }
            if ((ids = MShipperPickupTypes.getAllIDs((String)"M_ShipperPickupTypes", (String)whereClause, null)).length > 0) {
                mTab.setValue("M_ShipperPickupTypes_ID", (Object)ids[0]);
            }
            if ((accountLocationId = ShippingUtil.findRecipientAccountLocationId((int)shipper_id, (int)(c_bpartner_id = Env.getContextAsInt((Properties)ctx, (int)windowNo, (String)"C_BPartner_ID")), (int)(ad_org_id = Env.getContextAsInt((Properties)ctx, (int)windowNo, (String)"AD_Org_ID")), (int)(inout_id = Env.getContextAsInt((Properties)ctx, (int)windowNo, (String)"M_InOut_ID")), (int)0)) > 0) {
                mTab.setValue("C_BPartner_Location_ID", (Object)accountLocationId);
            }
            if (shipper_id > 0) {
                MShipper shipper = new MShipper(ctx, shipper_id, null);
                mTab.setValue("TrackingInfo", (Object)shipper.getTrackingURL());
                mTab.setValue("IsResidential", (Object)shipper.isResidential());
                mTab.setValue("IsSaturdayDelivery", (Object)shipper.isSaturdayDelivery());
            }
        }
        return "";
    }
}

