/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install.util;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public final class AppsAction
extends AbstractAction {
    private static final long serialVersionUID = 8522301377339185496L;
    public static final Dimension BUTTON_SIZE = new Dimension(28, 28);
    public static final Insets BUTTON_INSETS = new Insets(0, 0, 0, 0);
    private AbstractButton m_button;
    private JMenuItem m_menu;
    private String m_action = null;
    private KeyStroke m_accelerator = null;
    private Icon m_smallPressed = null;
    private ActionListener m_delegate = null;
    private boolean m_toggle = false;
    private boolean m_pressed = false;

    public AppsAction(String action, KeyStroke accelerator, boolean toggle) {
        this(action, accelerator, null, toggle);
    }

    public AppsAction(String action, KeyStroke accelerator, String text) {
        this(action, accelerator, text, false);
    }

    public AppsAction(String action, KeyStroke accelerator, String toolTipText, boolean toggle) {
        Character ch;
        int pos;
        this.m_action = action;
        this.m_accelerator = accelerator;
        this.m_toggle = toggle;
        if (toolTipText == null) {
            toolTipText = Msg.getMsg((Properties)Env.getCtx(), (String)action);
        }
        if ((pos = toolTipText.indexOf(38)) != -1 && toolTipText.length() > pos && (ch = new Character(toolTipText.toUpperCase().charAt(pos + 1))).charValue() != ' ') {
            toolTipText = String.valueOf(toolTipText.substring(0, pos)) + toolTipText.substring(pos + 1);
            this.putValue("MnemonicKey", new Integer(ch.hashCode()));
        }
        ImageIcon small = this.getIcon(action, true);
        ImageIcon large = this.getIcon(action, false);
        ImageIcon largePressed = null;
        if (this.m_toggle) {
            this.m_smallPressed = this.getIcon(String.valueOf(action) + "X", true);
            if (this.m_smallPressed == null) {
                this.m_smallPressed = small;
            }
            if ((largePressed = this.getIcon(String.valueOf(action) + "X", false)) == null) {
                largePressed = large;
            }
        }
        this.putValue("Name", toolTipText);
        this.putValue("SmallIcon", small);
        this.putValue("ShortDescription", toolTipText);
        this.putValue("ActionCommandKey", this.m_action);
        this.putValue("AcceleratorKey", accelerator);
        if (toggle) {
            this.m_button = new JToggleButton(this);
            this.m_button.setSelectedIcon(largePressed);
        } else {
            this.m_button = new JButton(this);
        }
        this.m_button.setName(action);
        if (large != null) {
            this.m_button.setIcon(large);
            this.m_button.setText(null);
        }
        this.m_button.setActionCommand(this.m_action);
        this.m_button.setMargin(BUTTON_INSETS);
        this.m_button.setSize(BUTTON_SIZE);
        if (accelerator != null) {
            this.m_button.getInputMap(2).put(accelerator, action);
            this.m_button.getActionMap().put(action, this);
        }
    }

    private ImageIcon getIcon(String name, boolean small) {
        String fullName = String.valueOf(name) + (small ? "16" : "24");
        return Env.getImageIcon2((String)fullName);
    }

    public String getName() {
        return this.m_action;
    }

    public AbstractButton getButton() {
        return this.m_button;
    }

    public JMenuItem getMenuItem() {
        if (this.m_menu == null) {
            if (this.m_toggle) {
                this.m_menu = new JCheckBoxMenuItem(this);
                this.m_menu.setSelectedIcon(this.m_smallPressed);
            } else {
                this.m_menu = new JMenuItem(this);
            }
            this.m_menu.setAccelerator(this.m_accelerator);
            this.m_menu.setActionCommand(this.m_action);
        }
        return this.m_menu;
    }

    public void setDelegate(ActionListener al) {
        this.m_delegate = al;
    }

    public void setPressed(boolean pressed) {
        if (!this.m_toggle) {
            return;
        }
        this.m_pressed = pressed;
        if (this.m_button != null) {
            this.m_button.setSelected(pressed);
        }
        if (this.m_menu != null) {
            this.m_menu.setSelected(pressed);
        }
    }

    public boolean isPressed() {
        return this.m_pressed;
    }

    public Character getMnemonic() {
        Object oo = this.getValue("MnemonicKey");
        if (oo instanceof Integer) {
            return Character.valueOf((char)((Integer)oo).intValue());
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_toggle) {
            this.setPressed(!this.m_pressed);
        }
        if (this.m_delegate != null) {
            this.m_delegate.actionPerformed(e);
        }
    }

    public void dispose() {
        this.m_button = null;
        this.m_menu = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AppsAction[");
        sb.append(this.m_action);
        Object oo = this.getValue("AcceleratorKey");
        if (oo != null) {
            sb.append(",Accelerator=").append(oo);
        }
        if ((oo = this.getMnemonic()) != null) {
            sb.append(",MnemonicKey=").append(oo);
        }
        sb.append("]");
        return sb.toString();
    }
}

