/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MStorageReservation;
import org.compiere.model.MTransaction;
import org.compiere.model.Query;
import org.compiere.model.X_M_Production;
import org.compiere.model.X_M_ProductionLine;
import org.compiere.model.X_M_ProductionPlan;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.ValueNamePair;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

@Deprecated
public class M_Production_Run
extends SvrProcess {
    private int p_Record_ID = 0;
    private boolean mustBeStocked = false;
    private int m_level = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("MustBeStocked")) {
                    this.mustBeStocked = ((String)para[i].getParameter()).equals("Y");
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_Record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("Search fields in M_Production");
        X_M_Production production = new X_M_Production(this.getCtx(), this.p_Record_ID, this.get_TrxName());
        if (production.isProcessed()) {
            this.log.info("Already Posted");
            return "@AlreadyPosted@";
        }
        String whereClause = "M_Production_ID=? ";
        List lines = new Query(this.getCtx(), "M_ProductionPlan", whereClause, this.get_TrxName()).setParameters(new Object[]{this.p_Record_ID}).setOrderBy("Line, M_Product_ID").list();
        for (X_M_ProductionPlan pp : lines) {
            if (!"Y".equals(production.getIsCreated())) {
                int line = 100;
                int no = DB.executeUpdateEx((String)"DELETE M_ProductionLine WHERE M_ProductionPlan_ID = ?", (Object[])new Object[]{pp.getM_ProductionPlan_ID()}, (String)this.get_TrxName());
                if (no == -1) {
                    this.raiseError("ERROR", "DELETE M_ProductionLine WHERE M_ProductionPlan_ID = " + pp.getM_ProductionPlan_ID());
                }
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)pp.getM_Product_ID());
                X_M_ProductionLine pl = new X_M_ProductionLine(this.getCtx(), 0, this.get_TrxName());
                pl.setAD_Org_ID(pp.getAD_Org_ID());
                pl.setLine(line);
                pl.setDescription(pp.getDescription());
                pl.setM_Product_ID(pp.getM_Product_ID());
                pl.setM_Locator_ID(pp.getM_Locator_ID());
                pl.setM_ProductionPlan_ID(pp.getM_ProductionPlan_ID());
                pl.setMovementQty(pp.getProductionQty());
                pl.saveEx();
                if (this.explosion(pp, product, pp.getProductionQty(), line) != 0) continue;
                this.raiseError("No BOM Lines", "");
                continue;
            }
            whereClause = "M_ProductionPlan_ID= ? ";
            List production_lines = new Query(this.getCtx(), "M_ProductionLine", whereClause, this.get_TrxName()).setParameters(new Object[]{pp.getM_ProductionPlan_ID()}).setOrderBy("Line").list();
            for (X_M_ProductionLine pline : production_lines) {
                MLocator locator = MLocator.get((Properties)this.getCtx(), (int)pline.getM_Locator_ID());
                String MovementType = "P+";
                BigDecimal MovementQty = pline.getMovementQty();
                if (MovementQty.signum() == 0) continue;
                if (MovementQty.signum() < 0) {
                    BigDecimal QtyAvailable = MStorageReservation.getQtyAvailable((int)locator.getM_Warehouse_ID(), (int)pline.getM_Product_ID(), (int)pline.getM_AttributeSetInstance_ID(), (String)this.get_TrxName());
                    if (this.mustBeStocked && QtyAvailable.add(MovementQty).signum() < 0) {
                        this.raiseError("@NotEnoughStocked@: " + pline.getM_Product().getName(), "");
                    }
                    MovementType = "P-";
                }
                if (!MStorageOnHand.add((Properties)this.getCtx(), (int)locator.getM_Warehouse_ID(), (int)locator.getM_Locator_ID(), (int)pline.getM_Product_ID(), (int)pline.getM_AttributeSetInstance_ID(), (BigDecimal)MovementQty, (String)this.get_TrxName())) {
                    this.raiseError("Cannot correct Inventory", "");
                }
                MTransaction mtrx = new MTransaction(this.getCtx(), pline.getAD_Org_ID(), MovementType, locator.getM_Locator_ID(), pline.getM_Product_ID(), pline.getM_AttributeSetInstance_ID(), MovementQty, production.getMovementDate(), this.get_TrxName());
                mtrx.setM_ProductionLine_ID(pline.getM_ProductionLine_ID());
                mtrx.saveEx();
                pline.setProcessed(true);
                pline.saveEx();
            }
            pp.setProcessed(true);
            pp.saveEx();
        }
        if (!"Y".equals(production.getIsCreated())) {
            production.setIsCreated("Y");
            production.saveEx();
        } else {
            production.setProcessed(true);
            production.saveEx();
            if (MClient.isClientAccountingImmediate()) {
                String string = DocumentEngine.postImmediate((Properties)this.getCtx(), (int)this.getAD_Client_ID(), (int)production.get_Table_ID(), (int)production.get_ID(), (boolean)true, (String)this.get_TrxName());
            }
        }
        return "@OK@";
    }

    private int explosion(X_M_ProductionPlan pp, MProduct product, BigDecimal qty, int line) throws Exception {
        MPPProductBOM bom = MPPProductBOM.getDefault((MProduct)product, (String)this.get_TrxName());
        if (bom == null) {
            this.raiseError("Do not exist default BOM for this product :" + product.getValue() + "-" + product.getName(), "");
        }
        MPPProductBOMLine[] bom_lines = bom.getLines(new Timestamp(System.currentTimeMillis()));
        ++this.m_level;
        int components = 0;
        line *= this.m_level;
        MPPProductBOMLine[] mPPProductBOMLineArray = bom_lines;
        int n = bom_lines.length;
        int n2 = 0;
        while (n2 < n) {
            MPPProductBOMLine bomline = mPPProductBOMLineArray[n2];
            MProduct component = MProduct.get((Properties)this.getCtx(), (int)bomline.getM_Product_ID());
            if (component.isBOM() && !component.isStocked()) {
                this.explosion(pp, component, bomline.getQtyBOM().multiply(qty), line);
            } else {
                X_M_ProductionLine pl = new X_M_ProductionLine(this.getCtx(), 0, this.get_TrxName());
                pl.setAD_Org_ID(pp.getAD_Org_ID());
                pl.setLine(++line);
                pl.setDescription(bomline.getDescription());
                pl.setM_Product_ID(bomline.getM_Product_ID());
                pl.setM_Locator_ID(pp.getM_Locator_ID());
                pl.setM_ProductionPlan_ID(pp.getM_ProductionPlan_ID());
                pl.setMovementQty(bomline.getQtyBOM().multiply(qty).negate());
                pl.saveEx();
                ++components;
            }
            ++n2;
        }
        return components;
    }

    private void raiseError(String string, String sql) throws Exception {
        StringBuilder msg = new StringBuilder(string);
        ValueNamePair pp = CLogger.retrieveError();
        if (pp != null) {
            msg = new StringBuilder(pp.getName()).append(" - ");
        }
        msg.append(sql);
        throw new AdempiereUserError(msg.toString());
    }
}

