/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MField;
import org.compiere.model.MTab;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;

public class TabCopy
extends SvrProcess {
    private int p_AD_TabTo_ID = 0;
    private int p_AD_TabFrom_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Tab_ID")) {
                    this.p_AD_TabFrom_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_AD_TabTo_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MTab from;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("To AD_Tab_ID=" + this.p_AD_TabTo_ID + ", From=" + this.p_AD_TabFrom_ID);
        }
        if ((from = new MTab(this.getCtx(), this.p_AD_TabFrom_ID, this.get_TrxName())).get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ (from->) @AD_Tab_ID@");
        }
        MTab to = new MTab(this.getCtx(), this.p_AD_TabTo_ID, this.get_TrxName());
        if (to.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ (to<-) @AD_Tab_ID@");
        }
        if (from.getAD_Table_ID() != to.getAD_Table_ID()) {
            throw new AdempiereUserError("@Error@ @AD_Table_ID@");
        }
        int count = 0;
        MField[] mFieldArray = from.getFields(false, this.get_TrxName());
        int n = mFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            MField oldField = mFieldArray[n2];
            MField newField = new MField(to, oldField);
            if (!oldField.isActive()) {
                newField.setIsActive(false);
            }
            if (newField.save()) {
                ++count;
            } else {
                throw new AdempiereUserError("@Error@ @AD_Field_ID@");
            }
            ++n2;
        }
        StringBuilder msgreturn = new StringBuilder("@Copied@ #").append(count);
        return msgreturn.toString();
    }
}

