/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Language;

public class TranslationDocSync
extends SvrProcess {
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MClient client = MClient.get((Properties)this.getCtx());
        String baselang = Language.getBaseAD_Language();
        if (client.isMultiLingualDocument() && client.getAD_Language().equals(baselang)) {
            throw new AdempiereUserError("@AD_Client_ID@: @IsMultiLingualDocument@");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("" + client);
        }
        List tables = new Query(this.getCtx(), "AD_Table", "TableName LIKE '%_Trl' AND TableName NOT LIKE 'AD%'", this.get_TrxName()).setOrderBy("TableName").list();
        for (MTable table : tables) {
            this.processTable(table, client);
        }
        return "OK";
    }

    private void processTable(MTable table, MClient client) {
        StringBuilder columnNames = new StringBuilder();
        MColumn[] columns = table.getColumns(false);
        int i = 0;
        while (i < columns.length) {
            MColumn column = columns[i];
            if (!(column.getColumnName().equals(PO.getUUIDColumnName((String)table.getTableName())) || column.getAD_Reference_ID() != 10 && column.getAD_Reference_ID() != 14)) {
                String columnName = column.getColumnName();
                if (columnNames.length() != 0) {
                    columnNames.append(",");
                }
                columnNames.append(columnName);
            }
            ++i;
        }
        String trlTable = table.getTableName();
        String baseTable = trlTable.substring(0, trlTable.length() - 4);
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(String.valueOf(baseTable) + ": " + columnNames);
        }
        if (client.isMultiLingualDocument()) {
            String baselang = Language.getBaseAD_Language();
            if (!client.getAD_Language().equals(baselang)) {
                StringBuilder sql = new StringBuilder("UPDATE ").append(trlTable).append(" SET (").append((CharSequence)columnNames).append(",IsTranslated) = (SELECT ").append((CharSequence)columnNames).append(",'Y' FROM ").append(baseTable).append(" b WHERE ").append(trlTable).append(".").append(baseTable).append("_ID=b.").append(baseTable).append("_ID) WHERE AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Language=").append(DB.TO_STRING((String)client.getAD_Language()));
                int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                this.addLog(0, null, new BigDecimal(no), baseTable);
            }
        } else {
            StringBuilder sql = new StringBuilder("UPDATE ").append(trlTable).append(" SET (").append((CharSequence)columnNames).append(",IsTranslated) = (SELECT ").append((CharSequence)columnNames).append(",'Y' FROM ").append(baseTable).append(" b WHERE ").append(trlTable).append(".").append(baseTable).append("_ID=b.").append(baseTable).append("_ID) WHERE AD_Client_ID=").append(this.getAD_Client_ID());
            int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(no), baseTable);
        }
    }
}

