/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.hazelcast.service;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiTask;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;
import org.idempiere.hazelcast.service.Activator;
import org.idempiere.hazelcast.service.ClusterMember;

public class ClusterServiceImpl
implements IClusterService {
    public Collection<IClusterMember> getMembers() {
        HazelcastInstance instance = Activator.getHazelcastInstance();
        HashSet<IClusterMember> clusterMembers = new HashSet<IClusterMember>();
        if (instance != null) {
            Set members = instance.getCluster().getMembers();
            for (Member member : members) {
                clusterMembers.add(new ClusterMember(member.getUuid(), member.getInetSocketAddress().getAddress(), member.getInetSocketAddress().getPort()));
            }
        }
        return clusterMembers;
    }

    public IClusterMember getLocalMember() {
        HazelcastInstance instance = Activator.getHazelcastInstance();
        if (instance != null) {
            Member member = instance.getCluster().getLocalMember();
            return new ClusterMember(member.getUuid(), member.getInetSocketAddress().getAddress(), member.getInetSocketAddress().getPort());
        }
        return null;
    }

    public <V> Future<V> execute(Callable<V> task, IClusterMember clusterMember) {
        HazelcastInstance instance = Activator.getHazelcastInstance();
        if (instance != null) {
            Set members = instance.getCluster().getMembers();
            for (Member member : members) {
                if (!member.getUuid().equals(clusterMember.getId())) continue;
                DistributedTask distributedTask = new DistributedTask(task, member);
                Activator.getHazelcastInstance().getExecutorService().execute((Runnable)distributedTask);
                return distributedTask;
            }
        }
        return null;
    }

    public <V> Future<Collection<V>> execute(Callable<V> task, Collection<IClusterMember> clusterMembers) {
        HashSet<String> selectedIds = new HashSet<String>();
        for (IClusterMember clusterMember : clusterMembers) {
            selectedIds.add(clusterMember.getId());
        }
        HazelcastInstance instance = Activator.getHazelcastInstance();
        if (instance != null) {
            Set members = instance.getCluster().getMembers();
            HashSet<Member> selectedMembers = new HashSet<Member>();
            for (Member member : members) {
                if (!selectedIds.contains(member.getUuid())) continue;
                selectedMembers.add(member);
            }
            if (selectedMembers.size() > 0) {
                MultiTask multiTask = new MultiTask(task, selectedMembers);
                Activator.getHazelcastInstance().getExecutorService().execute((Runnable)multiTask);
                return multiTask;
            }
        }
        return null;
    }
}

