/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import com.Verisign.payment.PFProAPI;
import java.io.File;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.PaymentProcessor;
import org.compiere.util.Ini;

public final class PP_PayFlowPro
extends PaymentProcessor
implements Serializable {
    private static final long serialVersionUID = -5694889644110445790L;
    private PFProAPI m_pp = new PFProAPI();
    private boolean m_ok = false;
    protected static final String RESULT_OK = "0";
    protected static final String RESULT_DECLINED = "12";
    protected static final String RESULT_INVALID_NO = "23";
    protected static final String RESULT_INVALID_EXP = "24";
    protected static final String RESULT_INSUFFICIENT_FUNDS = "50";
    protected static final String RESULT_TIMEOUT_PROCESSOR = "104";
    protected static final String RESULT_TIMEOUT_HOST = "109";

    public PP_PayFlowPro() {
        String path = String.valueOf(Ini.getAdempiereHome()) + File.separator + "lib";
        File file = new File(path, "f73e89fd.0");
        if (!file.exists()) {
            this.log.log(Level.SEVERE, "No cert file " + file.getAbsolutePath());
        }
        this.m_pp.SetCertPath(path);
    }

    public String getVersion() {
        return "PayFlowPro " + this.m_pp.Version();
    }

    public boolean processCC() throws IllegalArgumentException {
        String year;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.p_mbap.getHostAddress()) + " " + this.p_mbap.getHostPort() + ", Timeout=" + this.getTimeout() + "; Proxy=" + this.p_mbap.getProxyAddress() + " " + this.p_mbap.getProxyPort() + " " + this.p_mbap.getProxyLogon() + " " + this.p_mbap.getProxyPassword());
        }
        StringBuilder param = new StringBuilder();
        if (!this.p_mp.getTrxType().equals("S")) {
            throw new IllegalArgumentException("PP_PayFlowPro TrxType not supported - " + this.p_mp.getTrxType());
        }
        param.append("TRXTYPE=").append(this.p_mp.getTrxType());
        param.append("&TENDER=C").append("&ACCT=").append(MPaymentValidate.checkNumeric((String)this.p_mp.getCreditCardNumber()));
        param.append("&EXPDATE=");
        String month = String.valueOf(this.p_mp.getCreditCardExpMM());
        if (month.length() == 1) {
            param.append(RESULT_OK);
        }
        param.append(month);
        int expYY = this.p_mp.getCreditCardExpYY();
        if (expYY > 2000) {
            expYY -= 2000;
        }
        if ((year = String.valueOf(expYY)).length() == 1) {
            param.append(RESULT_OK);
        }
        param.append(year);
        param.append("&AMT=").append(this.p_mp.getPayAmt());
        param.append(this.createPair("&AUTHCODE", this.p_mp.getVoiceAuthCode(), 6));
        param.append(this.createPair("&ORIGID", this.p_mp.getOrig_TrxID(), 12));
        param.append(this.createPair("&CVV2", this.p_mp.getCreditCardVV(), 4));
        param.append(this.createPair("&NAME", this.p_mp.getA_Name(), 30));
        param.append(this.createPair("&STREET", this.p_mp.getA_Street(), 30));
        param.append(this.createPair("&ZIP", this.p_mp.getA_Zip(), 9));
        param.append(this.createPair("&EMAIL", this.p_mp.getA_EMail(), 64));
        param.append(this.createPair("&SHIPTOZIP", this.p_mp.getA_Zip(), 6));
        param.append(this.createPair("&TAXAMT", this.p_mp.getTaxAmt(), 10));
        param.append(this.createPair("&INVNUM", this.p_mp.getC_Invoice_ID(), 9));
        param.append(this.createPair("&COMMENT1", this.p_mp.getPO().get_ID(), 128));
        param.append(this.createPair("&COMMENT2", this.p_mp.getC_BPartner_ID(), 128));
        return this.process(param.toString());
    }

    public boolean process(String parameter) {
        long start = System.currentTimeMillis();
        StringBuilder param = new StringBuilder(parameter);
        param.append("&PARTNER=").append(this.p_mbap.getPartnerID()).append("&VENDOR=").append(this.p_mbap.getVendorID()).append("&USER=").append(this.p_mbap.getUserID()).append("&PWD=").append(this.p_mbap.getPassword());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("-> " + param.toString());
        }
        int rc = this.m_pp.CreateContext(this.p_mbap.getHostAddress(), this.p_mbap.getHostPort(), this.getTimeout(), this.p_mbap.getProxyAddress(), this.p_mbap.getProxyPort(), this.p_mbap.getProxyLogon(), this.p_mbap.getProxyPassword());
        String response = this.m_pp.SubmitTransaction(param.toString());
        this.m_pp.DestroyContext();
        long ms = System.currentTimeMillis() - start;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("<- " + ms + "ms - " + rc + " - " + response);
        }
        this.p_mp.setR_Result("");
        this.p_mp.setR_Info(response);
        StringTokenizer st = new StringTokenizer(response, "&", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int pos = token.indexOf(61);
            String name = token.substring(0, pos);
            String value = token.substring(pos + 1);
            if (name.equals("RESULT")) {
                this.p_mp.setR_Result(value);
                this.m_ok = RESULT_OK.equals(value);
                continue;
            }
            if (name.equals("PNREF")) {
                this.p_mp.setR_PnRef(value);
                continue;
            }
            if (name.equals("RESPMSG")) {
                this.p_mp.setR_RespMsg(value);
                continue;
            }
            if (name.equals("AUTHCODE")) {
                this.p_mp.setR_AuthCode(value);
                continue;
            }
            if (name.equals("AVSADDR")) {
                this.p_mp.setR_AvsAddr(value);
                continue;
            }
            if (name.equals("AVSZIP")) {
                this.p_mp.setR_AvsZip(value);
                continue;
            }
            if (name.equals("IAVS") || name.equals("CVV2MATCH")) continue;
            this.log.log(Level.SEVERE, "Response unknown = " + token);
        }
        return this.m_ok;
    }

    public boolean isProcessedOK() {
        return this.m_ok;
    }
}

