/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.utils.LogWriter;

public class CalRGBColorSpace
extends GenericColorSpace {
    private int r;
    private int g;
    private int b;
    private final double[][] xyzrgb = new double[][]{{3.240449, -1.537136, -0.498531}, {-0.969265, 1.876011, 0.041556}, {0.055643, -0.204026, 1.057229}};
    private float lastC = -255.0f;
    private float lastI = -255.0f;
    private float lastE = -255.0f;

    public CalRGBColorSpace(String string, String string2, String string3, String string4) {
        this.cs = ColorSpace.getInstance(1001);
        this.setCIEValues(string, string2, null, string3, string4);
        this.value = 5;
    }

    public final BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        int n3 = n * n2;
        try {
            for (int i = 0; i < n3 * 3; i += 3) {
                float f = dataBufferByte.getElemFloat(i);
                float f2 = dataBufferByte.getElemFloat(i + 1);
                float f3 = dataBufferByte.getElemFloat(i + 2);
                this.convertToRGB(f, f2, f3);
                ((DataBuffer)dataBufferByte).setElem(i, this.r);
                ((DataBuffer)dataBufferByte).setElem(i + 1, this.g);
                ((DataBuffer)dataBufferByte).setElem(i + 2, this.b);
            }
            int[] nArray = new int[]{0, 1, 2};
            bufferedImage = new BufferedImage(n, n2, 1);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
            bufferedImage.setData(writableRaster);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
        }
        return bufferedImage;
    }

    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f};
        if (n == 3) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = Float.parseFloat(stringArray[2 - i]);
            }
        }
        this.convertToRGB(fArray[0], fArray[1], fArray[2]);
        this.currentColor = new PdfColor(this.r, this.g, this.b);
    }

    private final void convertToRGB(float f, float f2, float f3) {
        if (this.lastC != f || this.lastI != f2 || this.lastE != f3) {
            this.r = (int)(f * 255.0f);
            this.g = (int)(f2 * 255.0f);
            this.b = (int)(f3 * 255.0f);
            this.lastC = f;
            this.lastI = f2;
            this.lastE = f3;
        }
    }

    public BufferedImage JPEGToRGBImageXXX(byte[] byArray, int n, int n2, String string) {
        BufferedImage bufferedImage = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
            Raster raster = jPEGImageDecoder.decodeAsRaster();
            int n3 = raster.getWidth();
            int n4 = raster.getHeight();
            int n5 = n3 * n4;
            DataBuffer dataBuffer = raster.getDataBuffer();
            for (int i = 0; i < n5 * 3; i += 3) {
                float f = dataBuffer.getElemFloat(i) / 255.0f;
                float f2 = dataBuffer.getElemFloat(i + 1) / 255.0f;
                float f3 = dataBuffer.getElemFloat(i + 2) / 255.0f;
                this.convertToRGB(f, f2, f3);
                dataBuffer.setElem(i, this.r);
                dataBuffer.setElem(i + 1, this.g);
                dataBuffer.setElem(i + 2, this.b);
            }
            int[] nArray = new int[]{0, 1, 2};
            bufferedImage = new BufferedImage(n3, n4, 1);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBuffer, n3, n4, n3 * 3, 3, nArray, null);
            bufferedImage.setData(writableRaster);
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
        }
        return bufferedImage;
    }

    public final byte[] convertIndexToRGB(byte[] byArray) {
        return byArray;
    }

    private double clip(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }
}

