/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.DBException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.compiere.model.MLanguage;
import org.compiere.model.MTable;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CommonTranslationHandler
extends AbstractElementHandler
implements ElementHandler {
    public static final String CONTEXT_KEY_PARENT_TABLE = "currentParentTableForTranslation";
    public static final String CONTEXT_KEY_PARENT_RECORD_ID = "currentParentTableRecordID_ForTranslation";
    private HashMap<String, ArrayList<String>> cacheColumns = new HashMap();

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        if (!this.isHandleTranslations(ctx.ctx)) {
            return;
        }
        if (this.isParentSkip(element, null)) {
            return;
        }
        if (this.isParentDefer(element, null)) {
            element.defer = true;
            return;
        }
        String elementValue = element.getElementValue();
        int parentID = element.parent.recordId;
        if (parentID == 0) {
            throw new SAXException();
        }
        String language = this.getStringValue(element, "AD_Language");
        MLanguage lang = MLanguage.get((Properties)ctx.ctx, (String)language);
        if (!lang.isSystemLanguage()) {
            return;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(elementValue) + " " + this.getStringValue(element, "Name"));
        }
        if (this.isRecordExists(elementValue, parentID, language, ctx)) {
            this.updateTranslation(elementValue, parentID, ctx, element);
        } else {
            this.insertTranslation(elementValue, parentID, ctx, element);
        }
    }

    private boolean isRecordExists(String tableName, int parentID, String language, PIPOContext ctx) {
        String sql = "SELECT AD_Client_ID FROM " + tableName + " WHERE " + tableName.substring(0, tableName.length() - 4) + "_ID = ? AND AD_Language = ?";
        return DB.getSQLValue((String)this.getTrxName(ctx), (String)sql, (int)parentID, (String)language) != -1;
    }

    private void insertTranslation(String tableName, int parentID, PIPOContext ctx, Element element) throws SAXException {
        String parentTable = tableName.substring(0, tableName.length() - 4);
        ArrayList<String> columns = this.getTranslatedColumns(parentTable);
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(tableName).append(" (").append(parentTable).append("_ID, ").append(" AD_Client_ID, AD_Org_ID, CreatedBy, UpdatedBy, ").append(this.cast(columns)).append(") values ( ?, ?, ?, ?, ? ");
        int i = 0;
        while (i < columns.size()) {
            sql.append(",?");
            ++i;
        }
        sql.append(")");
        CPreparedStatement pstm = null;
        try {
            try {
                pstm = DB.prepareStatement((String)sql.toString(), (String)this.getTrxName(ctx));
                pstm.setInt(1, parentID);
                pstm.setInt(2, 0);
                pstm.setInt(3, 0);
                pstm.setInt(4, 0);
                pstm.setInt(5, 0);
                int i2 = 5;
                for (String columnName : columns) {
                    ++i2;
                    String value = this.getStringValue(element, columnName);
                    if (columnName.equalsIgnoreCase("IsActive") || columnName.equalsIgnoreCase("IsTranslated")) {
                        value = "true".equals(value) ? "Y" : "N";
                    }
                    pstm.setString(i2, value);
                }
                if (pstm.executeUpdate() < 0) {
                    throw new SAXException();
                }
            }
            catch (Exception e) {
                throw new DBException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(pstm);
            throw throwable;
        }
        DB.close((Statement)pstm);
    }

    private void updateTranslation(String tableName, int parentID, PIPOContext ctx, Element element) throws SAXException {
        String parentTable = tableName.substring(0, tableName.length() - 4);
        ArrayList<String> columns = this.getTranslatedColumns(parentTable);
        StringBuilder buffer = new StringBuilder("UPDATE " + tableName + " SET ");
        for (String columnName : columns) {
            buffer.append(columnName).append("=?,");
        }
        String sql = buffer.substring(0, buffer.length() - 1);
        sql = String.valueOf(sql) + " WHERE AD_Language = '" + this.getStringValue(element, "AD_Language") + "' AND " + parentTable + "_ID=" + parentID;
        CPreparedStatement pstm = null;
        try {
            try {
                pstm = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                int i = 0;
                for (String columnName : columns) {
                    String value = this.getStringValue(element, columnName);
                    ++i;
                    if (columnName.equalsIgnoreCase("IsActive") || columnName.equalsIgnoreCase("IsTranslated")) {
                        value = "true".equals(value) ? "Y" : "N";
                    }
                    pstm.setString(i, value);
                }
                if (pstm.executeUpdate() < 0) {
                    throw new SAXException();
                }
            }
            catch (Exception e) {
                throw new DBException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(pstm);
            throw throwable;
        }
        DB.close((Statement)pstm);
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        String parenTableName = Env.getContext((Properties)ctx.ctx, (String)CONTEXT_KEY_PARENT_TABLE);
        int parentRecordID = Env.getContextAsInt((Properties)ctx.ctx, (String)CONTEXT_KEY_PARENT_RECORD_ID);
        this.createTranslationTags(ctx, parenTableName, parentRecordID, document);
    }

    private void createTranslationTags(PIPOContext ctx, String parentTable, int parentRecordID, TransformerHandler document) throws SAXException {
        ArrayList<String> translatedColumns = this.getTranslatedColumns(parentTable);
        String sql = "select " + this.cast(translatedColumns) + " from " + parentTable + "_trl where " + parentTable + "_ID=" + parentRecordID;
        CPreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                pstm = DB.prepareStatement((String)sql, null);
                rs = pstm.executeQuery();
                String elementName = String.valueOf(parentTable) + "_Trl";
                while (rs.next()) {
                    AttributesImpl atts = new AttributesImpl();
                    this.addTypeName(atts, "translation");
                    document.startElement("", "", elementName, atts);
                    this.exportRow(ctx, document, translatedColumns, rs);
                    document.endElement("", "", elementName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SAXException();
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstm);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstm);
    }

    private void exportRow(PIPOContext ctx, TransformerHandler document, ArrayList<String> columns, ResultSet rs) throws Exception {
        PoExporter af = new PoExporter(ctx, document, null);
        for (String columnName : columns) {
            if (columnName.equalsIgnoreCase("IsActive") || columnName.equalsIgnoreCase("IsTranslated")) {
                af.addBoolean(columnName, rs.getString(columnName).equalsIgnoreCase("Y"), new AttributesImpl());
                continue;
            }
            af.addString(columnName, rs.getString(columnName), new AttributesImpl());
        }
    }

    private ArrayList<String> getTranslatedColumns(String parentTable) throws SAXException {
        ArrayList<String> pipolColumns = this.cacheColumns.get(parentTable);
        if (pipolColumns != null) {
            return pipolColumns;
        }
        ArrayList<String> columns = new ArrayList<String>();
        String sql = "select * from ad_column where ad_table_id = (select ad_table_id from ad_table where tableName = ?)and isTranslated='Y'";
        CPreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                pstm = DB.prepareStatement((String)sql, null);
                pstm.setString(1, parentTable);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    columns.add(rs.getString("columnName"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SAXException();
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstm);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstm);
        columns.add("AD_Language");
        columns.add("IsActive");
        columns.add("IsTranslated");
        this.cacheColumns.put(parentTable, columns);
        return columns;
    }

    private String cast(ArrayList<String> arg) {
        String str = arg.toString();
        return str.substring(1, str.length() - 1);
    }

    private boolean existTranslated(String Name) {
        return MTable.getTable_ID((String)(String.valueOf(Name) + "_Trl")) > 0;
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        if ("Y".equals(packout.getCtx().ctx.getProperty("isHandleTranslations")) && this.existTranslated(packout.getCtx().ctx.getProperty("Table_Name"))) {
            Env.setContext((Properties)packout.getCtx().ctx, (String)CONTEXT_KEY_PARENT_TABLE, (String)packout.getCtx().ctx.getProperty("Table_Name"));
            Env.setContext((Properties)packout.getCtx().ctx, (String)CONTEXT_KEY_PARENT_RECORD_ID, (int)recordId);
            this.create(packout.getCtx(), packoutHandler);
            packout.getCtx().ctx.remove(CONTEXT_KEY_PARENT_TABLE);
            packout.getCtx().ctx.remove(CONTEXT_KEY_PARENT_RECORD_ID);
        }
    }
}

