/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PackoutItem;
import org.compiere.Adempiere;
import org.compiere.model.MPackageExp;
import org.compiere.model.X_AD_Package_Imp_Backup;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DistFileElementHandler
extends AbstractElementHandler {
    String fileDest;

    public DistFileElementHandler() {
    }

    public DistFileElementHandler(String fileDest) {
        this.fileDest = fileDest;
    }

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String action = null;
        String releaseNumber = this.getStringValue(element, "ReleaseNo");
        if (releaseNumber == null || Adempiere.MAIN_VERSION.equals(releaseNumber) || releaseNumber.equals("all")) {
            String fileDate;
            String fullTargetPath;
            String packagePath;
            String fileName;
            block16: {
                int success;
                OutputStream outputStream;
                FileInputStream inputStream;
                boolean success2;
                fileName = this.getStringValue(element, "filename");
                String sourceDirectory = this.getStringValue(element, "sourceDirectory");
                String targetDirectory = this.getStringValue(element, "targetDirectory");
                action = "New";
                packagePath = null;
                String adempiereSourcePath = null;
                try {
                    packagePath = this.getPackageDirectory(ctx.ctx);
                    File parentDirectory = new File(packagePath);
                    while (!parentDirectory.getName().equals("packages")) {
                        parentDirectory = parentDirectory.getParentFile();
                    }
                    parentDirectory = parentDirectory.getParentFile();
                    adempiereSourcePath = parentDirectory.getCanonicalPath();
                }
                catch (IOException e1) {
                    System.out.println("Can't find adempiere-all directory.");
                }
                File backupDir = new File(String.valueOf(packagePath) + File.separator + "backup" + File.separator);
                if (!backupDir.exists() && !(success2 = new File(String.valueOf(packagePath) + File.separator + "backup" + File.separator).mkdirs())) {
                    this.log.info("Backup directory creation failed");
                }
                fullTargetPath = String.valueOf(adempiereSourcePath) + targetDirectory;
                char slash1 = '\\';
                char slash2 = '/';
                fullTargetPath = File.separator.equals("/") ? fullTargetPath.replace(slash1, slash2) : fullTargetPath.replace(slash2, slash1);
                File file = new File(String.valueOf(fullTargetPath) + fileName);
                boolean force = true;
                fileDate = null;
                if (file.exists()) {
                    if (!force) {
                        System.out.println("Output file exists.  Use the -f option to replace it.");
                        return;
                    }
                    action = "Update";
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Target Backup:" + fullTargetPath + fileName);
                    }
                    inputStream = this.OpenInputfile(String.valueOf(fullTargetPath) + fileName);
                    SimpleDateFormat formatter_file = new SimpleDateFormat("yyMMddHHmmssSSSSZ");
                    Date today = new Date();
                    fileDate = formatter_file.format(today);
                    outputStream = this.OpenOutputfile(String.valueOf(packagePath) + File.separator + "backup" + File.separator + fileDate + "_" + fileName);
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Source Backup:" + packagePath + File.separator + "backup" + File.separator + fileDate + "_" + fileName);
                    }
                    this.copyFile(inputStream, outputStream);
                    this.log.info("Backup Complete");
                }
                String fullSourcePath = null;
                fullSourcePath = File.separator.equals("/") ? sourceDirectory.replace(slash1, slash2) : sourceDirectory.replace(slash2, slash1);
                inputStream = this.OpenInputfile(String.valueOf(packagePath) + fullSourcePath + fileName);
                File targetDir = new File(fullTargetPath);
                if (!targetDir.exists() && (success = new File(fullTargetPath).mkdirs()) == 0) {
                    this.log.info("Target directory creation failed");
                }
                outputStream = this.OpenOutputfile(String.valueOf(fullTargetPath) + fileName);
                success = this.copyFile(inputStream, outputStream);
                X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, "file", fileName, 0);
                if (success != -1) {
                    try {
                        this.logImportDetail(ctx, impDetail, 1, fileName, 0, action);
                    }
                    catch (SAXException e) {
                        if (this.log.isLoggable(Level.INFO)) {
                            this.log.info("setfile:" + e);
                        }
                        break block16;
                    }
                }
                try {
                    this.logImportDetail(ctx, impDetail, 0, fileName, 0, action);
                }
                catch (SAXException e) {
                    if (!this.log.isLoggable(Level.INFO)) break block16;
                    this.log.info("setfile:" + e);
                }
            }
            X_AD_Package_Imp_Backup backup = new X_AD_Package_Imp_Backup(ctx.ctx, 0, this.getTrxName(ctx));
            backup.setAD_Org_ID(Env.getAD_Org_ID((Properties)ctx.ctx));
            backup.setAD_Package_Imp_Org_Dir(String.valueOf(fullTargetPath) + fileName);
            backup.setAD_Package_Imp_Bck_Dir(String.valueOf(packagePath) + File.separator + "backup" + File.separator + fileDate + "_" + fileName);
            backup.setAD_Package_Imp_ID(this.getPackageImpId(ctx.ctx));
            backup.saveEx();
        }
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        String FileName = Env.getContext((Properties)ctx.ctx, (String)"FileName");
        String Source_Directory = Env.getContext((Properties)ctx.ctx, (String)"Source_Directory");
        String Target_Directory = Env.getContext((Properties)ctx.ctx, (String)"Target_Directory");
        String ReleaseNo = Env.getContext((Properties)ctx.ctx, (String)"ReleaseNo");
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "custom");
        document.startElement("", "", "Dist_File", atts);
        this.addTextProperty(document, "filename", FileName);
        this.addTextProperty(document, "sourceDirectory", Source_Directory);
        this.addTextProperty(document, "targetDirectory", Target_Directory);
        this.addTextProperty(document, "ReleaseNo", ReleaseNo);
        atts.addAttribute("", "", "ReleaseNo", "CDATA", ReleaseNo);
        document.endElement("", "", "Dist_File");
    }

    public void doPackout(PackOut packout, MPackageExp header, PackoutItem detail, TransformerHandler packOutDocument, TransformerHandler packageDocument, AttributesImpl atts, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"FileName", (String)((String)detail.getProperty("FileName")));
        Env.setContext((Properties)packout.getCtx().ctx, (String)"ReleaseNo", (String)((String)detail.getProperty("ReleaseNo")));
        Env.setContext((Properties)packout.getCtx().ctx, (String)"Target_Directory", (String)((String)detail.getProperty("TargetDirectory")));
        Env.setContext((Properties)packout.getCtx().ctx, (String)"Source_Directory", (String)this.fileDest);
        this.create(packout.getCtx(), packOutDocument);
        packout.getCtx().ctx.remove("FileName");
        packout.getCtx().ctx.remove("ReleaseNo");
        packout.getCtx().ctx.remove("Target_Directory");
        packout.getCtx().ctx.remove("Source_Directory");
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
    }
}

