/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class ImportDelete
extends SvrProcess {
    private int p_AD_Table_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Table_ID")) {
                this.p_AD_Table_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MTable table;
        StringBuilder msglog = new StringBuilder("AD_Table_ID=").append(this.p_AD_Table_ID);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(msglog.toString());
        }
        if ((table = new MTable(this.getCtx(), this.p_AD_Table_ID, this.get_TrxName())).get_ID() == 0) {
            StringBuilder msgexc = new StringBuilder("No AD_Table_ID=").append(this.p_AD_Table_ID);
            throw new IllegalArgumentException(msgexc.toString());
        }
        String tableName = table.getTableName();
        if (!tableName.startsWith("I")) {
            StringBuilder msgexc = new StringBuilder("Not an import table = ").append(tableName);
            throw new IllegalArgumentException(msgexc.toString());
        }
        StringBuilder sql = new StringBuilder("DELETE FROM ").append(tableName).append(" WHERE AD_Client_ID=").append(this.getAD_Client_ID());
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        StringBuilder msg = new StringBuilder().append(Msg.translate((Properties)this.getCtx(), (String)(String.valueOf(tableName) + "_ID"))).append(" #").append(no);
        return msg.toString();
    }
}

