/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_T_Replenish;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ReplenishInterface;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;

public class ReplenishReport
extends SvrProcess {
    private int p_M_Warehouse_ID = 0;
    private int p_C_BPartner_ID = 0;
    private String p_ReplenishmentCreate = null;
    private int p_C_DocType_ID = 0;
    private StringBuffer m_info = new StringBuffer();

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Warehouse_ID")) {
                    this.p_M_Warehouse_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("ReplenishmentCreate")) {
                    this.p_ReplenishmentCreate = (String)para[i].getParameter();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        StringBuilder msglog = new StringBuilder("M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(", C_BPartner_ID=").append(this.p_C_BPartner_ID).append(" - ReplenishmentCreate=").append(this.p_ReplenishmentCreate).append(", C_DocType_ID=").append(this.p_C_DocType_ID);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(msglog.toString());
        }
        if (this.p_ReplenishmentCreate != null && this.p_C_DocType_ID == 0) {
            throw new AdempiereUserError("@FillMandatory@ @C_DocType_ID@");
        }
        MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)this.p_M_Warehouse_ID);
        if (wh.get_ID() == 0) {
            throw new AdempiereSystemError("@FillMandatory@ @M_Warehouse_ID@");
        }
        this.prepareTable();
        this.fillTable(wh);
        if (this.p_ReplenishmentCreate == null) {
            return "OK";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.p_C_DocType_ID);
        if (!dt.getDocBaseType().equals(this.p_ReplenishmentCreate)) {
            throw new AdempiereSystemError("@C_DocType_ID@=" + dt.getName() + " <> " + this.p_ReplenishmentCreate);
        }
        if (this.p_ReplenishmentCreate.equals("POO")) {
            this.createPO();
        } else if (this.p_ReplenishmentCreate.equals("POR")) {
            this.createRequisition();
        } else if (this.p_ReplenishmentCreate.equals("MMM")) {
            this.createMovements();
        } else if (this.p_ReplenishmentCreate.equals("DOO")) {
            this.createDO();
        }
        return this.m_info.toString();
    }

    private void prepareTable() {
        StringBuilder sql = new StringBuilder("UPDATE M_Replenish").append(" SET Level_Max = Level_Min ").append("WHERE Level_Max < Level_Min");
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Corrected Max_Level=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE M_Product_PO").append(" SET Order_Min = 1 ").append("WHERE Order_Min IS NULL OR Order_Min < 1")).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Corrected Order Min=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE M_Product_PO").append(" SET Order_Pack = 1 ").append("WHERE Order_Pack IS NULL OR Order_Pack < 1")).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Corrected Order Pack=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE M_Product_PO p").append(" SET IsCurrentVendor='Y' ").append("WHERE IsCurrentVendor<>'Y'").append(" AND EXISTS (SELECT pp.M_Product_ID FROM M_Product_PO pp ").append("WHERE p.M_Product_ID=pp.M_Product_ID ").append("GROUP BY pp.M_Product_ID ").append("HAVING COUNT(*) = 1)")).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Corrected CurrentVendor(Y)=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE M_Product_PO p").append(" SET IsCurrentVendor='N' ").append("WHERE IsCurrentVendor = 'Y'").append(" AND EXISTS (SELECT pp.M_Product_ID FROM M_Product_PO pp ").append("WHERE p.M_Product_ID=pp.M_Product_ID AND pp.IsCurrentVendor='Y' ").append("GROUP BY pp.M_Product_ID ").append("HAVING COUNT(*) > 1)")).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Corrected CurrentVendor(N)=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("DELETE T_Replenish WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID())).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Delete Existing Temp=" + no);
        }
    }

    private void fillTable(MWarehouse wh) throws Exception {
        String className;
        StringBuilder sql = new StringBuilder("INSERT INTO T_Replenish ");
        sql.append("(AD_PInstance_ID, M_Warehouse_ID, M_Product_ID, AD_Client_ID, AD_Org_ID,");
        sql.append(" ReplenishType, Level_Min, Level_Max,");
        sql.append(" C_BPartner_ID, Order_Min, Order_Pack, QtyToOrder, ReplenishmentCreate) ");
        sql.append("SELECT ").append(this.getAD_PInstance_ID());
        sql.append(", r.M_Warehouse_ID, r.M_Product_ID, r.AD_Client_ID, r.AD_Org_ID,");
        sql.append(" r.ReplenishType, r.Level_Min, r.Level_Max,");
        sql.append(" po.C_BPartner_ID, po.Order_Min, po.Order_Pack, 0, ");
        if (this.p_ReplenishmentCreate == null) {
            sql.append("null");
        } else {
            sql.append("'").append(this.p_ReplenishmentCreate).append("'");
        }
        sql.append(" FROM M_Replenish r");
        sql.append(" INNER JOIN M_Product_PO po ON (r.M_Product_ID=po.M_Product_ID) ");
        sql.append("WHERE po.IsCurrentVendor='Y'");
        sql.append(" AND r.ReplenishType<>'0'");
        sql.append(" AND po.IsActive='Y' AND r.IsActive='Y'");
        sql.append(" AND r.M_Warehouse_ID=").append(this.p_M_Warehouse_ID);
        if (this.p_C_BPartner_ID != 0) {
            sql.append(" AND po.C_BPartner_ID=").append(this.p_C_BPartner_ID);
        }
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(sql.toString());
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Insert (1) #" + no);
        }
        if (this.p_C_BPartner_ID == 0) {
            sql = new StringBuilder("INSERT INTO T_Replenish ");
            sql.append("(AD_PInstance_ID, M_Warehouse_ID, M_Product_ID, AD_Client_ID, AD_Org_ID,");
            sql.append(" ReplenishType, Level_Min, Level_Max,");
            sql.append(" C_BPartner_ID, Order_Min, Order_Pack, QtyToOrder, ReplenishmentCreate) ");
            sql.append("SELECT ").append(this.getAD_PInstance_ID());
            sql.append(", r.M_Warehouse_ID, r.M_Product_ID, r.AD_Client_ID, r.AD_Org_ID,");
            sql.append(" r.ReplenishType, r.Level_Min, r.Level_Max,");
            sql.append(" 0, 1, 1, 0, ");
            if (this.p_ReplenishmentCreate == null) {
                sql.append("null");
            } else {
                sql.append("'").append(this.p_ReplenishmentCreate).append("'");
            }
            sql.append(" FROM M_Replenish r ");
            sql.append("WHERE r.ReplenishType<>'0' AND r.IsActive='Y'");
            sql.append(" AND r.M_Warehouse_ID=").append(this.p_M_Warehouse_ID);
            sql.append(" AND NOT EXISTS (SELECT * FROM T_Replenish t ");
            sql.append("WHERE r.M_Product_ID=t.M_Product_ID");
            sql.append(" AND AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(")");
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Insert (BP) #" + no);
            }
        }
        sql = new StringBuilder("UPDATE T_Replenish t SET ");
        sql.append("QtyOnHand = (SELECT COALESCE(SUM(QtyOnHand),0) FROM M_StorageOnHand s, M_Locator l WHERE t.M_Product_ID=s.M_Product_ID");
        sql.append(" AND l.M_Locator_ID=s.M_Locator_ID AND l.M_Warehouse_ID=t.M_Warehouse_ID),");
        sql.append("QtyReserved = (SELECT COALESCE(SUM(Qty),0) FROM M_StorageReservation s WHERE t.M_Product_ID=s.M_Product_ID");
        sql.append(" AND t.M_Warehouse_ID=s.M_Warehouse_ID),");
        sql.append("QtyOrdered = (SELECT COALESCE(SUM(Qty),0) FROM M_StorageReservation s WHERE t.M_Product_ID=s.M_Product_ID");
        sql.append(" AND t.M_Warehouse_ID=s.M_Warehouse_ID)");
        if (this.p_C_DocType_ID != 0) {
            sql.append(", C_DocType_ID=").append(this.p_C_DocType_ID);
        }
        sql.append(" WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Update #" + no);
        }
        sql = new StringBuilder("DELETE T_Replenish r ");
        sql.append("WHERE (EXISTS (SELECT * FROM M_Product p ");
        sql.append("WHERE p.M_Product_ID=r.M_Product_ID AND p.IsActive='N')");
        sql.append(" OR EXISTS (SELECT * FROM M_Replenish rr ");
        sql.append(" WHERE rr.M_Product_ID=r.M_Product_ID AND rr.IsActive='N'");
        sql.append(" AND rr.M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(" ))");
        sql.append(" AND AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Delete Inactive=" + no);
        }
        sql = new StringBuilder("UPDATE T_Replenish SET QtyOnHand = 0 WHERE QtyOnHand IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuilder("UPDATE T_Replenish SET QtyReserved = 0 WHERE QtyReserved IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuilder("UPDATE T_Replenish SET QtyOrdered = 0 WHERE QtyOrdered IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuilder("UPDATE T_Replenish");
        sql.append(" SET QtyToOrder = CASE WHEN QtyOnHand - QtyReserved + QtyOrdered <= Level_Min ");
        sql.append(" THEN Level_Max - QtyOnHand + QtyReserved - QtyOrdered ");
        sql.append(" ELSE 0 END ");
        sql.append("WHERE ReplenishType='1'");
        sql.append(" AND AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Update Type-1=" + no);
        }
        sql = new StringBuilder("UPDATE T_Replenish");
        sql.append(" SET QtyToOrder = Level_Max - QtyOnHand + QtyReserved - QtyOrdered ");
        sql.append("WHERE ReplenishType='2'");
        sql.append(" AND AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Update Type-2=" + no);
        }
        sql = new StringBuilder("UPDATE T_Replenish");
        sql.append(" SET QtyToOrder = Order_Min ");
        sql.append("WHERE QtyToOrder < Order_Min");
        sql.append(" AND QtyToOrder > 0");
        sql.append(" AND AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set MinOrderQty=" + no);
        }
        sql = new StringBuilder("UPDATE T_Replenish");
        sql.append(" SET QtyToOrder = QtyToOrder - MOD(QtyToOrder, Order_Pack) + Order_Pack ");
        sql.append("WHERE MOD(QtyToOrder, Order_Pack) <> 0");
        sql.append(" AND QtyToOrder > 0");
        sql.append(" AND AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set OrderPackQty=" + no);
        }
        if (wh.getM_WarehouseSource_ID() != 0) {
            sql = new StringBuilder("UPDATE T_Replenish");
            sql.append(" SET M_WarehouseSource_ID=").append(wh.getM_WarehouseSource_ID());
            sql.append(" WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID());
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (no != 0 && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set Source Warehouse=" + no);
            }
        }
        sql = new StringBuilder("UPDATE T_Replenish");
        sql.append(" SET M_WarehouseSource_ID = NULL ");
        sql.append("WHERE M_Warehouse_ID=M_WarehouseSource_ID");
        sql.append(" AND AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set same Source Warehouse=" + no);
        }
        if ((className = wh.getReplenishmentClass()) != null && className.length() > 0) {
            ReplenishInterface custom = null;
            try {
                Class<?> clazz = Class.forName(className);
                custom = (ReplenishInterface)clazz.newInstance();
            }
            catch (Exception e) {
                throw new AdempiereUserError("No custom Replenishment class " + className + " - " + e.toString());
            }
            X_T_Replenish[] replenishs = this.getReplenish("ReplenishType='9'");
            int i = 0;
            while (i < replenishs.length) {
                X_T_Replenish replenish = replenishs[i];
                if (replenish.getReplenishType().equals("9")) {
                    BigDecimal qto = null;
                    try {
                        qto = custom.getQtyToOrder(wh, replenish);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, custom.toString(), (Throwable)e);
                    }
                    if (qto == null) {
                        qto = Env.ZERO;
                    }
                    replenish.setQtyToOrder(qto);
                    replenish.saveEx();
                }
                ++i;
            }
        }
        sql = new StringBuilder("DELETE T_Replenish ");
        sql.append("WHERE QtyToOrder < 1");
        sql.append(" AND AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Delete No QtyToOrder=" + no);
        }
    }

    private void createPO() {
        int noOrders = 0;
        StringBuilder info = new StringBuilder();
        MOrder order = null;
        MWarehouse wh = null;
        X_T_Replenish[] replenishs = this.getReplenish("M_WarehouseSource_ID IS NULL");
        int i = 0;
        while (i < replenishs.length) {
            X_T_Replenish replenish = replenishs[i];
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get((Properties)this.getCtx(), (int)replenish.getM_Warehouse_ID());
            }
            if (order == null || order.getC_BPartner_ID() != replenish.getC_BPartner_ID() || order.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                order.setIsSOTrx(false);
                order.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
                MBPartner bp = new MBPartner(this.getCtx(), replenish.getC_BPartner_ID(), this.get_TrxName());
                order.setBPartner(bp);
                order.setSalesRep_ID(this.getAD_User_ID());
                order.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Replenishment"));
                order.setAD_Org_ID(wh.getAD_Org_ID());
                order.setM_Warehouse_ID(wh.getM_Warehouse_ID());
                if (!order.save()) {
                    return;
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(order.toString());
                }
                ++noOrders;
                info.append(" - ");
                info.append(order.getDocumentNo());
            }
            MOrderLine line = new MOrderLine(order);
            line.setM_Product_ID(replenish.getM_Product_ID());
            line.setQty(replenish.getQtyToOrder());
            line.setPrice();
            line.saveEx();
            ++i;
        }
        this.m_info = new StringBuffer("#").append(noOrders).append(info.toString());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.m_info.toString());
        }
    }

    private void createRequisition() {
        int noReqs = 0;
        StringBuilder info = new StringBuilder();
        MRequisition requisition = null;
        MWarehouse wh = null;
        X_T_Replenish[] replenishs = this.getReplenish("M_WarehouseSource_ID IS NULL");
        int i = 0;
        while (i < replenishs.length) {
            X_T_Replenish replenish = replenishs[i];
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get((Properties)this.getCtx(), (int)replenish.getM_Warehouse_ID());
            }
            if (requisition == null || requisition.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                requisition = new MRequisition(this.getCtx(), 0, this.get_TrxName());
                requisition.setAD_User_ID(this.getAD_User_ID());
                requisition.setC_DocType_ID(this.p_C_DocType_ID);
                requisition.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Replenishment"));
                requisition.setAD_Org_ID(wh.getAD_Org_ID());
                requisition.setM_Warehouse_ID(wh.getM_Warehouse_ID());
                if (!requisition.save()) {
                    return;
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(requisition.toString());
                }
                ++noReqs;
                info.append(" - ");
                info.append(requisition.getDocumentNo());
            }
            MRequisitionLine line = new MRequisitionLine(requisition);
            line.setM_Product_ID(replenish.getM_Product_ID());
            line.setC_BPartner_ID(replenish.getC_BPartner_ID());
            line.setQty(replenish.getQtyToOrder());
            line.setPrice();
            line.saveEx();
            ++i;
        }
        this.m_info = new StringBuffer("#").append(noReqs).append(info.toString());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.m_info.toString());
        }
    }

    private void createMovements() {
        int noMoves = 0;
        StringBuilder info = new StringBuilder();
        MClient client = null;
        MMovement move = null;
        int M_Warehouse_ID = 0;
        int M_WarehouseSource_ID = 0;
        MWarehouse whSource = null;
        MWarehouse wh = null;
        X_T_Replenish[] replenishs = this.getReplenish("M_WarehouseSource_ID IS NOT NULL");
        int i = 0;
        while (i < replenishs.length) {
            X_T_Replenish replenish = replenishs[i];
            if (whSource == null || whSource.getM_WarehouseSource_ID() != replenish.getM_WarehouseSource_ID()) {
                whSource = MWarehouse.get((Properties)this.getCtx(), (int)replenish.getM_WarehouseSource_ID());
            }
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get((Properties)this.getCtx(), (int)replenish.getM_Warehouse_ID());
            }
            if (client == null || client.getAD_Client_ID() != whSource.getAD_Client_ID()) {
                client = MClient.get((Properties)this.getCtx(), (int)whSource.getAD_Client_ID());
            }
            if (move == null || M_WarehouseSource_ID != replenish.getM_WarehouseSource_ID() || M_Warehouse_ID != replenish.getM_Warehouse_ID()) {
                M_WarehouseSource_ID = replenish.getM_WarehouseSource_ID();
                M_Warehouse_ID = replenish.getM_Warehouse_ID();
                move = new MMovement(this.getCtx(), 0, this.get_TrxName());
                move.setC_DocType_ID(this.p_C_DocType_ID);
                move.setDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Replenishment")) + ": " + whSource.getName() + "->" + wh.getName());
                move.setAD_Org_ID(whSource.getAD_Org_ID());
                if (!move.save()) {
                    return;
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(move.toString());
                }
                ++noMoves;
                info.append(" - ").append(move.getDocumentNo());
            }
            int M_LocatorTo_ID = wh.getDefaultLocator().getM_Locator_ID();
            MProduct product = MProduct.get((Properties)this.getCtx(), (int)replenish.getM_Product_ID());
            String MMPolicy = product.getMMPolicy();
            MStorageOnHand[] storages = MStorageOnHand.getWarehouse((Properties)this.getCtx(), (int)whSource.getM_Warehouse_ID(), (int)replenish.getM_Product_ID(), (int)0, null, (boolean)"F".equals(MMPolicy), (boolean)false, (int)0, (String)this.get_TrxName());
            BigDecimal target = replenish.getQtyToOrder();
            int j = 0;
            while (j < storages.length) {
                MStorageOnHand storage = storages[j];
                if (storage.getQtyOnHand().signum() > 0) {
                    BigDecimal moveQty = target;
                    if (storage.getQtyOnHand().compareTo(moveQty) < 0) {
                        moveQty = storage.getQtyOnHand();
                    }
                    MMovementLine line = new MMovementLine(move);
                    line.setM_Product_ID(replenish.getM_Product_ID());
                    line.setMovementQty(moveQty);
                    if (replenish.getQtyToOrder().compareTo(moveQty) != 0) {
                        line.setDescription("Total: " + replenish.getQtyToOrder());
                    }
                    line.setM_Locator_ID(storage.getM_Locator_ID());
                    line.setM_AttributeSetInstance_ID(storage.getM_AttributeSetInstance_ID());
                    line.setM_LocatorTo_ID(M_LocatorTo_ID);
                    line.setM_AttributeSetInstanceTo_ID(storage.getM_AttributeSetInstance_ID());
                    line.saveEx();
                    target = target.subtract(moveQty);
                    if (target.signum() == 0) break;
                }
                ++j;
            }
            ++i;
        }
        if (replenishs.length == 0) {
            this.m_info = new StringBuffer("No Source Warehouse");
            this.log.warning(this.m_info.toString());
        } else {
            this.m_info = new StringBuffer("#").append(noMoves).append((CharSequence)info);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(this.m_info.toString());
            }
        }
    }

    private void createDO() throws Exception {
        X_T_Replenish[] replenishs;
        int noMoves = 0;
        StringBuilder info = new StringBuilder();
        MClient client = null;
        MDDOrder order = null;
        int M_Warehouse_ID = 0;
        int M_WarehouseSource_ID = 0;
        MWarehouse whSource = null;
        MWarehouse wh = null;
        X_T_Replenish[] x_T_ReplenishArray = replenishs = this.getReplenishDO("M_WarehouseSource_ID IS NOT NULL");
        int n = replenishs.length;
        int n2 = 0;
        while (n2 < n) {
            X_T_Replenish replenish = x_T_ReplenishArray[n2];
            if (whSource == null || whSource.getM_WarehouseSource_ID() != replenish.getM_WarehouseSource_ID()) {
                whSource = MWarehouse.get((Properties)this.getCtx(), (int)replenish.getM_WarehouseSource_ID());
            }
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get((Properties)this.getCtx(), (int)replenish.getM_Warehouse_ID());
            }
            if (client == null || client.getAD_Client_ID() != whSource.getAD_Client_ID()) {
                client = MClient.get((Properties)this.getCtx(), (int)whSource.getAD_Client_ID());
            }
            if (order == null || M_WarehouseSource_ID != replenish.getM_WarehouseSource_ID() || M_Warehouse_ID != replenish.getM_Warehouse_ID()) {
                MWarehouse[] whsInTransit;
                M_WarehouseSource_ID = replenish.getM_WarehouseSource_ID();
                M_Warehouse_ID = replenish.getM_Warehouse_ID();
                order = new MDDOrder(this.getCtx(), 0, this.get_TrxName());
                order.setC_DocType_ID(this.p_C_DocType_ID);
                StringBuffer msgsd = new StringBuffer(Msg.getMsg((Properties)this.getCtx(), (String)"Replenishment")).append(": ").append(whSource.getName()).append("->").append(wh.getName());
                order.setDescription(msgsd.toString());
                order.setAD_Org_ID(whSource.getAD_Org_ID());
                MOrg orgTrx = MOrg.get((Properties)this.getCtx(), (int)wh.getAD_Org_ID());
                order.setAD_OrgTrx_ID(orgTrx.getAD_Org_ID());
                int C_BPartner_ID = orgTrx.getLinkedC_BPartner_ID(this.get_TrxName());
                if (C_BPartner_ID == 0) {
                    throw new AdempiereUserError(String.valueOf(Msg.translate((Properties)this.getCtx(), (String)"C_BPartner_ID")) + " @FillMandatory@ ");
                }
                MBPartner bp = new MBPartner(this.getCtx(), C_BPartner_ID, this.get_TrxName());
                order.setBPartner(bp);
                order.setDateOrdered(new Timestamp(System.currentTimeMillis()));
                order.setDeliveryRule("A");
                order.setDeliveryViaRule("D");
                order.setPriorityRule("5");
                order.setIsInDispute(false);
                order.setIsApproved(false);
                order.setIsDropShip(false);
                order.setIsDelivered(false);
                order.setIsInTransit(false);
                order.setIsPrinted(false);
                order.setIsSelected(false);
                order.setIsSOTrx(false);
                MWarehouse[] mWarehouseArray = whsInTransit = MWarehouse.getForOrg((Properties)this.getCtx(), (int)whSource.getAD_Org_ID());
                int n3 = whsInTransit.length;
                int n4 = 0;
                while (n4 < n3) {
                    MWarehouse whInTransit = mWarehouseArray[n4];
                    if (whInTransit.isInTransit()) {
                        order.setM_Warehouse_ID(whInTransit.getM_Warehouse_ID());
                    }
                    ++n4;
                }
                if (order.getM_Warehouse_ID() == 0) {
                    throw new AdempiereUserError("Warehouse inTransit is @FillMandatory@ ");
                }
                if (!order.save()) {
                    return;
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(order.toString());
                }
                ++noMoves;
                info.append(" - ").append(order.getDocumentNo());
            }
            int M_LocatorTo_ID = wh.getDefaultLocator().getM_Locator_ID();
            int M_Locator_ID = whSource.getDefaultLocator().getM_Locator_ID();
            if (M_LocatorTo_ID == 0 || M_Locator_ID == 0) {
                throw new AdempiereUserError(String.valueOf(Msg.translate((Properties)this.getCtx(), (String)"M_Locator_ID")) + " @FillMandatory@ ");
            }
            MDDOrderLine line = new MDDOrderLine(order);
            line.setM_Product_ID(replenish.getM_Product_ID());
            line.setQty(replenish.getQtyToOrder());
            if (replenish.getQtyToOrder().compareTo(replenish.getQtyToOrder()) != 0) {
                line.setDescription("Total: " + replenish.getQtyToOrder());
            }
            line.setM_Locator_ID(M_Locator_ID);
            line.setM_AttributeSetInstance_ID(0);
            line.setM_LocatorTo_ID(M_LocatorTo_ID);
            line.setM_AttributeSetInstanceTo_ID(0);
            line.setIsInvoiced(false);
            line.saveEx();
            ++n2;
        }
        if (replenishs.length == 0) {
            this.m_info = new StringBuffer("No Source Warehouse");
            this.log.warning(this.m_info.toString());
        } else {
            this.m_info = new StringBuffer("#").append(noMoves).append((CharSequence)info);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(this.m_info.toString());
            }
        }
    }

    private X_T_Replenish[] getReplenish(String where) {
        ArrayList<X_T_Replenish> list;
        block7: {
            StringBuilder sql = new StringBuilder("SELECT * FROM T_Replenish ");
            sql.append("WHERE AD_PInstance_ID=? AND C_BPartner_ID > 0 ");
            if (where != null && where.length() > 0) {
                sql.append(" AND ").append(where);
            }
            sql.append(" ORDER BY M_Warehouse_ID, M_WarehouseSource_ID, C_BPartner_ID");
            list = new ArrayList<X_T_Replenish>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, this.getAD_PInstance_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new X_T_Replenish(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        X_T_Replenish[] retValue = new X_T_Replenish[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private X_T_Replenish[] getReplenishDO(String where) {
        ArrayList<X_T_Replenish> list;
        block7: {
            StringBuilder sql = new StringBuilder("SELECT * FROM T_Replenish ");
            sql.append("WHERE AD_PInstance_ID=? ");
            if (where != null && where.length() > 0) {
                sql.append(" AND ").append(where);
            }
            sql.append(" ORDER BY M_Warehouse_ID, M_WarehouseSource_ID, C_BPartner_ID");
            list = new ArrayList<X_T_Replenish>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, this.getAD_PInstance_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new X_T_Replenish(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        X_T_Replenish[] retValue = new X_T_Replenish[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

