/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.compiere.web.MD5OutputStream;

public class MD5ResponseWrapper
extends HttpServletResponseWrapper {
    private ServletOutputStream stream = null;
    private PrintWriter writer = null;
    private HttpServletResponse origResponse;

    public MD5ResponseWrapper(HttpServletResponse response) {
        super(response);
        this.origResponse = response;
    }

    public void finishResponse() {
        if (this.stream != null) {
            String digest = ((MD5OutputStream)this.stream).getMD5Hash();
            this.origResponse.setContentType("text/plain");
            this.origResponse.setContentLength(digest.getBytes().length);
            try {
                this.origResponse.getOutputStream().write(digest.getBytes());
                this.origResponse.getOutputStream().flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.stream = this.createOutputStream();
        this.writer = new PrintWriter((OutputStream)this.stream);
        return this.writer;
    }

    private ServletOutputStream createOutputStream() {
        this.stream = new MD5OutputStream();
        return this.stream;
    }
}

