/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.adinterface;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.xmlbeans.StringEnumAbstractBase;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRefTable;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MWebServiceType;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.X_AD_Reference;
import org.compiere.model.X_WS_WebServiceFieldInput;
import org.compiere.model.X_WS_WebService_Para;
import org.compiere.process.DocAction;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.idempiere.adInterface.x10.ADLoginRequest;
import org.idempiere.adInterface.x10.DataField;
import org.idempiere.adInterface.x10.DataRow;
import org.idempiere.adInterface.x10.DataSet;
import org.idempiere.adInterface.x10.ModelCRUD;
import org.idempiere.adInterface.x10.ModelCRUDRequestDocument;
import org.idempiere.adInterface.x10.ModelGetList;
import org.idempiere.adInterface.x10.ModelGetListRequestDocument;
import org.idempiere.adInterface.x10.ModelRunProcess;
import org.idempiere.adInterface.x10.ModelRunProcessRequestDocument;
import org.idempiere.adInterface.x10.ModelSetDocAction;
import org.idempiere.adInterface.x10.ModelSetDocActionRequestDocument;
import org.idempiere.adInterface.x10.RunProcess;
import org.idempiere.adInterface.x10.RunProcessDocument;
import org.idempiere.adInterface.x10.RunProcessResponse;
import org.idempiere.adInterface.x10.RunProcessResponseDocument;
import org.idempiere.adInterface.x10.StandardResponse;
import org.idempiere.adInterface.x10.StandardResponseDocument;
import org.idempiere.adInterface.x10.WindowTabData;
import org.idempiere.adInterface.x10.WindowTabDataDocument;
import org.idempiere.adinterface.ADLookup;
import org.idempiere.adinterface.CompiereService;
import org.idempiere.adinterface.ModelADService;
import org.idempiere.adinterface.Process;
import org.idempiere.webservices.AbstractService;
import org.idempiere.webservices.fault.IdempiereServiceFault;

@WebService(endpointInterface="org.idempiere.adinterface.ModelADService", serviceName="ModelADService", targetNamespace="http://idempiere.org/ADInterface/1_0")
public class ModelADServiceImpl
extends AbstractService
implements ModelADService {
    private static CLogger log = CLogger.getCLogger(ModelADServiceImpl.class);
    private static String webServiceName = new String("ModelADService");
    private boolean manageTrx = true;
    private String localTrxName = null;

    public boolean isManageTrx() {
        return this.manageTrx;
    }

    public void setManageTrx(boolean manageTrx) {
        this.manageTrx = manageTrx;
    }

    public String getLocalTrxName() {
        return this.localTrxName;
    }

    public void setLocalTrxName(String locatTrxName) {
        this.localTrxName = locatTrxName;
    }

    public ModelADServiceImpl() {
        log.info("Creating session object ADService");
    }

    public ModelADServiceImpl(WebServiceContext soapContext, MessageContext jaxrsContext) {
        this.jaxwsContext = soapContext;
        this.jaxrsContext = jaxrsContext;
        log.info("Creating session object ADService");
    }

    public String getVersion() {
        return "0.8.0";
    }

    @Override
    public StandardResponseDocument setDocAction(ModelSetDocActionRequestDocument req) {
        boolean connected = this.getCompiereService().isConnected();
        try {
            if (!connected) {
                this.getCompiereService().connect();
            }
            StandardResponseDocument ret = StandardResponseDocument.Factory.newInstance();
            StandardResponse resp = ret.addNewStandardResponse();
            ModelSetDocAction modelSetDocAction = req.getModelSetDocActionRequest().getModelSetDocAction();
            String serviceType = modelSetDocAction.getServiceType();
            ADLoginRequest reqlogin = req.getModelSetDocActionRequest().getADLoginRequest();
            CompiereService m_cs = this.getCompiereService();
            String err = this.login(reqlogin, webServiceName, "setDocAction", serviceType);
            if (err != null && err.length() > 0) {
                resp.setError(err);
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                return standardResponseDocument;
            }
            try {
                modelSetDocAction.setTableName(this.validateParameter("tableName", modelSetDocAction.getTableName()));
                modelSetDocAction.setRecordID(this.validateParameter("recordID", modelSetDocAction.getRecordID()));
                modelSetDocAction.setDocAction(this.validateParameter("docAction", modelSetDocAction.getDocAction()));
            }
            catch (IdempiereServiceFault e) {
                resp.setError(e.getMessage());
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                if (!connected) {
                    this.getCompiereService().disconnect();
                }
                return standardResponseDocument;
            }
            Properties ctx = m_cs.getCtx();
            String trxName = this.localTrxName;
            if (trxName == null) {
                trxName = Trx.createTrxName((String)"ws_modelSetDocAction");
                this.manageTrx = true;
            }
            Trx trx = Trx.get((String)trxName, (boolean)true);
            Map<String, Object> requestCtx = this.getRequestCtx();
            String tableName = modelSetDocAction.getTableName();
            String recordIDVar = modelSetDocAction.getRecordIDVariable();
            int recordID = modelSetDocAction.getRecordID();
            if (recordIDVar != null && recordIDVar.startsWith("@")) {
                Integer retVal = (Integer)this.parseVariable(recordIDVar, null, null, requestCtx);
                if (retVal == null) {
                    StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot resolve variable: " + recordIDVar);
                    return standardResponseDocument;
                }
                recordID = retVal;
            }
            String docAction = modelSetDocAction.getDocAction();
            resp.setRecordID(recordID);
            MTable table2 = MTable.get((Properties)ctx, (String)tableName);
            if (table2 == null) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "No table " + tableName);
                return standardResponseDocument;
            }
            PO po = table2.getPO(recordID, trxName);
            if (po == null) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "No Record " + recordID + " in " + tableName);
                return standardResponseDocument;
            }
            po.set_ValueOfColumn("DocAction", (Object)docAction);
            if (!po.save()) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot save before set docAction: " + CLogger.retrieveErrorString((String)"no log message"));
                return standardResponseDocument;
            }
            MWebServiceType m_webservicetype = this.getWebServiceType();
            requestCtx.put("DocAction", docAction);
            StandardResponseDocument retResp = ModelADServiceImpl.invokeWSValidator(m_webservicetype, 1, po, null, trx, requestCtx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            if (!((DocAction)po).processIt(docAction)) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Couldn't set docAction: " + ((DocAction)po).getProcessMsg());
                return standardResponseDocument;
            }
            retResp = ModelADServiceImpl.invokeWSValidator(m_webservicetype, 3, po, null, trx, requestCtx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            if (!po.save()) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot save after set docAction: " + CLogger.retrieveErrorString((String)"no log message"));
                return standardResponseDocument;
            }
            retResp = ModelADServiceImpl.invokeWSValidator(m_webservicetype, 4, po, null, trx, requestCtx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            if (this.manageTrx && !trx.commit()) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot commit after docAction");
                return standardResponseDocument;
            }
            if (this.manageTrx) {
                trx.close();
            }
            resp.setIsError(false);
            POInfo poinfo = POInfo.getPOInfo((Properties)ctx, (int)table2.getAD_Table_ID());
            this.setOuputFields(resp, m_webservicetype, po, poinfo);
            StandardResponseDocument standardResponseDocument = ret;
            return standardResponseDocument;
        }
        finally {
            if (!connected) {
                this.getCompiereService().disconnect();
            }
        }
    }

    private String validateParameter(String parameterName, String string) {
        MWebServiceType m_webservicetype = this.getWebServiceType();
        X_WS_WebService_Para para = m_webservicetype.getParameter(parameterName);
        if (para == null && (string == null || string.length() == 0)) {
            return null;
        }
        if (para == null) {
            throw new IdempiereServiceFault("Web service type " + m_webservicetype.getValue() + ": invalid parameter " + parameterName, new QName("validateParameter"));
        }
        if ("C".equals(para.getParameterType())) {
            if (string == null || string.length() == 0) {
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "Web service type " + m_webservicetype.getValue() + ": constant parameter " + parameterName + " set to " + para.getConstantValue());
                }
                return para.getConstantValue();
            }
            if (!para.getConstantValue().equals(string)) {
                log.log(Level.WARNING, "Web service type " + m_webservicetype.getValue() + ": constant parameter " + parameterName + " changed to " + para.getConstantValue());
                return para.getConstantValue();
            }
        }
        return string;
    }

    private int validateParameter(String parameterName, int i2) {
        Integer io = i2;
        String string = this.validateParameter(parameterName, io.toString());
        if (string == null) {
            return -1;
        }
        if (string.equals(io.toString())) {
            return i2;
        }
        if (parameterName.endsWith("_ID") && ADLookup.isUUID(string)) {
            String tableName = parameterName.substring(0, parameterName.length() - 3);
            StringBuilder sql = new StringBuilder("SELECT ");
            sql.append(parameterName).append(" FROM ").append(tableName).append(" WHERE ").append(tableName).append("_UU=").append(DB.TO_STRING((String)string));
            return DB.getSQLValue(null, (String)sql.toString());
        }
        Map<String, Object> requestCtx = this.getRequestCtx();
        if (requestCtx != null && string.charAt(0) == '@') {
            Object value = ModelADServiceImpl.parseVatriable(this.getCompiereService(), requestCtx, parameterName, string);
            if (value != null && value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value != null) {
                string = value.toString();
            } else {
                return -1;
            }
        }
        return Integer.parseInt(string);
    }

    private ModelCRUD.Action.Enum validateParameter(String parameterName, ModelCRUD.Action.Enum action, StringEnumAbstractBase.Table table2) {
        String string = null;
        string = action == null ? this.validateParameter(parameterName, string) : this.validateParameter(parameterName, action.toString());
        if (string == null) {
            return (ModelCRUD.Action.Enum)table2.forInt(-1);
        }
        if (action != null && string.equals(action.toString())) {
            return action;
        }
        return (ModelCRUD.Action.Enum)table2.forString(string);
    }

    @Override
    public RunProcessResponseDocument runProcess(ModelRunProcessRequestDocument req) {
        boolean connected = this.getCompiereService().isConnected();
        try {
            if (!connected) {
                this.getCompiereService().connect();
            }
            RunProcessResponseDocument resbadlogin = RunProcessResponseDocument.Factory.newInstance();
            RunProcessResponse rbadlogin = resbadlogin.addNewRunProcessResponse();
            ModelRunProcess modelRunProcess = req.getModelRunProcessRequest().getModelRunProcess();
            String serviceType = modelRunProcess.getServiceType();
            ADLoginRequest reqlogin = req.getModelRunProcessRequest().getADLoginRequest();
            String err = this.login(reqlogin, webServiceName, "runProcess", serviceType);
            if (err != null && err.length() > 0) {
                rbadlogin.setError(err);
                rbadlogin.setIsError(true);
                RunProcessResponseDocument runProcessResponseDocument = resbadlogin;
                return runProcessResponseDocument;
            }
            modelRunProcess.setADMenuID(this.validateParameter("AD_Menu_ID", modelRunProcess.getADMenuID()));
            modelRunProcess.setADProcessID(this.validateParameter("AD_Process_ID", modelRunProcess.getADProcessID()));
            modelRunProcess.setADRecordID(this.validateParameter("AD_Record_ID", modelRunProcess.getADRecordID()));
            modelRunProcess.setDocAction(this.validateParameter("DocAction", modelRunProcess.getDocAction()));
            RunProcessDocument docprocess = RunProcessDocument.Factory.newInstance();
            RunProcess reqprocess = docprocess.addNewRunProcess();
            reqprocess.setParamValues(modelRunProcess.getParamValues());
            reqprocess.setADProcessID(modelRunProcess.getADProcessID());
            reqprocess.setADMenuID(modelRunProcess.getADMenuID());
            reqprocess.setADRecordID(modelRunProcess.getADRecordID());
            reqprocess.setDocAction(modelRunProcess.getDocAction());
            RunProcessResponseDocument response = Process.runProcess(this.getCompiereService(), docprocess, this.getRequestCtx(), this.localTrxName);
            Map<String, Object> requestCtx = this.getRequestCtx();
            requestCtx.put(String.valueOf(serviceType) + "_Summary", response.getRunProcessResponse().getSummary());
            RunProcessResponseDocument runProcessResponseDocument = response;
            return runProcessResponseDocument;
        }
        finally {
            if (!connected) {
                this.getCompiereService().disconnect();
            }
        }
    }

    @Override
    public WindowTabDataDocument getList(ModelGetListRequestDocument req) {
        boolean connected = this.getCompiereService().isConnected();
        try {
            if (!connected) {
                this.getCompiereService().connect();
            }
            WindowTabDataDocument resdoc = WindowTabDataDocument.Factory.newInstance();
            WindowTabData res = resdoc.addNewWindowTabData();
            DataSet ds = res.addNewDataSet();
            ModelGetList modelGetList = req.getModelGetListRequest().getModelGetList();
            String serviceType = modelGetList.getServiceType();
            int cnt = 0;
            ADLoginRequest reqlogin = req.getModelGetListRequest().getADLoginRequest();
            String err = this.login(reqlogin, webServiceName, "getList", serviceType);
            if (err != null && err.length() > 0) {
                res.setError(err);
                res.setErrorInfo(err);
                res.setSuccess(false);
                WindowTabDataDocument windowTabDataDocument = resdoc;
                return windowTabDataDocument;
            }
            int roleid = reqlogin.getRoleID();
            modelGetList.setADReferenceID(this.validateParameter("AD_Reference_ID", modelGetList.getADReferenceID()));
            modelGetList.setFilter(this.validateParameter("Filter", modelGetList.getFilter()));
            int ref_id = modelGetList.getADReferenceID();
            String filter = modelGetList.getFilter();
            filter = filter == null || filter.length() == 0 ? "" : " AND " + filter;
            CompiereService m_cs = this.getCompiereService();
            Properties ctx = m_cs.getCtx();
            X_AD_Reference ref = new X_AD_Reference(ctx, ref_id, null);
            String sql = null;
            ArrayList<String> listColumnNames = new ArrayList<String>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            MWebServiceType m_webservicetype = this.getWebServiceType();
            if ("L".equals(ref.getValidationType())) {
                String ad_language = Env.getAD_Language((Properties)ctx);
                boolean isBaseLanguage = Env.isBaseLanguage((String)ad_language, (String)"AD_Ref_List");
                sql = isBaseLanguage ? "SELECT AD_Ref_List.AD_Ref_List_ID, AD_Ref_List.Value, AD_Ref_List.Name, AD_Ref_List.Description FROM AD_Ref_List WHERE AD_Ref_List.AD_Reference_ID=? AND AD_Ref_List.IsActive='Y' " + filter + " ORDER BY AD_Ref_List.Name" : "SELECT AD_Ref_List.AD_Ref_List_ID, AD_Ref_List.Value, AD_Ref_List_Trl.Name, AD_Ref_List_Trl.Description FROM AD_Ref_List, AD_Ref_List_Trl WHERE AD_Ref_List.AD_Reference_ID=? AND AD_Ref_List.IsActive='Y' AND AD_Ref_List_Trl.AD_Language=? AND AD_Ref_List.AD_Ref_List_ID=AD_Ref_List_Trl.AD_Ref_List_ID " + filter + " ORDER BY AD_Ref_List_Trl.Name";
                listColumnNames.add("AD_Ref_List_ID");
                listColumnNames.add("Value");
                listColumnNames.add("Name");
                listColumnNames.add("Description");
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, ref_id);
                    if (!isBaseLanguage) {
                        pstmt.setString(2, ad_language);
                    }
                    rs = pstmt.executeQuery();
                }
                catch (SQLException e) {
                    res.setError(e.getMessage());
                    res.setErrorInfo(sql);
                    res.setSuccess(false);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw new IdempiereServiceFault(String.valueOf(e.getClass().toString()) + " " + e.getMessage() + " sql=" + sql, e.getCause(), new QName("getList"));
                }
            }
            if ("T".equals(ref.getValidationType())) {
                MTable table2;
                MRefTable rt;
                MRole role;
                block39: {
                    block37: {
                        role = new MRole(ctx, roleid, null);
                        String sqlrt = "SELECT * FROM AD_Ref_Table WHERE AD_Reference_ID=?";
                        rt = null;
                        CPreparedStatement pstmtrt = null;
                        ResultSet rsrt = null;
                        try {
                            try {
                                pstmtrt = DB.prepareStatement((String)sqlrt, null);
                                pstmtrt.setInt(1, ref_id);
                                rsrt = pstmtrt.executeQuery();
                                if (rsrt.next()) {
                                    rt = new MRefTable(ctx, rsrt, null);
                                }
                            }
                            catch (Exception exception) {
                                DB.close(rsrt, (Statement)pstmtrt);
                                rsrt = null;
                                pstmtrt = null;
                                break block37;
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rsrt, (Statement)pstmtrt);
                            rsrt = null;
                            pstmtrt = null;
                            throw throwable;
                        }
                        DB.close((ResultSet)rsrt, (Statement)pstmtrt);
                        rsrt = null;
                        pstmtrt = null;
                    }
                    if (rt == null) {
                        throw new IdempiereServiceFault("Web service type " + m_webservicetype.getValue() + ": reference table " + ref_id + " not found", new QName("getList"));
                    }
                    table2 = new MTable(ctx, rt.getAD_Table_ID(), null);
                    MColumn column = new MColumn(ctx, rt.getAD_Key(), null);
                    sql = "SELECT " + column.getColumnName();
                    listColumnNames.add(column.getColumnName());
                    if (rt.isValueDisplayed()) {
                        sql = String.valueOf(sql) + ",Value";
                        listColumnNames.add("Value");
                    }
                    String sqlident = "SELECT ColumnName FROM AD_Column WHERE AD_Table_ID=? AND IsActive='Y' AND IsIdentifier='Y' ORDER BY SeqNo";
                    CPreparedStatement pstmtident = null;
                    ResultSet rsident = null;
                    try {
                        try {
                            pstmtident = DB.prepareStatement((String)sqlident, null);
                            pstmtident.setInt(1, rt.getAD_Table_ID());
                            rsident = pstmtident.executeQuery();
                            while (rsident.next()) {
                                String colnameident = rsident.getString("ColumnName");
                                if (rt.isValueDisplayed() && colnameident.equalsIgnoreCase("Value")) continue;
                                sql = String.valueOf(sql) + "," + colnameident;
                                listColumnNames.add(colnameident);
                            }
                        }
                        catch (Exception colnameident) {
                            DB.close(rsident, (Statement)pstmtident);
                            rsident = null;
                            pstmtident = null;
                            break block39;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rsident, (Statement)pstmtident);
                        rsident = null;
                        pstmtident = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rsident, (Statement)pstmtident);
                    rsident = null;
                    pstmtident = null;
                }
                sql = String.valueOf(sql) + " FROM " + table2.getTableName() + " WHERE IsActive='Y'";
                sql = role.addAccessSQL(sql, table2.getTableName(), true, true);
                sql = String.valueOf(sql) + filter;
                if (rt.getWhereClause() != null && rt.getWhereClause().length() > 0) {
                    sql = String.valueOf(sql) + " AND " + rt.getWhereClause();
                }
                if (rt.getOrderByClause() != null && rt.getOrderByClause().length() > 0) {
                    sql = String.valueOf(sql) + " ORDER BY " + rt.getOrderByClause();
                }
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                }
                catch (SQLException e) {
                    res.setError(e.getMessage());
                    res.setErrorInfo(sql);
                    res.setSuccess(false);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw new IdempiereServiceFault(String.valueOf(e.getClass().toString()) + " " + e.getMessage() + " sql=" + sql, e.getCause(), new QName("getList"));
                }
            }
            if (rs != null) {
                try {
                    try {
                        while (rs.next()) {
                            ++cnt;
                            DataRow dr = ds.addNewDataRow();
                            for (String listColumnName : listColumnNames) {
                                if (!m_webservicetype.isOutputColumnNameAllowed(listColumnName)) continue;
                                DataField dfid = dr.addNewField();
                                dfid.setColumn(listColumnName);
                                dfid.setVal(rs.getString(listColumnName));
                            }
                        }
                        res.setSuccess(true);
                    }
                    catch (SQLException e) {
                        res.setError(e.getMessage());
                        res.setErrorInfo(sql);
                        res.setSuccess(false);
                        throw new IdempiereServiceFault(String.valueOf(e.getClass().toString()) + " " + e.getMessage() + " sql=" + sql, e.getCause(), new QName("getList"));
                    }
                }
                finally {
                    DB.close((ResultSet)rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            res.setRowCount(cnt);
            res.setNumRows(cnt);
            res.setTotalRows(cnt);
            res.setStartRow(1);
            WindowTabDataDocument windowTabDataDocument = resdoc;
            return windowTabDataDocument;
        }
        finally {
            if (!connected) {
                this.getCompiereService().disconnect();
            }
        }
    }

    @Override
    public StandardResponseDocument deleteData(ModelCRUDRequestDocument req) {
        boolean connected = this.getCompiereService().isConnected();
        Trx trx = null;
        boolean manageTrx = this.manageTrx;
        try {
            if (!connected) {
                this.getCompiereService().connect();
            }
            StandardResponseDocument ret = StandardResponseDocument.Factory.newInstance();
            StandardResponse resp = ret.addNewStandardResponse();
            ModelCRUD modelCRUD = req.getModelCRUDRequest().getModelCRUD();
            String serviceType = modelCRUD.getServiceType();
            ADLoginRequest reqlogin = req.getModelCRUDRequest().getADLoginRequest();
            String err = this.login(reqlogin, webServiceName, "deleteData", serviceType);
            if (err != null && err.length() > 0) {
                resp.setError(err);
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                return standardResponseDocument;
            }
            try {
                this.validateCRUD(modelCRUD);
            }
            catch (IdempiereServiceFault e) {
                resp.setError(e.getMessage());
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                if (manageTrx && trx != null) {
                    trx.close();
                }
                if (!connected) {
                    this.getCompiereService().disconnect();
                }
                return standardResponseDocument;
            }
            String tableName = modelCRUD.getTableName();
            int recordID = modelCRUD.getRecordID();
            resp.setRecordID(recordID);
            CompiereService m_cs = this.getCompiereService();
            Properties ctx = m_cs.getCtx();
            String trxName = this.localTrxName;
            if (trxName == null) {
                trxName = Trx.createTrxName((String)"ws_modelCreateData");
                manageTrx = true;
            }
            trx = Trx.get((String)trxName, (boolean)true);
            MTable table2 = MTable.get((Properties)ctx, (String)tableName);
            if (table2 == null) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "No table " + tableName);
                return standardResponseDocument;
            }
            PO po = table2.getPO(recordID, trxName);
            if (po == null) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "No Record " + recordID + " in " + tableName);
                return standardResponseDocument;
            }
            if (!po.delete(false)) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot delete record " + recordID + " in " + tableName + ": " + CLogger.retrieveErrorString((String)"no log message"));
                return standardResponseDocument;
            }
            if (manageTrx && !trx.commit()) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot commit transaction after delete record " + recordID + " in " + tableName);
                return standardResponseDocument;
            }
            StandardResponseDocument standardResponseDocument = ret;
            return standardResponseDocument;
        }
        finally {
            if (manageTrx && trx != null) {
                trx.close();
            }
            if (!connected) {
                this.getCompiereService().disconnect();
            }
        }
    }

    private void validateCRUD(ModelCRUD modelCRUD) {
        modelCRUD.setTableName(this.validateParameter("TableName", modelCRUD.getTableName()));
        modelCRUD.setRecordID(this.validateParameter("RecordID", modelCRUD.getRecordID()));
        modelCRUD.setFilter(this.validateParameter("Filter", modelCRUD.getFilter()));
        modelCRUD.setAction(this.validateParameter("Action", modelCRUD.getAction(), ModelCRUD.Action.Enum.table));
    }

    @Override
    public StandardResponseDocument createData(ModelCRUDRequestDocument req) {
        boolean connected = this.getCompiereService().isConnected();
        Trx trx = null;
        boolean manageTrx = this.manageTrx;
        try {
            if (!connected) {
                this.getCompiereService().connect();
            }
            StandardResponseDocument ret = StandardResponseDocument.Factory.newInstance();
            StandardResponse resp = ret.addNewStandardResponse();
            ModelCRUD modelCRUD = req.getModelCRUDRequest().getModelCRUD();
            String serviceType = modelCRUD.getServiceType();
            ADLoginRequest reqlogin = req.getModelCRUDRequest().getADLoginRequest();
            String err = this.login(reqlogin, webServiceName, "createData", serviceType);
            if (err != null && err.length() > 0) {
                resp.setError(err);
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                return standardResponseDocument;
            }
            try {
                this.validateCRUD(modelCRUD);
            }
            catch (IdempiereServiceFault e) {
                resp.setError(e.getMessage());
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                if (manageTrx && trx != null) {
                    trx.close();
                }
                if (!connected) {
                    this.getCompiereService().disconnect();
                }
                return standardResponseDocument;
            }
            String tableName = modelCRUD.getTableName();
            CompiereService m_cs = this.getCompiereService();
            Properties ctx = m_cs.getCtx();
            String trxName = this.localTrxName;
            if (trxName == null) {
                trxName = Trx.createTrxName((String)"ws_modelCreateData");
                manageTrx = true;
            }
            trx = Trx.get((String)trxName, (boolean)true);
            MTable table2 = MTable.get((Properties)ctx, (String)tableName);
            if (table2 == null) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "No table " + tableName);
                return standardResponseDocument;
            }
            PO po = table2.getPO(0, trxName);
            if (po == null) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot create PO for " + tableName);
                return standardResponseDocument;
            }
            POInfo poinfo = POInfo.getPOInfo((Properties)ctx, (int)table2.getAD_Table_ID());
            DataRow dr = modelCRUD.getDataRow();
            MWebServiceType m_webservicetype = this.getWebServiceType();
            Map<String, Object> requestCtx = this.getRequestCtx();
            DataField[] fields = dr.getFieldArray();
            StandardResponseDocument retResp = ModelADServiceImpl.invokeWSValidator(m_webservicetype, 1, po, fields, trx, requestCtx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            retResp = this.scanFields(fields, m_webservicetype, po, poinfo, trx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            retResp = ModelADServiceImpl.invokeWSValidator(m_webservicetype, 2, po, fields, trx, requestCtx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            retResp = ModelADServiceImpl.invokeWSValidator(m_webservicetype, 3, po, fields, trx, requestCtx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            if (!po.save()) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot save record in " + tableName + ": " + CLogger.retrieveErrorString((String)"no log message"));
                return standardResponseDocument;
            }
            retResp = ModelADServiceImpl.invokeWSValidator(m_webservicetype, 4, po, fields, trx, requestCtx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            int recordID = po.get_ID();
            resp.setRecordID(recordID);
            if (requestCtx != null) {
                requestCtx.put(po.get_TableName(), po);
            }
            if (manageTrx && !trx.commit()) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot commit transaction after create record " + recordID + " in " + tableName);
                return standardResponseDocument;
            }
            this.setOuputFields(resp, m_webservicetype, po, poinfo);
            StandardResponseDocument standardResponseDocument = ret;
            return standardResponseDocument;
        }
        finally {
            if (manageTrx && trx != null) {
                trx.close();
            }
            if (!connected) {
                this.getCompiereService().disconnect();
            }
        }
    }

    @Override
    public StandardResponseDocument createUpdateData(ModelCRUDRequestDocument req) {
        boolean connected = this.getCompiereService().isConnected();
        Trx trx = null;
        boolean manageTrx = this.manageTrx;
        try {
            Map<String, Object> requestCtx;
            if (!connected) {
                this.getCompiereService().connect();
            }
            StandardResponseDocument ret = StandardResponseDocument.Factory.newInstance();
            StandardResponse resp = ret.addNewStandardResponse();
            ModelCRUD modelCRUD = req.getModelCRUDRequest().getModelCRUD();
            String serviceType = modelCRUD.getServiceType();
            ADLoginRequest reqlogin = req.getModelCRUDRequest().getADLoginRequest();
            String err = this.login(reqlogin, webServiceName, "createData", serviceType);
            if (err != null && err.length() > 0) {
                resp.setError(err);
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                return standardResponseDocument;
            }
            try {
                this.validateCRUD(modelCRUD);
            }
            catch (IdempiereServiceFault e) {
                resp.setError(e.getMessage());
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                if (manageTrx && trx != null) {
                    trx.close();
                }
                if (!connected) {
                    this.getCompiereService().disconnect();
                }
                return standardResponseDocument;
            }
            String tableName = modelCRUD.getTableName();
            CompiereService m_cs = this.getCompiereService();
            Properties ctx = m_cs.getCtx();
            String trxName = this.localTrxName;
            if (trxName == null) {
                trxName = Trx.createTrxName((String)"ws_modelCreateData");
                manageTrx = true;
            }
            trx = Trx.get((String)trxName, (boolean)true);
            MTable table2 = MTable.get((Properties)ctx, (String)tableName);
            if (table2 == null) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "No table " + tableName);
                return standardResponseDocument;
            }
            DataRow dr = modelCRUD.getDataRow();
            DataField[] fields = dr.getFieldArray();
            PO holderPo = table2.getPO(0, trxName);
            POInfo poinfo = POInfo.getPOInfo((Properties)ctx, (int)table2.getAD_Table_ID());
            MWebServiceType m_webservicetype = this.getWebServiceType();
            StandardResponseDocument retResp = ModelADServiceImpl.invokeWSValidator(m_webservicetype, 1, holderPo, fields, trx, requestCtx = this.getRequestCtx(), resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            retResp = this.scanFields(fields, m_webservicetype, holderPo, poinfo, trx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            retResp = ModelADServiceImpl.invokeWSValidator(m_webservicetype, 2, holderPo, fields, trx, requestCtx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            boolean isCreate = false;
            boolean isUpdate = false;
            String action = modelCRUD.getAction().toString();
            if (action.equals("Create")) {
                isCreate = true;
            }
            if (action.equals("Update")) {
                isUpdate = true;
            }
            if (action.equals("CreateUpdate")) {
                isCreate = true;
                isUpdate = true;
            }
            ArrayList<String> identifierList = m_webservicetype.getKeyColumns();
            if (isUpdate && identifierList.size() == 0) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Web service type " + m_webservicetype.getValue() + ": There is no key column found ");
                return standardResponseDocument;
            }
            int record_id = 0;
            ArrayList<Object> resovedValue = new ArrayList<Object>();
            if (identifierList.size() > 0) {
                StringBuilder sqlBuilder = new StringBuilder("Select ");
                sqlBuilder.append(table2.getTableName()).append("_ID from ").append(table2.getTableName()).append(" ot Where ");
                ArrayList<Object> sqlParaList = new ArrayList<Object>();
                for (String colName : identifierList) {
                    X_WS_WebServiceFieldInput fieldInput = m_webservicetype.getFieldInput(colName);
                    if (fieldInput.getIdentifierLogic() == null) {
                        if (holderPo.get_Value(colName) == null && fieldInput.isNullIdentifier()) {
                            sqlBuilder.append(" ot.").append(colName).append(" Is Null AND ");
                            continue;
                        }
                        if (holderPo.get_Value(colName) == null) {
                            StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Web service type " + m_webservicetype.getValue() + ": Record Identifier column " + colName + " must be set");
                            return standardResponseDocument;
                        }
                        sqlBuilder.append(" ot.").append(colName).append("=? AND ");
                        sqlParaList.add(holderPo.get_Value(colName));
                        resovedValue.add(holderPo.get_Value(colName));
                        continue;
                    }
                    String sql = this.parseSQL(fieldInput.getIdentifierLogic(), sqlParaList, holderPo, poinfo, requestCtx);
                    sqlBuilder.append(" ot.").append(colName).append(" = (").append(sql).append(") AND ");
                    resovedValue.add("DYN SQL");
                }
                sqlBuilder.append(" ot.AD_Client_ID= ?");
                sqlParaList.add(Env.getAD_Client_ID((Properties)Env.getCtx()));
                String sql = sqlBuilder.toString();
                if (log.isLoggable(Level.INFO)) {
                    log.info("Web service type " + m_webservicetype.getValue() + "SQL to check existing record " + sql);
                }
                try {
                    record_id = DB.getSQLValueEx((String)trxName, (String)sql, sqlParaList);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "ExistingRecordCheck: Exception while executing SQL :" + sql);
                    StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Web service type " + m_webservicetype.getValue() + " Exception while executing sql :" + sql);
                    if (manageTrx && trx != null) {
                        trx.close();
                    }
                    if (!connected) {
                        this.getCompiereService().disconnect();
                    }
                    return standardResponseDocument;
                }
            }
            if (record_id == -1) {
                record_id = 0;
            }
            if (!isCreate && record_id == 0) {
                resp.setError("No Record to update for " + table2.getTableName() + " with (" + identifierList.toString() + ") = (" + resovedValue.toString() + ")");
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                return standardResponseDocument;
            }
            if (record_id > 0 && !isUpdate) {
                resp.setError("Record already presents with " + table2.getTableName() + "_ID = " + record_id);
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                return standardResponseDocument;
            }
            PO po = table2.getPO(record_id, trxName);
            if (po == null) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot create PO for " + tableName);
                return standardResponseDocument;
            }
            if (po.get_ColumnIndex("Processed") >= 0 && po.get_ValueAsBoolean("Processed")) {
                resp.setError("Record not updatable for " + table2.getTableName() + "_ID = " + record_id);
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                return standardResponseDocument;
            }
            DataField[] dataFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                DataField field = dataFieldArray[n2];
                int indx = poinfo.getColumnIndex(field.getColumn());
                if (indx != -1) {
                    po.set_ValueNoCheck(field.getColumn(), holderPo.get_Value(field.getColumn()));
                }
                ++n2;
            }
            retResp = ModelADServiceImpl.invokeWSValidator(m_webservicetype, 3, holderPo, fields, trx, requestCtx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            if (!po.save()) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot save record in " + tableName + ": " + CLogger.retrieveErrorString((String)"no log message"));
                return standardResponseDocument;
            }
            retResp = ModelADServiceImpl.invokeWSValidator(m_webservicetype, 4, holderPo, fields, trx, requestCtx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            int recordID = po.get_ID();
            resp.setRecordID(recordID);
            if (requestCtx != null) {
                requestCtx.put(po.get_TableName(), po);
            }
            if (manageTrx && !trx.commit()) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot commit transaction after create record " + recordID + " in " + tableName);
                return standardResponseDocument;
            }
            this.setOuputFields(resp, m_webservicetype, po, poinfo);
            StandardResponseDocument standardResponseDocument = ret;
            return standardResponseDocument;
        }
        finally {
            if (manageTrx && trx != null) {
                trx.close();
            }
            if (!connected) {
                this.getCompiereService().disconnect();
            }
        }
    }

    private void setValueAccordingToClass(PO po, POInfo poinfo, DataField field, int idxcol, X_WS_WebServiceFieldInput fieldInput) {
        CompiereService m_cs = this.getCompiereService();
        Class columnClass = poinfo.getColumnClass(idxcol);
        Object value = null;
        String strValue = field.getVal();
        String lookupValue = field.getLval();
        if (!Util.isEmpty((String)lookupValue)) {
            Lookup lookup = null;
            if (fieldInput.getAD_Reference_ID() > 0 && fieldInput.getAD_Reference_Value_ID() > 0) {
                try {
                    lookup = MLookupFactory.get((Properties)m_cs.getCtx(), (int)0, (int)poinfo.getAD_Column_ID(poinfo.getColumnName(idxcol)), (int)fieldInput.getAD_Reference_ID(), (Language)Env.getLanguage((Properties)m_cs.getCtx()), (String)poinfo.getColumnName(idxcol), (int)fieldInput.getAD_Reference_Value_ID(), (boolean)false, null);
                }
                catch (Exception e) {
                    throw new IdempiereServiceFault("Exception in resolving overridden lookup ", new QName("LookupResolutionFailed"));
                }
            } else {
                lookup = poinfo.getColumnLookup(idxcol);
            }
            if (lookup == null) {
                throw new IdempiereServiceFault(String.valueOf(field.getColumn()) + " is not lookup column. Pass Value in val element ", new QName("LookupResolutionFailed"));
            }
            int AD_Reference_ID = 0;
            if (lookup instanceof MLookup) {
                AD_Reference_ID = ((MLookup)lookup).getDisplayType();
            }
            if (AD_Reference_ID == 17) {
                Object[] list;
                if (lookup.getSize() == 0) {
                    lookup.refresh();
                }
                Object[] objectArray = list = lookup.getData(true, true, true, false, false).toArray();
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyNamePair p;
                    Object pair = objectArray[n2];
                    if (pair instanceof KeyNamePair) {
                        p = (KeyNamePair)pair;
                        if (p.getName().equalsIgnoreCase(lookupValue)) {
                            value = p.getID();
                            break;
                        }
                    } else {
                        p = (ValueNamePair)pair;
                        if (p.getName().equalsIgnoreCase(lookupValue)) {
                            value = p.getValue();
                            break;
                        }
                    }
                    ++n2;
                }
            } else {
                String sql = ADLookup.getDirectAccessSQL(lookup, lookupValue.toUpperCase());
                int id = DB.getSQLValue((String)this.localTrxName, (String)sql);
                if (id > 0) {
                    value = id;
                }
            }
            if (value == null) {
                throw new IdempiereServiceFault(" Invalid Lookup value:" + lookupValue, new QName("LookupResolutionFailed"));
            }
        } else if (strValue == null || strValue.length() == 0) {
            value = null;
        } else {
            Map<String, Object> requestCtx = this.getRequestCtx();
            if (requestCtx != null && strValue.charAt(0) == '@') {
                value = ModelADServiceImpl.parseVatriable(this.getCompiereService(), requestCtx, field.getColumn(), strValue);
            }
            if (value == null) {
                value = this.convertToObj(strValue, columnClass, field.getColumn());
            } else if (value instanceof String && !columnClass.equals(String.class)) {
                value = this.convertToObj(value.toString(), columnClass, field.getColumn());
            }
        }
        if (!po.set_ValueOfColumnReturningBoolean(field.getColumn(), value)) {
            ValueNamePair error = CLogger.retrieveError();
            if (error != null) {
                log.log(Level.SEVERE, String.valueOf(error.getValue()) + ", " + error.getName() + ": " + field.getColumn());
            }
            throw new IdempiereServiceFault("Cannot set value of column " + field.getColumn(), new QName("setValueAccordingToClass"));
        }
        Env.setContext((Properties)Env.getCtx(), (int)0, (String)field.getColumn(), (String)(value == null ? null : value.toString()));
    }

    public static Object parseVatriable(CompiereService cs, Map<String, Object> requestCtx, String name, String strValue) {
        String varName = strValue.substring(1);
        if (varName.charAt(0) == '#') {
            varName = varName.substring(1);
            return cs.getCtx().getProperty(varName);
        }
        int indDot = varName.indexOf(".");
        if (indDot == -1) {
            return requestCtx.get(varName);
        }
        String tblName = varName.substring(0, indDot);
        String colName = varName.substring(indDot + 1);
        if (colName.indexOf(".") >= 0) {
            throw new IdempiereServiceFault(String.valueOf(strValue) + " contains un supported multi level object resolution", new QName("resolveCtxVariable"));
        }
        Object obj = requestCtx.get(tblName);
        if (obj == null || !(obj instanceof PO)) {
            throw new IdempiereServiceFault(" input column " + name + " can not found object of " + tblName + ". Request variable " + strValue + " can not resolved", new QName("resolveCtxVariable"));
        }
        PO refPO = (PO)obj;
        return refPO.get_Value(colName);
    }

    public StandardResponseDocument scanFields(DataField[] fields, MWebServiceType m_webservicetype, PO po, POInfo poinfo, Trx trx, StandardResponse resp, StandardResponseDocument ret) {
        Map<String, Object> requestCtx = this.getRequestCtx();
        Env.clearWinContext((Properties)Env.getCtx(), (int)0);
        DataField[] dataFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            DataField field = dataFieldArray[n2];
            X_WS_WebServiceFieldInput fieldInput = m_webservicetype.getFieldInput(field.getColumn());
            if (fieldInput != null) {
                if (fieldInput.getAD_Column_ID() == 0 && fieldInput.getColumnName() != null) {
                    String varName = fieldInput.getColumnName();
                    Class<?> columnClass = this.getVariableType(varName, fieldInput.getAD_Reference_ID());
                    Object objVal = null;
                    String val = field.getVal();
                    objVal = val != null && val.length() > 0 && val.charAt(0) == '@' ? this.parseVariable(field.getVal(), po, poinfo, requestCtx) : this.convertToObj(field.getVal(), columnClass, varName);
                    requestCtx.put(varName, objVal);
                } else {
                    int idxcol = po.get_ColumnIndex(field.getColumn());
                    if (idxcol < 0) {
                        return ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Web service type " + m_webservicetype.getValue() + ": input column " + field.getColumn() + " does not exist");
                    }
                    try {
                        this.setValueAccordingToClass(po, poinfo, field, idxcol, fieldInput);
                    }
                    catch (IdempiereServiceFault e) {
                        log.log(Level.WARNING, "Error setting value", (Throwable)e);
                        return ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Web service type " + m_webservicetype.getValue() + ": input column " + field.getColumn() + " value could not be set: " + e.getLocalizedMessage());
                    }
                }
            } else {
                return ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Web service type " + m_webservicetype.getValue() + ": input column " + field.getColumn() + " not allowed");
            }
            ++n2;
        }
        return null;
    }

    @Override
    public StandardResponseDocument updateData(ModelCRUDRequestDocument req) {
        boolean connected = this.getCompiereService().isConnected();
        Trx trx = null;
        boolean manageTrx = this.manageTrx;
        try {
            if (!connected) {
                this.getCompiereService().connect();
            }
            StandardResponseDocument ret = StandardResponseDocument.Factory.newInstance();
            StandardResponse resp = ret.addNewStandardResponse();
            ModelCRUD modelCRUD = req.getModelCRUDRequest().getModelCRUD();
            String serviceType = modelCRUD.getServiceType();
            ADLoginRequest reqlogin = req.getModelCRUDRequest().getADLoginRequest();
            String err = this.login(reqlogin, webServiceName, "updateData", serviceType);
            if (err != null && err.length() > 0) {
                resp.setError(err);
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                return standardResponseDocument;
            }
            try {
                this.validateCRUD(modelCRUD);
            }
            catch (IdempiereServiceFault e) {
                resp.setError(e.getMessage());
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                if (manageTrx && trx != null) {
                    trx.close();
                }
                if (!connected) {
                    this.getCompiereService().disconnect();
                }
                return standardResponseDocument;
            }
            String tableName = modelCRUD.getTableName();
            int recordID = modelCRUD.getRecordID();
            resp.setRecordID(recordID);
            CompiereService m_cs = this.getCompiereService();
            MWebServiceType m_webservicetype = this.getWebServiceType();
            Properties ctx = m_cs.getCtx();
            String trxName = this.localTrxName;
            if (trxName == null) {
                trxName = Trx.createTrxName((String)"ws_modelCreateData");
                manageTrx = true;
            }
            trx = Trx.get((String)trxName, (boolean)true);
            MTable table2 = MTable.get((Properties)ctx, (String)tableName);
            if (table2 == null) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "No table " + tableName);
                return standardResponseDocument;
            }
            PO po = table2.getPO(recordID, trxName);
            if (po == null) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "No Record " + recordID + " in " + tableName);
                return standardResponseDocument;
            }
            POInfo poinfo = POInfo.getPOInfo((Properties)ctx, (int)table2.getAD_Table_ID());
            DataRow dr = modelCRUD.getDataRow();
            StandardResponseDocument retResp = this.scanFields(dr.getFieldArray(), m_webservicetype, po, poinfo, trx, resp, ret);
            if (retResp != null) {
                StandardResponseDocument standardResponseDocument = retResp;
                return standardResponseDocument;
            }
            if (po.get_ColumnIndex("Processed") >= 0 && po.get_ValueAsBoolean("Processed")) {
                resp.setError("Record is processed and can not be updated");
                resp.setIsError(true);
                StandardResponseDocument standardResponseDocument = ret;
                return standardResponseDocument;
            }
            if (!po.save()) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot save record in " + tableName + ": " + CLogger.retrieveErrorString((String)"no log message"));
                return standardResponseDocument;
            }
            if (manageTrx && !trx.commit()) {
                StandardResponseDocument standardResponseDocument = ModelADServiceImpl.rollbackAndSetError(trx, resp, ret, true, "Cannot commit transaction after create record " + recordID + " in " + tableName);
                return standardResponseDocument;
            }
            this.setOuputFields(resp, m_webservicetype, po, poinfo);
            StandardResponseDocument standardResponseDocument = ret;
            return standardResponseDocument;
        }
        finally {
            if (manageTrx && trx != null) {
                trx.close();
            }
            if (!connected) {
                this.getCompiereService().disconnect();
            }
        }
    }

    @Override
    public WindowTabDataDocument readData(ModelCRUDRequestDocument req) {
        boolean connected = this.getCompiereService().isConnected();
        try {
            MTable table2;
            if (!connected) {
                this.getCompiereService().connect();
            }
            WindowTabDataDocument ret = WindowTabDataDocument.Factory.newInstance();
            WindowTabData resp = ret.addNewWindowTabData();
            ModelCRUD modelCRUD = req.getModelCRUDRequest().getModelCRUD();
            String serviceType = modelCRUD.getServiceType();
            int cnt = 0;
            ADLoginRequest reqlogin = req.getModelCRUDRequest().getADLoginRequest();
            String err = this.login(reqlogin, webServiceName, "readData", serviceType);
            if (err != null && err.length() > 0) {
                resp.setError(err);
                WindowTabDataDocument windowTabDataDocument = ret;
                return windowTabDataDocument;
            }
            try {
                this.validateCRUD(modelCRUD);
            }
            catch (IdempiereServiceFault e) {
                resp.setError(e.getMessage());
                WindowTabDataDocument windowTabDataDocument = ret;
                if (!connected) {
                    this.getCompiereService().disconnect();
                }
                return windowTabDataDocument;
            }
            CompiereService m_cs = this.getCompiereService();
            MWebServiceType m_webservicetype = this.getWebServiceType();
            String trxName = this.localTrxName;
            Properties ctx = m_cs.getCtx();
            String tableName = modelCRUD.getTableName();
            String recordIDVar = modelCRUD.getRecordIDVariable();
            int recordID = modelCRUD.getRecordID();
            if (recordIDVar != null && recordIDVar.startsWith("@")) {
                Integer retVal = (Integer)this.parseVariable(recordIDVar, null, null, this.getRequestCtx());
                if (retVal == null) {
                    resp.setError("Cannot resolve variable: " + recordIDVar);
                    WindowTabDataDocument windowTabDataDocument = ret;
                    return windowTabDataDocument;
                }
                recordID = retVal;
            }
            if ((table2 = MTable.get((Properties)ctx, (String)tableName)) == null) {
                throw new IdempiereServiceFault("Web service type " + m_webservicetype.getValue() + ": table " + tableName + " not found", new QName("readData"));
            }
            PO po = table2.getPO(recordID, trxName);
            if (po == null) {
                resp.setSuccess(false);
                resp.setRowCount(cnt);
                resp.setNumRows(cnt);
                resp.setTotalRows(cnt);
                resp.setStartRow(0);
                WindowTabDataDocument windowTabDataDocument = ret;
                return windowTabDataDocument;
            }
            cnt = 1;
            POInfo poinfo = POInfo.getPOInfo((Properties)ctx, (int)table2.getAD_Table_ID());
            DataSet ds = resp.addNewDataSet();
            DataRow dr = ds.addNewDataRow();
            int i2 = 0;
            while (i2 < poinfo.getColumnCount()) {
                String columnName = poinfo.getColumnName(i2);
                if (m_webservicetype.isOutputColumnNameAllowed(columnName)) {
                    DataField dfid = dr.addNewField();
                    dfid.setColumn(columnName);
                    if (po.get_Value(i2) != null) {
                        dfid.setVal(po.get_Value(i2).toString());
                    } else {
                        dfid.setVal(null);
                    }
                }
                ++i2;
            }
            resp.setSuccess(true);
            resp.setRowCount(cnt);
            resp.setNumRows(cnt);
            resp.setTotalRows(cnt);
            resp.setStartRow(1);
            WindowTabDataDocument windowTabDataDocument = ret;
            return windowTabDataDocument;
        }
        finally {
            if (!connected) {
                this.getCompiereService().disconnect();
            }
        }
    }

    @Override
    public WindowTabDataDocument queryData(ModelCRUDRequestDocument req) {
        boolean connected = this.getCompiereService().isConnected();
        try {
            int cnt;
            WindowTabData resp;
            WindowTabDataDocument ret;
            block35: {
                if (!connected) {
                    this.getCompiereService().connect();
                }
                CompiereService m_cs = this.getCompiereService();
                ret = WindowTabDataDocument.Factory.newInstance();
                resp = ret.addNewWindowTabData();
                ModelCRUD modelCRUD = req.getModelCRUDRequest().getModelCRUD();
                String serviceType = modelCRUD.getServiceType();
                ADLoginRequest reqlogin = req.getModelCRUDRequest().getADLoginRequest();
                String err = this.login(reqlogin, webServiceName, "queryData", serviceType);
                if (err != null && err.length() > 0) {
                    resp.setError(err);
                    WindowTabDataDocument windowTabDataDocument = ret;
                    return windowTabDataDocument;
                }
                this.validateCRUD(modelCRUD);
                Properties ctx = m_cs.getCtx();
                String tableName = modelCRUD.getTableName();
                MWebServiceType m_webservicetype = this.getWebServiceType();
                MTable table2 = MTable.get((Properties)ctx, (String)tableName);
                if (table2 == null) {
                    throw new IdempiereServiceFault("Web service type " + m_webservicetype.getValue() + ": table " + tableName + " not found", new QName("queryData"));
                }
                int roleid = reqlogin.getRoleID();
                MRole role = new MRole(ctx, roleid, null);
                String sqlquery = "SELECT * FROM " + tableName;
                sqlquery = role.addAccessSQL(sqlquery, tableName, true, true);
                if (modelCRUD.getDataRow() != null) {
                    DataField[] dataFieldArray = modelCRUD.getDataRow().getFieldArray();
                    int n = dataFieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DataField field = dataFieldArray[n2];
                        if (!m_webservicetype.isInputColumnNameAllowed(field.getColumn())) {
                            throw new IdempiereServiceFault("Web service type " + m_webservicetype.getValue() + ": input column " + field.getColumn() + " not allowed", new QName("queryData"));
                        }
                        sqlquery = String.valueOf(sqlquery) + " AND " + field.getColumn() + "=?";
                        ++n2;
                    }
                }
                if (modelCRUD.getFilter() != null && modelCRUD.getFilter().length() > 0) {
                    sqlquery = String.valueOf(sqlquery) + " AND " + modelCRUD.getFilter();
                }
                POInfo poinfo = POInfo.getPOInfo((Properties)ctx, (int)table2.getAD_Table_ID());
                cnt = 0;
                CPreparedStatement pstmtquery = null;
                ResultSet rsquery = null;
                try {
                    try {
                        pstmtquery = DB.prepareStatement((String)sqlquery, (String)this.localTrxName);
                        int p = 1;
                        if (modelCRUD.getDataRow() != null) {
                            DataField[] dataFieldArray = modelCRUD.getDataRow().getFieldArray();
                            int n = dataFieldArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                DataField field = dataFieldArray[n3];
                                int idx = poinfo.getColumnIndex(field.getColumn());
                                Class c = poinfo.getColumnClass(idx);
                                if (c == Integer.class) {
                                    int value = 0;
                                    if (Util.isEmpty((String)field.getVal()) && !Util.isEmpty((String)field.getLval())) {
                                        Lookup lookup = null;
                                        int idxcol = poinfo.getColumnIndex(field.getColumn());
                                        X_WS_WebServiceFieldInput fieldInput = m_webservicetype.getFieldInput(field.getColumn());
                                        if (fieldInput.getAD_Reference_ID() > 0 && fieldInput.getAD_Reference_Value_ID() > 0) {
                                            try {
                                                lookup = MLookupFactory.get((Properties)m_cs.getCtx(), (int)0, (int)poinfo.getAD_Column_ID(poinfo.getColumnName(idxcol)), (int)fieldInput.getAD_Reference_ID(), (Language)Env.getLanguage((Properties)m_cs.getCtx()), (String)poinfo.getColumnName(idxcol), (int)fieldInput.getAD_Reference_Value_ID(), (boolean)false, null);
                                            }
                                            catch (Exception e) {
                                                throw new IdempiereServiceFault("Exception in resolving overridden lookup ", new QName("LookupResolutionFailed"));
                                            }
                                        } else {
                                            lookup = poinfo.getColumnLookup(idxcol);
                                        }
                                        if (lookup == null) {
                                            throw new IdempiereServiceFault(String.valueOf(field.getColumn()) + " is not lookup column. Pass Value in val element ", new QName("LookupResolutionFailed"));
                                        }
                                        String sql = ADLookup.getDirectAccessSQL(lookup, field.getLval().toUpperCase());
                                        int id = DB.getSQLValue((String)this.localTrxName, (String)sql);
                                        if (id > 0) {
                                            value = id;
                                        }
                                    } else {
                                        value = Integer.valueOf(field.getVal());
                                    }
                                    pstmtquery.setInt(p++, value);
                                } else if (c == Timestamp.class) {
                                    pstmtquery.setTimestamp(p++, Timestamp.valueOf(field.getVal()));
                                } else if (c == Boolean.class || c == String.class) {
                                    pstmtquery.setString(p++, field.getVal());
                                }
                                ++n3;
                            }
                        }
                        rsquery = pstmtquery.executeQuery();
                        DataSet ds = resp.addNewDataSet();
                        while (rsquery.next()) {
                            ++cnt;
                            DataRow dr = ds.addNewDataRow();
                            int i2 = 0;
                            while (i2 < poinfo.getColumnCount()) {
                                String columnName = poinfo.getColumnName(i2);
                                if (m_webservicetype.isOutputColumnNameAllowed(columnName)) {
                                    DataField dfid = dr.addNewField();
                                    dfid.setColumn(columnName);
                                    dfid.setVal(rsquery.getString(columnName));
                                }
                                ++i2;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                        DB.close(rsquery, (Statement)pstmtquery);
                        rsquery = null;
                        pstmtquery = null;
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rsquery, pstmtquery);
                    rsquery = null;
                    pstmtquery = null;
                    throw throwable;
                }
                DB.close((ResultSet)rsquery, (Statement)pstmtquery);
                rsquery = null;
                pstmtquery = null;
            }
            resp.setSuccess(true);
            resp.setRowCount(cnt);
            resp.setNumRows(cnt);
            resp.setTotalRows(cnt);
            resp.setStartRow(1);
            WindowTabDataDocument windowTabDataDocument = ret;
            return windowTabDataDocument;
        }
        finally {
            if (!connected) {
                this.getCompiereService().disconnect();
            }
        }
    }
}

