/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.adinterface;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import net.sf.compilo.report.ReportProcessor;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.NamePair;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWorkflow;
import org.idempiere.adInterface.x10.DataField;
import org.idempiere.adInterface.x10.DataRow;
import org.idempiere.adInterface.x10.GetProcessParamsDocument;
import org.idempiere.adInterface.x10.LookupValues;
import org.idempiere.adInterface.x10.ProcessParam;
import org.idempiere.adInterface.x10.ProcessParamList;
import org.idempiere.adInterface.x10.ProcessParams;
import org.idempiere.adInterface.x10.ProcessParamsDocument;
import org.idempiere.adInterface.x10.RunProcess;
import org.idempiere.adInterface.x10.RunProcessDocument;
import org.idempiere.adInterface.x10.RunProcessResponse;
import org.idempiere.adInterface.x10.RunProcessResponseDocument;
import org.idempiere.adinterface.ADLookup;
import org.idempiere.adinterface.CompiereService;
import org.idempiere.adinterface.ModelADServiceImpl;
import org.idempiere.adinterface.ReportEngineEx;
import org.idempiere.webservices.fault.IdempiereServiceFault;

public class Process {
    private static CLogger log = CLogger.getCLogger(Process.class);

    public static ProcessParamsDocument getProcessParams(CompiereService cs, GetProcessParamsDocument req) {
        ProcessParamsDocument res = ProcessParamsDocument.Factory.newInstance();
        ProcessParams params = res.addNewProcessParams();
        ProcessParamList PL = params.addNewParams();
        int AD_Menu_ID = req.getGetProcessParams().getADMenuID();
        int AD_Process_ID = req.getGetProcessParams().getADProcessID();
        MProcess process = null;
        if (AD_Menu_ID > 0 && AD_Process_ID == 0) {
            process = MProcess.getFromMenu((Properties)cs.getCtx(), (int)AD_Menu_ID);
        } else if (AD_Menu_ID == 0 && AD_Process_ID > 0) {
            process = new MProcess(cs.getCtx(), AD_Process_ID, null);
        }
        if (process != null) {
            params.setDescription(process.getDescription());
            params.setHelp(process.getHelp());
            params.setName(process.getName());
            params.setADProcessID(process.getAD_Process_ID());
            MProcessPara[] parameter = process.getParameters();
            int i2 = 0;
            while (i2 < parameter.length) {
                String t;
                MProcessPara para = parameter[i2];
                ProcessParam p = PL.addNewParam();
                p.setName(para.getName());
                p.setDescription(para.getDescription());
                p.setDisplayType(para.getAD_Reference_ID());
                p.setIsMandatory(para.isMandatory());
                p.setFieldLength(para.getFieldLength());
                p.setIsRange(para.isRange());
                p.setColumnName(para.getColumnName());
                p.setDefaultValue(para.getDefaultValue());
                p.setDefaultValue2(para.getDefaultValue2());
                if (para.getDefaultValue() != null) {
                    if (DisplayType.isDate((int)para.getAD_Reference_ID())) {
                        if (para.getDefaultValue().indexOf("@#Date@") >= 0) {
                            t = cs.dateFormat.format(Env.getContextAsDate((Properties)cs.getCtx(), (String)"#Date"));
                            p.setDefaultValue(t);
                        }
                    } else if (20 == para.getAD_Reference_ID()) {
                        if ("Y".equalsIgnoreCase(para.getDefaultValue())) {
                            p.setDefaultValue("true");
                        } else {
                            p.setDefaultValue("false");
                        }
                    }
                } else if (20 == para.getAD_Reference_ID()) {
                    p.setDefaultValue("false");
                }
                if (para.getDefaultValue2() != null && DisplayType.isDate((int)para.getAD_Reference_ID()) && para.getDefaultValue2().indexOf("@#Date@") >= 0) {
                    t = cs.dateFormat.format(Env.getContextAsDate((Properties)cs.getCtx(), (String)"#Date"));
                    p.setDefaultValue2(t);
                }
                if (para.isLookup()) {
                    LookupValues lvs = p.addNewLookup();
                    Lookup lookup = para.getLookup();
                    try {
                        ADLookup.fillLookupValues(lvs, lookup, para.isMandatory(), false, false);
                    }
                    catch (Exception ex) {
                        System.out.println("getProcessParams exception: " + ex.getMessage());
                        ex.printStackTrace();
                    }
                }
                ++i2;
            }
        }
        return res;
    }

    public static RunProcessResponseDocument runProcess(CompiereService m_cs, RunProcessDocument req) {
        return Process.runProcess(m_cs, req, null, null);
    }

    public static RunProcessResponseDocument runProcess(CompiereService m_cs, RunProcessDocument req, Map<String, Object> requestCtx, String trxName) {
        RunProcessResponseDocument res;
        block52: {
            boolean jasperreport;
            ProcessInfoParameter[] parameters;
            DataField[] s;
            DataField[] fields;
            PO po;
            MTable table2;
            MWorkflow wf;
            res = RunProcessResponseDocument.Factory.newInstance();
            RunProcessResponse r = res.addNewRunProcessResponse();
            RunProcess rp = req.getRunProcess();
            int AD_Process_ID = rp.getADProcessID();
            int m_record_id = rp.getADRecordID();
            MProcess process = MProcess.get((Properties)m_cs.getCtx(), (int)AD_Process_ID);
            if (process == null) {
                r.setError("Process not found");
                r.setIsError(true);
                return res;
            }
            String docAction = rp.getDocAction();
            if (docAction != null && docAction.length() > 0 && process.getAD_Workflow_ID() > 0 && (wf = MWorkflow.get((Properties)m_cs.getCtx(), (int)process.getAD_Workflow_ID())).getWorkflowType().equals("P") && (table2 = MTable.get((Properties)m_cs.getCtx(), (int)wf.getAD_Table_ID())) != null && (po = table2.getPO(m_record_id, null)) != null) {
                po.set_ValueOfColumn("DocAction", (Object)docAction);
                po.saveEx();
            }
            MPInstance pInstance = null;
            try {
                pInstance = Process.fillParameter(m_cs, rp.getParamValues(), process, requestCtx);
            }
            catch (Exception ex) {
                r.setError(ex.getMessage());
                r.setIsError(true);
                return res;
            }
            DataField[] dataFieldArray = fields = rp.getParamValues().getFieldArray();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                DataField field = dataFieldArray[n2];
                if ("AD_Record_ID".equals(field.getColumn())) {
                    Object value = null;
                    s = field.getVal();
                    if (requestCtx != null && !Util.isEmpty((String)s) && s.charAt(0) == '@') {
                        value = ModelADServiceImpl.parseVatriable(m_cs, requestCtx, field.getColumn(), (String)s);
                        if (value != null) {
                            if (value instanceof Number) {
                                m_record_id = ((Number)value).intValue();
                            } else {
                                try {
                                    m_record_id = Integer.parseInt(value.toString());
                                }
                                catch (Exception exception) {}
                            }
                        }
                    } else if (!Util.isEmpty((String)s)) {
                        try {
                            m_record_id = Integer.parseInt((String)s);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++n2;
            }
            if (m_record_id > 0) {
                pInstance.setRecord_ID(m_record_id);
                pInstance.saveEx();
            }
            ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID());
            pi.setAD_User_ID(Env.getAD_User_ID((Properties)m_cs.getCtx()));
            pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)m_cs.getCtx()));
            pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
            if (m_record_id > 0) {
                pi.setRecord_ID(m_record_id);
            }
            if ((parameters = pi.getParameter()) == null) {
                ProcessInfoUtil.setParameterFromDB((ProcessInfo)pi);
                parameters = pi.getParameter();
            }
            s = fields;
            int value = fields.length;
            int n3 = 0;
            while (n3 < value) {
                DataField field = s[n3];
                if (Process.isDataURI(field.getVal())) {
                    ProcessInfoParameter[] processInfoParameterArray = parameters;
                    int n4 = parameters.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        ProcessInfoParameter param = processInfoParameterArray[n5];
                        if (param.getParameterName().equals(field.getColumn())) {
                            String data = field.getVal().substring(field.getVal().indexOf(";base64,") + ";base64,".length());
                            param.setParameter((Object)data);
                            break;
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
            boolean processOK = false;
            boolean bl = jasperreport = process != null && (process.getJasperReport() != null || process.getClassname() != null && process.getClassname().indexOf("org.compiere.report.ReportStarter") >= 0);
            if (jasperreport) {
                processOK = true;
            }
            if (process.isWorkflow()) {
                try {
                    int AD_Workflow_ID = process.getAD_Workflow_ID();
                    MWorkflow wf2 = MWorkflow.get((Properties)Env.getCtx(), (int)AD_Workflow_ID);
                    MWFProcess wfProcess = wf2.startWait(pi);
                    if (wfProcess != null) {
                        r.setSummary(pi.getSummary());
                        r.setLogInfo(pi.getLogInfo(true));
                        r.setIsError(false);
                        return res;
                    }
                }
                catch (Exception ex) {
                    r.setError(ex.getMessage());
                    r.setLogInfo(pi.getLogInfo(true));
                    r.setIsError(true);
                    return res;
                }
            }
            if (process.isJavaProcess() && !jasperreport) {
                block51: {
                    Trx trx = trxName == null ? Trx.get((String)Trx.createTrxName((String)"WebPrc"), (boolean)true) : Trx.get((String)trxName, (boolean)true);
                    try {
                        try {
                            processOK = process.processIt(pi, trx, false);
                            if (trxName == null) {
                                trx.commit();
                            }
                        }
                        catch (Throwable t) {
                            trx.rollback();
                            if (trxName == null) {
                                trx.close();
                            }
                            break block51;
                        }
                    }
                    catch (Throwable wfProcess) {
                        if (trxName == null) {
                            trx.close();
                        }
                        throw wfProcess;
                    }
                    if (trxName == null) {
                        trx.close();
                    }
                }
                if (!processOK || pi.isError()) {
                    r.setSummary(pi.getSummary());
                    r.setError(pi.getSummary());
                    r.setLogInfo(pi.getLogInfo(true));
                    r.setIsError(true);
                    processOK = false;
                } else {
                    r.setSummary(pi.getSummary());
                    r.setError(pi.getSummary());
                    r.setLogInfo(pi.getLogInfo(true));
                    r.setIsError(false);
                }
            }
            if (process.isReport() || jasperreport) {
                r.setIsReport(true);
                ReportEngine re = null;
                if (!jasperreport) {
                    re = Process.start(pi);
                }
                if (re != null || jasperreport) {
                    try {
                        boolean ok = false;
                        String file_type = "pdf";
                        if (!jasperreport) {
                            MPrintFormat pf = re.getPrintFormat();
                            if (pf.isTableBased()) {
                                CharArrayWriter wr = new CharArrayWriter();
                                ok = ReportEngineEx.createEXCEL_HTML_wr(re, m_cs.getCtx(), wr, false, re.getPrintFormat().getLanguage());
                                file_type = "xls";
                                String data = wr.toString();
                                if (data != null) {
                                    r.setData(data.getBytes());
                                }
                                r.setReportFormat(file_type);
                            } else {
                                byte[] dat = re.createPDFData();
                                file_type = "pdf";
                                r.setData(dat);
                                r.setReportFormat(file_type);
                            }
                            ok = true;
                        } else {
                            JasperPrint jp = Process.getJasperReportPrint(m_cs.getCtx(), pi);
                            ByteArrayOutputStream wr = new ByteArrayOutputStream();
                            JasperExportManager.exportReportToPdfStream((JasperPrint)jp, (OutputStream)wr);
                            file_type = "pdf";
                            r.setData(wr.toByteArray());
                            r.setReportFormat(file_type);
                            ok = true;
                        }
                        if (ok) {
                            m_cs.getCtx().put("AD_PInstance_ID=" + pInstance.getAD_PInstance_ID(), "ok");
                            break block52;
                        }
                        r.setError("Cannot create report");
                        r.setLogInfo(pi.getLogInfo(true));
                        r.setIsError(true);
                        return res;
                    }
                    catch (Exception e) {
                        r.setError("Cannot create report:" + e.getMessage());
                        r.setLogInfo(pi.getLogInfo(true));
                        r.setIsError(true);
                        return res;
                    }
                }
            }
        }
        return res;
    }

    private static MPInstance fillParameter(CompiereService m_cs, DataRow dr, MProcess process, Map<String, Object> requestCtx) throws Exception {
        MPInstance pInstance = new MPInstance(process, 0);
        DataField[] f = dr.getFieldArray();
        HashMap<String, DataField> fmap = new HashMap<String, DataField>();
        int i2 = 0;
        while (i2 < f.length) {
            fmap.put(f[i2].getColumn(), f[i2]);
            ++i2;
        }
        MPInstancePara[] iParams = pInstance.getParameters();
        int pi = 0;
        while (pi < iParams.length) {
            MPInstancePara iPara = iParams[pi];
            String key = iPara.getParameterName();
            MProcessPara pPara = process.getParameter(key);
            if (pPara == null) {
                log.log(Level.SEVERE, "Parameter not found: " + key);
            } else {
                Object value;
                int displayType = pPara.getAD_Reference_ID();
                String valueString = null;
                DataField dataField = (DataField)fmap.get(key);
                if (dataField != null && !Util.isEmpty((String)dataField.getVal())) {
                    valueString = dataField.getVal();
                    if (requestCtx != null && valueString.charAt(0) == '@') {
                        Object value2 = ModelADServiceImpl.parseVatriable(m_cs, requestCtx, iPara.getParameterName(), valueString);
                        valueString = value2 != null ? value2.toString() : null;
                    }
                } else if (dataField != null && !Util.isEmpty((String)dataField.getLval())) {
                    valueString = Process.getLookupValue(pPara, dataField);
                }
                if (Process.isDataURI(valueString)) {
                    valueString = "";
                    iPara.setInfo("binary");
                }
                String valueString2 = null;
                if (pPara.isRange()) {
                    dataField = (DataField)fmap.get(String.valueOf(key) + "_2");
                    if (dataField != null && !Util.isEmpty((String)dataField.getVal())) {
                        valueString2 = dataField.toString();
                        if (requestCtx != null && valueString2.charAt(0) == '@') {
                            value = ModelADServiceImpl.parseVatriable(m_cs, requestCtx, iPara.getParameterName(), valueString2);
                            valueString2 = value != null ? value.toString() : null;
                        }
                    } else if (dataField != null && !Util.isEmpty((String)dataField.getLval())) {
                        valueString2 = Process.getLookupValue(pPara, dataField);
                    }
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("fillParameter - " + key + " = " + valueString);
                }
                value = valueString;
                if (valueString != null && valueString.length() == 0) {
                    value = null;
                }
                if (value != null && (17 == displayType || 19 == displayType || 18 == displayType) && value.equals("-1")) {
                    value = null;
                }
                if (value == null && 20 != pPara.getAD_Reference_ID()) {
                    if (pPara.isMandatory()) {
                        throw new Exception(" Parameter " + pPara.getName() + " is required.");
                    }
                } else {
                    try {
                        if (DisplayType.isNumeric((int)displayType) || DisplayType.isID((int)displayType)) {
                            BigDecimal bd = null;
                            bd = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof Integer ? new BigDecimal((Integer)value) : new BigDecimal(value.toString()));
                            iPara.setP_Number(bd);
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("fillParameter - " + key + " = " + valueString + " (=" + bd + "=)");
                            }
                            if (pPara.isRange()) {
                                bd = null;
                                bd = new BigDecimal(valueString2.toString());
                                iPara.setP_Number_To(bd);
                            }
                        } else if (DisplayType.isDate((int)displayType)) {
                            Date d = displayType == 16 ? m_cs.dateTimeFormat.parse(value.toString()) : m_cs.dateFormat.parse(value.toString());
                            Timestamp ts = null;
                            ts = new Timestamp(d.getTime());
                            iPara.setP_Date(ts);
                            if (pPara.isRange()) {
                                d = displayType == 16 ? m_cs.dateTimeFormat.parse(valueString2) : (valueString2 == null || valueString2.length() == 0 ? new Date() : m_cs.dateFormat.parse(valueString2));
                                ts = new Timestamp(d.getTime());
                                iPara.setP_Date_To(ts);
                            }
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("fillParameter - " + key + " = " + valueString + " (=" + ts + "=)");
                            }
                        } else if (20 == pPara.getAD_Reference_ID()) {
                            String bv = "N";
                            bv = value == null ? "N" : ("true".equalsIgnoreCase(valueString) || "y".equalsIgnoreCase(valueString) ? "Y" : "N");
                            iPara.setP_String(bv);
                        } else {
                            iPara.setP_String(value.toString());
                        }
                        if (pPara.isLookup()) {
                            NamePair np;
                            Lookup lok = pPara.getLookup();
                            if (lok != null && (np = lok.getDirect(value, false, false)) != null) {
                                iPara.setInfo(np.getName());
                            }
                        } else {
                            if (value != null) {
                                iPara.setInfo(value.toString());
                            }
                            if (valueString2 != null) {
                                iPara.setInfo_To(valueString2);
                            }
                        }
                        iPara.saveEx();
                    }
                    catch (Exception e) {
                        log.warning("fillParameter - " + key + " = " + valueString + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
                    }
                }
            }
            ++pi;
        }
        pInstance.saveEx();
        return pInstance;
    }

    private static String getLookupValue(MProcessPara pPara, DataField dataField) {
        MLookup lookup = null;
        try {
            lookup = MLookupFactory.get((Properties)pPara.getCtx(), (int)0, (int)0, (int)pPara.getAD_Reference_ID(), (Language)Env.getLanguage((Properties)pPara.getCtx()), (String)pPara.getColumnName(), (int)pPara.getAD_Reference_Value_ID(), (boolean)false, null);
        }
        catch (Exception e) {
            throw new IdempiereServiceFault("Exception in resolving lookup ", new QName("LookupResolutionFailed"));
        }
        String sql = ADLookup.getDirectAccessSQL((Lookup)lookup, dataField.getLval().toUpperCase());
        sql = String.valueOf(sql) + " ORDER BY AD_Client_ID DESC ";
        int id = DB.getSQLValue(null, (String)sql);
        if (id > 0) {
            return Integer.toString(id);
        }
        return null;
    }

    private static JasperPrint getJasperReportPrint(Properties ctx, ProcessInfo pi) {
        JasperPrint jasperPrint;
        block3: {
            try {
                ReportProcessor rp = new ReportProcessor(ctx, pi);
                jasperPrint = rp.runReport();
                if (jasperPrint != null) break block3;
                log.finer("ReportStarter.startProcess Cannot process JasperPrint Object");
                return null;
            }
            catch (Exception ex) {
                log.saveError("ReportStarter.startProcess: Can not run report - ", ex);
                return null;
            }
        }
        return jasperPrint;
    }

    public static ReportEngine start(ProcessInfo pi) {
        if (log.isLoggable(Level.INFO)) {
            log.info("start - " + pi);
        }
        if (pi.getAD_Process_ID() == 110) {
            return Process.startDocumentPrint(0, pi.getRecord_ID());
        }
        if (pi.getAD_Process_ID() == 116) {
            return Process.startDocumentPrint(2, pi.getRecord_ID());
        }
        if (pi.getAD_Process_ID() == 117) {
            return Process.startDocumentPrint(1, pi.getRecord_ID());
        }
        if (pi.getAD_Process_ID() == 217) {
            return Process.startDocumentPrint(3, pi.getRecord_ID());
        }
        if (pi.getAD_Process_ID() == 276) {
            return Process.startDocumentPrint(4, pi.getRecord_ID());
        }
        if (pi.getAD_Process_ID() == 313) {
            return Process.startCheckPrint(pi.getRecord_ID());
        }
        if (pi.getAD_Process_ID() == 159) {
            return Process.startDocumentPrint(7, pi.getRecord_ID());
        }
        if (pi.getAD_Process_ID() == 202 || pi.getAD_Process_ID() == 204) {
            return Process.startFinReport(pi);
        }
        return Process.startStandardReport(pi);
    }

    public static ReportEngine startDocumentPrint(int type, int Record_ID) {
        ReportEngine re = ReportEngine.get((Properties)Env.getCtx(), (int)type, (int)Record_ID);
        if (re == null) {
            return null;
        }
        return re;
    }

    public static ReportEngine startStandardReport(ProcessInfo pi) {
        ReportEngine re = ReportEngine.get((Properties)Env.getCtx(), (ProcessInfo)pi);
        if (re == null) {
            pi.setSummary("No ReportEngine");
            return null;
        }
        return re;
    }

    public static ReportEngine startCheckPrint(int C_Payment_ID) {
        int C_PaySelectionCheck_ID = 0;
        MPaySelectionCheck psc = MPaySelectionCheck.getOfPayment((Properties)Env.getCtx(), (int)C_Payment_ID, null);
        if (psc != null) {
            C_PaySelectionCheck_ID = psc.getC_PaySelectionCheck_ID();
        } else {
            psc = MPaySelectionCheck.createForPayment((Properties)Env.getCtx(), (int)C_Payment_ID, null);
            if (psc != null) {
                C_PaySelectionCheck_ID = psc.getC_PaySelectionCheck_ID();
            }
        }
        return Process.startDocumentPrint(6, C_PaySelectionCheck_ID);
    }

    private static boolean isDataURI(String s) {
        if (Util.isEmpty((String)s)) {
            return false;
        }
        return s.startsWith("data:") && s.indexOf(";base64,") > 0;
    }

    public static ReportEngine startFinReport(ProcessInfo pi) {
        String TableName = pi.getAD_Process_ID() == 202 ? "T_Report" : "T_ReportStatement";
        MQuery query = MQuery.get((Properties)Env.getCtx(), (int)pi.getAD_PInstance_ID(), (String)TableName);
        MPrintFormat format = (MPrintFormat)pi.getTransientObject();
        if (format == null) {
            format = (MPrintFormat)pi.getSerializableObject();
        }
        if (format == null) {
            log.log(Level.SEVERE, "startFinReport - No PrintFormat");
            return null;
        }
        PrintInfo info = new PrintInfo(pi);
        ReportEngine re = new ReportEngine(Env.getCtx(), format, query, info);
        return re;
    }
}

