/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.equinox.metatype.AttributeDefinitionImpl;
import org.eclipse.equinox.metatype.MetaTypeMsg;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueTokenizer {
    private static final char DELIMITER = ',';
    private static final char ESCAPE = '\\';
    private final LogService logger;
    private final List<String> values = new ArrayList<String>();

    public ValueTokenizer(String values_str, LogService logger) {
        this.logger = logger;
        if (values_str == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < values_str.length()) {
            char c1 = values_str.charAt(i);
            block0 : switch (c1) {
                case ',': {
                    this.values.add(buffer.toString());
                    buffer.delete(0, buffer.length());
                    break;
                }
                case '\\': {
                    if (i + 1 < values_str.length()) {
                        buffer.append(values_str.charAt(++i));
                        break;
                    }
                    logger.log(1, new StringBuffer("ValueTokenizer.ValueTokenizer(String) ").append(MetaTypeMsg.TOKENIZER_GOT_INVALID_DATA).toString());
                    break;
                }
                default: {
                    if (Character.isWhitespace(c1)) {
                        if (buffer.length() == 0) break;
                        int j = i + 1;
                        while (j < values_str.length()) {
                            char c2 = values_str.charAt(j);
                            if (!(Character.isWhitespace(c2) || c2 == '\\' && j + 1 >= values_str.length())) {
                                if (c2 != ',') {
                                    buffer.append(values_str.substring(i, j));
                                }
                                i = j - 1;
                                break block0;
                            }
                            ++j;
                        }
                        break;
                    }
                    buffer.append(c1);
                }
            }
            ++i;
        }
        this.values.add(buffer.toString());
    }

    public Collection<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public String[] getValuesAsArray() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.toArray(new String[this.values.size()]);
    }

    public String getValuesAsString() {
        if (this.values.isEmpty()) {
            return null;
        }
        if (this.values.size() == 1) {
            return this.values.get(0);
        }
        StringBuffer buffer = new StringBuffer(this.values.get(0));
        int i = 1;
        while (i < this.values.size()) {
            buffer.append(',');
            buffer.append(this.values.get(i));
            ++i;
        }
        return buffer.toString();
    }

    public String validate(AttributeDefinitionImpl ad) {
        if (this.values.isEmpty()) {
            return MetaTypeMsg.NULL_IS_INVALID;
        }
        try {
            int cardinality = Math.abs(ad.getCardinality());
            if (cardinality == 0) {
                if (this.values.size() != 1) {
                    return NLS.bind((String)MetaTypeMsg.CARDINALITY_VIOLATION, (Object[])new Object[]{this.getValuesAsString(), new Integer(this.values.size()), new Integer(1), new Integer(1)});
                }
            } else if (this.values.size() > cardinality) {
                return NLS.bind((String)MetaTypeMsg.CARDINALITY_VIOLATION, (Object[])new Object[]{this.getValuesAsString(), new Integer(this.values.size()), new Integer(0), new Integer(cardinality)});
            }
            for (String s : this.values) {
                if (!ad._values.isEmpty() && !ad._values.contains(s)) {
                    return NLS.bind((String)MetaTypeMsg.VALUE_OUT_OF_OPTION, (Object)s);
                }
                boolean rangeError = false;
                switch (ad._dataType) {
                    case 1: 
                    case 12: {
                        if (ad._minValue != null && s.length() < (Integer)ad._minValue) {
                            rangeError = true;
                            break;
                        }
                        if (ad._maxValue == null || s.length() <= (Integer)ad._maxValue) break;
                        rangeError = true;
                        break;
                    }
                    case 3: {
                        Integer intVal = new Integer(s);
                        if (ad._minValue != null && intVal.compareTo((Integer)ad._minValue) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad._maxValue == null || intVal.compareTo((Integer)ad._maxValue) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 2: {
                        Long longVal = new Long(s);
                        if (ad._minValue != null && longVal.compareTo((Long)ad._minValue) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad._maxValue == null || longVal.compareTo((Long)ad._maxValue) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 7: {
                        Double doubleVal = new Double(s);
                        if (ad._minValue != null && doubleVal.compareTo((Double)ad._minValue) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad._maxValue == null || doubleVal.compareTo((Double)ad._maxValue) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 5: {
                        Character charVal = new Character(s.charAt(0));
                        if (ad._minValue != null && charVal.compareTo((Character)ad._minValue) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad._maxValue == null || charVal.compareTo((Character)ad._maxValue) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 8: {
                        Float floatVal = new Float(s);
                        if (ad._minValue != null && floatVal.compareTo((Float)ad._minValue) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad._maxValue == null || floatVal.compareTo((Float)ad._maxValue) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 4: {
                        Short shortVal = new Short(s);
                        if (ad._minValue != null && shortVal.compareTo((Short)ad._minValue) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad._maxValue == null || shortVal.compareTo((Short)ad._maxValue) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 6: {
                        Byte byteVal = new Byte(s);
                        if (ad._minValue != null && byteVal.compareTo((Byte)ad._minValue) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad._maxValue == null || byteVal.compareTo((Byte)ad._maxValue) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 10: {
                        BigDecimal bigDecVal = new BigDecimal(s);
                        if (ad._minValue != null && bigDecVal.compareTo((BigDecimal)ad._minValue) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad._maxValue == null || bigDecVal.compareTo((BigDecimal)ad._maxValue) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 9: {
                        BigInteger bigIntVal = new BigInteger(s);
                        if (ad._minValue != null && bigIntVal.compareTo((BigInteger)ad._minValue) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad._maxValue == null || bigIntVal.compareTo((BigInteger)ad._maxValue) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (!rangeError) continue;
                return NLS.bind((String)MetaTypeMsg.VALUE_OUT_OF_RANGE, (Object)s);
            }
            return "";
        }
        catch (Throwable t) {
            String message = NLS.bind((String)MetaTypeMsg.EXCEPTION_MESSAGE, (Object)t.getClass().getName(), (Object)t.getMessage());
            this.logger.log(4, message, t);
            return message;
        }
    }
}

