/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;
import net.sf.jasperreports.data.cache.TimestampValuesIterator;

public class TimestampValues
implements ColumnValues,
Serializable {
    private static final long serialVersionUID = 10200L;
    private ColumnValues timeValues;
    private ColumnValues nanoValues;

    public TimestampValues(ColumnValues timeValues, ColumnValues nanoValues) {
        if (timeValues.size() != nanoValues.size()) {
            throw new IllegalArgumentException();
        }
        this.timeValues = timeValues;
        this.nanoValues = nanoValues;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUnshared(this.timeValues);
        out.writeUnshared(this.nanoValues);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.timeValues = (ColumnValues)in.readUnshared();
        this.nanoValues = (ColumnValues)in.readUnshared();
    }

    @Override
    public int size() {
        return this.timeValues.size();
    }

    @Override
    public ColumnValuesIterator iterator() {
        ColumnValuesIterator timeIterator = this.timeValues.iterator();
        ColumnValuesIterator nanoIterator = this.nanoValues.iterator();
        return new TimestampValuesIterator(timeIterator, nanoIterator);
    }
}

